/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.things.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.exceptions.DittoRuntimeException;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.model.base.headers.WithDittoHeaders;
import org.eclipse.ditto.signals.base.assertions.WithDittoHeadersChecker;
import org.eclipse.ditto.signals.commands.things.ThingErrorResponse;

public class ThingErrorResponseAssert
extends AbstractAssert<ThingErrorResponseAssert, ThingErrorResponse> {
    private final WithDittoHeadersChecker withDittoHeadersChecker;

    public ThingErrorResponseAssert(ThingErrorResponse actual) {
        super((Object)actual, ThingErrorResponseAssert.class);
        this.withDittoHeadersChecker = new WithDittoHeadersChecker((WithDittoHeaders)actual);
    }

    public ThingErrorResponseAssert hasDittoHeaders(DittoHeaders expectedDittoHeaders) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasDittoHeaders(expectedDittoHeaders);
        return (ThingErrorResponseAssert)this.myself;
    }

    public ThingErrorResponseAssert hasEmptyDittoHeaders() {
        this.isNotNull();
        this.withDittoHeadersChecker.hasEmptyDittoHeaders();
        return (ThingErrorResponseAssert)this.myself;
    }

    public ThingErrorResponseAssert hasCorrelationId(CharSequence expectedCorrelationId) {
        this.isNotNull();
        this.withDittoHeadersChecker.hasCorrelationId(expectedCorrelationId);
        return (ThingErrorResponseAssert)this.myself;
    }

    public ThingErrorResponseAssert hasType(String expectedType) {
        return this.assertThatEquals(((ThingErrorResponse)this.actual).getType(), expectedType, "type");
    }

    public ThingErrorResponseAssert hasStatusCode(HttpStatusCode expectedStatusCode) {
        return this.assertThatEquals(((ThingErrorResponse)this.actual).getStatusCode(), expectedStatusCode, "HTTP status code");
    }

    public ThingErrorResponseAssert contains(DittoRuntimeException expectedDittoRuntimeException) {
        return this.assertThatEquals(((ThingErrorResponse)this.actual).getDittoRuntimeException(), expectedDittoRuntimeException, "DittoRuntimeException");
    }

    public ThingErrorResponseAssert containsDittoRuntimeExceptionOfType(Class<? extends DittoRuntimeException> expectedType) {
        this.isNotNull();
        DittoRuntimeException actualDittoRuntimeException = ((ThingErrorResponse)this.actual).getDittoRuntimeException();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)actualDittoRuntimeException).overridingErrorMessage("Expected Thing Error Response to contain DittoRuntimeException of type <%s> but it did not", new Object[]{expectedType})).isInstanceOf(expectedType);
        return this;
    }

    public ThingErrorResponseAssert dittoRuntimeExceptionHasErrorCode(String expectedErrorCode) {
        this.isNotNull();
        DittoRuntimeException dittoRuntimeException = ((ThingErrorResponse)this.actual).getDittoRuntimeException();
        String actualErrorCode = dittoRuntimeException.getErrorCode();
        ((AbstractStringAssert)Assertions.assertThat((String)actualErrorCode).overridingErrorMessage("Expected DittoRuntimeException of Thing Error Response to have error code \n<%s> but it had \n<%s>", new Object[]{expectedErrorCode, actualErrorCode})).isEqualTo((Object)expectedErrorCode);
        return this;
    }

    private <T> ThingErrorResponseAssert assertThatEquals(T actual, T expected, String propertyName) {
        this.isNotNull();
        ((ObjectAssert)Assertions.assertThat(actual).overridingErrorMessage("Expected Thing Error Response to have %s \n<%s> but it had \n<%s>", new Object[]{propertyName, expected, actual})).isEqualTo(expected);
        return this;
    }
}

