/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.things.assertions;

import java.util.Optional;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.base.assertions.AbstractCommandResponseAssert;
import org.eclipse.ditto.signals.commands.things.modify.ThingModifyCommandResponse;

public class ThingModifyCommandResponseAssert
extends AbstractCommandResponseAssert<ThingModifyCommandResponseAssert, ThingModifyCommandResponse> {
    public ThingModifyCommandResponseAssert(ThingModifyCommandResponse actual) {
        super((CommandResponse)actual, ThingModifyCommandResponseAssert.class);
    }

    public ThingModifyCommandResponseAssert withType(CharSequence expectedType) {
        return (ThingModifyCommandResponseAssert)this.hasType(expectedType);
    }

    public ThingModifyCommandResponseAssert withDittoHeaders(DittoHeaders expectedDittoHeaders) {
        return (ThingModifyCommandResponseAssert)this.hasDittoHeaders(expectedDittoHeaders);
    }

    public ThingModifyCommandResponseAssert withResourcePath(CharSequence expectedResourcePath) {
        return this.withResourcePath(expectedResourcePath, JsonFactory.emptyPointer());
    }

    public ThingModifyCommandResponseAssert withResourcePath(CharSequence expectedResourcePath, CharSequence ... furtherResourcePathSegments) {
        JsonKey[] subLevels = null != furtherResourcePathSegments ? (JsonKey[])Stream.of(furtherResourcePathSegments).map(JsonFactory::newKey).toArray(JsonKey[]::new) : new JsonKey[]{};
        JsonPointer expectedResourcePathPointer = JsonFactory.newPointer((JsonKey)JsonFactory.newKey((CharSequence)expectedResourcePath), (JsonKey[])subLevels);
        JsonPointer actualResourcePath = ((ThingModifyCommandResponse)this.actual).getResourcePath();
        ((ObjectAssert)Assertions.assertThat((Object)actualResourcePath).overridingErrorMessage("Expected ThingModifyCommandResponse to have resource path \n<%s> but it had\n<%s>", new Object[]{expectedResourcePathPointer, actualResourcePath})).isEqualTo((Object)expectedResourcePathPointer);
        return (ThingModifyCommandResponseAssert)this.myself;
    }

    public ThingModifyCommandResponseAssert withResourcePath(CharSequence resourcePath, JsonPointer furtherResourcePathSegments) {
        this.isNotNull();
        JsonPointer expectedResourcePath = JsonFactory.newPointer((CharSequence)resourcePath).append(furtherResourcePathSegments);
        JsonPointer actualResourcePath = ((ThingModifyCommandResponse)this.actual).getResourcePath();
        ((ObjectAssert)Assertions.assertThat((Object)actualResourcePath).overridingErrorMessage("Expected ThingModifyCommandResponse to have resource path \n<%s> but it had\n<%s>", new Object[]{expectedResourcePath, actualResourcePath})).isEqualTo((Object)expectedResourcePath);
        return (ThingModifyCommandResponseAssert)this.myself;
    }

    public ThingModifyCommandResponseAssert withStatus(HttpStatusCode expectedStatus) {
        return (ThingModifyCommandResponseAssert)this.hasStatus(expectedStatus);
    }

    public ThingModifyCommandResponseAssert withEntity(JsonValue expectedEntity) {
        this.isNotNull();
        Optional actualEntity = ((ThingModifyCommandResponse)this.actual).getEntity();
        ((OptionalAssert)Assertions.assertThat((Optional)actualEntity).overridingErrorMessage("Expected ThingModifyCommandResponse to have entity\n<%s> but it had\n<%s>", new Object[]{expectedEntity, actualEntity.orElse(null)})).contains((Object)expectedEntity);
        return (ThingModifyCommandResponseAssert)this.myself;
    }

    public ThingModifyCommandResponseAssert withoutEntity() {
        this.isNotNull();
        Optional actualEntity = ((ThingModifyCommandResponse)this.actual).getEntity();
        ((OptionalAssert)Assertions.assertThat((Optional)actualEntity).overridingErrorMessage("Expected ThingModifyCommandResponse not to have an entity but it had\n<%s>", new Object[]{actualEntity.orElse(null)})).isEmpty();
        return (ThingModifyCommandResponseAssert)this.myself;
    }
}

