/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ditto.signals.commands.things.assertions;

import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.eclipse.ditto.json.JsonFactory;
import org.eclipse.ditto.json.JsonKey;
import org.eclipse.ditto.json.JsonPointer;
import org.eclipse.ditto.json.JsonValue;
import org.eclipse.ditto.model.base.common.HttpStatusCode;
import org.eclipse.ditto.model.base.headers.DittoHeaders;
import org.eclipse.ditto.signals.commands.base.CommandResponse;
import org.eclipse.ditto.signals.commands.base.assertions.AbstractCommandResponseAssert;
import org.eclipse.ditto.signals.commands.things.query.ThingQueryCommandResponse;

public class ThingQueryCommandResponseAssert
extends AbstractCommandResponseAssert<ThingQueryCommandResponseAssert, ThingQueryCommandResponse> {
    public ThingQueryCommandResponseAssert(ThingQueryCommandResponse actual) {
        super((CommandResponse)actual, ThingQueryCommandResponseAssert.class);
    }

    public ThingQueryCommandResponseAssert withType(CharSequence expectedType) {
        return (ThingQueryCommandResponseAssert)this.hasType(expectedType);
    }

    public ThingQueryCommandResponseAssert withDittoHeaders(DittoHeaders expectedDittoHeaders) {
        return (ThingQueryCommandResponseAssert)this.hasDittoHeaders(expectedDittoHeaders);
    }

    public ThingQueryCommandResponseAssert withResourcePath(CharSequence expectedResourcePath) {
        return this.withResourcePath(expectedResourcePath, JsonFactory.emptyPointer());
    }

    public ThingQueryCommandResponseAssert withResourcePath(CharSequence expectedResourcePath, CharSequence ... furtherResourcePathSegments) {
        JsonKey[] subLevels = null != furtherResourcePathSegments ? (JsonKey[])Stream.of(furtherResourcePathSegments).map(JsonFactory::newKey).toArray(JsonKey[]::new) : new JsonKey[]{};
        JsonPointer expectedResourcePathPointer = JsonFactory.newPointer((JsonKey)JsonFactory.newKey((CharSequence)expectedResourcePath), (JsonKey[])subLevels);
        JsonPointer actualResourcePath = ((ThingQueryCommandResponse)this.actual).getResourcePath();
        ((ObjectAssert)Assertions.assertThat((Object)actualResourcePath).overridingErrorMessage("Expected ThingQueryCommandResponse to have resource path \n<%s> but it had\n<%s>", new Object[]{expectedResourcePathPointer, actualResourcePath})).isEqualTo((Object)expectedResourcePathPointer);
        return (ThingQueryCommandResponseAssert)this.myself;
    }

    public ThingQueryCommandResponseAssert withResourcePath(CharSequence resourcePath, JsonPointer furtherResourcePathSegments) {
        this.isNotNull();
        JsonPointer expectedResourcePath = JsonFactory.newPointer((CharSequence)resourcePath).append(furtherResourcePathSegments);
        JsonPointer actualResourcePath = ((ThingQueryCommandResponse)this.actual).getResourcePath();
        ((ObjectAssert)Assertions.assertThat((Object)actualResourcePath).overridingErrorMessage("Expected ThingQueryCommandResponse to have resource path \n<%s> but it had\n<%s>", new Object[]{expectedResourcePath, actualResourcePath})).isEqualTo((Object)expectedResourcePath);
        return (ThingQueryCommandResponseAssert)this.myself;
    }

    public ThingQueryCommandResponseAssert withStatus(HttpStatusCode expectedStatus) {
        return (ThingQueryCommandResponseAssert)this.hasStatus(expectedStatus);
    }

    public ThingQueryCommandResponseAssert withEntity(JsonValue expectedEntity) {
        this.isNotNull();
        JsonValue actualEntity = ((ThingQueryCommandResponse)this.actual).getEntity();
        ((ObjectAssert)Assertions.assertThat((Object)actualEntity).overridingErrorMessage("Expected ThingQueryCommandResponse to have entity\n<%s> but it had\n<%s>", new Object[]{expectedEntity, actualEntity})).isEqualTo((Object)expectedEntity);
        return (ThingQueryCommandResponseAssert)this.myself;
    }
}

