/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.compiler;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor9;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationBooleanValueResolver;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationClassValuesResolver;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationLongValueResolver;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationStringValueResolver;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationStringValuesResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationFunctions {
    private static final AnnotationClassValuesResolver CLASS_VALUES_RESOLVER = new AnnotationClassValuesResolver();
    private static final AnnotationStringValuesResolver STRING_VALUES_RESOLVER = new AnnotationStringValuesResolver();
    private static final AnnotationBooleanValueResolver BOOLEAN_VALUE_RESOLVER = new AnnotationBooleanValueResolver();
    private static final AnnotationStringValueResolver STRING_VALUE_RESOLVER = new AnnotationStringValueResolver();
    private static final AnnotationLongValueResolver LONG_VALUE_RESOLVER = new AnnotationLongValueResolver();
    private static final String ANNOTATION_METHOD_POSTFIX = "()";

    private AnnotationFunctions() {
    }

    @Nullable
    public static AnnotationMirror mirrorFor(Class<? extends Annotation> type, Element element) {
        List<? extends AnnotationMirror> elementAnnotations = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : elementAnnotations) {
            if (!type.getName().equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static TypeMirror mirrorForReturn(Element element) {
        TypeMirror type = element.asType();
        if (type instanceof ExecutableType) {
            ExecutableType methodSymbol = (ExecutableType)type;
            return methodSymbol.getReturnType();
        }
        return null;
    }

    public static <T> T attributeValue(Class<T> type, String name, AnnotationMirror annotationMirror, Elements elementUtils) {
        name = (String)name + ANNOTATION_METHOD_POSTFIX;
        SimpleAnnotationValueVisitor9<?, ?> resolver = AnnotationFunctions.getResolver(type);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!((String)name).equals(entry.getKey().toString())) continue;
            return type.cast(entry.getValue().accept(resolver, null));
        }
        throw new IllegalArgumentException(String.format("Unknown attribute '%s' for annotation: %s", name, annotationMirror.getAnnotationType().asElement()));
    }

    public static List<String> attributeStringValues(String name, AnnotationMirror annotationMirror, Elements elementUtils) {
        name = (String)name + ANNOTATION_METHOD_POSTFIX;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!((String)name).equals(entry.getKey().toString())) continue;
            return entry.getValue().accept(STRING_VALUES_RESOLVER, new ArrayList());
        }
        throw new IllegalArgumentException(String.format("Unknown attribute '%s' for annotation: %s", name, annotationMirror.getAnnotationType().asElement()));
    }

    public static List<String> attributeTypeValues(String name, AnnotationMirror annotationMirror, Elements elementUtils) {
        name = (String)name + ANNOTATION_METHOD_POSTFIX;
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
            if (!((String)name).equals(entry.getKey().toString())) continue;
            return entry.getValue().accept(CLASS_VALUES_RESOLVER, new ArrayList());
        }
        return Collections.emptyList();
    }

    @NotNull
    private static <T> SimpleAnnotationValueVisitor9<?, ?> getResolver(Class<T> type) {
        SimpleAnnotationValueVisitor9 resolver;
        if (Boolean.class.equals(type)) {
            resolver = BOOLEAN_VALUE_RESOLVER;
        } else if (String.class.equals(type)) {
            resolver = STRING_VALUE_RESOLVER;
        } else if (Long.class.equals(type)) {
            resolver = LONG_VALUE_RESOLVER;
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + type.getName());
        }
        return resolver;
    }
}

