/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.plugins.autodoc.core.processor.introspection;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.eclipse.edc.plugins.autodoc.core.processor.compiler.AnnotationFunctions;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.ExtensionPoint;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Requires;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.runtime.metamodel.annotation.Spi;
import org.eclipse.edc.runtime.metamodel.domain.Service;

public class ModuleIntrospector {
    private static final String SERVICE_EXTENSION_NAME = "org.eclipse.edc.spi.system.ServiceExtension";
    private final Elements elementUtils;
    private final Types typeUtils;

    public ModuleIntrospector(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    public List<String> getCategories(RoundEnvironment environment) {
        Element extensionElement = environment.getElementsAnnotatedWith(Spi.class).iterator().next();
        return AnnotationFunctions.attributeStringValues("categories", AnnotationFunctions.mirrorFor(Spi.class, extensionElement), this.elementUtils);
    }

    public List<Service> resolveExtensionPoints(RoundEnvironment environment) {
        return environment.getElementsAnnotatedWith(ExtensionPoint.class).stream().map(element -> new Service(element.asType().toString())).collect(Collectors.toList());
    }

    public String getModuleName(RoundEnvironment environment) {
        Element extensionElement = environment.getElementsAnnotatedWith(Spi.class).iterator().next();
        return AnnotationFunctions.attributeValue(String.class, "value", AnnotationFunctions.mirrorFor(Spi.class, extensionElement), this.elementUtils);
    }

    public Set<Element> getExtensionElements(RoundEnvironment environment) {
        Set<? extends Element> extensionClasses = environment.getElementsAnnotatedWith(Extension.class);
        Set<? extends Element> settingsSymbols = environment.getElementsAnnotatedWith(Setting.class);
        Set<? extends Element> injectSymbols = environment.getElementsAnnotatedWith(Inject.class);
        Set<? extends Element> providerSymbols = environment.getElementsAnnotatedWith(Provider.class);
        Set<? extends Element> providesClasses = environment.getElementsAnnotatedWith(Provides.class);
        Set<? extends Element> requiresClasses = environment.getElementsAnnotatedWith(Requires.class);
        Stream symbols = settingsSymbols.stream();
        symbols = Stream.concat(symbols, injectSymbols.stream());
        symbols = Stream.concat(symbols, providerSymbols.stream());
        Set<Element> classes = symbols.map(Element::getEnclosingElement).filter(this::isExtension).collect(Collectors.toSet());
        classes.addAll(requiresClasses);
        classes.addAll(providesClasses);
        classes.addAll(extensionClasses);
        return classes;
    }

    private boolean isExtension(Element element) {
        TypeElement t = (TypeElement)element;
        while (t != null && !t.toString().equals(Object.class.getName())) {
            if (t.getInterfaces().stream().anyMatch(p -> p.toString().contains(SERVICE_EXTENSION_NAME))) {
                return true;
            }
            t = (TypeElement)this.typeUtils.asElement(t.getSuperclass());
        }
        return false;
    }
}

