/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.azure.blob.testfixtures;

import java.time.Instant;
import java.util.UUID;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.transfer.DataFlowStartMessage;

public class AzureStorageTestFixtures {
    private AzureStorageTestFixtures() {
    }

    public static DataFlowStartMessage.Builder createRequest(String type) {
        return DataFlowStartMessage.Builder.newInstance().id(UUID.randomUUID().toString()).processId(UUID.randomUUID().toString()).sourceDataAddress(AzureStorageTestFixtures.createDataAddress(type).build()).destinationDataAddress(AzureStorageTestFixtures.createDataAddress(type).build());
    }

    public static DataAddress.Builder createDataAddress(String type) {
        return DataAddress.Builder.newInstance().type(type);
    }

    public static String createAccountName() {
        return "acct" + Instant.now().getEpochSecond();
    }

    public static String createContainerName() {
        return ("cont-" + UUID.randomUUID()).toLowerCase();
    }

    public static String createBlobName() {
        return "blob-" + UUID.randomUUID();
    }

    public static String createBlobPrefix() {
        return "blobFolder-" + UUID.randomUUID() + "/";
    }

    public static String createSharedKey() {
        return "SK-" + UUID.randomUUID();
    }

    public static String createSharedAccessSignature() {
        return "SAS-" + UUID.randomUUID();
    }
}

