/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.controlplane.callback.staticendpoint;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.edc.connector.controlplane.services.spi.callback.CallbackRegistry;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;

@Extension(value="Static callbacks extension")
public class CallbackStaticEndpointExtension
implements ServiceExtension {
    public static final String EDC_CALLBACK_SETTING_PREFIX = "edc.callback";
    public static final String EDC_CALLBACK_URI = "uri";
    public static final String EDC_CALLBACK_EVENTS = "events";
    public static final String EDC_CALLBACK_TRANSACTIONAL = "transactional";
    public static final String EDC_CALLBACK_AUTH_KEY = "auth-key";
    public static final String EDC_CALLBACK_AUTH_CODE_ID = "auth-code-id";
    static final String NAME = "Static callbacks extension";
    @Inject
    private CallbackRegistry callbackRegistry;

    public void initialize(ServiceExtensionContext context) {
        context.getConfig(EDC_CALLBACK_SETTING_PREFIX).partition().map(this::configureCallback).forEach(arg_0 -> ((CallbackRegistry)this.callbackRegistry).register(arg_0));
    }

    public String name() {
        return NAME;
    }

    public CallbackAddress configureCallback(Config config) {
        Set events = Arrays.stream(config.getString(EDC_CALLBACK_EVENTS).split(",")).map(String::trim).collect(Collectors.toSet());
        String authKey = config.getString(EDC_CALLBACK_AUTH_KEY, null);
        String authCodeId = config.getString(EDC_CALLBACK_AUTH_CODE_ID, null);
        if (authKey != null && authCodeId == null) {
            throw new EdcException(String.format("%s cannot be null if %s is present", EDC_CALLBACK_AUTH_CODE_ID, EDC_CALLBACK_AUTH_KEY));
        }
        return CallbackAddress.Builder.newInstance().uri(config.getString(EDC_CALLBACK_URI)).transactional(config.getBoolean(EDC_CALLBACK_TRANSACTIONAL, Boolean.valueOf(false)).booleanValue()).authKey(authKey).authCodeId(authCodeId).events(events).build();
    }
}

