/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.control.configuration;

import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provider;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Extension(value="Control API configuration")
public class ControlApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Control API configuration";
    private static final String WEB_SERVICE_NAME = "Control API";
    private static final String CONTROL_CONTEXT_ALIAS = "control";
    private static final int DEFAULT_CONTROL_API_PORT = 9191;
    private static final String DEFAULT_CONTROL_API_CONTEXT_PATH = "/api/v1/control";
    @Inject
    private WebServer webServer;
    @Inject
    private WebServiceConfigurer configurator;

    public String name() {
        return NAME;
    }

    @Provider
    public ControlApiConfiguration controlApiConfiguration(ServiceExtensionContext context) {
        WebServiceSettings settings = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.control").contextAlias(CONTROL_CONTEXT_ALIAS).defaultPath(DEFAULT_CONTROL_API_CONTEXT_PATH).defaultPort(9191).useDefaultContext(true).name(WEB_SERVICE_NAME).build();
        WebServiceConfiguration webServiceConfiguration = this.configurator.configure(context, this.webServer, settings);
        return new ControlApiConfiguration(webServiceConfiguration);
    }
}

