/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.control.configuration;

import java.net.URI;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Extension(value="Control API configuration")
@Provides(value={ControlApiConfiguration.class, ControlApiUrl.class})
public class ControlApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Control API configuration";
    @Setting(value="Configures endpoint for reaching the Control API. If it's missing it defaults to the hostname configuration.")
    public static final String CONTROL_API_ENDPOINT = "edc.control.endpoint";
    public static final String CONTROL_CONTEXT_ALIAS = "control";
    private static final String WEB_SERVICE_NAME = "Control API";
    private static final int DEFAULT_CONTROL_API_PORT = 9191;
    private static final String DEFAULT_CONTROL_API_CONTEXT_PATH = "/api/v1/control";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.control").contextAlias("control").defaultPath("/api/v1/control").defaultPort(9191).useDefaultContext(true).name("Control API").build();
    @Inject
    private WebServer webServer;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private Hostname hostname;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration config = this.configurator.configure(context, this.webServer, SETTINGS);
        ControlApiUrl callbackAddress = this.controlApiUrl(context, config);
        context.registerService(ControlApiConfiguration.class, (Object)new ControlApiConfiguration(config));
        context.registerService(ControlApiUrl.class, (Object)callbackAddress);
    }

    private ControlApiUrl controlApiUrl(ServiceExtensionContext context, WebServiceConfiguration config) {
        String callbackAddress = context.getSetting(CONTROL_API_ENDPOINT, String.format("http://%s:%s%s", this.hostname.get(), config.getPort(), config.getPath()));
        try {
            URI url = URI.create(callbackAddress);
            return () -> url;
        }
        catch (IllegalArgumentException e) {
            context.getMonitor().severe("Error creating control plane endpoint url", new Throwable[]{e});
            throw new EdcException((Throwable)e);
        }
    }
}

