/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.control.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import org.eclipse.edc.connector.api.control.configuration.ControlApiConfiguration;
import org.eclipse.edc.connector.controlplane.transfer.spi.callback.ControlApiUrl;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.system.Hostname;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.jersey.providers.jsonld.JerseyJsonLdInterceptor;
import org.eclipse.edc.web.jersey.providers.jsonld.ObjectMapperProvider;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

@Extension(value="Control API configuration")
@Provides(value={ControlApiConfiguration.class, ControlApiUrl.class})
public class ControlApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Control API configuration";
    @Setting(value="Configures endpoint for reaching the Control API. If it's missing it defaults to the hostname configuration.")
    public static final String CONTROL_API_ENDPOINT = "edc.control.endpoint";
    public static final String CONTROL_CONTEXT_ALIAS = "control";
    private static final String WEB_SERVICE_NAME = "Control API";
    private static final int DEFAULT_CONTROL_API_PORT = 9191;
    private static final String DEFAULT_CONTROL_API_CONTEXT_PATH = "/api/v1/control";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.control").contextAlias("control").defaultPath("/api/v1/control").defaultPort(9191).useDefaultContext(true).name("Control API").build();
    private static final String CONTROL_SCOPE = "CONTROL_API";
    @Inject
    private WebServer webServer;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private WebService webService;
    @Inject
    private Hostname hostname;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration config = this.configurator.configure(context, this.webServer, SETTINGS);
        ControlApiUrl callbackAddress = this.controlApiUrl(context, config);
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        context.registerService(ControlApiConfiguration.class, (Object)new ControlApiConfiguration(config));
        context.registerService(ControlApiUrl.class, (Object)callbackAddress);
        this.jsonLd.registerNamespace("odrl", "http://www.w3.org/ns/odrl/2/", CONTROL_SCOPE);
        this.jsonLd.registerNamespace("dspace", "https://w3id.org/dspace/v0.8/", CONTROL_SCOPE);
        this.webService.registerResource(SETTINGS.getContextAlias(), (Object)new ObjectMapperProvider(jsonLdMapper));
        this.webService.registerResource(SETTINGS.getContextAlias(), (Object)new JerseyJsonLdInterceptor(this.jsonLd, jsonLdMapper, CONTROL_SCOPE));
    }

    private ControlApiUrl controlApiUrl(ServiceExtensionContext context, WebServiceConfiguration config) {
        String callbackAddress = context.getSetting(CONTROL_API_ENDPOINT, String.format("http://%s:%s%s", this.hostname.get(), config.getPort(), config.getPath()));
        try {
            URI url = URI.create(callbackAddress);
            return () -> url;
        }
        catch (IllegalArgumentException e) {
            context.getMonitor().severe("Error creating control plane endpoint url", new Throwable[]{e});
            throw new EdcException((Throwable)e);
        }
    }
}

