/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.dataplane.selector.api;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.eclipse.edc.connector.dataplane.selector.api.DataplaneSelectorApi;
import org.eclipse.edc.connector.dataplane.selector.api.SelectionRequest;
import org.eclipse.edc.connector.dataplane.selector.spi.DataPlaneSelectorService;
import org.eclipse.edc.connector.dataplane.selector.spi.instance.DataPlaneInstance;
import org.eclipse.edc.web.spi.exception.ServiceResultHandler;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/instances")
public class DataplaneSelectorApiController
implements DataplaneSelectorApi {
    private final DataPlaneSelectorService selectionService;

    public DataplaneSelectorApiController(DataPlaneSelectorService selectionService) {
        this.selectionService = selectionService;
    }

    @POST
    @Path(value="select")
    public DataPlaneInstance find(SelectionRequest request) {
        if (request.getStrategy() != null) {
            return this.selectionService.select(request.getSource(), request.getDestination(), request.getStrategy());
        }
        return this.selectionService.select(request.getSource(), request.getDestination());
    }

    @POST
    public void addEntry(DataPlaneInstance instance) {
        this.selectionService.addInstance(instance).orElseThrow(ServiceResultHandler.exceptionMapper(DataPlaneInstance.class, (String)instance.getId()));
    }

    @GET
    public List<DataPlaneInstance> getAll() {
        return this.selectionService.getAll();
    }
}

