/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.dispatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.edc.http.spi.EdcHttpClient;
import org.eclipse.edc.http.spi.FallbackFactories;
import org.eclipse.edc.policy.engine.spi.PolicyContext;
import org.eclipse.edc.policy.engine.spi.PolicyContextImpl;
import org.eclipse.edc.policy.engine.spi.PolicyEngine;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRemoteMessageDispatcher;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.response.DspHttpResponseBodyExtractor;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.iam.AudienceResolver;
import org.eclipse.edc.spi.iam.IdentityService;
import org.eclipse.edc.spi.iam.RequestContext;
import org.eclipse.edc.spi.iam.RequestScope;
import org.eclipse.edc.spi.iam.TokenParameters;
import org.eclipse.edc.spi.response.ResponseStatus;
import org.eclipse.edc.spi.response.StatusResult;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.token.spi.TokenDecorator;
import org.jetbrains.annotations.NotNull;

public class DspHttpRemoteMessageDispatcherImpl
implements DspHttpRemoteMessageDispatcher {
    private static final String AUDIENCE_CLAIM = "aud";
    private static final String SCOPE_CLAIM = "scope";
    private final Map<Class<? extends RemoteMessage>, MessageHandler<?, ?>> handlers = new HashMap();
    private final Map<Class<? extends RemoteMessage>, PolicyScope<? extends RemoteMessage>> policyScopes = new HashMap<Class<? extends RemoteMessage>, PolicyScope<? extends RemoteMessage>>();
    private final EdcHttpClient httpClient;
    private final IdentityService identityService;
    private final PolicyEngine policyEngine;
    private final TokenDecorator tokenDecorator;
    private final AudienceResolver audienceResolver;

    public DspHttpRemoteMessageDispatcherImpl(EdcHttpClient httpClient, IdentityService identityService, TokenDecorator decorator, PolicyEngine policyEngine, AudienceResolver audienceResolver) {
        this.httpClient = httpClient;
        this.identityService = identityService;
        this.policyEngine = policyEngine;
        this.tokenDecorator = decorator;
        this.audienceResolver = audienceResolver;
    }

    public String protocol() {
        return "dataspace-protocol-http";
    }

    public <T, M extends RemoteMessage> CompletableFuture<StatusResult<T>> dispatch(Class<T> responseType, M message) {
        MessageHandler<?, ?> handler = this.handlers.get(message.getClass());
        if (handler == null) {
            return CompletableFuture.failedFuture((Throwable)new EdcException(String.format("No DSP message dispatcher found for message type %s", message.getClass())));
        }
        Request request = handler.requestFactory.createRequest(message);
        TokenParameters.Builder tokenParametersBuilder = TokenParameters.Builder.newInstance();
        PolicyScope<? extends RemoteMessage> policyScope = this.policyScopes.get(message.getClass());
        if (policyScope != null) {
            RequestScope.Builder requestScopeBuilder = RequestScope.Builder.newInstance();
            RequestContext requestContext = RequestContext.Builder.newInstance().message(message).direction(RequestContext.Direction.Egress).build();
            PolicyContext context = PolicyContextImpl.Builder.newInstance().additional(RequestScope.Builder.class, (Object)requestScopeBuilder).additional(RequestContext.class, (Object)requestContext).build();
            Function policyProvider = policyScope.policyProvider;
            this.policyEngine.evaluate(policyScope.scope, policyProvider.apply(message), context);
            Set scopes = requestScopeBuilder.build().getScopes();
            if (!scopes.isEmpty()) {
                tokenParametersBuilder.claims(SCOPE_CLAIM, (Object)String.join((CharSequence)" ", scopes));
            }
        }
        TokenParameters tokenParameters = this.tokenDecorator.decorate(tokenParametersBuilder).claims(AUDIENCE_CLAIM, (Object)this.audienceResolver.resolve(message)).build();
        return (CompletableFuture)this.identityService.obtainClientCredentials(tokenParameters).map(token -> {
            Request requestWithAuth = request.newBuilder().header("Authorization", token.getToken()).build();
            return this.httpClient.executeAsync(requestWithAuth, List.of(FallbackFactories.retryWhenStatusNot2xxOr4xx())).thenApply(response -> this.handleResponse((Response)response, responseType, (DspHttpResponseBodyExtractor)handler.bodyExtractor));
        }).orElse(failure -> CompletableFuture.failedFuture((Throwable)new EdcException(String.format("Unable to obtain credentials: %s", failure.getFailureDetail()))));
    }

    public <M extends RemoteMessage, R> void registerMessage(Class<M> clazz, DspHttpRequestFactory<M> requestFactory, DspHttpResponseBodyExtractor<R> bodyExtractor) {
        this.handlers.put(clazz, new MessageHandler<M, R>(requestFactory, bodyExtractor));
    }

    public <M extends RemoteMessage> void registerPolicyScope(Class<M> messageClass, String scope, Function<M, Policy> policyProvider) {
        this.policyScopes.put(messageClass, new PolicyScope<M>(messageClass, scope, policyProvider));
    }

    @NotNull
    private <T> StatusResult<T> handleResponse(Response response, Class<T> responseType, DspHttpResponseBodyExtractor<T> bodyExtractor) {
        try (ResponseBody responseBody = response.body();){
            if (response.isSuccessful()) {
                Object responsePayload = bodyExtractor.extractBody(responseBody);
                StatusResult statusResult = StatusResult.success(responseType.cast(responsePayload));
                return statusResult;
            }
            String stringBody = Optional.ofNullable(responseBody).map(this::asString).orElse("Response body is null");
            ResponseStatus status = response.code() >= 400 && response.code() < 500 ? ResponseStatus.FATAL_ERROR : ResponseStatus.ERROR_RETRY;
            StatusResult statusResult = StatusResult.failure((ResponseStatus)status, (String)stringBody);
            return statusResult;
        }
    }

    private String asString(ResponseBody it) {
        try {
            return it.string();
        }
        catch (IOException e) {
            return "Cannot read response body: " + e.getMessage();
        }
    }

    private record MessageHandler<M extends RemoteMessage, R>(DspHttpRequestFactory<M> requestFactory, DspHttpResponseBodyExtractor<R> bodyExtractor) {
    }

    private record PolicyScope<M extends RemoteMessage>(Class<M> messageClass, String scope, Function<M, Policy> policyProvider) {
    }
}

