/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.dispatcher;

import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.RequestPathProvider;
import org.eclipse.edc.protocol.dsp.http.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;

public class PostDspHttpRequestFactory<M extends RemoteMessage>
implements DspHttpRequestFactory<M> {
    public static final String APPLICATION_JSON = "application/json";
    private final RequestPathProvider<M> pathProvider;
    private final JsonLdRemoteMessageSerializer serializer;

    public PostDspHttpRequestFactory(JsonLdRemoteMessageSerializer serializer, RequestPathProvider<M> pathProvider) {
        this.serializer = serializer;
        this.pathProvider = pathProvider;
    }

    public Request createRequest(M message) {
        String body = this.serializer.serialize(message);
        RequestBody requestBody = RequestBody.create((String)body, (MediaType)MediaType.get((String)APPLICATION_JSON));
        HttpUrl url = HttpUrl.get((String)(message.getCounterPartyAddress() + this.pathProvider.providePath(message)));
        return new Request.Builder().url(url).header("Content-Type", APPLICATION_JSON).post(requestBody).build();
    }
}

