/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.message;

import jakarta.json.JsonObject;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.UUID;
import org.eclipse.edc.protocol.dsp.http.spi.error.DspErrorResponse;
import org.eclipse.edc.protocol.dsp.http.spi.message.DspRequestHandler;
import org.eclipse.edc.protocol.dsp.http.spi.message.GetDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.PostDspRequest;
import org.eclipse.edc.protocol.dsp.http.spi.message.ResponseDecorator;
import org.eclipse.edc.spi.iam.TokenRepresentation;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.eclipse.edc.spi.result.ServiceResult;
import org.eclipse.edc.spi.types.domain.message.ProcessRemoteMessage;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.eclipse.edc.validator.spi.JsonObjectValidatorRegistry;
import org.eclipse.edc.validator.spi.ValidationResult;

public class DspRequestHandlerImpl
implements DspRequestHandler {
    private final Monitor monitor;
    private final JsonObjectValidatorRegistry validatorRegistry;
    private final TypeTransformerRegistry transformerRegistry;

    public DspRequestHandlerImpl(Monitor monitor, JsonObjectValidatorRegistry validatorRegistry, TypeTransformerRegistry transformerRegistry) {
        this.monitor = monitor;
        this.validatorRegistry = validatorRegistry;
        this.transformerRegistry = transformerRegistry;
    }

    public <R> Response getResource(GetDspRequest<R> request) {
        this.monitor.debug(() -> "DSP: Incoming resource request for %s id %s".formatted(request.getResultClass(), request.getId()), new Throwable[0]);
        String token = request.getToken();
        if (token == null) {
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getId()).unauthorized();
        }
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        ServiceResult serviceResult = (ServiceResult)request.getServiceCall().apply(request.getId(), tokenRepresentation);
        if (serviceResult.failed()) {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(serviceResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getId()).from((ServiceFailure)serviceResult.getFailure());
        }
        Object resource = serviceResult.getContent();
        Result transformation = this.transformerRegistry.transform(resource, JsonObject.class);
        if (transformation.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning("Error transforming %s, error id %s: %s".formatted(request.getResultClass().getSimpleName(), errorCode, transformation.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getId()).message(String.format("Error code %s", errorCode)).internalServerError();
        }
        return Response.ok().type("application/json").entity(transformation.getContent()).build();
    }

    public <I extends RemoteMessage, R> Response createResource(PostDspRequest<I, R> request, ResponseDecorator<I, R> responseDecorator) {
        this.monitor.debug(() -> "DSP: Incoming %s for %s process%s".formatted(request.getInputClass().getSimpleName(), request.getResultClass(), request.getProcessId() != null ? ": " + request.getProcessId() : ""), new Throwable[0]);
        String token = request.getToken();
        if (token == null) {
            return DspErrorResponse.type((String)request.getErrorType()).unauthorized();
        }
        ValidationResult validation = this.validatorRegistry.validate(request.getExpectedMessageType(), request.getMessage());
        if (validation.failed()) {
            this.monitor.debug(() -> "DSP: Validation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).badRequest();
        }
        Result inputTransformation = (Result)this.transformerRegistry.transform((Object)request.getMessage(), request.getInputClass()).compose(message -> {
            if (message instanceof ProcessRemoteMessage) {
                ProcessRemoteMessage processRemoteMessage = (ProcessRemoteMessage)message;
                processRemoteMessage.setProtocol("dataspace-protocol-http");
            }
            return Result.success((Object)message);
        });
        if (inputTransformation.failed()) {
            this.monitor.debug(() -> "DSP: Transformation failed: %s".formatted(inputTransformation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).badRequest();
        }
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(token).build();
        RemoteMessage input = (RemoteMessage)inputTransformation.getContent();
        ServiceResult serviceResult = (ServiceResult)request.getServiceCall().apply(input, tokenRepresentation);
        if (serviceResult.failed()) {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(serviceResult.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).from((ServiceFailure)serviceResult.getFailure());
        }
        Object resource = serviceResult.getContent();
        Result outputTransformation = this.transformerRegistry.transform(resource, JsonObject.class);
        if (outputTransformation.failed()) {
            UUID errorCode = UUID.randomUUID();
            this.monitor.warning("Error transforming %s, error id %s: %s".formatted(request.getResultClass().getSimpleName(), errorCode, outputTransformation.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).message("Error code %s".formatted(errorCode)).internalServerError();
        }
        return responseDecorator.decorate(Response.ok(), (Object)input, resource).type("application/json").entity(outputTransformation.getContent()).build();
    }

    public <I extends RemoteMessage, R> Response updateResource(PostDspRequest<I, R> request) {
        this.monitor.debug(() -> "DSP: Incoming %s for %s process%s".formatted(request.getInputClass().getSimpleName(), request.getResultClass(), request.getProcessId() != null ? ": " + request.getProcessId() : ""), new Throwable[0]);
        String token = request.getToken();
        if (token == null) {
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getProcessId()).unauthorized();
        }
        TokenRepresentation tokenRepresentation = TokenRepresentation.Builder.newInstance().token(request.getToken()).build();
        ValidationResult validation = this.validatorRegistry.validate(request.getExpectedMessageType(), request.getMessage());
        if (validation.failed()) {
            this.monitor.debug(() -> "DSP: Validation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getProcessId()).badRequest();
        }
        Result inputTransformation = (Result)this.transformerRegistry.transform((Object)request.getMessage(), request.getInputClass()).compose(message -> {
            if (message instanceof ProcessRemoteMessage) {
                ProcessRemoteMessage processRemoteMessage = (ProcessRemoteMessage)message;
                Result processIdValidation = processRemoteMessage.isValidProcessId(request.getProcessId());
                if (processIdValidation.succeeded()) {
                    processRemoteMessage.setProcessId(request.getProcessId());
                    processRemoteMessage.setProtocol("dataspace-protocol-http");
                    return Result.success((Object)message);
                }
                return Result.failure((String)"DSP: %s".formatted(processIdValidation.getFailureDetail()));
            }
            return Result.success((Object)message);
        });
        if (inputTransformation.failed()) {
            this.monitor.debug(() -> "DSP: Transformation failed: %s".formatted(validation.getFailureMessages()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getProcessId()).badRequest();
        }
        return (Response)((ServiceResult)request.getServiceCall().apply((RemoteMessage)inputTransformation.getContent(), tokenRepresentation)).map(it -> Response.ok().type(MediaType.APPLICATION_JSON_TYPE).build()).orElse(failure -> {
            this.monitor.debug(() -> "DSP: Service call failed: %s".formatted(failure.getFailureDetail()), new Throwable[0]);
            return DspErrorResponse.type((String)request.getErrorType()).processId(request.getProcessId()).from(failure);
        });
    }
}

