/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonObject;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.http.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.domain.message.RemoteMessage;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;

public class JsonLdRemoteMessageSerializerImpl
implements JsonLdRemoteMessageSerializer {
    private final TypeTransformerRegistry registry;
    private final ObjectMapper mapper;
    private final JsonLd jsonLdService;
    private final String scope;

    public JsonLdRemoteMessageSerializerImpl(TypeTransformerRegistry registry, ObjectMapper mapper, JsonLd jsonLdService, String scope) {
        this.registry = registry;
        this.mapper = mapper;
        this.jsonLdService = jsonLdService;
        this.scope = scope;
    }

    public String serialize(RemoteMessage message) {
        try {
            Result transformResult = this.registry.transform((Object)message, JsonObject.class);
            if (transformResult.succeeded()) {
                Result compacted = this.jsonLdService.compact((JsonObject)transformResult.getContent(), this.scope);
                if (compacted.succeeded()) {
                    return this.mapper.writeValueAsString(compacted.getContent());
                }
                throw new EdcException("Failed to compact JSON-LD: " + compacted.getFailureDetail());
            }
            throw new EdcException(String.format("Failed to transform %s: %s", message.getClass().getSimpleName(), String.join((CharSequence)", ", transformResult.getFailureMessages())));
        }
        catch (JsonProcessingException e) {
            throw new EdcException(String.format("Failed to serialize %s", message.getClass().getSimpleName()), (Throwable)e);
        }
    }
}

