/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.http.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.ResponseBody;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.response.DspHttpResponseBodyExtractor;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.Failure;
import org.eclipse.edc.transform.spi.TypeTransformerRegistry;
import org.jetbrains.annotations.NotNull;

public class JsonLdResponseBodyDeserializer<T>
implements DspHttpResponseBodyExtractor<T> {
    private final Class<T> type;
    private final ObjectMapper objectMapper;
    private final JsonLd jsonLd;
    private final TypeTransformerRegistry transformerRegistry;

    public JsonLdResponseBodyDeserializer(Class<T> type, ObjectMapper objectMapper, JsonLd jsonLd, TypeTransformerRegistry transformerRegistry) {
        this.type = type;
        this.objectMapper = objectMapper;
        this.jsonLd = jsonLd;
        this.transformerRegistry = transformerRegistry;
    }

    public T extractBody(ResponseBody responseBody) {
        try {
            JsonObject jsonObject = (JsonObject)this.objectMapper.readValue(responseBody.byteStream(), JsonObject.class);
            JsonObject expanded = (JsonObject)this.jsonLd.expand(jsonObject).orElseThrow(this.exception("Cannot expand json-ld"));
            return (T)this.transformerRegistry.transform((Object)expanded, this.type).orElseThrow(this.exception("Cannot transform json to ContractNegotiationAck"));
        }
        catch (IOException e) {
            throw new EdcException("Cannot deserialize response body as JsonObject", (Throwable)e);
        }
    }

    @NotNull
    private Function<Failure, EdcException> exception(String message) {
        return f -> new EdcException("%s: %s".formatted(message, f.getFailureDetail()));
    }
}

