/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.protocol.dsp.negotiation.http.dispatcher;

import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractAgreementVerificationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.agreement.ContractNegotiationEventMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractNegotiationTerminationMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractOfferMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.negotiation.ContractRequestMessage;
import org.eclipse.edc.connector.controlplane.contract.spi.types.protocol.ContractNegotiationAck;
import org.eclipse.edc.jsonld.spi.JsonLd;
import org.eclipse.edc.protocol.dsp.http.dispatcher.PostDspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.serialization.JsonLdResponseBodyDeserializer;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRemoteMessageDispatcher;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspHttpRequestFactory;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.DspRequestBasePathProvider;
import org.eclipse.edc.protocol.dsp.http.spi.dispatcher.response.DspHttpResponseBodyExtractor;
import org.eclipse.edc.protocol.dsp.http.spi.serialization.JsonLdRemoteMessageSerializer;
import org.eclipse.edc.protocol.dsp.spi.transform.DspProtocolTypeTransformerRegistry;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Dataspace Protocol Negotiation HTTP Dispatcher Extension")
public class DspNegotiationHttpDispatcherExtension
implements ServiceExtension {
    public static final String NAME = "Dataspace Protocol Negotiation HTTP Dispatcher Extension";
    @Inject
    private DspHttpRemoteMessageDispatcher messageDispatcher;
    @Inject
    private JsonLdRemoteMessageSerializer remoteMessageSerializer;
    @Inject
    private TypeManager typeManager;
    @Inject
    private DspProtocolTypeTransformerRegistry dspTransformerRegistry;
    @Inject
    private JsonLd jsonLd;
    @Inject
    private DspRequestBasePathProvider dspRequestBasePathProvider;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        JsonLdResponseBodyDeserializer contractNegotiationAckDeserializer = new JsonLdResponseBodyDeserializer(ContractNegotiationAck.class, this.typeManager, "json-ld", this.jsonLd, this.dspTransformerRegistry);
        this.messageDispatcher.registerMessage(ContractAgreementMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> "/negotiations/" + m.getProcessId() + "/agreement"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(ContractAgreementVerificationMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> "/negotiations/" + m.getProcessId() + "/agreement/verification"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(ContractNegotiationEventMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> "/negotiations/" + m.getProcessId() + "/events"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(ContractNegotiationTerminationMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> "/negotiations/" + m.getProcessId() + "/termination"), DspHttpResponseBodyExtractor.NOOP);
        this.messageDispatcher.registerMessage(ContractRequestMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> {
            if (m.getType() == ContractRequestMessage.Type.INITIAL) {
                return "/negotiations/request";
            }
            return "/negotiations/" + m.getProcessId() + "/request";
        }), (DspHttpResponseBodyExtractor)contractNegotiationAckDeserializer);
        this.messageDispatcher.registerMessage(ContractOfferMessage.class, (DspHttpRequestFactory)new PostDspHttpRequestFactory(this.remoteMessageSerializer, this.dspRequestBasePathProvider, m -> "/negotiations/" + m.getProcessId() + "/offers"), (DspHttpResponseBodyExtractor)contractNegotiationAckDeserializer);
    }
}

