/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.catalog.store.sql;

import org.eclipse.edc.catalog.store.sql.FederatedCatalogCacheStatements;
import org.eclipse.edc.catalog.store.sql.schema.postgres.FederatedCatalogMapping;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.sql.translation.SqlOperatorTranslator;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.sql.translation.TranslationMapping;

public abstract class BaseSqlDialectStatements
implements FederatedCatalogCacheStatements {
    protected final SqlOperatorTranslator operatorTranslator;

    protected BaseSqlDialectStatements(SqlOperatorTranslator operatorTranslator) {
        this.operatorTranslator = operatorTranslator;
    }

    @Override
    public String getFindByIdTemplate() {
        return String.format("SELECT * FROM %s WHERE %s = ?", this.getFederatedCatalogTable(), this.getIdColumn());
    }

    @Override
    public String getUpdateAsMarkedTemplate() {
        return String.format("UPDATE %s SET %s = ?", this.getFederatedCatalogTable(), this.getMarkedColumn());
    }

    @Override
    public String getDeleteByMarkedTemplate() {
        return this.executeStatement().delete(this.getFederatedCatalogTable(), this.getMarkedColumn());
    }

    @Override
    public String getInsertTemplate() {
        return this.executeStatement().column(this.getIdColumn()).jsonColumn(this.getCatalogColumn()).column(this.getMarkedColumn()).insertInto(this.getFederatedCatalogTable());
    }

    @Override
    public String getUpdateTemplate() {
        return this.executeStatement().jsonColumn(this.getCatalogColumn()).column(this.getMarkedColumn()).update(this.getFederatedCatalogTable(), this.getIdColumn());
    }

    @Override
    public SqlQueryStatement createQuery(QuerySpec querySpec) {
        String select = this.getSelectStatement();
        return new SqlQueryStatement(select, querySpec, (TranslationMapping)new FederatedCatalogMapping(this), this.operatorTranslator);
    }

    @Override
    public String getSelectStatement() {
        return String.format("SELECT * FROM %s", this.getFederatedCatalogTable());
    }
}

