/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.catalog.store.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.edc.catalog.spi.FederatedCatalogCache;
import org.eclipse.edc.catalog.store.sql.FederatedCatalogCacheStatements;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class SqlFederatedCatalogCache
extends AbstractSqlStore
implements FederatedCatalogCache {
    private final FederatedCatalogCacheStatements statements;

    public SqlFederatedCatalogCache(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, QueryExecutor queryExecutor, FederatedCatalogCacheStatements statements) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
    }

    public void save(Catalog catalog) {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String id = Optional.ofNullable(catalog.getProperties().get("https://w3id.org/edc/v0.0.1/ns/originator")).map(Object::toString).orElse(catalog.getId());
                if (this.findByIdInternal(connection, id) == null) {
                    this.insertInternal(connection, id, catalog);
                } else {
                    this.updateInternal(connection, id, catalog);
                }
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public Collection<Catalog> query(QuerySpec querySpec) {
        return (Collection)this.transactionContext.execute(() -> {
            List list;
            block8: {
                Connection connection = this.getConnection();
                try {
                    SqlQueryStatement query = this.statements.createQuery(querySpec);
                    list = this.queryExecutor.query(connection, true, this::mapResultSet, query.getQueryAsString(), query.getParameters()).toList();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return list;
        });
    }

    public void deleteExpired() {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String stmt = this.statements.getDeleteByMarkedTemplate();
                this.queryExecutor.execute(connection, stmt, new Object[]{true});
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    public void expireAll() {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String stmt = this.statements.getUpdateAsMarkedTemplate();
                this.queryExecutor.execute(connection, stmt, new Object[]{true});
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    private Catalog findByIdInternal(Connection connection, String id) {
        String stmt = this.statements.getFindByIdTemplate();
        return (Catalog)this.queryExecutor.single(connection, false, this::mapResultSet, stmt, new Object[]{id});
    }

    private void insertInternal(Connection connection, String id, Catalog catalog) {
        String stmt = this.statements.getInsertTemplate();
        this.queryExecutor.execute(connection, stmt, new Object[]{id, this.toJson(catalog), false});
    }

    private void updateInternal(Connection connection, String id, Catalog catalog) {
        String stmt = this.statements.getUpdateTemplate();
        this.queryExecutor.execute(connection, stmt, new Object[]{this.toJson(catalog), false, id});
    }

    private Catalog mapResultSet(ResultSet resultSet) throws Exception {
        String json = resultSet.getString(this.statements.getCatalogColumn());
        return (Catalog)this.fromJson(json, Catalog.class);
    }
}

