/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.catalog.store.sql;

import org.eclipse.edc.catalog.spi.FederatedCatalogCache;
import org.eclipse.edc.catalog.store.sql.FederatedCatalogCacheStatements;
import org.eclipse.edc.catalog.store.sql.SqlFederatedCatalogCache;
import org.eclipse.edc.catalog.store.sql.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.connector.controlplane.catalog.spi.Catalog;
import org.eclipse.edc.connector.controlplane.catalog.spi.Dataset;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.bootstrapper.SqlSchemaBootstrapper;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={FederatedCatalogCache.class})
@Extension(value="SQL federated catalog cache")
public class SqlFederatedCatalogCacheExtension
implements ServiceExtension {
    @Setting(description="The datasource to be used", defaultValue="default", key="edc.sql.store.federatedcatalog.datasource")
    private String dataSourceName;
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext trxContext;
    @Inject(required=false)
    private FederatedCatalogCacheStatements statements;
    @Inject
    private TypeManager typeManager;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject
    private SqlSchemaBootstrapper sqlSchemaBootstrapper;

    public void initialize(ServiceExtensionContext context) {
        this.typeManager.registerTypes(new Class[]{Catalog.class, Dataset.class});
        SqlFederatedCatalogCache store = new SqlFederatedCatalogCache(this.dataSourceRegistry, this.dataSourceName, this.trxContext, this.typeManager.getMapper(), this.queryExecutor, this.getStatementImpl());
        context.registerService(FederatedCatalogCache.class, (Object)store);
        this.sqlSchemaBootstrapper.addStatementFromResource(this.dataSourceName, "cache-schema.sql");
    }

    private FederatedCatalogCacheStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }
}

