/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.eclipse.edc.api.auth.spi.AuthenticationRequestFilter;
import org.eclipse.edc.api.auth.spi.AuthenticationService;
import org.eclipse.edc.connector.api.management.configuration.ManagementApiConfiguration;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.WebService;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;
import org.eclipse.edc.web.spi.provider.ObjectMapperProvider;

@Provides(value={ManagementApiConfiguration.class})
@Extension(value="Management API configuration")
public class ManagementApiConfigurationExtension
implements ServiceExtension {
    public static final String NAME = "Management API configuration";
    private static final String MANAGEMENT_CONTEXT_ALIAS = "management";
    private static final int DEFAULT_MANAGEMENT_API_PORT = 8181;
    private static final String DEFAULT_MANAGEMENT_API_CONTEXT_PATH = "/api/v1/management";
    public static final String WEB_SERVICE_NAME = "Management API";
    public static final WebServiceSettings SETTINGS = WebServiceSettings.Builder.newInstance().apiConfigKey("web.http.management").contextAlias("management").defaultPath("/api/v1/management").defaultPort(8181).useDefaultContext(true).name("Management API").build();
    @Inject
    private WebService webService;
    @Inject
    private WebServer webServer;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private WebServiceConfigurer configurator;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        WebServiceConfiguration webServiceConfiguration = this.configurator.configure(context, this.webServer, SETTINGS);
        context.registerService(ManagementApiConfiguration.class, (Object)new ManagementApiConfiguration(webServiceConfiguration));
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new AuthenticationRequestFilter(this.authenticationService));
        ObjectMapper jsonLdMapper = this.typeManager.getMapper("json-ld");
        this.webService.registerResource(webServiceConfiguration.getContextAlias(), (Object)new ObjectMapperProvider(jsonLdMapper));
    }
}

