/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.provision.azure;

import dev.failsafe.RetryPolicy;
import org.eclipse.edc.azure.blob.AzureSasToken;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.connector.provision.azure.blob.ObjectContainerProvisionedResource;
import org.eclipse.edc.connector.provision.azure.blob.ObjectStorageConsumerResourceDefinitionGenerator;
import org.eclipse.edc.connector.provision.azure.blob.ObjectStorageProvisioner;
import org.eclipse.edc.connector.provision.azure.blob.ObjectStorageResourceDefinition;
import org.eclipse.edc.connector.transfer.spi.provision.ConsumerResourceDefinitionGenerator;
import org.eclipse.edc.connector.transfer.spi.provision.ProvisionManager;
import org.eclipse.edc.connector.transfer.spi.provision.Provisioner;
import org.eclipse.edc.connector.transfer.spi.provision.ResourceManifestGenerator;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

public class AzureProvisionExtension
implements ServiceExtension {
    @Inject
    private BlobStoreApi blobStoreApi;
    @Inject
    private RetryPolicy<Object> retryPolicy;
    @Inject
    private ResourceManifestGenerator manifestGenerator;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return "Azure Provision";
    }

    public void initialize(ServiceExtensionContext context) {
        Monitor monitor = context.getMonitor();
        ProvisionManager provisionManager = (ProvisionManager)context.getService(ProvisionManager.class);
        provisionManager.register((Provisioner)new ObjectStorageProvisioner(this.retryPolicy, monitor, this.blobStoreApi));
        this.manifestGenerator.registerGenerator((ConsumerResourceDefinitionGenerator)new ObjectStorageConsumerResourceDefinitionGenerator());
        this.registerTypes(this.typeManager);
    }

    private void registerTypes(TypeManager typeManager) {
        typeManager.registerTypes(new Class[]{ObjectContainerProvisionedResource.class, ObjectStorageResourceDefinition.class, AzureSasToken.class});
    }
}

