/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.provision.azure.blob;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedDataDestinationResource;

@JsonDeserialize(builder=Builder.class)
@JsonTypeName(value="dataspaceconnector:objectcontainerprovisionedresource")
public class ObjectContainerProvisionedResource
extends ProvisionedDataDestinationResource {
    public String getAccountName() {
        return this.getDataAddress().getStringProperty("account");
    }

    public String getContainerName() {
        return this.getDataAddress().getStringProperty("container");
    }

    private ObjectContainerProvisionedResource() {
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends ProvisionedDataDestinationResource.Builder<ObjectContainerProvisionedResource, Builder> {
        private Builder() {
            super((ProvisionedDataDestinationResource)new ObjectContainerProvisionedResource());
            this.dataAddressBuilder.type("AzureStorage");
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder accountName(String accountName) {
            this.dataAddressBuilder.property("https://w3id.org/edc/v0.0.1/ns/account", (Object)accountName);
            return this;
        }

        public Builder containerName(String containerName) {
            this.dataAddressBuilder.property("https://w3id.org/edc/v0.0.1/ns/container", (Object)containerName);
            return this;
        }

        public Builder resourceName(String name) {
            this.dataAddressBuilder.keyName(name);
            super.resourceName(name);
            return this;
        }
    }
}

