/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.provision.azure.blob;

import java.util.UUID;
import org.eclipse.edc.connector.provision.azure.blob.ObjectStorageResourceDefinition;
import org.eclipse.edc.connector.transfer.spi.provision.ConsumerResourceDefinitionGenerator;
import org.eclipse.edc.connector.transfer.spi.types.DataRequest;
import org.eclipse.edc.connector.transfer.spi.types.ResourceDefinition;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.jetbrains.annotations.Nullable;

public class ObjectStorageConsumerResourceDefinitionGenerator
implements ConsumerResourceDefinitionGenerator {
    @Nullable
    public ResourceDefinition generate(DataRequest dataRequest, Policy policy) {
        DataAddress destination = dataRequest.getDataDestination();
        String id = UUID.randomUUID().toString();
        String account = destination.getStringProperty("account");
        String container = destination.getStringProperty("container");
        if (container == null) {
            container = UUID.randomUUID().toString();
        }
        return ((ObjectStorageResourceDefinition.Builder)ObjectStorageResourceDefinition.Builder.newInstance().id(id)).accountName(account).containerName(container).build();
    }

    public boolean canGenerate(DataRequest dataRequest, Policy policy) {
        return "AzureStorage".equals(dataRequest.getDestinationType());
    }
}

