/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.provision.azure.blob;

import dev.failsafe.Failsafe;
import dev.failsafe.RetryPolicy;
import java.time.OffsetDateTime;
import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.azure.blob.AzureSasToken;
import org.eclipse.edc.azure.blob.api.BlobStoreApi;
import org.eclipse.edc.connector.provision.azure.blob.ObjectContainerProvisionedResource;
import org.eclipse.edc.connector.provision.azure.blob.ObjectStorageResourceDefinition;
import org.eclipse.edc.connector.transfer.spi.provision.Provisioner;
import org.eclipse.edc.connector.transfer.spi.types.DeprovisionedResource;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionResponse;
import org.eclipse.edc.connector.transfer.spi.types.ProvisionedResource;
import org.eclipse.edc.connector.transfer.spi.types.ResourceDefinition;
import org.eclipse.edc.connector.transfer.spi.types.SecretToken;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.response.StatusResult;
import org.jetbrains.annotations.NotNull;

public class ObjectStorageProvisioner
implements Provisioner<ObjectStorageResourceDefinition, ObjectContainerProvisionedResource> {
    private final RetryPolicy<Object> retryPolicy;
    private final Monitor monitor;
    private final BlobStoreApi blobStoreApi;

    public ObjectStorageProvisioner(RetryPolicy<Object> retryPolicy, Monitor monitor, BlobStoreApi blobStoreApi) {
        this.retryPolicy = retryPolicy;
        this.monitor = monitor;
        this.blobStoreApi = blobStoreApi;
    }

    public boolean canProvision(ResourceDefinition resourceDefinition) {
        return resourceDefinition instanceof ObjectStorageResourceDefinition;
    }

    public boolean canDeprovision(ProvisionedResource resourceDefinition) {
        return resourceDefinition instanceof ObjectContainerProvisionedResource;
    }

    public CompletableFuture<StatusResult<ProvisionResponse>> provision(ObjectStorageResourceDefinition resourceDefinition, Policy policy) {
        String containerName = resourceDefinition.getContainerName();
        String accountName = resourceDefinition.getAccountName();
        this.monitor.debug("Azure Storage Container request submitted: " + containerName, new Throwable[0]);
        OffsetDateTime expiryTime = OffsetDateTime.now().plusHours(1L);
        return ((CompletableFuture)((CompletableFuture)Failsafe.with(this.retryPolicy, (dev.failsafe.Policy[])new RetryPolicy[0]).getAsync(() -> this.blobStoreApi.exists(accountName, containerName)).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return this.reusingExistingContainer(containerName);
            }
            return this.createContainer(containerName, accountName);
        })).thenCompose(empty -> this.createContainerSasToken(containerName, accountName, expiryTime))).thenApply(writeOnlySas -> {
            String resourceName = resourceDefinition.getId() + "-container";
            ObjectContainerProvisionedResource resource = (ObjectContainerProvisionedResource)((ObjectContainerProvisionedResource.Builder)((ObjectContainerProvisionedResource.Builder)((ObjectContainerProvisionedResource.Builder)((ObjectContainerProvisionedResource.Builder)ObjectContainerProvisionedResource.Builder.newInstance().id(containerName)).accountName(accountName).containerName(containerName).resourceDefinitionId(resourceDefinition.getId())).transferProcessId(resourceDefinition.getTransferProcessId())).resourceName(resourceName).hasToken(true)).build();
            AzureSasToken secretToken = new AzureSasToken("?" + writeOnlySas, expiryTime.toInstant().toEpochMilli());
            ProvisionResponse response = ProvisionResponse.Builder.newInstance().resource((ProvisionedResource)resource).secretToken((SecretToken)secretToken).build();
            return StatusResult.success((Object)response);
        });
    }

    public CompletableFuture<StatusResult<DeprovisionedResource>> deprovision(ObjectContainerProvisionedResource provisionedResource, Policy policy) {
        return Failsafe.with(this.retryPolicy, (dev.failsafe.Policy[])new RetryPolicy[0]).runAsync(() -> this.blobStoreApi.deleteContainer(provisionedResource.getAccountName(), provisionedResource.getContainerName())).thenApply(empty -> StatusResult.success((Object)DeprovisionedResource.Builder.newInstance().provisionedResourceId(provisionedResource.getId()).build()));
    }

    @NotNull
    private CompletableFuture<Void> reusingExistingContainer(String containerName) {
        this.monitor.debug("ObjectStorageProvisioner: re-use existing container " + containerName, new Throwable[0]);
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    private CompletableFuture<Void> createContainer(String containerName, String accountName) {
        return Failsafe.with(this.retryPolicy, (dev.failsafe.Policy[])new RetryPolicy[0]).runAsync(() -> {
            this.blobStoreApi.createContainer(accountName, containerName);
            this.monitor.debug("ObjectStorageProvisioner: created a new container " + containerName, new Throwable[0]);
        });
    }

    @NotNull
    private CompletableFuture<String> createContainerSasToken(String containerName, String accountName, OffsetDateTime expiryTime) {
        return Failsafe.with(this.retryPolicy, (dev.failsafe.Policy[])new RetryPolicy[0]).getAsync(() -> {
            this.monitor.debug("ObjectStorageProvisioner: obtained temporary SAS token (write-only)", new Throwable[0]);
            return this.blobStoreApi.createContainerSasToken(accountName, containerName, "w", expiryTime);
        });
    }
}

