/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.catalog.store.sql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.edc.catalog.store.sql.TargetNodeStatements;
import org.eclipse.edc.crawler.spi.TargetNode;
import org.eclipse.edc.crawler.spi.TargetNodeDirectory;
import org.eclipse.edc.spi.persistence.EdcPersistenceException;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.store.AbstractSqlStore;
import org.eclipse.edc.sql.translation.SqlQueryStatement;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

public class SqlTargetNodeDirectory
extends AbstractSqlStore
implements TargetNodeDirectory {
    private final TargetNodeStatements statements;

    public SqlTargetNodeDirectory(DataSourceRegistry dataSourceRegistry, String dataSourceName, TransactionContext transactionContext, ObjectMapper objectMapper, QueryExecutor queryExecutor, TargetNodeStatements statements) {
        super(dataSourceRegistry, dataSourceName, transactionContext, objectMapper, queryExecutor);
        this.statements = statements;
    }

    public List<TargetNode> getAll() {
        return (List)this.transactionContext.execute(() -> {
            List list;
            block8: {
                Connection connection = this.getConnection();
                try {
                    SqlQueryStatement query = this.statements.createQuery(QuerySpec.max());
                    list = this.queryExecutor.query(connection, true, this::mapResultSet, query.getQueryAsString(), query.getParameters()).toList();
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new EdcPersistenceException((Throwable)e);
                    }
                }
                connection.close();
            }
            return list;
        });
    }

    public void insert(TargetNode node) {
        this.transactionContext.execute(() -> {
            try (Connection connection = this.getConnection();){
                String id = node.id();
                if (this.findByIdInternal(connection, id) == null) {
                    this.insertInternal(connection, id, node);
                } else {
                    this.updateInternal(connection, id, node);
                }
            }
            catch (SQLException e) {
                throw new EdcPersistenceException((Throwable)e);
            }
        });
    }

    private TargetNode findByIdInternal(Connection connection, String id) {
        String stmt = this.statements.getFindByIdTemplate();
        return (TargetNode)this.queryExecutor.single(connection, false, this::mapResultSet, stmt, new Object[]{id});
    }

    private void insertInternal(Connection connection, String id, TargetNode targetNode) {
        String stmt = this.statements.getInsertTemplate();
        this.queryExecutor.execute(connection, stmt, new Object[]{id, targetNode.name(), targetNode.targetUrl(), this.toJson(targetNode.supportedProtocols())});
    }

    private void updateInternal(Connection connection, String id, TargetNode targetNode) {
        String stmt = this.statements.getUpdateTemplate();
        this.queryExecutor.execute(connection, stmt, new Object[]{targetNode.name(), targetNode.targetUrl(), this.toJson(targetNode.supportedProtocols()), id});
    }

    private TargetNode mapResultSet(ResultSet resultSet) throws Exception {
        return new TargetNode(resultSet.getString(this.statements.getNameColumn()), resultSet.getString(this.statements.getIdColumn()), resultSet.getString(this.statements.getTargetUrlColumn()), (List)this.fromJson(resultSet.getString(this.statements.getSupportedProtocolsColumn()), (TypeReference)new TypeReference<List<String>>(){}));
    }
}

