/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.catalog.store.sql;

import org.eclipse.edc.catalog.store.sql.SqlTargetNodeDirectory;
import org.eclipse.edc.catalog.store.sql.TargetNodeStatements;
import org.eclipse.edc.catalog.store.sql.schema.postgres.PostgresDialectStatements;
import org.eclipse.edc.crawler.spi.TargetNode;
import org.eclipse.edc.crawler.spi.TargetNodeDirectory;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Provides;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.sql.QueryExecutor;
import org.eclipse.edc.sql.bootstrapper.SqlSchemaBootstrapper;
import org.eclipse.edc.transaction.datasource.spi.DataSourceRegistry;
import org.eclipse.edc.transaction.spi.TransactionContext;

@Provides(value={TargetNodeDirectory.class})
@Extension(value="SQL target node directory")
public class SqlTargetNodeDirectoryExtension
implements ServiceExtension {
    @Setting(description="The datasource to be used", defaultValue="default", key="edc.sql.store.targetnodedirectory.datasource")
    private String dataSourceName;
    @Inject
    private DataSourceRegistry dataSourceRegistry;
    @Inject
    private TransactionContext trxContext;
    @Inject(required=false)
    private TargetNodeStatements statements;
    @Inject
    private TypeManager typeManager;
    @Inject
    private QueryExecutor queryExecutor;
    @Inject
    private SqlSchemaBootstrapper sqlSchemaBootstrapper;

    public void initialize(ServiceExtensionContext context) {
        this.typeManager.registerTypes(new Class[]{TargetNode.class});
        SqlTargetNodeDirectory targetNodeDirectory = new SqlTargetNodeDirectory(this.dataSourceRegistry, this.dataSourceName, this.trxContext, this.typeManager.getMapper(), this.queryExecutor, this.getStatementImpl());
        context.registerService(TargetNodeDirectory.class, (Object)targetNodeDirectory);
        this.sqlSchemaBootstrapper.addStatementFromResource(this.dataSourceName, "target-node-directory-schema.sql");
    }

    private TargetNodeStatements getStatementImpl() {
        return this.statements != null ? this.statements : new PostgresDialectStatements();
    }
}

