/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.receiver.http.dynamic;

import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceReceiver;
import org.eclipse.edc.connector.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.connector.transfer.spi.types.TransferProcess;
import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.result.Result;
import org.eclipse.edc.spi.types.TypeManager;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.edc.util.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public class HttpDynamicEndpointDataReferenceReceiver
implements EndpointDataReferenceReceiver {
    public static final String HTTP_RECEIVER_ENDPOINT = "https://w3id.org/edc/v0.0.1/ns/receiverHttpEndpoint";
    private static final MediaType JSON = MediaType.get((String)"application/json");
    private Monitor monitor;
    private OkHttpClient httpClient;
    private TypeManager typeManager;
    private RetryPolicy<Object> retryPolicy;
    private TransferProcessStore transferProcessStore;
    private String authKey;
    private String authToken;
    private String fallbackEndpoint;

    private HttpDynamicEndpointDataReferenceReceiver() {
    }

    public CompletableFuture<Result<Void>> send(@NotNull EndpointDataReference edr) {
        TransferProcess transferProcess = this.transferProcessStore.findForCorrelationId(edr.getId());
        if (transferProcess == null) {
            return CompletableFuture.completedFuture(Result.failure((String)String.format("Failed to found transfer process for correlation id %s", edr.getId())));
        }
        String endpoint = transferProcess.getPrivateProperties().getOrDefault(HTTP_RECEIVER_ENDPOINT, this.fallbackEndpoint);
        if (endpoint != null) {
            this.monitor.debug(String.format("Sending EDR to %s", endpoint), new Throwable[0]);
            return CompletableFuture.completedFuture(this.sendEdr(edr, endpoint.toString()));
        }
        this.monitor.debug(String.format("Missing %s property in the transfer process properties or fallback endpoint in configuration", HTTP_RECEIVER_ENDPOINT), new Throwable[0]);
        return CompletableFuture.completedFuture(Result.success());
    }

    @NotNull
    private Result<Void> sendEdr(@NotNull EndpointDataReference edr, String endpoint) {
        RequestBody requestBody = RequestBody.create((String)this.typeManager.writeValueAsString((Object)edr), (MediaType)JSON);
        Request.Builder requestBuilder = new Request.Builder().url(endpoint).post(requestBody);
        if (!StringUtils.isNullOrBlank((String)this.authKey) && !StringUtils.isNullOrBlank((String)this.authToken)) {
            requestBuilder.header(this.authKey, this.authToken);
        }
        try (Response response = (Response)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.httpClient.newCall(requestBuilder.build()).execute());){
            if (response.isSuccessful()) {
                Result result = Result.success();
                return result;
            }
            Result result = Result.failure((String)String.format("Received error code %s when transferring endpoint data reference at uri: %s", response.code(), endpoint));
            return result;
        }
    }

    public static class Builder {
        private final HttpDynamicEndpointDataReferenceReceiver receiver = new HttpDynamicEndpointDataReferenceReceiver();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder monitor(Monitor monitor) {
            this.receiver.monitor = monitor;
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.receiver.httpClient = httpClient;
            return this;
        }

        public Builder typeManager(TypeManager typeManager) {
            this.receiver.typeManager = typeManager;
            return this;
        }

        public Builder retryPolicy(RetryPolicy<Object> retryPolicy) {
            this.receiver.retryPolicy = retryPolicy;
            return this;
        }

        public Builder transferProcessStore(TransferProcessStore transferProcessStore) {
            this.receiver.transferProcessStore = transferProcessStore;
            return this;
        }

        public Builder authHeader(String key, String code) {
            this.receiver.authKey = key;
            this.receiver.authToken = code;
            return this;
        }

        public Builder fallbackEndpoint(String fallbackEndpoint) {
            this.receiver.fallbackEndpoint = fallbackEndpoint;
            return this;
        }

        public HttpDynamicEndpointDataReferenceReceiver build() {
            Objects.requireNonNull(this.receiver.monitor, "monitor");
            Objects.requireNonNull(this.receiver.httpClient, "httpClient");
            Objects.requireNonNull(this.receiver.typeManager, "typeManager");
            Objects.requireNonNull(this.receiver.retryPolicy, "retryPolicy");
            Objects.requireNonNull(this.receiver.transferProcessStore, "transferProcessStore");
            return this.receiver;
        }
    }
}

