/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.receiver.http.dynamic;

import dev.failsafe.RetryPolicy;
import okhttp3.OkHttpClient;
import org.eclipse.edc.connector.receiver.http.dynamic.HttpDynamicEndpointDataReferenceReceiver;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceReceiver;
import org.eclipse.edc.connector.transfer.spi.edr.EndpointDataReferenceReceiverRegistry;
import org.eclipse.edc.connector.transfer.spi.observe.TransferProcessObservable;
import org.eclipse.edc.connector.transfer.spi.store.TransferProcessStore;
import org.eclipse.edc.runtime.metamodel.annotation.Extension;
import org.eclipse.edc.runtime.metamodel.annotation.Inject;
import org.eclipse.edc.runtime.metamodel.annotation.Setting;
import org.eclipse.edc.spi.system.ServiceExtension;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.types.TypeManager;

@Extension(value="Http Dynamic Endpoint Data Reference Receiver")
public class HttpDynamicEndpointDataReferenceReceiverExtension
implements ServiceExtension {
    public static final String NAME = "Http Dynamic Endpoint Data Reference Receiver";
    @Setting(value="Fallback endpoint when url is missing the the transfer process")
    private static final String HTTP_RECEIVER_ENDPOINT = "edc.receiver.http.dynamic.endpoint";
    @Setting(value="Header name that will be sent with the EDR")
    private static final String HTTP_RECEIVER_AUTH_KEY = "edc.receiver.http.dynamic.auth-key";
    @Setting(value="Header value that will be sent with the EDR")
    private static final String HTTP_RECEIVER_AUTH_CODE = "edc.receiver.http.dynamic.auth-code";
    @Inject
    private EndpointDataReferenceReceiverRegistry receiverRegistry;
    @Inject
    private OkHttpClient httpClient;
    @Inject
    private RetryPolicy<Object> retryPolicy;
    @Inject
    private TransferProcessStore transferProcessStore;
    @Inject
    private TransferProcessObservable transferProcessObservable;
    @Inject
    private TypeManager typeManager;

    public String name() {
        return NAME;
    }

    public void initialize(ServiceExtensionContext context) {
        String fallbackEndpoint = context.getSetting(HTTP_RECEIVER_ENDPOINT, null);
        String authKey = context.getSetting(HTTP_RECEIVER_AUTH_KEY, null);
        String authCode = context.getSetting(HTTP_RECEIVER_AUTH_CODE, null);
        HttpDynamicEndpointDataReferenceReceiver receiver = HttpDynamicEndpointDataReferenceReceiver.Builder.newInstance().httpClient(this.httpClient).typeManager(this.typeManager).retryPolicy(this.retryPolicy).fallbackEndpoint(fallbackEndpoint).authHeader(authKey, authCode).monitor(context.getMonitor()).transferProcessStore(this.transferProcessStore).build();
        this.receiverRegistry.registerReceiver((EndpointDataReferenceReceiver)receiver);
    }
}

