/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.validator.dataaddress.kafka;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.validator.spi.ValidationResult;
import org.eclipse.edc.validator.spi.Validator;
import org.eclipse.edc.validator.spi.Violation;

public class KafkaDataAddressValidator
implements Validator<DataAddress> {
    public ValidationResult validate(DataAddress input) {
        List<Violation> violations = Stream.of("https://w3id.org/edc/v0.0.1/ns/topic", "https://w3id.org/edc/v0.0.1/ns/kafka.bootstrap.servers").map(it -> {
            String value = input.getStringProperty(it);
            if (value == null || value.isBlank()) {
                return Violation.violation((String)"'%s' is a mandatory attribute".formatted(it), (String)it, (Object)value);
            }
            return null;
        }).filter(Objects::nonNull).toList();
        if (violations.isEmpty()) {
            return ValidationResult.success();
        }
        return ValidationResult.failure(violations);
    }
}

