/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.characteristic.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.eclipse.esmf.characteristic.Collection;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.CollectionValue;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.impl.DefaultCharacteristic;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;

public class DefaultCollection
extends DefaultCharacteristic
implements Collection {
    private final boolean allowDuplicates;
    private final boolean ordered;
    private final Optional<Characteristic> elementCharacteristic;

    public DefaultCollection(MetaModelBaseAttributes metaModelBaseAttributes, Optional<Type> dataType, Optional<Characteristic> elementCharacteristic) {
        super(metaModelBaseAttributes, dataType);
        this.allowDuplicates = true;
        this.ordered = false;
        this.elementCharacteristic = elementCharacteristic;
    }

    DefaultCollection(MetaModelBaseAttributes metaModelBaseAttributes, Optional<Type> dataType, boolean allowDuplicates, boolean ordered, Optional<Characteristic> elementCharacteristic) {
        super(metaModelBaseAttributes, dataType);
        this.allowDuplicates = allowDuplicates;
        this.ordered = ordered;
        this.elementCharacteristic = elementCharacteristic;
    }

    @Override
    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Optional<Characteristic> getElementCharacteristic() {
        return this.elementCharacteristic;
    }

    @Override
    public CollectionValue.CollectionType getCollectionType() {
        return CollectionValue.CollectionType.COLLECTION;
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitCollection(this, context);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DefaultCollection.class.getSimpleName() + "[", "]").add("allowDuplicates=" + this.allowDuplicates).add("ordered=" + this.ordered).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultCollection that = (DefaultCollection)o;
        return this.allowDuplicates == that.allowDuplicates && this.ordered == that.ordered && Objects.equals(this.elementCharacteristic, that.elementCharacteristic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allowDuplicates, this.ordered, this.elementCharacteristic);
    }
}

