/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.StructureElement;
import org.eclipse.esmf.metamodel.Type;

public interface ComplexType
extends Type,
StructureElement {
    default public List<ComplexType> getExtendingElements() {
        return Collections.emptyList();
    }

    default public boolean isAbstractEntity() {
        return false;
    }

    default public List<Property> getAllProperties() {
        if (this.getExtends().isPresent()) {
            return Stream.of(this.getProperties(), this.getExtends().get().getAllProperties()).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return List.copyOf(this.getProperties());
    }

    @Override
    default public String getUrn() {
        return this.getAspectModelUrn().get().toString();
    }

    default public Optional<ComplexType> getExtends() {
        return Optional.empty();
    }

    @Override
    default public boolean isComplexType() {
        return true;
    }
}

