/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel;

import java.util.Arrays;
import java.util.Optional;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.metamodel.QuantityKind;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;
import org.eclipse.esmf.samm.KnownVersion;

public enum QuantityKinds implements QuantityKind
{
    ABSOLUTE_ACTIVITY("absoluteActivity", "absolute activity"),
    ABSORBANCE("absorbance", "absorbance"),
    ABSORBED_DOSE("absorbedDose", "absorbed dose"),
    ABSORBED_DOSE_RATE("absorbedDoseRate", "absorbed dose rate"),
    ABSORPTION_FACTOR("absorptionFactor", "absorption factor"),
    ACCELERATION("acceleration", "acceleration"),
    ACCELERATION_DUE_TO_GRAVITY("accelerationDueToGravity", "acceleration due to gravity"),
    ACCELERATION_OF_FREE_FALL("accelerationOfFreeFall", "acceleration of free fall"),
    ACCEPTOR_IONIZATION_ENERGY("acceptorIonizationEnergy", "acceptor ionization energy"),
    ACCEPTOR_NUMBER_DENSITY("acceptorNumberDensity", "acceptor number density"),
    ACOUSTIC_IMPEDANCE("acousticImpedance", "acoustic impedance"),
    ACTIVE_ENERGY("activeEnergy", "active energy"),
    ACTIVE_POWER("activePower", "active power"),
    ACTIVITY("activity", "activity"),
    ACTIVITY_COEFFICIENT_OF_B_IN_A_LIQUID_AS_A_SOLID_MIXTURE("activityCoefficientOfBInALiquidAsASolidMixture", "activity coefficient of B (in a liquid as a solid mixture)"),
    ACTIVITY_COEFFICIENT_OF_SOLUTE_B_ESPECIALLY_IN_A_DILUTE_SOLUTION("activityCoefficientOfSoluteBEspeciallyInADiluteSolution", "activity coefficient of solute B (especially in a dilute solution)"),
    ACTIVITY_CONCENTRATION("activityConcentration", "activity concentration"),
    ACTIVITY_OF_SOLVENT_A("activityOfSolventA", "activity of solvent A"),
    ADMITTANCE("admittance", "admittance"),
    AFFINITY_OF_A_CHEMICAL_REACTION("affinityOfAChemicalReaction", "affinity (of a chemical reaction)"),
    ALFVEN_NUMBER("alfvenNumber", "Alfven number"),
    ALPHA_DISINTEGRATION_ENERGY("alphaDisintegrationEnergy", "alpha disintegration energy"),
    AMOUNT_OF_SUBSTANCE("amountOfSubstance", "amount of substance"),
    ANGLE_OF_OPTICAL_ROTATION("angleOfOpticalRotation", "angle of optical rotation"),
    ANGLE_PLANE("anglePlane", "angle (plane)"),
    ANGULAR_ACCELERATION("angularAcceleration", "angular acceleration"),
    ANGULAR_CROSS_SECTION("angularCrossSection", "angular cross-section"),
    ANGULAR_FREQUENCY("angularFrequency", "angular frequency"),
    ANGULAR_IMPULSE("angularImpulse", "angular impulse"),
    ANGULAR_MOMENTUM("angularMomentum", "angular momentum"),
    ANGULAR_RECIPROCAL_LATTICE_VECTOR("angularReciprocalLatticeVector", "angular reciprocal lattice vector"),
    ANGULAR_REPETENCY("angularRepetency", "angular repetency"),
    ANGULAR_VELOCITY("angularVelocity", "angular velocity"),
    ANGULAR_WAVE_NUMBER("angularWaveNumber", "angular wave number"),
    ANGULAR_WAVENUMBER("angularWavenumber", "angular wavenumber"),
    APPARENT_POWER("apparentPower", "apparent power"),
    AREA("area", "area"),
    AREA_RELATED_TORSIONAL_MOMENT("areaRelatedTorsionalMoment", "area-related torsional moment"),
    AREIC_MASS("areicMass", "areic mass"),
    ATOMIC_ATTENUATION_COEFFICIENT("atomicAttenuationCoefficient", "atomic attenuation coefficient"),
    ATOMIC_NUMBER("atomicNumber", "atomic number"),
    ATTENUATION_COEFFICIENT("attenuationCoefficient", "attenuation coefficient"),
    AVERAGE_LOGARITHMIC_ENERGY_DECREMENT("averageLogarithmicEnergyDecrement", "average logarithmic energy decrement"),
    AVOGADRO_CONSTANT("avogadroConstant", "Avogadro constant"),
    BETA_DISINTEGRATION_ENERGY("betaDisintegrationEnergy", "beta disintegration energy"),
    BINDING_FRACTION("bindingFraction", "binding fraction"),
    BOHR_MAGNETON("bohrMagneton", "Bohr magneton"),
    BOHR_RADIUS("bohrRadius", "Bohr radius"),
    BOLTZMANN_CONSTANT("boltzmannConstant", "Boltzmann constant"),
    BRAGG_ANGLE("braggAngle", "Bragg angle"),
    BREADTH("breadth", "breadth"),
    BULK_COMPRESSIBILITY("bulkCompressibility", "bulk compressibility"),
    BULK_MODULUS("bulkModulus", "bulk modulus"),
    BURGERS_VECTOR("burgersVector", "Burgers vector"),
    BURST_INDEX("burstIndex", "burst index"),
    CANONICAL_PARTITION_FUNCTION("canonicalPartitionFunction", "canonical partition function"),
    CAPACITANCE("capacitance", "capacitance"),
    CARRIER_LIFE_TIME("carrierLifeTime", "carrier life time"),
    CARTESIAN_COORDINATES("cartesianCoordinates", "cartesian coordinates"),
    CATALYTIC_ACTIVITY("catalyticActivity", "catalytic activity"),
    CHARACTERISTIC_IMPEDANCE_OF_A_MEDIUM("characteristicImpedanceOfAMedium", "characteristic impedance of a medium"),
    CHARGE_DENSITY("chargeDensity", "charge density"),
    CHARGE_NUMBER_OF_ION("chargeNumberOfIon", "charge number of ion"),
    CHEMICAL_POTENTIAL("chemicalPotential", "chemical potential"),
    CIE_COLORIMETRIC_FUNCTIONS("cieColorimetricFunctions", "CIE colorimetric functions"),
    CIRCULAR_FREQUENCY("circularFrequency", "circular frequency"),
    COEFFICIENT("coefficient", "coefficient"),
    COEFFICIENT_OF_FRICTION("coefficientOfFriction", "coefficient of friction"),
    COEFFICIENT_OF_HEAT_TRANSFER("coefficientOfHeatTransfer", "coefficient of heat transfer"),
    COEFFICIENT_OF_THERMAL_INSULATION("coefficientOfThermalInsulation", "coefficient of thermal insulation"),
    COHERENCE_LENGTH("coherenceLength", "coherence length"),
    COMPLEX_ADMITTANCE("complexAdmittance", "complex admittance"),
    COMPLEX_IMPEDANCES("complexImpedances", "complex impedances"),
    COMPRESSIBILITY("compressibility", "compressibility"),
    COMPTON_WAVELENGTH("comptonWavelength", "Compton wavelength"),
    CONCENTRATION_OF_B("concentrationOfB", "concentration of B"),
    CONDUCTANCE_FOR_ALTERNATING_CURRENT("conductanceForAlternatingCurrent", "conductance (for alternating current)"),
    CONDUCTANCE_FOR_DIRECT_CURRENT("conductanceForDirectCurrent", "conductance (for direct current)"),
    CONDUCTIVITY("conductivity", "conductivity"),
    COORDINATES_TRICHROMATIC("coordinatesTrichromatic", "coordinates trichromatic"),
    COUPLING_COEFFICIENT("couplingCoefficient", "coupling coefficient"),
    COWLING_NUMBER("cowlingNumber", "Cowling number"),
    CROSS_SECTION("crossSection", "cross-section"),
    CUBIC_EXPANSION_COEFFICIENT("cubicExpansionCoefficient", "cubic expansion coefficient"),
    CURIE_TEMPERATURE("curieTemperature", "Curie temperature"),
    CURRENT_DENSITY("currentDensity", "current density"),
    CURRENT_DENSITY_OF_PARTICLES("currentDensityOfParticles", "current density of particles"),
    CURRENT_FRACTION_OF_ION_B("currentFractionOfIonB", "current fraction of ion B"),
    CURRENT_LINKAGE("currentLinkage", "current linkage"),
    CURVATURE("curvature", "curvature"),
    CYCLOTRON_ANGULAR_FREQUENCY("cyclotronAngularFrequency", "cyclotron angular frequency"),
    DAMPING_COEFFICIENT("dampingCoefficient", "damping coefficient"),
    DATA_RATE("dataRate", "Data rate"),
    DEBYE_ANGULAR_FREQUENCY("debyeAngularFrequency", "Debye angular frequency"),
    DEBYE_ANGULAR_REPETENCY("debyeAngularRepetency", "Debye angular repetency"),
    DEBYE_ANGULAR_WAVE_NUMBER("debyeAngularWaveNumber", "Debye angular wave number"),
    DEBYE_TEMPERATURE("debyeTemperature", "Debye temperature"),
    DEBYE_WALLE_FACTOR("debyeWalleFactor", "Debye-Walle factor"),
    DECAY_CONSTANT("decayConstant", "decay constant"),
    DEGREE_OF_DISSOCIATION("degreeOfDissociation", "degree of dissociation"),
    DENSITY("density", "density"),
    DENSITY_OF_HEAT_FLOW_RATE("densityOfHeatFlowRate", "density of heat flow rate"),
    DENSITY_OF_STATES("densityOfStates", "density of states"),
    DIAMETER("diameter", "diameter"),
    DIFFUSION_AREA("diffusionArea", "diffusion area"),
    DIFFUSION_COEFFICIENT("diffusionCoefficient", "diffusion coefficient"),
    DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE("diffusionCoefficientForNeutronFluenceRate", "diffusion coefficient for neutron fluence rate"),
    DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY("diffusionCoefficientForNeutronFluxDensity", "diffusion coefficient for neutron flux density"),
    DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY("diffusionCoefficientForNeutronNumberDensity", "diffusion coefficient for neutron number density"),
    DIFFUSION_LENGTH("diffusionLength", "diffusion length"),
    DIMENSIONLESS("dimensionless", "dimensionless"),
    DIRECTIONAL_SPECTRAL_EMISSIVITY("directionalSpectralEmissivity", "directional spectral emissivity"),
    DISINTEGRATION_CONSTANT("disintegrationConstant", "disintegration constant"),
    DISPLACEMENT_ELECTRIC_POLARIZATION("displacementElectricPolarization", "displacement electric polarization"),
    DISPLACEMENT_VECTOR_OF_ION_OR_ATOM("displacementVectorOfIonOrAtom", "displacement vector of ion or atom"),
    DISSIPANCE("dissipance", "dissipance"),
    DISSIPATION_FACTOR("dissipationFactor", "dissipation factor"),
    DISTANCE("distance", "distance"),
    DONOR_IONIZATION_ENERGY("donorIonizationEnergy", "donor ionization energy"),
    DONOR_NUMBER_DENSITY("donorNumberDensity", "donor number density"),
    DOSE_EQUIVALENT("doseEquivalent", "dose equivalent"),
    EFFECTIVE_MASS("effectiveMass", "effective mass"),
    EFFECTIVE_MULTIPLICATION_FACTOR("effectiveMultiplicationFactor", "effective multiplication factor"),
    ELECTRIC_CHARGE("electricCharge", "electric charge"),
    ELECTRIC_CONSTANT("electricConstant", "electric constant"),
    ELECTRIC_CURRENT("electricCurrent", "electric current"),
    ELECTRIC_DIPOLE_MOMENT("electricDipoleMoment", "electric dipole moment"),
    ELECTRIC_DIPOLE_MOMENT_OF_MOLECULE("electricDipoleMomentOfMolecule", "electric dipole moment of molecule"),
    ELECTRIC_FIELD_STRENGTH("electricFieldStrength", "electric field strength"),
    ELECTRIC_FLUX_DENSITY("electricFluxDensity", "electric flux density"),
    ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT("electricFluxFluxOfDisplacement", "electric flux (flux of displacement)"),
    ELECTRIC_POLARIZABILITY_OF_A_MOLECULE("electricPolarizabilityOfAMolecule", "electric polarizability of a molecule"),
    ELECTRIC_POTENTIAL("electricPotential", "electric potential"),
    ELECTRIC_SUSCEPTIBILITY("electricSusceptibility", "electric susceptibility"),
    ELECTROLYTIC_CONDUCTIVITY("electrolyticConductivity", "electrolytic conductivity"),
    ELECTROMAGNETIC_ENERGY_DENSITY("electromagneticEnergyDensity", "electromagnetic energy density"),
    ELECTROMAGNETIC_MOMENT("electromagneticMoment", "electromagnetic moment"),
    ELECTROMOTIVE_FORCE("electromotiveForce", "electromotive force"),
    ELECTRON_AFFINITY("electronAffinity", "electron affinity"),
    ELECTRON_NUMBER_DENSITY("electronNumberDensity", "electron number density"),
    ELECTRON_RADIUS("electronRadius", "electron radius"),
    ELEMENTARY_CHARGE("elementaryCharge", "elementary charge"),
    EMISSIVITY("emissivity", "emissivity"),
    EMISSIVITY_AT_A_SPECIFIED_WAVELENGTH("emissivityAtASpecifiedWavelength", "emissivity at a specified wavelength"),
    ENERGY("energy", "energy"),
    ENERGY_DENSITY("energyDensity", "energy density"),
    ENERGY_FLUENCE("energyFluence", "energy fluence"),
    ENERGY_FLUENCE_RATE("energyFluenceRate", "energy fluence rate"),
    ENERGY_FLUX_DENSITY("energyFluxDensity", "energy flux density"),
    ENERGY_IMPARTED("energyImparted", "energy imparted"),
    ENTHALPY("enthalpy", "enthalpy"),
    ENTROPY("entropy", "entropy"),
    EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM("equilibriumPositionVectorOfIonOrAtom", "equilibrium position vector of ion or atom"),
    EQUIVALENCE_DOSE_OUTPUT("equivalenceDoseOutput", "equivalence dose output"),
    EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT("equivalentAbsorptionAreaOfASurfaceOrObject", "equivalent absorption area of a surface or object"),
    EULER_NUMBER("eulerNumber", "Euler number"),
    EXCHANGE_INTERGRAL("exchangeIntergral", "exchange intergral"),
    EXPOSURE("exposure", "exposure"),
    EXPOSURE_RATE("exposureRate", "exposure rate"),
    FAHRENHEIT_TEMPERATURE("fahrenheitTemperature", "fahrenheit temperature"),
    FARADAY_CONSTANT("faradayConstant", "Faraday constant"),
    FAST_FISSION_FACTOR("fastFissionFactor", "fast fission factor"),
    FERMI_ANGULAR_REPETENCY("fermiAngularRepetency", "Fermi angular repetency"),
    FERMI_ANGULAR_WAVE_NUMBER("fermiAngularWaveNumber", "Fermi angular wave number"),
    FERMI_ENERGY("fermiEnergy", "Fermi energy"),
    FERMI_TEMPERATURE("fermiTemperature", "Fermi temperature"),
    FINE_STRUCTURE_CONSTANT("fineStructureConstant", "fine structure constant"),
    FIRST_RADIATION_CONSTANT("firstRadiationConstant", "first radiation constant"),
    FLUENCE_RATE("fluenceRate", "fluence rate"),
    FOCAL_DISTANCE("focalDistance", "focal distance"),
    FORCE("force", "force"),
    FORCE_DIVIDED_BY_LENGTH("forceDividedByLength", "force divided by length"),
    FOURIER_NUMBER("fourierNumber", "Fourier number"),
    FOURIER_NUMBER_FOR_MASS_TRANSFER("fourierNumberForMassTransfer", "Fourier number for mass transfer"),
    FREQUENCY("frequency", "frequency"),
    FREQUENCY_INTERVAL("frequencyInterval", "frequency interval"),
    FRICTION_FACTOR("frictionFactor", "friction factor"),
    FROUDE_NUMBER("froudeNumber", "Froude number"),
    FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE("fugacityOfBInAGaseousMixture", "fugacity of B (in a gaseous mixture)"),
    FUNDAMENTAL_LATTICE_VECTOR("fundamentalLatticeVector", "fundamental lattice vector"),
    FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR("fundamentalReciprocalLatticeVector", "fundamental reciprocal lattice vector"),
    G_FACTOR_OF_ATOM_OR_ELECTRON("gFactorOfAtomOrElectron", "g-factor of atom or electron"),
    G_FACTOR_OF_NUCLEUS("gFactorOfNucleus", "g-factor of nucleus"),
    GAP_ENERGY("gapEnergy", "gap energy"),
    GRAND_CANONICAL_PARTITION_FUNCTION("grandCanonicalPartitionFunction", "grand-canonical partition function"),
    GRAND_PARTITION_FUNCTION("grandPartitionFunction", "grand partition function"),
    GRASHOF_NUMBER("grashofNumber", "Grashof number"),
    GRASHOF_NUMBER_FOR_MASS_TRANSFER("grashofNumberForMassTransfer", "Grashof number for mass transfer"),
    GRAVITATIONAL_CONSTANT("gravitationalConstant", "gravitational constant"),
    GROUP_VELOCITY("groupVelocity", "group velocity"),
    GRUENEISEN_PARAMETER("grueneisenParameter", "Gr\u00fcneisen parameter"),
    GYROMAGNETIC_COEFFICIENT("gyromagneticCoefficient", "gyromagnetic coefficient"),
    GYROMAGNETIC_RATIO("gyromagneticRatio", "gyromagnetic ratio"),
    HALF_LIFE("halfLife", "half life"),
    HALF_THICKNESS("halfThickness", "half-thickness"),
    HALF_VALUE_THICKNESS("halfValueThickness", "half-value thickness"),
    HALL_COEFFICIENT("hallCoefficient", "Hall coefficient"),
    HARDNESS_INDEX("hardnessIndex", "hardness index"),
    HARTMANN_NUMBER("hartmannNumber", "Hartmann number"),
    HARTREE_ENERGY("hartreeEnergy", "Hartree energy"),
    HEAT("heat", "heat"),
    HEAT_CAPACITY("heatCapacity", "heat capacity"),
    HEAT_FLOW_RATE("heatFlowRate", "heat flow rate"),
    HEIGHT("height", "height"),
    HELMHOLTZ_FREE_ENERGY("helmholtzFreeEnergy", "Helmholtz free energy"),
    HELMHOLTZ_FUNCTION("helmholtzFunction", "Helmholtz function"),
    HOLE_NUMBER_DENSITY("holeNumberDensity", "hole number density"),
    HYPERFINE_STRUCTURE_QUANTUM_NUMBER("hyperfineStructureQuantumNumber", "hyperfine structure quantum number"),
    ILLUMINANCE("illuminance", "illuminance"),
    IMAGE_DISTANCE("imageDistance", "image distance"),
    IMPEDANCE("impedance", "impedance"),
    IMPULSE("impulse", "impulse"),
    INFINITE_MEDIUM_MULTIPLICATION_FACTOR("infiniteMediumMultiplicationFactor", "infinite medium multiplication factor"),
    INFORMATION_ENTROPY("informationEntropy", "Information entropy"),
    INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION("instantaneousSoundParticleAcceleration", "(instantaneous) sound particle acceleration"),
    INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT("instantaneousSoundParticleDisplacement", "(instantaneous) sound particle displacement"),
    INSTANTANEOUS_SOUND_PARTICLE_VELOCITY("instantaneousSoundParticleVelocity", "(instantaneous) sound particle velocity"),
    INSTANTANEOUS_SOUND_PRESSURE("instantaneousSoundPressure", "(instantaneous) sound pressure"),
    INSTANTANEOUS_VOLUME_FLOW_RATE("instantaneousVolumeFlowRate", "(instantaneous) volume flow rate"),
    INTERNAL_CONVERSION_FACTOR("internalConversionFactor", "internal conversion factor"),
    INTRINSIC_NUMBER_DENSITY("intrinsicNumberDensity", "intrinsic number density"),
    ION_DENSITY("ionDensity", "ion density"),
    ION_NUMBER_DENSITY("ionNumberDensity", "ion number density"),
    IONIC_STRENGTH("ionicStrength", "ionic strength"),
    IRRADIANCE("irradiance", "irradiance"),
    ISENTROPIC_COMPRESSIBILITY("isentropicCompressibility", "isentropic compressibility"),
    ISENTROPIC_EXPONENT("isentropicExponent", "isentropic exponent"),
    ISOTHERMAL_COMPRESSIBILITY("isothermalCompressibility", "isothermal compressibility"),
    KINEMATIC_VISCOSITY("kinematicViscosity", "kinematic viscosity"),
    KINETIC_ENERGY("kineticEnergy", "kinetic energy"),
    KNUDSEN_NUMBER("knudsenNumber", "Knudsen number"),
    LANDAU_GINZBURG_NUMBER("landauGinzburgNumber", "Landau-Ginzburg number"),
    LARMOR_ANGULAR_FREQUENCY("larmorAngularFrequency", "Larmor angular frequency"),
    LATTICE_PLANE_SPACING("latticePlaneSpacing", "lattice plane spacing"),
    LATTICE_VECTOR("latticeVector", "lattice vector"),
    LEAKAGE_COEFFICIENT("leakageCoefficient", "leakage coefficient"),
    LEAKAGE_RATE_OF_GAS("leakageRateOfGas", "leakage rate of gas"),
    LENGTH("length", "length"),
    LENGTH_OF_PATH("lengthOfPath", "length of path"),
    LENS_POWER("lensPower", "lens power"),
    LETHARGY("lethargy", "lethargy"),
    LEVEL_OF_A_FIELD_QUANTITY("levelOfAFieldQuantity", "level of a field quantity"),
    LEVEL_OF_A_POWER_QUANTITY("levelOfAPowerQuantity", "level of a power quantity"),
    LEVEL_WIDTH("levelWidth", "level width"),
    LEWIS_NUMBER("lewisNumber", "Lewis number"),
    LIGHT_EXPOSURE("lightExposure", "light exposure"),
    LINEAR_ABSORPTION_COEFFICIENT("linearAbsorptionCoefficient", "linear absorption coefficient"),
    LINEAR_ATTENUATION_COEFFICIENT("linearAttenuationCoefficient", "linear attenuation coefficient"),
    LINEAR_DENSITY("linearDensity", "linear density"),
    LINEAR_ELECTRIC_CURRENT_DENSITY("linearElectricCurrentDensity", "linear electric current density"),
    LINEAR_ENERGY_TRANSFER("linearEnergyTransfer", "linear energy transfer"),
    LINEAR_EXPANSION_COEFFICIENT("linearExpansionCoefficient", "linear expansion coefficient"),
    LINEAR_EXTINCTION_COEFFICIENT("linearExtinctionCoefficient", "linear extinction coefficient"),
    LINEAR_IONIZATION_BY_A_PARTICLE("linearIonizationByAParticle", "linear ionization by a particle"),
    LINEAR_MASS("linearMass", "linear mass"),
    LINEAR_STRAIN("linearStrain", "linear strain"),
    LINEIC_CHARGE("lineicCharge", "lineic charge"),
    LINEIC_ELECTRIC_CURRENT("lineicElectricCurrent", "lineic electric current"),
    LINEIC_RESISTANCE("lineicResistance", "lineic resistance"),
    LOGARITHMIC_DECREMENT("logarithmicDecrement", "logarithmic decrement"),
    LONDON_PENETRATION_DEPTH("londonPenetrationDepth", "London penetration depth"),
    LONG_RANGE_ORDER_PARAMETER("longRangeOrderParameter", "long-range order parameter"),
    LOSS_ANGLE("lossAngle", "loss angle"),
    LOUDNESS("loudness", "loudness"),
    LOUDNESS_LEVEL("loudnessLevel", "loudness level"),
    LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY("lowerCriticalMagneticFluxDensity", "lower critical magnetic flux density"),
    LUMINANCE("luminance", "luminance"),
    LUMINIOUS_EFFICACY("luminiousEfficacy", "luminious efficacy"),
    LUMINOUS_EFFICACY_AT_A_SPECIFIED_WAVELENGTH("luminousEfficacyAtASpecifiedWavelength", "luminous efficacy at a specified wavelength"),
    LUMINOUS_EFFICIENCY("luminousEfficiency", "luminous efficiency"),
    LUMINOUS_EFFICIENCY_AT_A_SPECIFIED_WAVELENGTH("luminousEfficiencyAtASpecifiedWavelength", "luminous efficiency at a specified wavelength"),
    LUMINOUS_EXITANCE("luminousExitance", "luminous exitance"),
    LUMINOUS_FLUX("luminousFlux", "luminous flux"),
    LUMINOUS_INTENSITY("luminousIntensity", "luminous intensity"),
    MACH_NUMBER("machNumber", "Mach number"),
    MACROSCOPIC_CROSS_SECTION("macroscopicCrossSection", "macroscopic cross-section"),
    MACROSCOPIC_TOTAL_CROSS_SECTION("macroscopicTotalCrossSection", "macroscopic total cross-section"),
    MADELUNG_CONSTANT("madelungConstant", "Madelung constant"),
    MAGNETIC_AREA_MOMENT("magneticAreaMoment", "magnetic area moment"),
    MAGNETIC_CONSTANT("magneticConstant", "magnetic constant"),
    MAGNETIC_DIPOLE_MOMENT("magneticDipoleMoment", "magnetic dipole moment"),
    MAGNETIC_FIELD_STRENGTH("magneticFieldStrength", "magnetic field strength"),
    MAGNETIC_FLUX("magneticFlux", "magnetic flux"),
    MAGNETIC_FLUX_DENSITY("magneticFluxDensity", "magnetic flux density"),
    MAGNETIC_FLUX_QUANTUM("magneticFluxQuantum", "magnetic flux quantum"),
    MAGNETIC_INDUCTION("magneticInduction", "magnetic induction"),
    MAGNETIC_MOMENT("magneticMoment", "magnetic moment"),
    MAGNETIC_MOMENT_OF_PARTICLE("magneticMomentOfParticle", "magnetic moment of particle"),
    MAGNETIC_POLARIZATION("magneticPolarization", "magnetic polarization"),
    MAGNETIC_POTENTIAL_DIFFERENCE("magneticPotentialDifference", "magnetic potential difference"),
    MAGNETIC_QUANTUM_NUMBER("magneticQuantumNumber", "magnetic quantum number"),
    MAGNETIC_REYNOLDS_NUMBER("magneticReynoldsNumber", "magnetic Reynolds number"),
    MAGNETIC_SUSCEPTIBILITY("magneticSusceptibility", "magnetic susceptibility"),
    MAGNETIC_VECTOR_POTENTIAL("magneticVectorPotential", "magnetic vector potential"),
    MAGNETIZATION("magnetization", "magnetization"),
    MAGNETOMOTIVE_FORCE("magnetomotiveForce", "magnetomotive force"),
    MASS("mass", "mass"),
    MASS_ATTENUATION_COEFFICIENT("massAttenuationCoefficient", "mass attenuation coefficient"),
    MASS_CONCENTRATION_OF_B("massConcentrationOfB", "mass concentration of B"),
    MASS_DEFECT("massDefect", "mass defect"),
    MASS_DENSITY("massDensity", "mass density"),
    MASS_ENERGY_TRANSFER_COEFFICIENT("massEnergyTransferCoefficient", "mass energy transfer coefficient"),
    MASS_EXCESS("massExcess", "mass excess"),
    MASS_FLOW_RATE("massFlowRate", "mass flow rate"),
    MASS_NUMBER("massNumber", "mass number"),
    MASS_OF_ATOM_OF_A_NUCLIDE_X("massOfAtomOfANuclideX", "mass of atom (of a nuclide x)"),
    MASS_OF_MOLECULE("massOfMolecule", "mass of molecule"),
    MASS_RATIO("massRatio", "mass ratio"),
    MASSIC_ENERGY("massicEnergy", "massic energy"),
    MASSIC_ENERGY_IMPARTED("massicEnergyImparted", "massic energy imparted"),
    MASSIC_ENTHALPY("massicEnthalpy", "massic enthalpy"),
    MASSIC_HELMHOLTZ_FREE_ENERGY("massicHelmholtzFreeEnergy", "massic Helmholtz free energy"),
    MASSIC_OPTICAL("massicOptical", "massic optical"),
    MASSIC_THERMODYNAMIC_ENERGY("massicThermodynamicEnergy", "massic thermodynamic energy"),
    MASSIC_VOLUME("massicVolume", "massic volume"),
    MASSIEU_FUNCTION("massieuFunction", "massieu function"),
    MAXIMUM_BETA_PARTICLE_ENERGY("maximumBetaParticleEnergy", "maximum beta particle energy"),
    MAXIMUM_SPECTRAL_LUMINOUS_EFFICACY("maximumSpectralLuminousEfficacy", "maximum spectral luminous efficacy"),
    MEAN_ENERGY_IMPARTED("meanEnergyImparted", "mean energy imparted"),
    MEAN_FREE_PATH("meanFreePath", "mean free path"),
    MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS("meanFreePathOfPhononsOrElectrons", "mean free path of phonons or electrons"),
    MEAN_LIFE("meanLife", "mean life"),
    MEAN_LINEAR_RANGE("meanLinearRange", "mean linear range"),
    MEAN_MASS_RANGE("meanMassRange", "mean mass range"),
    MECHANICAL_IMPEDANCE("mechanicalImpedance", "mechanical impedance"),
    MICROCANONICAL_PARTITION_FUNCTION("microcanonicalPartitionFunction", "microcanonical partition function"),
    MIGRATION_AREA("migrationArea", "migration area"),
    MIGRATION_LENGTH("migrationLength", "migration length"),
    MOBILITY("mobility", "mobility"),
    MOBILITY_RATIO("mobilityRatio", "mobility ratio"),
    MODULUS_OF_ADMITTANCE("modulusOfAdmittance", "modulus of admittance"),
    MODULUS_OF_COMPRESSION("modulusOfCompression", "modulus of compression"),
    MODULUS_OF_ELASTICITY("modulusOfElasticity", "modulus of elasticity"),
    MODULUS_OF_IMPEDANCE("modulusOfImpedance", "modulus of impedance"),
    MODULUS_OF_RIGIDITY("modulusOfRigidity", "modulus of rigidity"),
    MOLALITY_OF_SOLUTE_B("molalityOfSoluteB", "molality of solute B"),
    MOLAR_ABSORPTION_COEFFICIENT("molarAbsorptionCoefficient", "molar absorption coefficient"),
    MOLAR_ATTENUATION_COEFFICIENT("molarAttenuationCoefficient", "molar attenuation coefficient"),
    MOLAR_CONDUCTIVITY("molarConductivity", "molar conductivity"),
    MOLAR_ENTROPY("molarEntropy", "molar entropy"),
    MOLAR_FLUX("molarFlux", "molar flux"),
    MOLAR_GAS_CONSTANT("molarGasConstant", "molar gas constant"),
    MOLAR_HEAT_CAPACITY("molarHeatCapacity", "molar heat capacity"),
    MOLAR_MASS("molarMass", "molar mass"),
    MOLAR_OPTICAL_ROTATORY_POWER("molarOpticalRotatoryPower", "molar optical rotatory power"),
    MOLAR_THERMODYNAMIC_ENERGY("molarThermodynamicEnergy", "molar thermodynamic energy"),
    MOLAR_VOLUME("molarVolume", "molar volume"),
    MOLE_FRACTION_OF_B("moleFractionOfB", "mole fraction of B"),
    MOLE_RATIO_OF_SOLUTE_B("moleRatioOfSoluteB", "mole ratio of solute B"),
    MOLECULAR_CONCENTRATION_OF_B("molecularConcentrationOfB", "molecular concentration of B"),
    MOLECULAR_PARTITION_FUNCTION("molecularPartitionFunction", "molecular partition function"),
    MOMENT_OF_A_COUPLE("momentOfACouple", "moment of a couple"),
    MOMENT_OF_FORCE("momentOfForce", "moment of force"),
    MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA("momentOfInertiaDynamicMomentOfInertia", "moment of inertia (dynamic moment of inertia)"),
    MOMENT_OF_MOMENTUM("momentOfMomentum", "moment of momentum"),
    MOMENTUM("momentum", "momentum"),
    MULTIPLICATION_FACTOR("multiplicationFactor", "multiplication factor"),
    MUTUAL_INDUCTANCE("mutualInductance", "mutual inductance"),
    NEEL_TEMPERATURE("neelTemperature", "N\u00e9el temperature"),
    NEUTRON_FLUENCE_RATE("neutronFluenceRate", "neutron fluence rate"),
    NEUTRON_NUMBER("neutronNumber", "neutron number"),
    NEUTRON_NUMBER_DENSITY("neutronNumberDensity", "neutron number density"),
    NEUTRON_SPEED("neutronSpeed", "neutron speed"),
    NEUTRON_YIELD_PER_ABSORPTION("neutronYieldPerAbsorption", "neutron yield per absorption"),
    NEUTRON_YIELD_PER_FISSION("neutronYieldPerFission", "neutron yield per fission"),
    NEUTRONFLUX_DENSITY("neutronfluxDensity", "neutronflux density"),
    NON_LEAKAGE_PROBABILITY("nonLeakageProbability", "non leakage probability"),
    NORMAL_STRESS("normalStress", "normal stress"),
    NUCLEAR_MAGNETON_ORNUCLEUS("nuclearMagnetonOrnucleus", "nuclear magneton ornucleus"),
    NUCLEAR_PRECESSION("nuclearPrecession", "nuclear precession"),
    NUCLEAR_QUADRUPOLE_MOMENT("nuclearQuadrupoleMoment", "nuclear quadrupole moment"),
    NUCLEAR_RADIUS("nuclearRadius", "nuclear radius"),
    NUCLEAR_SPIN_QUANTUM_NUMBER("nuclearSpinQuantumNumber", "nuclear spin quantum number"),
    NUCLEON_NUMBER("nucleonNumber", "nucleon number"),
    NUCLIDIC_MASS("nuclidicMass", "nuclidic mass"),
    NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES("numberDensityOfMoleculesOrParticles", "number density of molecules  (or particles)"),
    NUMBER_OF_MOLECULES_OR_OTHER_ELEMENTARY_ENTITIES("numberOfMoleculesOrOtherElementaryEntities", "number of molecules or other elementary entities"),
    NUMBER_OF_PAIRS_OF_POLES("numberOfPairsOfPoles", "number of pairs of poles"),
    NUMBER_OF_PHASES("numberOfPhases", "number of phases"),
    NUMBER_OF_TURNS_IN_A_WINDING("numberOfTurnsInAWinding", "number of turns in a winding"),
    NUSSELT_NUMBER("nusseltNumber", "Nusselt number"),
    NUSSELT_NUMBER_FOR_MASS_TRANSFER("nusseltNumberForMassTransfer", "Nusselt number for mass transfer"),
    OBJECT_DISTANCE("objectDistance", "object distance"),
    OPTICAL_DENSITY("opticalDensity", "optical density"),
    ORBITAL_ANGULAR_MOMENTUM_QUANTUM_NUMBER("orbitalAngularMomentumQuantumNumber", "orbital angular momentum quantum number"),
    ORDER_OF_REFLEXION("orderOfReflexion", "order of reflexion"),
    OSMOTIC_COEFFICIENT_OF_THE_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION("osmoticCoefficientOfTheSolventAEspeciallyInADiluteSolution", "osmotic coefficient of the solvent A (especially in a dilute solution)"),
    OSMOTIC_PRESSURE("osmoticPressure", "osmotic pressure"),
    PACKING_FRACTION("packingFraction", "packing fraction"),
    PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE("partialPressureOfBInAGaseousMixture", "partial pressure of B (in a gaseous mixture)"),
    PARTICAL_FLUX_DENSITY("particalFluxDensity", "partical flux density"),
    PARTICLE_FLUENCE("particleFluence", "particle fluence"),
    PARTICLE_FLUENCE_RATE("particleFluenceRate", "particle fluence rate"),
    PARTICLE_POSITION_VECTOR("particlePositionVector", "particle position vector"),
    PARTITION_FUNCTION_OF_A_MOLECULE("partitionFunctionOfAMolecule", "partition function of a molecule"),
    PECLET_NUMBER("pecletNumber", "Peclet number"),
    PECLET_NUMBER_FOR_MASS_TRANSFER("pecletNumberForMassTransfer", "Peclet number for mass transfer"),
    PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B("peltierCoefficientForSubstancesAAndB", "Peltier coefficient for substances a and b"),
    PERFORMANCE_CHARACTERISTIC("performanceCharacteristic", "performance characteristic"),
    PERIOD("period", "period"),
    PERIODIC_TIME("periodicTime", "periodic time"),
    PERMEABILITY("permeability", "permeability"),
    PERMEABILITY_OF_VACUUM("permeabilityOfVacuum", "permeability of vacuum"),
    PERMEANCE("permeance", "permeance"),
    PERMITTIVITY("permittivity", "permittivity"),
    PERMITTIVITY_OF_VACUUM("permittivityOfVacuum", "permittivity of vacuum"),
    PHASE_COEFFICIENT("phaseCoefficient", "phase coefficient"),
    PHASE_DIFFERENCE("phaseDifference", "phase difference"),
    PHASE_DISPLACEMENT("phaseDisplacement", "phase displacement"),
    PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES("phaseSpeedOfElectromagneticWaves", "phase speed of electromagnetic waves"),
    PHASE_VELOCITY("phaseVelocity", "phase velocity"),
    PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES("phaseVelocityOfElectromagneticWaves", "phase velocity of electromagnetic waves"),
    PHOTON_EXITANCE("photonExitance", "photon exitance"),
    PHOTON_EXPOSURE("photonExposure", "photon exposure"),
    PHOTON_FLUX("photonFlux", "photon flux"),
    PHOTON_INTENSITY("photonIntensity", "photon intensity"),
    PHOTON_LUMINANCE("photonLuminance", "photon luminance"),
    PHOTON_RADIANCE("photonRadiance", "photon radiance"),
    PLANCK_CONSTANT("planckConstant", "Planck constant"),
    PLANCK_FUNCTION("planckFunction", "planck function"),
    POISSON_NUMBER("poissonNumber", "poisson number"),
    POISSON_RATIO("poissonRatio", "poisson ratio"),
    POROSITY("porosity", "porosity"),
    POTENTIAL_DIFFERENCE("potentialDifference", "potential difference"),
    POTENTIAL_ENERGY("potentialEnergy", "potential energy"),
    POWER("power", "power"),
    POWER_FOR_DIRECT_CURRENT("powerForDirectCurrent", "power (for direct current)"),
    POYNTING_VECTOR("poyntingVector", "Poynting vector"),
    PRANDTL_NUMBER("prandtlNumber", "Prandtl number"),
    PRESSURE("pressure", "pressure"),
    PRESSURE_COEFFICIENT("pressureCoefficient", "pressure coefficient"),
    PRESSURE_RATIO("pressureRatio", "pressure ratio"),
    PRINCIPLE_QUANTUM_NUMBER("principleQuantumNumber", "principle quantum number"),
    PROPAGATION_COEFFICIENT("propagationCoefficient", "propagation coefficient"),
    PROTON_NUMBER("protonNumber", "proton number"),
    PULSATANCE("pulsatance", "pulsatance"),
    QUANTITY_OF_ELECTRICITY("quantityOfElectricity", "quantity of electricity"),
    QUANTITY_OF_HEAT("quantityOfHeat", "quantity of heat"),
    QUANTITY_OF_LIGHT("quantityOfLight", "quantity of light"),
    RADIANCE("radiance", "radiance"),
    RADIANCE_EXPOSURE("radianceExposure", "radiance exposure"),
    RADIANT_ENERGY("radiantEnergy", "radiant energy"),
    RADIANT_ENERGY_DENSITY("radiantEnergyDensity", "radiant energy density"),
    RADIANT_ENERGY_FLUENCE("radiantEnergyFluence", "radiant energy fluence"),
    RADIANT_ENERGYFLUX("radiantEnergyflux", "radiant energyflux"),
    RADIANT_EXITANCE("radiantExitance", "radiant exitance"),
    RADIANT_INTENSITY("radiantIntensity", "radiant intensity"),
    RADIANT_POWER("radiantPower", "radiant power"),
    RADIUS("radius", "radius"),
    RADIUS_OF_CURVATURE("radiusOfCurvature", "radius of curvature"),
    RATIO_OF_THE_MASSIC_HEAT_CAPACITY("ratioOfTheMassicHeatCapacity", "ratio of the massic heat capacity"),
    RATIO_OF_THE_SPECIFIC_HEAT_CAPACITIES("ratioOfTheSpecificHeatCapacities", "ratio of the specific heat capacities"),
    RAYLEIGH_NUMBER("rayleighNumber", "Rayleigh number"),
    REACTANCE("reactance", "reactance"),
    REACTION_ENERGY("reactionEnergy", "reaction energy"),
    REACTIVE_POWER("reactivePower", "reactive power"),
    REACTIVITY("reactivity", "reactivity"),
    REACTOR_TIME_CONSTANT("reactorTimeConstant", "reactor time constant"),
    RECOMBINATION_COEFFICIENT("recombinationCoefficient", "recombination coefficient"),
    REFLECTANCE("reflectance", "reflectance"),
    REFLECTION_FACTOR("reflectionFactor", "reflection factor"),
    REFRACTIVE_INDEX("refractiveIndex", "refractive index"),
    RELATIVE_ACTIVITY_OF_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION("relativeActivityOfSolventAEspeciallyInADiluteSolution", "relative activity of solvent A (especially in a dilute solution)"),
    RELATIVE_ATOMIC_MASS("relativeAtomicMass", "relative atomic mass"),
    RELATIVE_DENSITY("relativeDensity", "relative density"),
    RELATIVE_ELONGATION("relativeElongation", "relative elongation"),
    RELATIVE_MASS_DEFECT("relativeMassDefect", "relative mass defect"),
    RELATIVE_MASS_DENSITY("relativeMassDensity", "relative mass density"),
    RELATIVE_MASS_EXCESS("relativeMassExcess", "relative mass excess"),
    RELATIVE_MOLECULAR_MASS("relativeMolecularMass", "relative molecular mass"),
    RELATIVE_PERMEABILITY("relativePermeability", "relative permeability"),
    RELATIVE_PERMITTIVITY("relativePermittivity", "relative permittivity"),
    RELATIVE_PRESSURE_COEFFICIENT("relativePressureCoefficient", "relative pressure coefficient"),
    RELAXATION_TIME("relaxationTime", "relaxation time"),
    RELUCTANCE("reluctance", "reluctance"),
    REPETENCY("repetency", "repetency"),
    RESIDUAL_RESISTIVITY("residualResistivity", "residual resistivity"),
    RESISTANCE_LOAD_PER_UNIT_LENGTH("resistanceLoadPerUnitLength", "resistance load per unit length"),
    RESISTANCE_TO_ALTERNATING_CURRENT("resistanceToAlternatingCurrent", "resistance (to alternating current)"),
    RESISTANCE_TO_DIRECT_CURRENT("resistanceToDirectCurrent", "resistance (to direct current)"),
    RESISTIVITY("resistivity", "resistivity"),
    RESONANCE_ENERGY("resonanceEnergy", "resonance energy"),
    RESONANCE_ESCAPE_PROBABILITY("resonanceEscapeProbability", "resonance escape probability"),
    REST_MASS_OF_ELECTRON("restMassOfElectron", "(rest) mass of electron"),
    REST_MASS_OF_NEUTRON("restMassOfNeutron", "(rest) mass of neutron"),
    REST_MASS_OF_PROTON("restMassOfProton", "(rest) mass of proton"),
    REVERBERATION_TIME("reverberationTime", "reverberation time"),
    REYNOLDS_NUMBER("reynoldsNumber", "Reynolds number"),
    RICHARDSON_CONSTANT("richardsonConstant", "Richardson constant"),
    ROTATIONAL_FREQUENCY("rotationalFrequency", "rotational frequency"),
    ROTATORY_POWER("rotatoryPower", "rotatory power"),
    RYDBERG_CONSTANT("rydbergConstant", "Rydberg constant"),
    SCHMIDT_NUMBER("schmidtNumber", "Schmidt number"),
    SECOND_AXIAL_MOMENT_OF_AREA("secondAxialMomentOfArea", "second axial moment of area"),
    SECOND_MOMENT_OF_AREA("secondMomentOfArea", "second moment of area"),
    SECOND_POLAR_MOMENT_OF_AREA("secondPolarMomentOfArea", "second polar moment of area"),
    SECOND_RADIATION_CONSTANT("secondRadiationConstant", "second radiation constant"),
    SECTION_MODULUS("sectionModulus", "section modulus"),
    SEEBECK_COEFFICIENT_FOR_SUBSTANCES_A_AND_B("seebeckCoefficientForSubstancesAAndB", "Seebeck coefficient for substances a and b"),
    SELF_INDUCTANCE("selfInductance", "self inductance"),
    SHEAR_MODULUS("shearModulus", "shear modulus"),
    SHEAR_STRAIN("shearStrain", "shear strain"),
    SHEAR_STRESS("shearStress", "shear stress"),
    SHORT_RANGE_ORDER_PARAMETER("shortRangeOrderParameter", "short-range order parameter"),
    SLOWING_DOWN_AREA("slowingDownArea", "slowing down area"),
    SLOWING_DOWN_DENSITY("slowingDownDensity", "slowing down density"),
    SLOWING_DOWN_LENGTH("slowingDownLength", "slowing-down length"),
    SOLID_ANGLE("solidAngle", "solid angle"),
    SOUND_ENERGY("soundEnergy", "sound energy"),
    SOUND_ENERGY_DENSITY("soundEnergyDensity", "sound energy density"),
    SOUND_EXPOSURE("soundExposure", "sound exposure"),
    SOUND_INTENSITY("soundIntensity", "sound intensity"),
    SOUND_POWER("soundPower", "sound power"),
    SOUND_POWER_LEVEL("soundPowerLevel", "sound power level"),
    SOUND_PRESSURE_LEVEL("soundPressureLevel", "sound pressure level"),
    SOUND_REDUCTION_INDEX("soundReductionIndex", "sound reduction index"),
    SPECIFIC_ACTIVITY_IN_A_SAMPLE("specificActivityInASample", "specific activity in a sample"),
    SPECIFIC_ENERGY("specificEnergy", "specific energy"),
    SPECIFIC_ENERGY_IMPARTED("specificEnergyImparted", "specific energy imparted"),
    SPECIFIC_ENTHALPY("specificEnthalpy", "specific enthalpy"),
    SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE("specificHeatCapacityAtConstantPressure", "specific heat capacity at constant pressure"),
    SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME("specificHeatCapacityAtConstantVolume", "specific heat capacity at constant volume"),
    SPECIFIC_HEAT_CAPACITY_AT_SATURATION("specificHeatCapacityAtSaturation", "specific heat capacity at saturation"),
    SPECIFIC_OPTICAL_ROTATORY_POWER("specificOpticalRotatoryPower", "specific optical rotatory power"),
    SPECIFIC_THERMODYNAMIC_ENERGY("specificThermodynamicEnergy", "specific thermodynamic energy"),
    SPECIFIC_VOLUME("specificVolume", "specific volume"),
    SPECTRAL_ABSORPTANCE("spectralAbsorptance", "spectral absorptance"),
    SPECTRAL_ABSORPTION_FACTOR("spectralAbsorptionFactor", "spectral absorption factor"),
    SPECTRAL_ANGULAR_CROSS_SECTION("spectralAngularCrossSection", "spectral angular cross-section"),
    SPECTRAL_CONCENTRATION_OF_RADIANT_ENERGY_DENSITY_IN_TERMS_OF_WAVELENGTH("spectralConcentrationOfRadiantEnergyDensityInTermsOfWavelength", "spectral concentration of radiant energy density (in terms of wavelength)"),
    SPECTRAL_CONCENTRATION_OF_VIBRATIONAL_MODES_IN_TERMS_OF_ANGULAR_FREQUENCY("spectralConcentrationOfVibrationalModesInTermsOfAngularFrequency", "spectral concentration of vibrational modes (in terms of angular frequency)"),
    SPECTRAL_CROSS_SECTION("spectralCrossSection", "spectral cross-section"),
    SPECTRAL_EMISSIVITY("spectralEmissivity", "spectral emissivity"),
    SPECTRAL_LUMINOUS_EFFICACY("spectralLuminousEfficacy", "spectral luminous efficacy"),
    SPECTRAL_LUMINOUS_EFFICIENCY("spectralLuminousEfficiency", "spectral luminous efficiency"),
    SPECTRAL_RADIANCE_FACTOR("spectralRadianceFactor", "spectral radiance factor"),
    SPECTRAL_RADIANT_ENERGY_DENSITY_IN_TERMS_OF_WAVE_LENGTH("spectralRadiantEnergyDensityInTermsOfWaveLength", "spectral radiant energy density (in terms of wave length)"),
    SPECTRAL_REFLECTANCE("spectralReflectance", "spectral reflectance"),
    SPECTRAL_REFLECTIONFACTOR("spectralReflectionfactor", "spectral reflectionfactor"),
    SPECTRAL_TRANSMISSION_FACTOR("spectralTransmissionFactor", "spectral transmission factor"),
    SPECTRAL_TRANSMITTANCE("spectralTransmittance", "spectral transmittance"),
    SPIN_ANGULAR_MOMENTUM_QUANTUM_NUMBER("spinAngularMomentumQuantumNumber", "spin angular momentum quantum number"),
    STANDARD_ABSOLUTE_ACTIVITY_OF_B_IN_A_GASEOUS_MIXTURE("standardAbsoluteActivityOfBInAGaseousMixture", "standard absolute activity of B (in a gaseous mixture)"),
    STANDARD_ABSOLUTE_ACTIVITY_OF_B_IN_A_LIQUID_OR_A_SOLID_MIXTURE("standardAbsoluteActivityOfBInALiquidOrASolidMixture", "standard absolute activity of B (in a liquid or a solid mixture)"),
    STANDARD_ABSOLUTE_ACTIVITY_OF_SOLUTE_B_ESPECIALLY_IN_A_DILUTE_SOLUTION("standardAbsoluteActivityOfSoluteBEspeciallyInADiluteSolution", "standard absolute activity of solute B (especially in a dilute solution)"),
    STANDARD_ABSOLUTE_ACTIVITY_OF_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION("standardAbsoluteActivityOfSolventAEspeciallyInADiluteSolution", "standard absolute activity of solvent A (especially in a dilute solution)"),
    STANDARD_EQUILIBRIUM_CONSTANT("standardEquilibriumConstant", "standard equilibrium constant"),
    STANTON_NUMBER("stantonNumber", "Stanton number"),
    STANTON_NUMBER_FOR_MASS_TRANSFER("stantonNumberForMassTransfer", "Stanton number for mass transfer"),
    STATIC_PRESSURE("staticPressure", "static pressure"),
    STATISTICAL_WEIGHT("statisticalWeight", "statistical weight"),
    STEFAN_BOLTZMANN_CONSTANT("stefanBoltzmannConstant", "Stefan-Boltzmann constant"),
    STOICHIOMETRIC_NUMBER_OF_B("stoichiometricNumberOfB", "stoichiometric number of B"),
    STROUHAL_NUMBER("strouhalNumber", "Strouhal number"),
    SUPER_CONDUCTOR_TRANSITION_TEMPERATURE("superConductorTransitionTemperature", "Super conductor transition temperature"),
    SUPERCONDUCTOR_ENERGY_GAP("superconductorEnergyGap", "superconductor energy gap"),
    SURFACE_COEFFICIENT_OF_HEAT_TRANSFER("surfaceCoefficientOfHeatTransfer", "surface coefficient of heat transfer"),
    SURFACE_DENSITY("surfaceDensity", "surface density"),
    SURFACE_DENSITY_OF_CHARGE("surfaceDensityOfCharge", "surface density of charge"),
    SURFACE_TENSION("surfaceTension", "surface tension"),
    TEMPERATURE("temperature", "temperature"),
    TEMPERATURE_VARIATION_OVER_TIME("temperatureVariationOverTime", "temperature variation over time"),
    TENSION("tension", "tension"),
    THERMAL_CONDUCTANCE("thermalConductance", "thermal conductance"),
    THERMAL_CONDUCTIVITY("thermalConductivity", "thermal conductivity"),
    THERMAL_DIFFUSION_COEFFICIENT("thermalDiffusionCoefficient", "thermal diffusion coefficient"),
    THERMAL_DIFFUSION_FACTOR("thermalDiffusionFactor", "thermal diffusion factor"),
    THERMAL_DIFFUSION_RATIO("thermalDiffusionRatio", "thermal diffusion ratio"),
    THERMAL_DIFFUSIVITY("thermalDiffusivity", "thermal diffusivity"),
    THERMAL_INSULANCE("thermalInsulance", "thermal insulance"),
    THERMAL_RESISTANCE("thermalResistance", "thermal resistance"),
    THERMAL_UTILIZATION_FACTOR("thermalUtilizationFactor", "thermal utilization factor"),
    THERMODYNAMIC("thermodynamic", "thermodynamic"),
    THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY("thermodynamicCriticalMagneticFluxDensity", "thermodynamic critical magnetic flux density"),
    THERMODYNAMIC_ENERGY("thermodynamicEnergy", "thermodynamic energy"),
    THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B("thermoelectromotiveForceBetweenSubstancesAAndB", "thermoelectromotive force between substances a and b"),
    THICKNESS("thickness", "thickness"),
    THOMPSON_COEFFICIENT("thompsonCoefficient", "Thompson coefficient"),
    TIME("time", "time"),
    TIME_CONSTANT("timeConstant", "time constant"),
    TORQUE("torque", "torque"),
    TORSIONAL_STIFFNESS("torsionalStiffness", "torsional stiffness"),
    TOTAL_ANGULAR_MOMENTUM_QUANTUM_NUMBER("totalAngularMomentumQuantumNumber", "total angular momentum quantum number"),
    TOTAL_ATOMIC_STOPPING_POWER("totalAtomicStoppingPower", "total atomic stopping power"),
    TOTAL_CROSS_SECTION("totalCrossSection", "total cross-section"),
    TOTAL_IONIZATION_BY_A_PARTICLE("totalIonizationByAParticle", "total ionization by a particle"),
    TOTAL_LINEAR_STOPPING_POWER("totalLinearStoppingPower", "total linear stopping power"),
    TOTAL_MASS_STOPPING_POWER("totalMassStoppingPower", "total mass stopping power"),
    TRANSMISSION_FACTOR("transmissionFactor", "transmission factor"),
    TRANSMITTANCE("transmittance", "transmittance"),
    TRANSPORT_NUMBER_OF_ION_B("transportNumberOfIonB", "transport number of ion B"),
    UNIFIED_ATOMIC_MASS_CONSTANT("unifiedAtomicMassConstant", "unified atomic mass constant"),
    UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY("upperCriticalMagneticFluxDensity", "upper critical magnetic flux density"),
    VELOCITY("velocity", "velocity"),
    VELOCITY_OF_SOUND_PHASE_VELOCITY("velocityOfSoundPhaseVelocity", "velocity of sound (phase velocity)"),
    VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO("velocitySpeedOnPropagationOfElectromagneticWavesInVacuo", "velocity (speed) on propagation of electromagnetic waves in vacuo"),
    VERGENCE("vergence", "vergence"),
    VISCOSITY_DYNAMIC_VISCOSITY("viscosityDynamicViscosity", "viscosity (dynamic viscosity)"),
    VOLTAGE("voltage", "voltage"),
    VOLUME("volume", "volume"),
    VOLUME_DENSITY_OF_CHARGE("volumeDensityOfCharge", "volume density of charge"),
    VOLUME_FLOW_RATE("volumeFlowRate", "volume flow rate"),
    VOLUME_OR_BULK_STRAIN("volumeOrBulkStrain", "volume or bulk strain"),
    VOLUME_PER_TEMPERATURE("volumePerTemperature", "volume per temperature"),
    VOLUME_RATIO("volumeRatio", "volume ratio"),
    VOLUMIC("volumic", "volumic"),
    VOLUMIC_ACCEPTOR_NUMBER("volumicAcceptorNumber", "volumic acceptor number"),
    VOLUMIC_ACTIVITY("volumicActivity", "volumic activity"),
    VOLUMIC_CHARGE("volumicCharge", "volumic charge"),
    VOLUMIC_CROSS_SECTION("volumicCrossSection", "volumic cross-section"),
    VOLUMIC_DONOR_NUMBER("volumicDonorNumber", "volumic donor number"),
    VOLUMIC_DOSE("volumicDose", "volumic dose"),
    VOLUMIC_ELECTROMAGNETIC_ENERGY("volumicElectromagneticEnergy", "volumic electromagnetic energy"),
    VOLUMIC_ELECTRON_NUMBER("volumicElectronNumber", "volumic electron number"),
    VOLUMIC_HOLE_NUMBER("volumicHoleNumber", "volumic hole number"),
    VOLUMIC_INTRINSIS_NUMBER("volumicIntrinsisNumber", "volumic intrinsis number"),
    VOLUMIC_MASS("volumicMass", "volumic mass"),
    VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES("volumicNumberOfMoleculesOrParticles", "volumic number of molecules (or particles)"),
    VOLUMIC_TOTAL_CROSS_SECTION("volumicTotalCrossSection", "volumic total cross-section"),
    WAVE_NUMBER("waveNumber", "wave number"),
    WAVELENGTH("wavelength", "wavelength"),
    WAVENUMBER("wavenumber", "wavenumber"),
    WEBER_NUMBER("weberNumber", "Weber number"),
    WEIGHT("weight", "weight"),
    WORK("work", "work"),
    WORK_FUNCTION("workFunction", "work function"),
    WORK_PER_UNIT_WEIGHT("workPerUnitWeight", "work per unit weight");

    private static final KnownVersion LATEST;
    private final String name;
    private final String label;

    private QuantityKinds(String name, String label) {
        this.name = name;
        this.label = label;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public Optional<AspectModelUrn> getAspectModelUrn() {
        return Optional.of(AspectModelUrn.fromUrn((String)String.format("urn:samm:org.eclipse.esmf.samm:unit:%s#%s", LATEST.toVersionString(), this.name)));
    }

    @Override
    public KnownVersion getMetaModelVersion() {
        return LATEST;
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitQuantityKind(this, context);
    }

    public static Optional<QuantityKind> fromName(String name) {
        return Arrays.stream(QuantityKinds.values()).filter(quantityKind -> quantityKind.getName().equals(name)).map(QuantityKind.class::cast).findAny();
    }

    static {
        LATEST = KnownVersion.getLatest();
    }
}

