/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.metamodel.QuantityKind;
import org.eclipse.esmf.metamodel.QuantityKinds;
import org.eclipse.esmf.metamodel.Unit;
import org.eclipse.esmf.metamodel.impl.DefaultUnit;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.samm.KnownVersion;

public class Units {
    private static final Map<String, Function<KnownVersion, Unit>> UNITS_BY_NAME = new HashMap<String, Function<KnownVersion, Unit>>();
    private static final KnownVersion LATEST = KnownVersion.getLatest();

    private Units() {
    }

    private static AspectModelUrn urn(KnownVersion version, String name) {
        return AspectModelUrn.fromUrn((String)String.format("urn:samm:org.eclipse.esmf.samm:unit:%s#%s", version.toVersionString(), name));
    }

    private static void init0() {
        UNITS_BY_NAME.put("accessLine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "accessLine"), "accessLine", "access line"), Optional.empty(), Optional.of("AL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("accountingUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "accountingUnit"), "accountingUnit", "accounting unit"), Optional.empty(), Optional.of("E50"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("acre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "acre"), "acre", "acre"), Optional.of("acre"), Optional.of("ACR"), Optional.of("squareMetre"), Optional.of("4046.873 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("acreFootBasedOnUsSurveyFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "acreFootBasedOnUsSurveyFoot"), "acreFootBasedOnUsSurveyFoot", "acre-foot (based on U.S. survey foot)"), Optional.of("acre-ft (US survey)"), Optional.of("M67"), Optional.of("cubicMetre"), Optional.of("1.233489 \u00d7 10\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("activeUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "activeUnit"), "activeUnit", "active unit"), Optional.empty(), Optional.of("E25"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("actualPer360", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "actualPer360"), "actualPer360", "actual/360"), Optional.of("y (360 days)"), Optional.of("M37"), Optional.of("secondUnitOfTime"), Optional.of("3.1104000 \u00d7 10\u2077 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("additionalMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "additionalMinute"), "additionalMinute", "additional minute"), Optional.empty(), Optional.of("AH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("airDryMetricTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "airDryMetricTon"), "airDryMetricTon", "air dry metric ton"), Optional.empty(), Optional.of("MD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("airDryTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "airDryTon"), "airDryTon", "air dry ton"), Optional.empty(), Optional.of("E28"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("alcoholicStrengthByMass", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "alcoholicStrengthByMass"), "alcoholicStrengthByMass", "alcoholic strength by mass"), Optional.empty(), Optional.of("ASM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("alcoholicStrengthByVolume", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "alcoholicStrengthByVolume"), "alcoholicStrengthByVolume", "alcoholic strength by volume"), Optional.empty(), Optional.of("ASU"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampere"), "ampere", "ampere"), Optional.of("A"), Optional.of("AMP"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT))));
        UNITS_BY_NAME.put("ampereHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereHour"), "ampereHour", "ampere hour"), Optional.of("A\u00b7h"), Optional.of("AMH"), Optional.of("coulomb"), Optional.of("3.6 \u00d7 10\u00b3 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("ampereMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereMinute"), "ampereMinute", "ampere minute"), Optional.of("A\u00b7min"), Optional.of("N95"), Optional.of("coulomb"), Optional.of("60 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT))));
        UNITS_BY_NAME.put("amperePerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerCentimetre"), "amperePerCentimetre", "ampere per centimetre"), Optional.of("A/cm"), Optional.of("A2"), Optional.of("amperePerMetre"), Optional.of("10\u00b2 A/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.MAGNETIZATION, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.LINEIC_ELECTRIC_CURRENT))));
        UNITS_BY_NAME.put("amperePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerKilogram"), "amperePerKilogram", "ampere per kilogram"), Optional.of("A/kg"), Optional.of("H31"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("amperePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerMetre"), "amperePerMetre", "ampere per metre"), Optional.of("A/m"), Optional.of("AE"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.MAGNETIZATION, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY))));
        UNITS_BY_NAME.put("amperePerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerMillimetre"), "amperePerMillimetre", "ampere per millimetre"), Optional.of("A/mm"), Optional.of("A3"), Optional.of("amperePerMetre"), Optional.of("10\u00b3 A/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.MAGNETIZATION, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("amperePerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerPascal"), "amperePerPascal", "ampere per pascal"), Optional.of("A/Pa"), Optional.of("N93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("amperePerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerSquareCentimetre"), "amperePerSquareCentimetre", "ampere per square centimetre"), Optional.of("A/cm\u00b2"), Optional.of("A4"), Optional.of("amperePerSquareMetre"), Optional.of("10\u2074 A/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY, QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("amperePerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerSquareMetre"), "amperePerSquareMetre", "ampere per square metre"), Optional.of("A/m\u00b2"), Optional.of("A41"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("amperePerSquareMetreKelvinSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerSquareMetreKelvinSquared"), "amperePerSquareMetreKelvinSquared", "ampere per square metre kelvin squared"), Optional.of("A/(m\u00b2\u00b7K\u00b2)"), Optional.of("A6"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RICHARDSON_CONSTANT))));
        UNITS_BY_NAME.put("amperePerSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "amperePerSquareMillimetre"), "amperePerSquareMillimetre", "ampere per square millimetre"), Optional.of("A/mm\u00b2"), Optional.of("A7"), Optional.of("amperePerSquareMetre"), Optional.of("10\u2076 A/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY, QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("ampereSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereSecond"), "ampereSecond", "ampere second"), Optional.of("A\u00b7s"), Optional.of("A8"), Optional.of("coulomb"), Optional.of("C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("ampereSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereSquareMetre"), "ampereSquareMetre", "ampere square metre"), Optional.of("A\u00b7m\u00b2"), Optional.of("A5"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NUCLEAR_MAGNETON_ORNUCLEUS, QuantityKinds.BOHR_MAGNETON, QuantityKinds.MAGNETIC_MOMENT_OF_PARTICLE, QuantityKinds.ELECTROMAGNETIC_MOMENT, QuantityKinds.MAGNETIC_MOMENT, QuantityKinds.MAGNETIC_AREA_MOMENT))));
        UNITS_BY_NAME.put("ampereSquareMetrePerJouleSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereSquareMetrePerJouleSecond"), "ampereSquareMetrePerJouleSecond", "ampere square metre per joule second"), Optional.of("A\u00b7m\u00b2/(J\u00b7s)"), Optional.of("A10"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GYROMAGNETIC_RATIO, QuantityKinds.GYROMAGNETIC_COEFFICIENT))));
        UNITS_BY_NAME.put("ampereSquaredSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ampereSquaredSecond"), "ampereSquaredSecond", "ampere squared second"), Optional.of("A\u00b2\u00b7s"), Optional.of("H32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE))));
        UNITS_BY_NAME.put("angstrom", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "angstrom"), "angstrom", "angstrom"), Optional.of("\u00c5"), Optional.of("A11"), Optional.of("metre"), Optional.of("10\u207b\u00b9\u2070 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.DISTANCE, QuantityKinds.WAVELENGTH, QuantityKinds.BURGERS_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.LATTICE_PLANE_SPACING, QuantityKinds.HEIGHT, QuantityKinds.BOHR_RADIUS, QuantityKinds.BREADTH, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS))));
        UNITS_BY_NAME.put("antiHemophilicFactorAhfUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "antiHemophilicFactorAhfUnit"), "antiHemophilicFactorAhfUnit", "anti-hemophilic factor (AHF) unit"), Optional.empty(), Optional.of("AQ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("assembly", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "assembly"), "assembly", "assembly"), Optional.empty(), Optional.of("AY"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("assortment", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "assortment"), "assortment", "assortment"), Optional.empty(), Optional.of("AS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("astronomicalUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "astronomicalUnit"), "astronomicalUnit", "astronomical unit"), Optional.of("ua"), Optional.of("A12"), Optional.of("metre"), Optional.of("1.49597870 \u00d7 10\u00b9\u00b9 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("attofarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "attofarad"), "attofarad", "attofarad"), Optional.of("aF"), Optional.of("H48"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("attojoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "attojoule"), "attojoule", "attojoule"), Optional.of("aJ"), Optional.of("A13"), Optional.of("joule"), Optional.of("10\u207b\u00b9\u2078 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.EXCHANGE_INTERGRAL, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.SUPERCONDUCTOR_ENERGY_GAP, QuantityKinds.ELECTRON_AFFINITY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.DONOR_IONIZATION_ENERGY, QuantityKinds.ACCEPTOR_IONIZATION_ENERGY))));
        UNITS_BY_NAME.put("averageMinutePerCall", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "averageMinutePerCall"), "averageMinutePerCall", "average minute per call"), Optional.empty(), Optional.of("AI"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ball", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ball"), "ball", "ball"), Optional.empty(), Optional.of("AA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("barCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barCubicMetrePerSecond"), "barCubicMetrePerSecond", "bar cubic metre per second"), Optional.of("bar\u00b7m\u00b3/s"), Optional.of("F92"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("barLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barLitrePerSecond"), "barLitrePerSecond", "bar litre per second"), Optional.of("bar\u00b7l/s"), Optional.of("F91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("barPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barPerBar"), "barPerBar", "bar per bar"), Optional.of("bar/bar"), Optional.of("J56"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("barPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barPerKelvin"), "barPerKelvin", "bar per kelvin"), Optional.of("bar/K"), Optional.of("F81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_COEFFICIENT))));
        UNITS_BY_NAME.put("barUnitOfPressure", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barUnitOfPressure"), "barUnitOfPressure", "bar [unit of pressure]"), Optional.of("bar"), Optional.of("BAR"), Optional.of("pascal"), Optional.of("10\u2075 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS))));
        UNITS_BY_NAME.put("barn", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barn"), "barn", "barn"), Optional.of("b"), Optional.of("A14"), Optional.of("squareMetre"), Optional.of("10\u207b\u00b2\u2078 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA, QuantityKinds.TOTAL_CROSS_SECTION))));
        UNITS_BY_NAME.put("barnPerElectronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barnPerElectronvolt"), "barnPerElectronvolt", "barn per electronvolt"), Optional.of("b/eV"), Optional.of("A15"), Optional.of("squareMetrePerJoule"), Optional.of("6.241 51 \u00d7 10\u207b\u00b9\u2070 m\u00b2/J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_CROSS_SECTION, QuantityKinds.SPECTRAL_CROSS_SECTION))));
        UNITS_BY_NAME.put("barnPerSteradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barnPerSteradian"), "barnPerSteradian", "barn per steradian"), Optional.of("b/sr"), Optional.of("A17"), Optional.of("squareMetrePerSteradian"), Optional.of("1 \u00d7 10\u207b\u00b2\u2078 m\u00b2/sr"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_CROSS_SECTION, QuantityKinds.ANGULAR_CROSS_SECTION))));
        UNITS_BY_NAME.put("barnPerSteradianElectronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barnPerSteradianElectronvolt"), "barnPerSteradianElectronvolt", "barn per steradian electronvolt"), Optional.of("b/(sr\u00b7eV)"), Optional.of("A16"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_ANGULAR_CROSS_SECTION))));
        UNITS_BY_NAME.put("barrelImperial", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelImperial"), "barrelImperial", "barrel, imperial"), Optional.empty(), Optional.of("B4"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("barrelUkPetroleum", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUkPetroleum"), "barrelUkPetroleum", "barrel (UK petroleum)"), Optional.of("bbl (UK liq.)"), Optional.of("J57"), Optional.of("cubicMetre"), Optional.of("0.15911315 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("barrelUkPetroleumPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUkPetroleumPerDay"), "barrelUkPetroleumPerDay", "barrel (UK petroleum) per day"), Optional.of("bbl (UK liq.)/d"), Optional.of("J59"), Optional.of("cubicMetrePerSecond"), Optional.of("1.8415874 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUkPetroleumPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUkPetroleumPerHour"), "barrelUkPetroleumPerHour", "barrel (UK petroleum) per hour"), Optional.of("bbl (UK liq.)/h"), Optional.of("J60"), Optional.of("cubicMetrePerSecond"), Optional.of("4.419810 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUkPetroleumPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUkPetroleumPerMinute"), "barrelUkPetroleumPerMinute", "barrel (UK petroleum) per minute"), Optional.of("bbl (UK liq.)/min"), Optional.of("J58"), Optional.of("cubicMetrePerSecond"), Optional.of("2.651886 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUkPetroleumPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUkPetroleumPerSecond"), "barrelUkPetroleumPerSecond", "barrel (UK petroleum) per second"), Optional.of("bbl (UK liq.)/s"), Optional.of("J61"), Optional.of("cubicMetrePerSecond"), Optional.of("0.15911315 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUs"), "barrelUs", "barrel (US)"), Optional.of("barrel (US)"), Optional.of("BLL"), Optional.of("cubicMetre"), Optional.of("158.9873 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("barrelUsPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUsPerDay"), "barrelUsPerDay", "barrel (US) per day"), Optional.of("barrel\u00a0(US)/d"), Optional.of("B1"), Optional.of("cubicMetrePerSecond"), Optional.of("1.84013 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUsPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUsPerMinute"), "barrelUsPerMinute", "barrel (US) per minute"), Optional.of("barrel (US)/min"), Optional.of("5A"), Optional.of("cubicMetrePerSecond"), Optional.of("2.64979 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUsPetroleumPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUsPetroleumPerHour"), "barrelUsPetroleumPerHour", "barrel (US petroleum) per hour"), Optional.of("bbl (US)/h"), Optional.of("J62"), Optional.of("cubicMetrePerSecond"), Optional.of("4.416314 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("barrelUsPetroleumPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "barrelUsPetroleumPerSecond"), "barrelUsPetroleumPerSecond", "barrel (US petroleum) per second"), Optional.of("bbl (US)/s"), Optional.of("J63"), Optional.of("cubicMetrePerSecond"), Optional.of("0.1589873 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("baseBox", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "baseBox"), "baseBox", "base box"), Optional.empty(), Optional.of("BB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("batch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "batch"), "batch", "batch"), Optional.empty(), Optional.of("5B"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("battingPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "battingPound"), "battingPound", "batting pound"), Optional.empty(), Optional.of("B3"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("baud", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "baud"), "baud", "baud"), Optional.of("Bd"), Optional.of("J38"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("beaufort", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "beaufort"), "beaufort", "Beaufort"), Optional.of("Bft"), Optional.of("M19"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("becquerel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "becquerel"), "becquerel", "becquerel"), Optional.of("Bq"), Optional.of("BQL"), Optional.of("curie"), Optional.of("27.027 \u00d7 10\u207b\u00b9\u00b2 Ci"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("becquerelPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "becquerelPerCubicMetre"), "becquerelPerCubicMetre", "becquerel per cubic metre"), Optional.of("Bq/m\u00b3"), Optional.of("A19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_ACTIVITY, QuantityKinds.ACTIVITY_CONCENTRATION))));
        UNITS_BY_NAME.put("becquerelPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "becquerelPerKilogram"), "becquerelPerKilogram", "becquerel per kilogram"), Optional.of("Bq/kg"), Optional.of("A18"), Optional.of("curiePerKilogram"), Optional.of("27.027 \u00d7 10\u207b\u00b9\u00b2 Ci/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE, QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE))));
        UNITS_BY_NAME.put("bel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bel"), "bel", "bel"), Optional.of("B"), Optional.of("M72"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LEVEL_OF_A_POWER_QUANTITY, QuantityKinds.LEVEL_OF_A_FIELD_QUANTITY))));
        UNITS_BY_NAME.put("belPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "belPerMetre"), "belPerMetre", "bel per metre"), Optional.of("B/m"), Optional.of("P43"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_PRESSURE_LEVEL, QuantityKinds.SOUND_POWER_LEVEL))));
        UNITS_BY_NAME.put("bigPoint", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bigPoint"), "bigPoint", "big point"), Optional.of("bp"), Optional.of("H82"), Optional.of("metre"), Optional.of("0.3527778 \u00d7 10\u207b\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("billionEur", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "billionEur"), "billionEur", "billion (EUR)"), Optional.empty(), Optional.of("BIL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("biot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "biot"), "biot", "biot"), Optional.of("Bi"), Optional.of("N96"), Optional.of("ampere"), Optional.of("10\u00b9 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT))));
        UNITS_BY_NAME.put("bit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bit"), "bit", "bit"), Optional.of("b"), Optional.of("A99"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("bitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bitPerCubicMetre"), "bitPerCubicMetre", "bit per cubic metre"), Optional.of("bit/m\u00b3"), Optional.of("F01"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("bitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bitPerMetre"), "bitPerMetre", "bit per metre"), Optional.of("bit/m"), Optional.of("E88"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("bitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bitPerSecond"), "bitPerSecond", "bit per second"), Optional.of("bit/s"), Optional.of("B10"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("bitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bitPerSquareMetre"), "bitPerSquareMetre", "bit per square metre"), Optional.of("bit/m\u00b2"), Optional.of("E89"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("blank", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "blank"), "blank", "blank"), Optional.empty(), Optional.of("H21"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("boardFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "boardFoot"), "boardFoot", "board foot"), Optional.of("fbm"), Optional.of("BFT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("book", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "book"), "book", "book"), Optional.empty(), Optional.of("D63"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("brakeHorsePower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "brakeHorsePower"), "brakeHorsePower", "brake horse power"), Optional.of("BHP"), Optional.of("BHP"), Optional.of("watt"), Optional.of("7.457 \u00d7 10\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER))));
        UNITS_BY_NAME.put("britishThermalUnit39Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnit39Degreesf"), "britishThermalUnit39Degreesf", "British thermal unit (39 \u00b0F)"), Optional.of("Btu (39 \u00b0F)"), Optional.of("N66"), Optional.of("joule"), Optional.of("1.05967 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.HEAT))));
        UNITS_BY_NAME.put("britishThermalUnit59Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnit59Degreesf"), "britishThermalUnit59Degreesf", "British thermal unit (59 \u00b0F)"), Optional.of("Btu (59 \u00b0F)"), Optional.of("N67"), Optional.of("joule"), Optional.of("1.05480 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY, QuantityKinds.HEAT, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.ENTHALPY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.QUANTITY_OF_HEAT))));
        UNITS_BY_NAME.put("britishThermalUnit60Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnit60Degreesf"), "britishThermalUnit60Degreesf", "British thermal unit (60 \u00b0F)"), Optional.of("Btu (60 \u00b0F)"), Optional.of("N68"), Optional.of("joule"), Optional.of("1.05468 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.HEAT, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.QUANTITY_OF_HEAT))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTable"), "britishThermalUnitInternationalTable", "British thermal unit (international table)"), Optional.of("BtuIT"), Optional.of("BTU"), Optional.of("joule"), Optional.of("1.055056 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.ENTHALPY, QuantityKinds.HEAT, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTableFootPerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTableFootPerHourSquareFootDegreeFahrenheit"), "britishThermalUnitInternationalTableFootPerHourSquareFootDegreeFahrenheit", "British thermal unit (international table) foot per hour\u00a0square foot degree Fahrenheit"), Optional.of("BtuIT\u00b7ft/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J40"), Optional.of("wattPerMetreKelvin"), Optional.of("1.730735 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTableInchPerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTableInchPerHourSquareFootDegreeFahrenheit"), "britishThermalUnitInternationalTableInchPerHourSquareFootDegreeFahrenheit", "British thermal unit (international table) inch per hour square\u00a0foot degree Fahrenheit"), Optional.of("BtuIT\u00b7in/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J41"), Optional.of("wattPerMetreKelvin"), Optional.of("0.1442279 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTableInchPerSecondSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTableInchPerSecondSquareFootDegreeFahrenheit"), "britishThermalUnitInternationalTableInchPerSecondSquareFootDegreeFahrenheit", "British thermal unit (international table) inch per second square\u00a0foot degree Fahrenheit"), Optional.of("BtuIT\u00b7in/(s\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J42"), Optional.of("wattPerMetreKelvin"), Optional.of("5.192204 \u00d7 10\u00b2 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerCubicFoot"), "britishThermalUnitInternationalTablePerCubicFoot", "British thermal unit (international table) per cubic foot"), Optional.of("BtuIT/ft\u00b3"), Optional.of("N58"), Optional.of("joulePerCubicMetre"), Optional.of("3.725895 \u00d710\u2074 J/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_ENERGY, QuantityKinds.VOLUMIC, QuantityKinds.VOLUMIC_ELECTROMAGNETIC_ENERGY, QuantityKinds.SOUND_ENERGY_DENSITY, QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.ELECTROMAGNETIC_ENERGY_DENSITY, QuantityKinds.ENERGY_DENSITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerDegreeFahrenheit"), "britishThermalUnitInternationalTablePerDegreeFahrenheit", "British thermal unit (international table) per degree Fahrenheit"), Optional.of("BtuIT/\u00b0F"), Optional.of("N60"), Optional.of("joulePerKelvin"), Optional.of("1.899101 \u00d7 10\u00b3 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerDegreeRankine"), "britishThermalUnitInternationalTablePerDegreeRankine", "British thermal unit (international table) per degree Rankine"), Optional.of("BtuIT/\u00b0R"), Optional.of("N62"), Optional.of("joulePerKelvin"), Optional.of("1.899101 \u00d7 10\u00b3 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerHour"), "britishThermalUnitInternationalTablePerHour", "British thermal unit (international table) per hour"), Optional.of("BtuIT/h"), Optional.of("2I"), Optional.of("watt"), Optional.of("2.930711\u00d7 10\u207b\u00b9 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerHourSquareFootDegreeFahrenheit"), "britishThermalUnitInternationalTablePerHourSquareFootDegreeFahrenheit", "British thermal unit (international table) per hour square foot degree Fahrenheit"), Optional.of("BtuIT/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("N74"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("5.678263 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerHourSquareFootDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerHourSquareFootDegreeRankine"), "britishThermalUnitInternationalTablePerHourSquareFootDegreeRankine", "British thermal unit (international table) per hour square foot degree Rankine"), Optional.of("BtuIT/(h\u00b7ft\u00b2\u00b7\u00b0R)"), Optional.of("A23"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerMinute"), "britishThermalUnitInternationalTablePerMinute", "British thermal unit (international table) per minute"), Optional.of("BtuIT/min"), Optional.of("J44"), Optional.of("watt"), Optional.of("17.584266 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerPound"), "britishThermalUnitInternationalTablePerPound", "British thermal unit (international table) per pound"), Optional.of("BtuIT/lb"), Optional.of("AZ"), Optional.of("joulePerKilogram"), Optional.of("2326 J/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASSIC_HELMHOLTZ_FREE_ENERGY, QuantityKinds.SPECIFIC_ENERGY, QuantityKinds.MASSIC_ENERGY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerPoundDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerPoundDegreeFahrenheit"), "britishThermalUnitInternationalTablePerPoundDegreeFahrenheit", "British thermal unit (international table) per pound degree Fahrenheit"), Optional.of("BtuIT/(lb\u00b7\u00b0F)"), Optional.of("J43"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.1868 \u00d7 10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerPoundDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerPoundDegreeRankine"), "britishThermalUnitInternationalTablePerPoundDegreeRankine", "British thermal unit (international table) per pound degree Rankine"), Optional.of("BtuIT/(lb\u00b7\u00b0R)"), Optional.of("A21"), Optional.of("joulePerKilogramKelvin"), Optional.of("4186.8 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSecond"), "britishThermalUnitInternationalTablePerSecond", "British thermal unit (international table) per second"), Optional.of("BtuIT/s"), Optional.of("J45"), Optional.of("watt"), Optional.of("1.055056 \u00d7 10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.HEAT_FLOW_RATE))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSecondFootDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSecondFootDegreeRankine"), "britishThermalUnitInternationalTablePerSecondFootDegreeRankine", "British thermal unit (international table) per second foot degree Rankine"), Optional.of("BtuIT/(s\u00b7ft\u00b7\u00b0R)"), Optional.of("A22"), Optional.of("wattPerMetreKelvin"), Optional.of("6230.64 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSecondSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSecondSquareFootDegreeFahrenheit"), "britishThermalUnitInternationalTablePerSecondSquareFootDegreeFahrenheit", "British thermal unit (international table) per second square foot degree Fahrenheit"), Optional.of("BtuIT/(s\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("N76"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("2.044175 \u00d7 10\u2074 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSecondSquareFootDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSecondSquareFootDegreeRankine"), "britishThermalUnitInternationalTablePerSecondSquareFootDegreeRankine", "British thermal unit (international table) per second square foot degree Rankine"), Optional.of("BtuIT/(s\u00b7ft\u00b2\u00b7\u00b0R)"), Optional.of("A20"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("20441.7 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSquareFoot"), "britishThermalUnitInternationalTablePerSquareFoot", "British thermal unit (international table) per square foot"), Optional.of("BtuIT/ft\u00b2"), Optional.of("P37"), Optional.of("joulePerSquareMetre"), Optional.of("1.135653 \u00d7 10\u2074 J/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE))));
    }

    private static void init1() {
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSquareFootHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSquareFootHour"), "britishThermalUnitInternationalTablePerSquareFootHour", "British thermal unit (international table) per square foot hour"), Optional.of("BtuIT/(ft\u00b2\u00b7h)"), Optional.of("N50"), Optional.of("wattPerSquareMetre"), Optional.of("3.154591 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSquareFootSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSquareFootSecond"), "britishThermalUnitInternationalTablePerSquareFootSecond", "British thermal unit (international table) per square foot second"), Optional.of("BtuIT/(ft\u00b2\u00b7s)"), Optional.of("N53"), Optional.of("wattPerSquareMetre"), Optional.of("1.135653 \u00d7 10\u2074 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("britishThermalUnitInternationalTablePerSquareInchSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitInternationalTablePerSquareInchSecond"), "britishThermalUnitInternationalTablePerSquareInchSecond", "British thermal unit (international table) per square inch second"), Optional.of("BtuIT/(in\u00b2\u00b7s)"), Optional.of("N55"), Optional.of("wattPerSquareMetre"), Optional.of("1.634246 \u00d7 10\u2076 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("britishThermalUnitMean", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitMean"), "britishThermalUnitMean", "British thermal unit (mean)"), Optional.of("Btu"), Optional.of("J39"), Optional.of("joule"), Optional.of("1.05587 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.HEAT))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalFootPerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalFootPerHourSquareFootDegreeFahrenheit"), "britishThermalUnitThermochemicalFootPerHourSquareFootDegreeFahrenheit", "British thermal unit (thermochemical) foot per hour square\u00a0foot degree Fahrenheit"), Optional.of("Btuth\u00b7ft/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J46"), Optional.of("wattPerMetreKelvin"), Optional.of("1.729577 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalInchPerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalInchPerHourSquareFootDegreeFahrenheit"), "britishThermalUnitThermochemicalInchPerHourSquareFootDegreeFahrenheit", "British thermal unit (thermochemical) inch per hour square\u00a0foot degree Fahrenheit"), Optional.of("Btuth\u00b7in/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J48"), Optional.of("wattPerMetreKelvin"), Optional.of("0.1441314 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalInchPerSecondSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalInchPerSecondSquareFootDegreeFahrenheit"), "britishThermalUnitThermochemicalInchPerSecondSquareFootDegreeFahrenheit", "British thermal unit (thermochemical) inch per second\u00a0square foot degree Fahrenheit"), Optional.of("Btuth\u00b7in/(s\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("J49"), Optional.of("wattPerMetreKelvin"), Optional.of("5.188732 \u00d7 10\u00b2 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerCubicFoot"), "britishThermalUnitThermochemicalPerCubicFoot", "British thermal unit (thermochemical) per cubic foot"), Optional.of("Btuth/ft\u00b3"), Optional.of("N59"), Optional.of("joulePerCubicMetre"), Optional.of("3.723403 \u00d710\u2074 J/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_ENERGY, QuantityKinds.VOLUMIC, QuantityKinds.VOLUMIC_ELECTROMAGNETIC_ENERGY, QuantityKinds.SOUND_ENERGY_DENSITY, QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.ELECTROMAGNETIC_ENERGY_DENSITY, QuantityKinds.ENERGY_DENSITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerDegreeFahrenheit"), "britishThermalUnitThermochemicalPerDegreeFahrenheit", "British thermal unit (thermochemical) per degree Fahrenheit"), Optional.of("Btuth/\u00b0F"), Optional.of("N61"), Optional.of("joulePerKelvin"), Optional.of("1.897830 \u00d7 10\u00b3 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerDegreeRankine"), "britishThermalUnitThermochemicalPerDegreeRankine", "British thermal unit (thermochemical) per degree Rankine"), Optional.of("Btuth/\u00b0R"), Optional.of("N63"), Optional.of("joulePerKelvin"), Optional.of("1.897830 \u00d7 10\u00b3 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerHour"), "britishThermalUnitThermochemicalPerHour", "British thermal unit (thermochemical) per hour"), Optional.of("Btuth/h"), Optional.of("J47"), Optional.of("watt"), Optional.of("0.2928751 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerHourSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerHourSquareFootDegreeFahrenheit"), "britishThermalUnitThermochemicalPerHourSquareFootDegreeFahrenheit", "British thermal unit (thermochemical) per hour square foot degree Fahrenheit"), Optional.of("Btuth/(h\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("N75"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("5.674466 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerMinute"), "britishThermalUnitThermochemicalPerMinute", "British thermal unit (thermochemical) per minute"), Optional.of("Btuth/min"), Optional.of("J51"), Optional.of("watt"), Optional.of("17.57250 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.HEAT_FLOW_RATE))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerPound"), "britishThermalUnitThermochemicalPerPound", "British thermal unit (thermochemical) per pound"), Optional.of("Btuth/lb"), Optional.of("N73"), Optional.of("joulePerKilogram"), Optional.of("2.324444 \u00d7 10\u00b3 J/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASSIC_HELMHOLTZ_FREE_ENERGY, QuantityKinds.SPECIFIC_ENERGY, QuantityKinds.MASSIC_ENERGY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerPoundDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerPoundDegreeFahrenheit"), "britishThermalUnitThermochemicalPerPoundDegreeFahrenheit", "British thermal unit (thermochemical) per pound degree Fahrenheit"), Optional.of("Btuth/(lb\u00b7\u00b0F)"), Optional.of("J50"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.184 \u00d7 10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerPoundDegreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerPoundDegreeRankine"), "britishThermalUnitThermochemicalPerPoundDegreeRankine", "British thermal unit (thermochemical) per pound degree Rankine"), Optional.of("(Btuth/\u00b0R)/lb"), Optional.of("N64"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.184 \u00d7 10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSecond"), "britishThermalUnitThermochemicalPerSecond", "British thermal unit (thermochemical) per second"), Optional.of("Btuth/s"), Optional.of("J52"), Optional.of("watt"), Optional.of("1.054350 \u00d7 10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSecondSquareFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSecondSquareFootDegreeFahrenheit"), "britishThermalUnitThermochemicalPerSecondSquareFootDegreeFahrenheit", "British thermal unit (thermochemical) per second square foot degree Fahrenheit"), Optional.of("Btuth/(s\u00b7ft\u00b2\u00b7\u00b0F)"), Optional.of("N77"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("2.042808 \u00d7 10\u2074 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSquareFoot"), "britishThermalUnitThermochemicalPerSquareFoot", "British thermal unit (thermochemical) per square foot"), Optional.of("Btuth/ft\u00b2"), Optional.of("P38"), Optional.of("joulePerSquareMetre"), Optional.of("1.134893 \u00d7 10\u2074 J/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSquareFootHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSquareFootHour"), "britishThermalUnitThermochemicalPerSquareFootHour", "British thermal unit (thermochemical) per square foot hour"), Optional.of("Btuth/(ft\u00b2\u00b7h)"), Optional.of("N51"), Optional.of("wattPerSquareMetre"), Optional.of("3.152481 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSquareFootMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSquareFootMinute"), "britishThermalUnitThermochemicalPerSquareFootMinute", "British thermal unit (thermochemical) per square foot minute"), Optional.of("Btuth/(ft\u00b2\u00b7min)"), Optional.of("N52"), Optional.of("wattPerSquareMetre"), Optional.of("1.891489 \u00d7 10\u00b2 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("britishThermalUnitThermochemicalPerSquareFootSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "britishThermalUnitThermochemicalPerSquareFootSecond"), "britishThermalUnitThermochemicalPerSquareFootSecond", "British thermal unit (thermochemical) per square foot second"), Optional.of("Btuth/(ft\u00b2\u00b7s)"), Optional.of("N54"), Optional.of("wattPerSquareMetre"), Optional.of("1.134893 \u00d7 10\u2074 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("bulkPack", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bulkPack"), "bulkPack", "bulk pack"), Optional.of("pk"), Optional.of("AB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("bushelUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUk"), "bushelUk", "bushel (UK)"), Optional.of("bushel (UK)"), Optional.of("BUI"), Optional.of("cubicMetre"), Optional.of("3.636872 \u00d7 10\u207b\u00b2 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("bushelUkPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUkPerDay"), "bushelUkPerDay", "bushel (UK) per day"), Optional.of("bu (UK)/d"), Optional.of("J64"), Optional.of("cubicMetrePerSecond"), Optional.of("4.209343 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUkPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUkPerHour"), "bushelUkPerHour", "bushel (UK) per hour"), Optional.of("bu (UK)/h"), Optional.of("J65"), Optional.of("cubicMetrePerSecond"), Optional.of("1.010242 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUkPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUkPerMinute"), "bushelUkPerMinute", "bushel (UK) per minute"), Optional.of("bu (UK)/min"), Optional.of("J66"), Optional.of("cubicMetrePerSecond"), Optional.of("6.061453 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUkPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUkPerSecond"), "bushelUkPerSecond", "bushel (UK) per second"), Optional.of("bu (UK)/s"), Optional.of("J67"), Optional.of("cubicMetrePerSecond"), Optional.of("3.636872 \u00d7 10\u207b\u00b2 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUs"), "bushelUs", "bushel (US)"), Optional.of("bu (US)"), Optional.of("BUA"), Optional.of("cubicMetre"), Optional.of("3.523907 \u00d7 10\u207b\u00b2 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("bushelUsDryPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUsDryPerDay"), "bushelUsDryPerDay", "bushel (US dry) per day"), Optional.of("bu (US dry)/d"), Optional.of("J68"), Optional.of("cubicMetrePerSecond"), Optional.of("4.078596 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUsDryPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUsDryPerHour"), "bushelUsDryPerHour", "bushel (US dry) per hour"), Optional.of("bu (US dry)/h"), Optional.of("J69"), Optional.of("cubicMetrePerSecond"), Optional.of("9.788631 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUsDryPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUsDryPerMinute"), "bushelUsDryPerMinute", "bushel (US dry) per minute"), Optional.of("bu (US dry)/min"), Optional.of("J70"), Optional.of("cubicMetrePerSecond"), Optional.of("5.873178 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("bushelUsDryPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bushelUsDryPerSecond"), "bushelUsDryPerSecond", "bushel (US dry) per second"), Optional.of("bu (US dry)/s"), Optional.of("J71"), Optional.of("cubicMetrePerSecond"), Optional.of("3.523907 \u00d7 10\u207b\u00b2 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("byte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "byte"), "byte", "byte"), Optional.of("B"), Optional.of("AD"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("bytePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "bytePerSecond"), "bytePerSecond", "byte per second"), Optional.of("byte/s"), Optional.of("P93"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("cake", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cake"), "cake", "cake"), Optional.empty(), Optional.of("KA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("call", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "call"), "call", "call"), Optional.empty(), Optional.of("C0"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("calorie20Degreesc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorie20Degreesc"), "calorie20Degreesc", "calorie (20 \u00b0C)"), Optional.of("cal\u2082\u2080"), Optional.of("N69"), Optional.of("joule"), Optional.of("4.18190"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HEAT, QuantityKinds.ENTHALPY, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HELMHOLTZ_FREE_ENERGY))));
        UNITS_BY_NAME.put("calorieInternationalTablePerGramDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieInternationalTablePerGramDegreeCelsius"), "calorieInternationalTablePerGramDegreeCelsius", "calorie (international table) per gram degree Celsius"), Optional.of("calIT/(g\u00b7\u00b0C)"), Optional.of("J76"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.1868 \u00d7 10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("calorieMean", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieMean"), "calorieMean", "calorie (mean)"), Optional.of("cal"), Optional.of("J75"), Optional.of("joule"), Optional.of("4.19002 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.HEAT, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.ENTHALPY, QuantityKinds.THERMODYNAMIC_ENERGY))));
        UNITS_BY_NAME.put("calorieThermochemicalPerCentimetreSecondDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerCentimetreSecondDegreeCelsius"), "calorieThermochemicalPerCentimetreSecondDegreeCelsius", "calorie (thermochemical) per centimetre second degree Celsius"), Optional.of("calth/(cm\u00b7s\u00b7\u00b0C)"), Optional.of("J78"), Optional.of("wattPerMetreKelvin"), Optional.of("4.184 \u00d7 10\u00b2 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("calorieThermochemicalPerGramDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerGramDegreeCelsius"), "calorieThermochemicalPerGramDegreeCelsius", "calorie (thermochemical) per gram degree Celsius"), Optional.of("calth/(g\u00b7\u00b0C)"), Optional.of("J79"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.184 \u00d7 10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("calorieThermochemicalPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerMinute"), "calorieThermochemicalPerMinute", "calorie (thermochemical) per minute"), Optional.of("calth/min"), Optional.of("J81"), Optional.of("watt"), Optional.of("6.973333 \u00d7 10\u207b\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.HEAT_FLOW_RATE))));
        UNITS_BY_NAME.put("calorieThermochemicalPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerSecond"), "calorieThermochemicalPerSecond", "calorie (thermochemical) per second"), Optional.of("calth/s"), Optional.of("J82"), Optional.of("watt"), Optional.of("4.184 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("calorieThermochemicalPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerSquareCentimetre"), "calorieThermochemicalPerSquareCentimetre", "calorie (thermochemical) per square centimetre"), Optional.of("calth/cm\u00b2"), Optional.of("P39"), Optional.of("joulePerSquareMetre"), Optional.of("4.184 \u00d7 10\u2074 J/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE))));
        UNITS_BY_NAME.put("calorieThermochemicalPerSquareCentimetreMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerSquareCentimetreMinute"), "calorieThermochemicalPerSquareCentimetreMinute", "calorie (thermochemical) per square centimetre minute"), Optional.of("calth/(cm\u00b2\u00b7min)"), Optional.of("N56"), Optional.of("wattPerSquareMetre"), Optional.of("6.973333 \u00d7 10\u00b2 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("calorieThermochemicalPerSquareCentimetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "calorieThermochemicalPerSquareCentimetreSecond"), "calorieThermochemicalPerSquareCentimetreSecond", "calorie (thermochemical) per square centimetre second"), Optional.of("calth/(cm\u00b2\u00b7s)"), Optional.of("N57"), Optional.of("wattPerSquareMetre"), Optional.of("4.184 \u00d7 10\u2074 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("candela", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "candela"), "candela", "candela"), Optional.of("cd"), Optional.of("CDL"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_INTENSITY))));
        UNITS_BY_NAME.put("candelaPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "candelaPerSquareFoot"), "candelaPerSquareFoot", "candela per square foot"), Optional.of("cd/ft\u00b2"), Optional.of("P32"), Optional.of("candelaPerSquareMetre"), Optional.of("1.076391 \u00d7 10 cd/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE, QuantityKinds.LUMINANCE))));
        UNITS_BY_NAME.put("candelaPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "candelaPerSquareInch"), "candelaPerSquareInch", "candela per square inch"), Optional.of("cd/in\u00b2"), Optional.of("P28"), Optional.of("candelaPerSquareMetre"), Optional.of("1.550003 \u00d7 10\u00b3 cd/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE, QuantityKinds.LUMINANCE))));
        UNITS_BY_NAME.put("candelaPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "candelaPerSquareMetre"), "candelaPerSquareMetre", "candela per square metre"), Optional.of("cd/m\u00b2"), Optional.of("A24"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE))));
        UNITS_BY_NAME.put("card", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "card"), "card", "card"), Optional.empty(), Optional.of("CG"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("carryingCapacityInMetricTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "carryingCapacityInMetricTon"), "carryingCapacityInMetricTon", "carrying capacity in metric ton"), Optional.empty(), Optional.of("CCT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("centalUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centalUk"), "centalUk", "cental (UK)"), Optional.empty(), Optional.of("CNT"), Optional.of("kilogram"), Optional.of("45.359237 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("centigram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centigram"), "centigram", "centigram"), Optional.of("cg"), Optional.of("CGM"), Optional.of("kilogram"), Optional.of("10\u207b\u2075 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("centilitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centilitre"), "centilitre", "centilitre"), Optional.of("cl"), Optional.of("CLT"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2075 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("centimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetre"), "centimetre", "centimetre"), Optional.of("cm"), Optional.of("CMT"), Optional.of("metre"), Optional.of("10\u207b\u00b2 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH, QuantityKinds.BREADTH))));
        UNITS_BY_NAME.put("centimetreOfMercury0Degreesc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetreOfMercury0Degreesc"), "centimetreOfMercury0Degreesc", "centimetre of mercury (0 \u00b0C)"), Optional.of("cmHg (0 \u00b0C)"), Optional.of("N13"), Optional.of("pascal"), Optional.of("1.33322 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("centimetreOfWater4Degreesc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetreOfWater4Degreesc"), "centimetreOfWater4Degreesc", "centimetre of water (4 \u00b0C)"), Optional.of("cmH\u2082O (4 \u00b0C)"), Optional.of("N14"), Optional.of("pascal"), Optional.of("9.80638 \u00d7 10 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_STRESS))));
        UNITS_BY_NAME.put("centimetrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerBar"), "centimetrePerBar", "centimetre per bar"), Optional.of("cm/bar"), Optional.of("G04"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LENGTH_OF_PATH, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.RADIUS, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("centimetrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerHour"), "centimetrePerHour", "centimetre per hour"), Optional.of("cm/h"), Optional.of("H49"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("centimetrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerKelvin"), "centimetrePerKelvin", "centimetre per kelvin"), Optional.of("cm/K"), Optional.of("F51"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIUS, QuantityKinds.LENGTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.BREADTH, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER))));
        UNITS_BY_NAME.put("centimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerSecond"), "centimetrePerSecond", "centimetre per second"), Optional.of("cm/s"), Optional.of("2M"), Optional.of("metrePerSecond"), Optional.of("10\u207b\u00b2 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY))));
        UNITS_BY_NAME.put("centimetrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerSecondBar"), "centimetrePerSecondBar", "centimetre per second bar"), Optional.of("(cm/s)/bar"), Optional.of("J85"), Optional.of("metrePerSecondPascal"), Optional.of("10\u207b\u2077 (m/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("centimetrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerSecondKelvin"), "centimetrePerSecondKelvin", "centimetre per second kelvin"), Optional.of("(cm/s)/K"), Optional.of("J84"), Optional.of("metrePerSecondKelvin"), Optional.of("10\u207b\u00b2 (m/s)/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("centimetrePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centimetrePerSecondSquared"), "centimetrePerSecondSquared", "centimetre per second squared"), Optional.of("cm/s\u00b2"), Optional.of("M39"), Optional.of("metrePerSecondSquared"), Optional.of("10\u207b\u00b2 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("centinewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centinewtonMetre"), "centinewtonMetre", "centinewton metre"), Optional.of("cN\u00b7m"), Optional.of("J72"), Optional.of("newtonMetre"), Optional.of("10\u207b\u00b2 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("centipoise", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centipoise"), "centipoise", "centipoise"), Optional.of("cP"), Optional.of("C7"), Optional.of("pascalSecond"), Optional.of("10\u207b\u00b3 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("centipoisePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centipoisePerBar"), "centipoisePerBar", "centipoise per bar"), Optional.of("cP/bar"), Optional.of("J74"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2078 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("centipoisePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centipoisePerKelvin"), "centipoisePerKelvin", "centipoise per kelvin"), Optional.of("cP/K"), Optional.of("J73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("centistokes", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "centistokes"), "centistokes", "centistokes"), Optional.of("cSt"), Optional.of("4C"), Optional.of("squareMetrePerSecond"), Optional.of("10\u207b\u2076 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("chainBasedOnUsSurveyFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "chainBasedOnUsSurveyFoot"), "chainBasedOnUsSurveyFoot", "chain (based on U.S. survey foot)"), Optional.of("ch (US survey)"), Optional.of("M49"), Optional.of("metre"), Optional.of("2.011684 \u00d7 10 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.BREADTH, QuantityKinds.THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("circularMil", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "circularMil"), "circularMil", "circular mil"), Optional.of("cmil"), Optional.of("M47"), Optional.of("squareMetre"), Optional.of("5.067075 \u00d7 10\u207b\u00b9\u2070 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("clo", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "clo"), "clo", "clo"), Optional.of("clo"), Optional.of("J83"), Optional.of("squareMetreKelvinPerWatt"), Optional.of("0.155 m\u00b2 \u00d7 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION, QuantityKinds.THERMAL_INSULANCE))));
        UNITS_BY_NAME.put("coilGroup", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coilGroup"), "coilGroup", "coil group"), Optional.empty(), Optional.of("C9"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("commonYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "commonYear"), "commonYear", "common year"), Optional.of("y (365 days)"), Optional.of("L95"), Optional.of("secondUnitOfTime"), Optional.of("3.1536 \u00d7 10\u2077 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("contentGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "contentGram"), "contentGram", "content gram"), Optional.empty(), Optional.of("CTG"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("contentTonMetric", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "contentTonMetric"), "contentTonMetric", "content ton (metric)"), Optional.empty(), Optional.of("CTN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("conventionalMetreOfWater", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "conventionalMetreOfWater"), "conventionalMetreOfWater", "conventional metre of water"), Optional.of("mH\u2082O"), Optional.of("N23"), Optional.of("pascal"), Optional.of("9.80665 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS, QuantityKinds.PRESSURE))));
        UNITS_BY_NAME.put("cord", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cord"), "cord", "cord"), Optional.empty(), Optional.of("WCD"), Optional.of("cubicMetre"), Optional.of("3.63 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("cord128Ft3", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cord128Ft3"), "cord128Ft3", "cord (128 ft3)"), Optional.of("cord"), Optional.of("M68"), Optional.of("cubicMetre"), Optional.of("3.624556 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("coulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulomb"), "coulomb", "coulomb"), Optional.of("C"), Optional.of("COU"), Optional.of("ampereSecond"), Optional.of("A \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("coulombMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombMetre"), "coulombMetre", "coulomb metre"), Optional.of("C\u00b7m"), Optional.of("A26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_DIPOLE_MOMENT_OF_MOLECULE, QuantityKinds.ELECTRIC_DIPOLE_MOMENT))));
        UNITS_BY_NAME.put("coulombMetreSquaredPerVolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombMetreSquaredPerVolt"), "coulombMetreSquaredPerVolt", "coulomb metre squared per volt"), Optional.of("C\u00b7m\u00b2/V"), Optional.of("A27"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_POLARIZABILITY_OF_A_MOLECULE))));
        UNITS_BY_NAME.put("coulombPerCubicCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerCubicCentimetre"), "coulombPerCubicCentimetre", "coulomb per cubic centimetre"), Optional.of("C/cm\u00b3"), Optional.of("A28"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u2076 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUMIC_CHARGE))));
        UNITS_BY_NAME.put("coulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerCubicMetre"), "coulombPerCubicMetre", "coulomb per cubic metre"), Optional.of("C/m\u00b3"), Optional.of("A29"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("coulombPerCubicMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerCubicMillimetre"), "coulombPerCubicMillimetre", "coulomb per cubic millimetre"), Optional.of("C/mm\u00b3"), Optional.of("A30"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u2079 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("coulombPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerKilogram"), "coulombPerKilogram", "coulomb per kilogram"), Optional.of("C/kg"), Optional.of("CKG"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("coulombPerKilogramSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerKilogramSecond"), "coulombPerKilogramSecond", "coulomb per kilogram second"), Optional.of("C/(kg\u00b7s)"), Optional.of("A31"), Optional.of("amperePerKilogram"), Optional.of("A/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE_RATE, QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("coulombPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerMetre"), "coulombPerMetre", "coulomb per metre"), Optional.of("C/m"), Optional.of("P10"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_CHARGE))));
        UNITS_BY_NAME.put("coulombPerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerMole"), "coulombPerMole", "coulomb per mole"), Optional.of("C/mol"), Optional.of("A32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FARADAY_CONSTANT))));
        UNITS_BY_NAME.put("coulombPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerSquareCentimetre"), "coulombPerSquareCentimetre", "coulomb per square centimetre"), Optional.of("C/cm\u00b2"), Optional.of("A33"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u2074 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("coulombPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerSquareMetre"), "coulombPerSquareMetre", "coulomb per square metre"), Optional.of("C/m\u00b2"), Optional.of("A34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("coulombPerSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombPerSquareMillimetre"), "coulombPerSquareMillimetre", "coulomb per square millimetre"), Optional.of("C/mm\u00b2"), Optional.of("A35"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u2076 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("coulombSquareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "coulombSquareMetrePerKilogram"), "coulombSquareMetrePerKilogram", "coulomb square metre per kilogram"), Optional.of("C\u00b7m\u00b2/kg"), Optional.of("J53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("credit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "credit"), "credit", "credit"), Optional.empty(), Optional.of("B17"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("cubicCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetre"), "cubicCentimetre", "cubic centimetre"), Optional.of("cm\u00b3"), Optional.of("CMQ"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2076 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicCentimetrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerBar"), "cubicCentimetrePerBar", "cubic centimetre per bar"), Optional.of("cm\u00b3/bar"), Optional.of("G94"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicCentimetrePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerCubicMetre"), "cubicCentimetrePerCubicMetre", "cubic centimetre per cubic metre"), Optional.of("cm\u00b3/m\u00b3"), Optional.of("J87"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("cubicCentimetrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerDay"), "cubicCentimetrePerDay", "cubic centimetre per day"), Optional.of("cm\u00b3/d"), Optional.of("G47"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
    }

    private static void init2() {
        UNITS_BY_NAME.put("cubicCentimetrePerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerDayBar"), "cubicCentimetrePerDayBar", "cubic centimetre per day bar"), Optional.of("cm\u00b3/(d\u00b7bar)"), Optional.of("G78"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerDayKelvin"), "cubicCentimetrePerDayKelvin", "cubic centimetre per day kelvin"), Optional.of("cm\u00b3/(d\u00b7K)"), Optional.of("G61"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerHour"), "cubicCentimetrePerHour", "cubic centimetre per hour"), Optional.of("cm\u00b3/h"), Optional.of("G48"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerHourBar"), "cubicCentimetrePerHourBar", "cubic centimetre per hour bar"), Optional.of("cm\u00b3/(h\u00b7bar)"), Optional.of("G79"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerHourKelvin"), "cubicCentimetrePerHourKelvin", "cubic centimetre per hour kelvin"), Optional.of("cm\u00b3/(h\u00b7K)"), Optional.of("G62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerKelvin"), "cubicCentimetrePerKelvin", "cubic centimetre per kelvin"), Optional.of("cm\u00b3/K"), Optional.of("G27"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_PER_TEMPERATURE))));
        UNITS_BY_NAME.put("cubicCentimetrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerMinute"), "cubicCentimetrePerMinute", "cubic centimetre per minute"), Optional.of("cm\u00b3/min"), Optional.of("G49"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerMinuteBar"), "cubicCentimetrePerMinuteBar", "cubic centimetre per minute bar"), Optional.of("cm\u00b3/(min\u00b7bar)"), Optional.of("G80"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerMinuteKelvin"), "cubicCentimetrePerMinuteKelvin", "cubic centimetre per minute kelvin"), Optional.of("cm\u00b3/(min\u00b7K)"), Optional.of("G63"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerMole"), "cubicCentimetrePerMole", "cubic centimetre per mole"), Optional.of("cm\u00b3/mol"), Optional.of("A36"), Optional.of("cubicMetrePerMole"), Optional.of("10\u207b\u2076 m\u00b3/mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_VOLUME, QuantityKinds.MOLAR_VOLUME))));
        UNITS_BY_NAME.put("cubicCentimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerSecond"), "cubicCentimetrePerSecond", "cubic centimetre per second"), Optional.of("cm\u00b3/s"), Optional.of("2J"), Optional.of("cubicMetrePerSecond"), Optional.of("10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerSecondBar"), "cubicCentimetrePerSecondBar", "cubic centimetre per second bar"), Optional.of("cm\u00b3/(s\u00b7bar)"), Optional.of("G81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicCentimetrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicCentimetrePerSecondKelvin"), "cubicCentimetrePerSecondKelvin", "cubic centimetre per second kelvin"), Optional.of("cm\u00b3/(s\u00b7K)"), Optional.of("G64"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicDecametre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecametre"), "cubicDecametre", "cubic decametre"), Optional.of("dam\u00b3"), Optional.of("DMA"), Optional.of("cubicMetre"), Optional.of("10\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicDecimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetre"), "cubicDecimetre", "cubic decimetre"), Optional.of("dm\u00b3"), Optional.of("DMQ"), Optional.of("cubicMetre"), Optional.of("10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicDecimetrePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerCubicMetre"), "cubicDecimetrePerCubicMetre", "cubic decimetre per cubic metre"), Optional.of("dm\u00b3/m\u00b3"), Optional.of("J91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("cubicDecimetrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerDay"), "cubicDecimetrePerDay", "cubic decimetre per day"), Optional.of("dm\u00b3/d"), Optional.of("J90"), Optional.of("cubicMetrePerSecond"), Optional.of("1.15741 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicDecimetrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerHour"), "cubicDecimetrePerHour", "cubic decimetre per hour"), Optional.of("dm\u00b3/h"), Optional.of("E92"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicDecimetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerKilogram"), "cubicDecimetrePerKilogram", "cubic decimetre per kilogram"), Optional.of("dm\u00b3/kg"), Optional.of("N28"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("cubicDecimetrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerMinute"), "cubicDecimetrePerMinute", "cubic decimetre per minute"), Optional.of("dm\u00b3/min"), Optional.of("J92"), Optional.of("cubicMetrePerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicDecimetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerMole"), "cubicDecimetrePerMole", "cubic decimetre per mole"), Optional.of("dm\u00b3/mol"), Optional.of("A37"), Optional.of("cubicMetrePerMole"), Optional.of("10\u207b\u00b3 m\u00b3/mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_VOLUME, QuantityKinds.MOLAR_VOLUME))));
        UNITS_BY_NAME.put("cubicDecimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicDecimetrePerSecond"), "cubicDecimetrePerSecond", "cubic decimetre per second"), Optional.of("dm\u00b3/s"), Optional.of("J93"), Optional.of("cubicMetrePerSecond"), Optional.of("10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFoot"), "cubicFoot", "cubic foot"), Optional.of("ft\u00b3"), Optional.of("FTQ"), Optional.of("cubicMetre"), Optional.of("2.831685 \u00d7 10\u207b\u00b2 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicFootPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerDay"), "cubicFootPerDay", "cubic foot per day"), Optional.of("ft\u00b3/d"), Optional.of("K22"), Optional.of("cubicMetrePerSecond"), Optional.of("3.277413 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicFootPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerDegreeFahrenheit"), "cubicFootPerDegreeFahrenheit", "cubic foot per degree Fahrenheit"), Optional.of("ft\u00b3/\u00b0F"), Optional.of("K21"), Optional.of("cubicMetrePerKelvin"), Optional.of("5.097033 \u00d7 10\u207b\u00b2 m\u00b3/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_PER_TEMPERATURE, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicFootPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerHour"), "cubicFootPerHour", "cubic foot per hour"), Optional.of("ft\u00b3/h"), Optional.of("2K"), Optional.of("cubicMetrePerSecond"), Optional.of("7.86579 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicFootPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerMinute"), "cubicFootPerMinute", "cubic foot per minute"), Optional.of("ft\u00b3/min"), Optional.of("2L"), Optional.of("cubicMetrePerSecond"), Optional.of("4.719474 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicFootPerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerPound"), "cubicFootPerPound", "cubic foot per pound"), Optional.of("ft\u00b3/lb"), Optional.of("N29"), Optional.of("cubicMetrePerKilogram"), Optional.of("6.242796 \u00d7 10\u207b\u00b2 m\u00b3/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.SPECIFIC_VOLUME))));
        UNITS_BY_NAME.put("cubicFootPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerPsi"), "cubicFootPerPsi", "cubic foot per psi"), Optional.of("ft\u00b3/psi"), Optional.of("K23"), Optional.of("cubicMetrePerPascal"), Optional.of("4.107012 \u00d7 10\u207b\u2076 m\u00b3/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicFootPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicFootPerSecond"), "cubicFootPerSecond", "cubic foot per second"), Optional.of("ft\u00b3/s"), Optional.of("E17"), Optional.of("cubicMetrePerSecond"), Optional.of("2.831685 \u00d7 10\u207b\u00b2 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicHectometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicHectometre"), "cubicHectometre", "cubic hectometre"), Optional.of("hm\u00b3"), Optional.of("H19"), Optional.of("cubicMetre"), Optional.of("10\u2076 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicInch"), "cubicInch", "cubic inch"), Optional.of("in\u00b3"), Optional.of("INQ"), Optional.of("cubicMetre"), Optional.of("16.387064 \u00d7 10\u207b\u2076 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("cubicInchPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicInchPerHour"), "cubicInchPerHour", "cubic inch per hour"), Optional.of("in\u00b3/h"), Optional.of("G56"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicInchPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicInchPerMinute"), "cubicInchPerMinute", "cubic inch per minute"), Optional.of("in\u00b3/min"), Optional.of("G57"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicInchPerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicInchPerPound"), "cubicInchPerPound", "cubic inch per pound"), Optional.of("in\u00b3/lb"), Optional.of("N30"), Optional.of("cubicMetrePerKilogram"), Optional.of("3.612728 \u00d7 10\u207b\u2075 m\u00b3/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("cubicInchPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicInchPerSecond"), "cubicInchPerSecond", "cubic inch per second"), Optional.of("in\u00b3/s"), Optional.of("G58"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicKilometre"), "cubicKilometre", "cubic kilometre"), Optional.of("km\u00b3"), Optional.of("H20"), Optional.of("cubicMetre"), Optional.of("10\u2079 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetre"), "cubicMetre", "cubic metre"), Optional.of("m\u00b3"), Optional.of("MTQ"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("cubicMetrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerBar"), "cubicMetrePerBar", "cubic metre per bar"), Optional.of("m\u00b3/bar"), Optional.of("G96"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMetrePerCoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerCoulomb"), "cubicMetrePerCoulomb", "cubic metre per coulomb"), Optional.of("m\u00b3/C"), Optional.of("A38"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HALL_COEFFICIENT))));
        UNITS_BY_NAME.put("cubicMetrePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerCubicMetre"), "cubicMetrePerCubicMetre", "cubic metre per cubic metre"), Optional.of("m\u00b3/m\u00b3"), Optional.of("H60"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("cubicMetrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerDay"), "cubicMetrePerDay", "cubic metre per day"), Optional.of("m\u00b3/d"), Optional.of("G52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerDayBar"), "cubicMetrePerDayBar", "cubic metre per day bar"), Optional.of("m\u00b3/(d\u00b7bar)"), Optional.of("G86"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerDayKelvin"), "cubicMetrePerDayKelvin", "cubic metre per day kelvin"), Optional.of("m\u00b3/(d\u00b7K)"), Optional.of("G69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerHour"), "cubicMetrePerHour", "cubic metre per hour"), Optional.of("m\u00b3/h"), Optional.of("MQH"), Optional.of("cubicMetrePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerHourBar"), "cubicMetrePerHourBar", "cubic metre per hour bar"), Optional.of("m\u00b3/(h\u00b7bar)"), Optional.of("G87"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerHourKelvin"), "cubicMetrePerHourKelvin", "cubic metre per hour kelvin"), Optional.of("m\u00b3/(h\u00b7K)"), Optional.of("G70"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerKelvin"), "cubicMetrePerKelvin", "cubic metre per kelvin"), Optional.of("m\u00b3/K"), Optional.of("G29"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_PER_TEMPERATURE))));
        UNITS_BY_NAME.put("cubicMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerKilogram"), "cubicMetrePerKilogram", "cubic metre per kilogram"), Optional.of("m\u00b3/kg"), Optional.of("A39"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("cubicMetrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerMinute"), "cubicMetrePerMinute", "cubic metre per minute"), Optional.of("m\u00b3/min"), Optional.of("G53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerMinuteBar"), "cubicMetrePerMinuteBar", "cubic metre per minute bar"), Optional.of("m\u00b3/(min\u00b7bar)"), Optional.of("G88"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerMinuteKelvin"), "cubicMetrePerMinuteKelvin", "cubic metre per minute kelvin"), Optional.of("m\u00b3/(min\u00b7K)"), Optional.of("G71"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerMole"), "cubicMetrePerMole", "cubic metre per mole"), Optional.of("m\u00b3/mol"), Optional.of("A40"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_VOLUME))));
        UNITS_BY_NAME.put("cubicMetrePerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerPascal"), "cubicMetrePerPascal", "cubic metre per pascal"), Optional.of("m\u00b3/Pa"), Optional.of("M71"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerSecond"), "cubicMetrePerSecond", "cubic metre per second"), Optional.of("m\u00b3/s"), Optional.of("MQS"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerSecondBar"), "cubicMetrePerSecondBar", "cubic metre per second bar"), Optional.of("m\u00b3/(s\u00b7bar)"), Optional.of("G89"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerSecondKelvin"), "cubicMetrePerSecondKelvin", "cubic metre per second kelvin"), Optional.of("m\u00b3/(s\u00b7K)"), Optional.of("G72"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerSecondPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerSecondPascal"), "cubicMetrePerSecondPascal", "cubic metre per second pascal"), Optional.of("(m\u00b3/s)/Pa"), Optional.of("N45"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicMetrePerSecondSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMetrePerSecondSquareMetre"), "cubicMetrePerSecondSquareMetre", "cubic metre per second square metre"), Optional.of("(m\u00b3/s)/m\u00b2"), Optional.of("P87"), Optional.of("metrePerSecond"), Optional.of("m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.POROSITY))));
        UNITS_BY_NAME.put("cubicMicrometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMicrometre"), "cubicMicrometre", "cubic micrometre"), Optional.of("\u00b5m\u00b3"), Optional.empty(), Optional.of("cubicMetre"), Optional.of("10\u207b\u00b9\u2078 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMileUkStatute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMileUkStatute"), "cubicMileUkStatute", "cubic mile (UK statute)"), Optional.of("mi\u00b3"), Optional.of("M69"), Optional.of("cubicMetre"), Optional.of("4.168182 \u00d7 10\u2079 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMillimetre"), "cubicMillimetre", "cubic millimetre"), Optional.of("mm\u00b3"), Optional.of("MMQ"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2079 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicMillimetrePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicMillimetrePerCubicMetre"), "cubicMillimetrePerCubicMetre", "cubic millimetre per cubic metre"), Optional.of("mm\u00b3/m\u00b3"), Optional.of("L21"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("cubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYard"), "cubicYard", "cubic yard"), Optional.of("yd\u00b3"), Optional.of("YDQ"), Optional.of("cubicMetre"), Optional.of("0.764555 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicYardPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerDay"), "cubicYardPerDay", "cubic yard per day"), Optional.of("yd\u00b3/d"), Optional.of("M12"), Optional.of("cubicMetrePerSecond"), Optional.of("8.849015 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicYardPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerDegreeFahrenheit"), "cubicYardPerDegreeFahrenheit", "cubic yard per degree Fahrenheit"), Optional.of("yd\u00b3/\u00b0F"), Optional.of("M11"), Optional.of("cubicMetrePerKelvin"), Optional.of("1.376199 m\u00b3/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME_PER_TEMPERATURE))));
        UNITS_BY_NAME.put("cubicYardPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerHour"), "cubicYardPerHour", "cubic yard per hour"), Optional.of("yd\u00b3/h"), Optional.of("M13"), Optional.of("cubicMetrePerSecond"), Optional.of("2.123764 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicYardPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerMinute"), "cubicYardPerMinute", "cubic yard per minute"), Optional.of("yd\u00b3/min"), Optional.of("M15"), Optional.of("cubicMetrePerSecond"), Optional.of("1.274258 \u00d7 10\u207b\u00b2 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cubicYardPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerPsi"), "cubicYardPerPsi", "cubic yard per psi"), Optional.of("yd\u00b3/psi"), Optional.of("M14"), Optional.of("cubicMetrePerPascal"), Optional.of("1.108893 \u00d7 10\u207b\u2074 m\u00b3/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("cubicYardPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cubicYardPerSecond"), "cubicYardPerSecond", "cubic yard per second"), Optional.of("yd\u00b3/s"), Optional.of("M16"), Optional.of("cubicMetrePerSecond"), Optional.of("0.7645549 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("cupUnitOfVolume", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cupUnitOfVolume"), "cupUnitOfVolume", "cup [unit of volume]"), Optional.of("cup (US)"), Optional.of("G21"), Optional.of("cubicMetre"), Optional.of("2.365882 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("curie", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "curie"), "curie", "curie"), Optional.of("Ci"), Optional.of("CUR"), Optional.of("becquerel"), Optional.of("3.7 \u00d7 10\u00b9\u2070 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("curiePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "curiePerKilogram"), "curiePerKilogram", "curie per kilogram"), Optional.of("Ci/kg"), Optional.of("A42"), Optional.of("becquerelPerKilogram"), Optional.of("3.7 \u00d7 10\u00b9\u2070 Bq/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE, QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE))));
        UNITS_BY_NAME.put("cycle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "cycle"), "cycle", "cycle"), Optional.empty(), Optional.of("B7"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("day", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "day"), "day", "day"), Optional.of("d"), Optional.of("DAY"), Optional.of("secondUnitOfTime"), Optional.of("86400 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("deadweightTonnage", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "deadweightTonnage"), "deadweightTonnage", "deadweight tonnage"), Optional.of("dwt"), Optional.of("A43"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("decade", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decade"), "decade", "decade"), Optional.empty(), Optional.of("DEC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("decadeLogarithmic", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decadeLogarithmic"), "decadeLogarithmic", "decade (logarithmic)"), Optional.of("dec"), Optional.of("P41"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LOGARITHMIC_DECREMENT))));
        UNITS_BY_NAME.put("decagram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decagram"), "decagram", "decagram"), Optional.of("dag"), Optional.of("DJ"), Optional.of("kilogram"), Optional.of("10\u207b\u00b2 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("decalitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decalitre"), "decalitre", "decalitre"), Optional.of("dal"), Optional.of("A44"), Optional.of("cubicMetre"), Optional.of("10\u207b\u00b2 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("decametre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decametre"), "decametre", "decametre"), Optional.of("dam"), Optional.of("A45"), Optional.of("metre"), Optional.of("10 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("decapascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decapascal"), "decapascal", "decapascal"), Optional.of("daPa"), Optional.of("H75"), Optional.of("pascal"), Optional.of("10\u00b9 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("decare", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decare"), "decare", "decare"), Optional.of("daa"), Optional.of("DAA"), Optional.of("squareMetre"), Optional.of("10\u00b3 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("decibel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decibel"), "decibel", "decibel"), Optional.of("dB"), Optional.of("2N"), Optional.of("neper"), Optional.of("0.1151293 Np"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LEVEL_OF_A_FIELD_QUANTITY, QuantityKinds.LEVEL_OF_A_POWER_QUANTITY, QuantityKinds.SOUND_REDUCTION_INDEX, QuantityKinds.SOUND_PRESSURE_LEVEL, QuantityKinds.SOUND_POWER_LEVEL, QuantityKinds.LOGARITHMIC_DECREMENT, QuantityKinds.LEVEL_OF_A_POWER_QUANTITY, QuantityKinds.LEVEL_OF_A_FIELD_QUANTITY))));
        UNITS_BY_NAME.put("decibelPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decibelPerKilometre"), "decibelPerKilometre", "decibel per kilometre"), Optional.of("dB/km"), Optional.of("H51"), Optional.of("belPerMetre"), Optional.of("10\u207b\u2074 B/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_PRESSURE_LEVEL, QuantityKinds.SOUND_POWER_LEVEL, QuantityKinds.SOUND_POWER_LEVEL, QuantityKinds.SOUND_PRESSURE_LEVEL))));
        UNITS_BY_NAME.put("decibelPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decibelPerMetre"), "decibelPerMetre", "decibel per metre"), Optional.of("dB/m"), Optional.of("H52"), Optional.of("belPerMetre"), Optional.of("10\u207b\u00b9 B/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_PRESSURE_LEVEL, QuantityKinds.SOUND_POWER_LEVEL, QuantityKinds.SOUND_POWER_LEVEL, QuantityKinds.SOUND_PRESSURE_LEVEL))));
        UNITS_BY_NAME.put("decigram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decigram"), "decigram", "decigram"), Optional.of("dg"), Optional.of("DG"), Optional.of("kilogram"), Optional.of("10\u207b\u2074 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("decilitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decilitre"), "decilitre", "decilitre"), Optional.of("dl"), Optional.of("DLT"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("decilitrePerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decilitrePerGram"), "decilitrePerGram", "decilitre per gram"), Optional.of("dl/g"), Optional.of("22"), Optional.of("cubicMetrePerKilogram"), Optional.of("10\u207b\u00b9 \u00d7 m\u00b3/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.SPECIFIC_VOLUME))));
        UNITS_BY_NAME.put("decimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decimetre"), "decimetre", "decimetre"), Optional.of("dm"), Optional.of("DMT"), Optional.of("metre"), Optional.of("10\u207b\u00b9 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.HEIGHT, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH_OF_PATH))));
        UNITS_BY_NAME.put("decinewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decinewtonMetre"), "decinewtonMetre", "decinewton metre"), Optional.of("dN\u00b7m"), Optional.of("DN"), Optional.of("newtonMetre"), Optional.of("10\u207b\u00b9 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE))));
        UNITS_BY_NAME.put("decitex", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decitex"), "decitex", "decitex"), Optional.of("dtex (g/10km)"), Optional.of("A47"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("decitonne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "decitonne"), "decitonne", "decitonne"), Optional.of("dt or dtn"), Optional.of("DTN"), Optional.of("kilogram"), Optional.of("10\u00b2 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("degreeApi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeApi"), "degreeApi", "degree API"), Optional.of("\u00b0API"), Optional.of("J13"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeBalling", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeBalling"), "degreeBalling", "degree Balling"), Optional.of("\u00b0Balling"), Optional.of("J17"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeBaumeOriginScale", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeBaumeOriginScale"), "degreeBaumeOriginScale", "degree Baume (origin scale)"), Optional.of("\u00b0B\u00e9"), Optional.of("J14"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeBaumeUsHeavy", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeBaumeUsHeavy"), "degreeBaumeUsHeavy", "degree Baume (US heavy)"), Optional.of("\u00b0B\u00e9 (US heavy)"), Optional.of("J15"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeBaumeUsLight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeBaumeUsLight"), "degreeBaumeUsLight", "degree Baume (US light)"), Optional.of("\u00b0B\u00e9 (US light)"), Optional.of("J16"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeBrix", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeBrix"), "degreeBrix", "degree Brix"), Optional.of("\u00b0Bx"), Optional.of("J18"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsius"), "degreeCelsius", "degree Celsius"), Optional.of("\u00b0C"), Optional.of("CEL"), Optional.of("kelvin"), Optional.of("1 \u00d7 K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE, QuantityKinds.NEEL_TEMPERATURE, QuantityKinds.THERMODYNAMIC, QuantityKinds.SUPER_CONDUCTOR_TRANSITION_TEMPERATURE, QuantityKinds.DEBYE_TEMPERATURE, QuantityKinds.FERMI_TEMPERATURE, QuantityKinds.CURIE_TEMPERATURE))));
    }

    private static void init3() {
        UNITS_BY_NAME.put("degreeCelsiusPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsiusPerBar"), "degreeCelsiusPerBar", "degree Celsius per bar"), Optional.of("\u00b0C/bar"), Optional.of("F60"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeCelsiusPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsiusPerHour"), "degreeCelsiusPerHour", "degree Celsius per hour"), Optional.of("\u00b0C/h"), Optional.of("H12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeCelsiusPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsiusPerKelvin"), "degreeCelsiusPerKelvin", "degree Celsius per kelvin"), Optional.of("\u00b0C/K"), Optional.of("E98"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeCelsiusPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsiusPerMinute"), "degreeCelsiusPerMinute", "degree Celsius per minute"), Optional.of("\u00b0C/min"), Optional.of("H13"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeCelsiusPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeCelsiusPerSecond"), "degreeCelsiusPerSecond", "degree Celsius per second"), Optional.of("\u00b0C/s"), Optional.of("H14"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeDay"), "degreeDay", "degree day"), Optional.of("deg da"), Optional.of("E10"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheit"), "degreeFahrenheit", "degree Fahrenheit"), Optional.of("\u00b0F"), Optional.of("FAH"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FAHRENHEIT_TEMPERATURE))));
        UNITS_BY_NAME.put("degreeFahrenheitHourPerBritishThermalUnitInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourPerBritishThermalUnitInternationalTable"), "degreeFahrenheitHourPerBritishThermalUnitInternationalTable", "degree Fahrenheit hour per British thermal unit (international table)"), Optional.of("\u00b0F/(BtuIT/h)"), Optional.of("N84"), Optional.of("kelvinPerWatt"), Optional.of("1.895634 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeFahrenheitHourPerBritishThermalUnitThermochemical", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourPerBritishThermalUnitThermochemical"), "degreeFahrenheitHourPerBritishThermalUnitThermochemical", "degree Fahrenheit hour per British thermal unit (thermochemical)"), Optional.of("\u00b0F/(Btuth/h)"), Optional.of("N85"), Optional.of("kelvinPerWatt"), Optional.of("1.896903 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTable"), "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTable", "degree Fahrenheit hour square foot per British thermal unit (international table)"), Optional.of("\u00b0F\u00b7h\u00b7ft\u00b2/BtuIT"), Optional.of("J22"), Optional.of("squareMetreKelvinPerWatt"), Optional.of("0.1761102 m\u00b2 \u00d7 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION, QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION))));
        UNITS_BY_NAME.put("degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTableInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTableInch"), "degreeFahrenheitHourSquareFootPerBritishThermalUnitInternationalTableInch", "degree Fahrenheit hour square foot per British thermal unit (international table) inch"), Optional.of("\u00b0F\u00b7h\u00b7ft\u00b2/(BtuIT\u00b7in)"), Optional.of("N88"), Optional.of("kelvinMetrePerWatt"), Optional.of("6.933472 K \u00d7 m/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemical", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemical"), "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemical", "degree Fahrenheit hour square foot per British thermal unit (thermochemical)"), Optional.of("\u00b0F\u00b7h\u00b7ft\u00b2/Btuth"), Optional.of("J19"), Optional.of("squareMetreKelvinPerWatt"), Optional.of("0.176228 m\u00b2 \u00d7 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION, QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION))));
        UNITS_BY_NAME.put("degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemicalInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemicalInch"), "degreeFahrenheitHourSquareFootPerBritishThermalUnitThermochemicalInch", "degree Fahrenheit hour square foot per British thermal unit (thermochemical) inch"), Optional.of("\u00b0F\u00b7h\u00b7ft\u00b2/(Btuth\u00b7in)"), Optional.of("N89"), Optional.of("kelvinMetrePerWatt"), Optional.of("6.938112 K \u00d7 m/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeFahrenheitPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitPerBar"), "degreeFahrenheitPerBar", "degree Fahrenheit per bar"), Optional.of("\u00b0F/bar"), Optional.of("J21"), Optional.of("kelvinPerPascal"), Optional.of("0.5555556 \u00d7 10\u207b\u2075 K/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE, QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeFahrenheitPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitPerHour"), "degreeFahrenheitPerHour", "degree Fahrenheit per hour"), Optional.of("\u00b0F/h"), Optional.of("J23"), Optional.of("kelvinPerSecond"), Optional.of("1.543210 \u00d7 10\u207b\u2074 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME, QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeFahrenheitPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitPerKelvin"), "degreeFahrenheitPerKelvin", "degree Fahrenheit per kelvin"), Optional.of("\u00b0F/K"), Optional.of("J20"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeFahrenheitPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitPerMinute"), "degreeFahrenheitPerMinute", "degree Fahrenheit per minute"), Optional.of("\u00b0F/min"), Optional.of("J24"), Optional.of("kelvinPerSecond"), Optional.of("9.259259 \u00d7 10\u207b\u00b3 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME, QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeFahrenheitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitPerSecond"), "degreeFahrenheitPerSecond", "degree Fahrenheit per second"), Optional.of("\u00b0F/s"), Optional.of("J25"), Optional.of("kelvinPerSecond"), Optional.of("0.5555556 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE, QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME))));
        UNITS_BY_NAME.put("degreeFahrenheitSecondPerBritishThermalUnitInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitSecondPerBritishThermalUnitInternationalTable"), "degreeFahrenheitSecondPerBritishThermalUnitInternationalTable", "degree Fahrenheit second per British thermal unit (international table)"), Optional.of("\u00b0F/(BtuIT/s)"), Optional.of("N86"), Optional.of("kelvinPerWatt"), Optional.of("5.265651 \u00d7 10\u207b\u2074 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeFahrenheitSecondPerBritishThermalUnitThermochemical", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeFahrenheitSecondPerBritishThermalUnitThermochemical"), "degreeFahrenheitSecondPerBritishThermalUnitThermochemical", "degree Fahrenheit second per British thermal unit (thermochemical)"), Optional.of("\u00b0F/(Btuth/s)"), Optional.of("N87"), Optional.of("kelvinPerWatt"), Optional.of("5.269175 \u00d7 10\u207b\u2074 K/W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE, QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("degreeOechsle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeOechsle"), "degreeOechsle", "degree Oechsle"), Optional.of("\u00b0Oechsle"), Optional.of("J27"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreePerMetre"), "degreePerMetre", "degree per metre"), Optional.of("\u00b0/m"), Optional.of("H27"), Optional.of("radianPerMetre"), Optional.of("1.745329 \u00d7 10\u207b\u00b2 rad/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_WAVENUMBER, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.DEBYE_ANGULAR_REPETENCY, QuantityKinds.DEBYE_ANGULAR_WAVE_NUMBER, QuantityKinds.SOLID_ANGLE))));
        UNITS_BY_NAME.put("degreePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreePerSecond"), "degreePerSecond", "degree per second"), Optional.of("\u00b0/s"), Optional.of("E96"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOLID_ANGLE))));
        UNITS_BY_NAME.put("degreePlato", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreePlato"), "degreePlato", "degree Plato"), Optional.of("\u00b0P"), Optional.of("PLA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeRankine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeRankine"), "degreeRankine", "degree Rankine"), Optional.of("\u00b0R"), Optional.of("A48"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeRankinePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeRankinePerHour"), "degreeRankinePerHour", "degree Rankine per hour"), Optional.of("\u00b0R/h"), Optional.of("J28"), Optional.of("kelvinPerSecond"), Optional.of("1.543210 \u00d7 10\u207b\u2074 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE, QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME))));
        UNITS_BY_NAME.put("degreeRankinePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeRankinePerMinute"), "degreeRankinePerMinute", "degree Rankine per minute"), Optional.of("\u00b0R/min"), Optional.of("J29"), Optional.of("kelvinPerSecond"), Optional.of("9.259259 \u00d7 10\u207b\u00b3 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME, QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("degreeRankinePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeRankinePerSecond"), "degreeRankinePerSecond", "degree Rankine per second"), Optional.of("\u00b0R/s"), Optional.of("J30"), Optional.of("kelvinPerSecond"), Optional.of("0.5555556 K/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE, QuantityKinds.TEMPERATURE_VARIATION_OVER_TIME))));
        UNITS_BY_NAME.put("degreeTwaddell", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeTwaddell"), "degreeTwaddell", "degree Twaddell"), Optional.of("\u00b0Tw"), Optional.of("J31"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("degreeUnitOfAngle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeUnitOfAngle"), "degreeUnitOfAngle", "degree [unit of angle]"), Optional.of("\u00b0"), Optional.of("DD"), Optional.of("rad"), Optional.of("1.745329 \u00d7 10\u207b\u00b2 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE, QuantityKinds.ANGLE_PLANE, QuantityKinds.BRAGG_ANGLE))));
        UNITS_BY_NAME.put("degreeUnitOfAnglePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "degreeUnitOfAnglePerSecondSquared"), "degreeUnitOfAnglePerSecondSquared", "degree [unit of angle] per second squared"), Optional.of("\u00b0/s\u00b2"), Optional.of("M45"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_ACCELERATION))));
        UNITS_BY_NAME.put("denier", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "denier"), "denier", "denier"), Optional.of("den (g/9 km)"), Optional.of("A49"), Optional.of("kilogramPerMetre"), Optional.of("1.111111 \u00d7 10\u207b\u2077 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("digit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "digit"), "digit", "digit"), Optional.empty(), Optional.of("B19"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dioptre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dioptre"), "dioptre", "dioptre"), Optional.of("dpt"), Optional.of("Q25"), Optional.of("reciprocalMetre"), Optional.of("m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("displacementTonnage", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "displacementTonnage"), "displacementTonnage", "displacement tonnage"), Optional.empty(), Optional.of("DPT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dose", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dose"), "dose", "dose"), Optional.empty(), Optional.of("E27"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dotsPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dotsPerInch"), "dotsPerInch", "dots per inch"), Optional.of("dpi"), Optional.of("E39"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dozen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dozen"), "dozen", "dozen"), Optional.of("DOZ"), Optional.of("DZN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dozenPack", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dozenPack"), "dozenPack", "dozen pack"), Optional.empty(), Optional.of("DZP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dozenPair", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dozenPair"), "dozenPair", "dozen pair"), Optional.empty(), Optional.of("DPR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dozenPiece", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dozenPiece"), "dozenPiece", "dozen piece"), Optional.empty(), Optional.of("DPC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dozenRoll", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dozenRoll"), "dozenRoll", "dozen roll"), Optional.empty(), Optional.of("DRL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dramUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dramUk"), "dramUk", "dram (UK)"), Optional.empty(), Optional.of("DRI"), Optional.of("gram"), Optional.of("1.771745 g"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("dramUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dramUs"), "dramUs", "dram (US)"), Optional.empty(), Optional.of("DRA"), Optional.of("gram"), Optional.of("3.887935 g"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("dryBarrelUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryBarrelUs"), "dryBarrelUs", "dry barrel (US)"), Optional.of("bbl (US)"), Optional.of("BLD"), Optional.of("cubicMetre"), Optional.of("1.15627 \u00d7 10\u207b\u00b9 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("dryGallonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryGallonUs"), "dryGallonUs", "dry gallon (US)"), Optional.of("dry gal (US)"), Optional.of("GLD"), Optional.of("cubicMetre"), Optional.of("4.404884 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("dryPintUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryPintUs"), "dryPintUs", "dry pint (US)"), Optional.of("dry pt (US)"), Optional.of("PTD"), Optional.of("cubicMetre"), Optional.of("5.506105 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("dryPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryPound"), "dryPound", "dry pound"), Optional.empty(), Optional.of("DB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dryQuartUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryQuartUs"), "dryQuartUs", "dry quart (US)"), Optional.of("dry qt (US)"), Optional.of("QTD"), Optional.of("cubicMetre"), Optional.of("1.101221 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("dryTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dryTon"), "dryTon", "dry ton"), Optional.empty(), Optional.of("DT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("dyneMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "dyneMetre"), "dyneMetre", "dyne metre"), Optional.of("dyn\u00b7m"), Optional.of("M97"), Optional.of("newtonMetre"), Optional.of("10\u207b\u2075 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("each", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "each"), "each", "each"), Optional.empty(), Optional.of("EA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("eightPartCloudCover", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "eightPartCloudCover"), "eightPartCloudCover", "8-part cloud cover"), Optional.empty(), Optional.of("A59"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("electronicMailBox", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "electronicMailBox"), "electronicMailBox", "electronic mail box"), Optional.empty(), Optional.of("EB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("electronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "electronvolt"), "electronvolt", "electronvolt"), Optional.of("eV"), Optional.of("A53"), Optional.of("joule"), Optional.of("1.602176487 \u00d7 10\u207b\u00b9\u2079 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.MAXIMUM_BETA_PARTICLE_ENERGY, QuantityKinds.FERMI_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.RESONANCE_ENERGY, QuantityKinds.BETA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("electronvoltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "electronvoltPerMetre"), "electronvoltPerMetre", "electronvolt per metre"), Optional.of("eV/m"), Optional.of("A54"), Optional.of("joulePerMetre"), Optional.of("1.602176487 \u00d7 10\u207b\u00b9\u2079 J/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_LINEAR_STOPPING_POWER, QuantityKinds.LINEAR_ENERGY_TRANSFER, QuantityKinds.LINEAR_ENERGY_TRANSFER, QuantityKinds.TOTAL_LINEAR_STOPPING_POWER))));
        UNITS_BY_NAME.put("electronvoltSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "electronvoltSquareMetre"), "electronvoltSquareMetre", "electronvolt square metre"), Optional.of("eV\u00b7m\u00b2"), Optional.of("A55"), Optional.of("jouleSquareMetre"), Optional.of("1.602176487 \u00d7 10\u207b\u00b9\u2079 J \u00d7 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_ATOMIC_STOPPING_POWER, QuantityKinds.TOTAL_ATOMIC_STOPPING_POWER))));
        UNITS_BY_NAME.put("electronvoltSquareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "electronvoltSquareMetrePerKilogram"), "electronvoltSquareMetrePerKilogram", "electronvolt square metre per kilogram"), Optional.of("eV\u00b7m\u00b2/kg"), Optional.of("A56"), Optional.of("jouleSquareMetrePerKilogram"), Optional.of("1.602176487 \u00d7 10\u207b\u00b9\u2079 J \u00d7 m\u00b2/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_MASS_STOPPING_POWER, QuantityKinds.TOTAL_MASS_STOPPING_POWER))));
        UNITS_BY_NAME.put("equivalentGallon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "equivalentGallon"), "equivalentGallon", "equivalent gallon"), Optional.empty(), Optional.of("EQ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("erlang", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "erlang"), "erlang", "erlang"), Optional.of("E"), Optional.of("Q11"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("exabitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exabitPerSecond"), "exabitPerSecond", "exabit per second"), Optional.of("Ebit/s"), Optional.of("E58"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("exabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exabyte"), "exabyte", "Exabyte"), Optional.of("EB"), Optional.empty(), Optional.of("byte"), Optional.of("10\u00b9\u2078 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("exajoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exajoule"), "exajoule", "exajoule"), Optional.of("EJ"), Optional.of("A68"), Optional.of("joule"), Optional.of("10\u00b9\u2078 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.WORK, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY))));
        UNITS_BY_NAME.put("exbibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exbibitPerCubicMetre"), "exbibitPerCubicMetre", "exbibit per cubic metre"), Optional.of("Eibit/m\u00b3"), Optional.of("E67"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("exbibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exbibitPerMetre"), "exbibitPerMetre", "exbibit per metre"), Optional.of("Eibit/m"), Optional.of("E65"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("exbibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exbibitPerSquareMetre"), "exbibitPerSquareMetre", "exbibit per square metre"), Optional.of("Eibit/m\u00b2"), Optional.of("E66"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("exbibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "exbibyte"), "exbibyte", "exbibyte"), Optional.of("Eibyte"), Optional.of("E59"), Optional.of("byte"), Optional.of("2\u2076\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("failuresInTime", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "failuresInTime"), "failuresInTime", "failures in time"), Optional.of("FIT"), Optional.of("FIT"), Optional.of("reciprocalSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9\u00b3 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY))));
        UNITS_BY_NAME.put("farad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "farad"), "farad", "farad"), Optional.of("F"), Optional.of("FAR"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("faradPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "faradPerKilometre"), "faradPerKilometre", "farad per kilometre"), Optional.of("F/km"), Optional.of("H33"), Optional.of("faradPerMetre"), Optional.of("10\u207b\u00b3 F/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.PERMITTIVITY, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.ELECTRIC_CONSTANT))));
        UNITS_BY_NAME.put("faradPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "faradPerMetre"), "faradPerMetre", "farad per metre"), Optional.of("F/m"), Optional.of("A69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT))));
        UNITS_BY_NAME.put("fathom", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fathom"), "fathom", "fathom"), Optional.of("fth"), Optional.of("AK"), Optional.of("metre"), Optional.of("1.8288 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE))));
        UNITS_BY_NAME.put("femtojoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "femtojoule"), "femtojoule", "femtojoule"), Optional.of("fJ"), Optional.of("A70"), Optional.of("joule"), Optional.of("10\u207b\u00b9\u2075 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.GAP_ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("femtometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "femtometre"), "femtometre", "femtometre"), Optional.of("fm"), Optional.of("A71"), Optional.of("metre"), Optional.of("10\u207b\u00b9\u2075 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("fibreMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fibreMetre"), "fibreMetre", "fibre metre"), Optional.empty(), Optional.of("FBM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("fivePack", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fivePack"), "fivePack", "five pack"), Optional.empty(), Optional.of("P5"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("fixedRate", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fixedRate"), "fixedRate", "fixed rate"), Optional.empty(), Optional.of("1I"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("flakeTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "flakeTon"), "flakeTon", "flake ton"), Optional.empty(), Optional.of("FL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("fluidOunceUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fluidOunceUk"), "fluidOunceUk", "fluid ounce (UK)"), Optional.of("fl oz (UK)"), Optional.of("OZI"), Optional.of("cubicMetre"), Optional.of("2.841306 \u00d7 10\u207b\u2075 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("fluidOunceUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fluidOunceUs"), "fluidOunceUs", "fluid ounce (US)"), Optional.of("fl oz (US)"), Optional.of("OZA"), Optional.of("cubicMetre"), Optional.of("2.957353 \u00d7 10\u207b\u2075 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("foot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "foot"), "foot", "foot"), Optional.of("ft"), Optional.of("FOT"), Optional.of("metre"), Optional.of("0.3048 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DIAMETER, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS))));
        UNITS_BY_NAME.put("footOfWater392Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footOfWater392Degreesf"), "footOfWater392Degreesf", "foot of water (39.2 \u00b0F)"), Optional.of("ftH\u2082O (39,2 \u00b0F)"), Optional.of("N15"), Optional.of("pascal"), Optional.of("2.98898 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("footPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerDegreeFahrenheit"), "footPerDegreeFahrenheit", "foot per degree Fahrenheit"), Optional.of("ft/\u00b0F"), Optional.of("K13"), Optional.of("metrePerKelvin"), Optional.of("0.54864 m/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.BREADTH, QuantityKinds.RADIUS, QuantityKinds.DISTANCE, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("footPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerHour"), "footPerHour", "foot per hour"), Optional.of("ft/h"), Optional.of("K14"), Optional.of("metrePerSecond"), Optional.of("8.466667 \u00d7 10\u207b\u2075m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY))));
        UNITS_BY_NAME.put("footPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerMinute"), "footPerMinute", "foot per minute"), Optional.of("ft/min"), Optional.of("FR"), Optional.of("metrePerSecond"), Optional.of("5.08 \u00d7 10\u207b\u00b3 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY))));
        UNITS_BY_NAME.put("footPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerPsi"), "footPerPsi", "foot per psi"), Optional.of("ft/psi"), Optional.of("K17"), Optional.of("metrePerPascal"), Optional.of("4.420750 \u00d7 10\u207b\u2075 m/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS))));
        UNITS_BY_NAME.put("footPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerSecond"), "footPerSecond", "foot per second"), Optional.of("ft/s"), Optional.of("FS"), Optional.of("metrePerSecond"), Optional.of("0.3048 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES))));
        UNITS_BY_NAME.put("footPerSecondDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerSecondDegreeFahrenheit"), "footPerSecondDegreeFahrenheit", "foot per second degree Fahrenheit"), Optional.of("(ft/s)/\u00b0F"), Optional.of("K18"), Optional.of("metrePerSecondKelvin"), Optional.of("0.54864 (m/s)/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("footPerSecondPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerSecondPsi"), "footPerSecondPsi", "foot per second psi"), Optional.of("(ft/s)/psi"), Optional.of("K19"), Optional.of("metrePerSecondPascal"), Optional.of("4.420750 \u00d7 10\u207b\u2075 (m/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("footPerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerSecondSquared"), "footPerSecondSquared", "foot per second squared"), Optional.of("ft/s\u00b2"), Optional.of("A73"), Optional.of("metrePerSecondSquared"), Optional.of("0.3048 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("footPerThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPerThousand"), "footPerThousand", "foot per thousand"), Optional.empty(), Optional.of("E33"), Optional.of("metre"), Optional.of("3.048 \u00d7 10\u207b\u2074 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("footPoundForce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPoundForce"), "footPoundForce", "foot pound-force"), Optional.of("ft\u00b7lbf"), Optional.of("85"), Optional.of("joule"), Optional.of("1.355818 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("footPoundForcePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPoundForcePerHour"), "footPoundForcePerHour", "foot pound-force per hour"), Optional.of("ft\u00b7lbf/h"), Optional.of("K15"), Optional.of("watt"), Optional.of("3.766161 \u00d7 10\u207b\u2074 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER))));
        UNITS_BY_NAME.put("footPoundForcePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPoundForcePerMinute"), "footPoundForcePerMinute", "foot pound-force per minute"), Optional.of("ft\u00b7lbf/min"), Optional.of("K16"), Optional.of("watt"), Optional.of("2.259697 \u00d7 10\u207b\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER))));
        UNITS_BY_NAME.put("footPoundForcePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPoundForcePerSecond"), "footPoundForcePerSecond", "foot pound-force per second"), Optional.of("ft\u00b7lbf/s"), Optional.of("A74"), Optional.of("watt"), Optional.of("1.355818 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("footPoundal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footPoundal"), "footPoundal", "foot poundal"), Optional.of("ft\u00b7pdl"), Optional.of("N46"), Optional.of("joule"), Optional.of("4.214011 \u00d7 10\u207b\u00b2 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY))));
        UNITS_BY_NAME.put("footToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footToTheFourthPower"), "footToTheFourthPower", "foot to the fourth power"), Optional.of("ft\u2074"), Optional.of("N27"), Optional.of("metreToTheFourthPower"), Optional.of("8.630975 \u00d7 10\u207b\u00b3 m\u2074"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SECOND_POLAR_MOMENT_OF_AREA, QuantityKinds.SECOND_MOMENT_OF_AREA, QuantityKinds.SECOND_AXIAL_MOMENT_OF_AREA))));
        UNITS_BY_NAME.put("footUsSurvey", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footUsSurvey"), "footUsSurvey", "foot (U.S. survey)"), Optional.of("ft (US survey)"), Optional.of("M51"), Optional.of("metre"), Optional.of("3.048006 \u00d7 10\u207b\u00b9 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.RADIUS, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.DIAMETER, QuantityKinds.DISTANCE))));
        UNITS_BY_NAME.put("footcandle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footcandle"), "footcandle", "footcandle"), Optional.of("ftc"), Optional.of("P27"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ILLUMINANCE))));
        UNITS_BY_NAME.put("footlambert", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "footlambert"), "footlambert", "footlambert"), Optional.of("ftL"), Optional.of("P29"), Optional.of("candelaPerSquareMetre"), Optional.of("3.426259 cd/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE, QuantityKinds.LUMINANCE))));
    }

    private static void init4() {
        UNITS_BY_NAME.put("fortyFootContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "fortyFootContainer"), "fortyFootContainer", "forty foot container"), Optional.empty(), Optional.of("21"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("franklin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "franklin"), "franklin", "franklin"), Optional.of("Fr"), Optional.of("N94"), Optional.of("coulomb"), Optional.of("3.335641 \u00d7 10\u207b\u00b9\u2070 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE))));
        UNITS_BY_NAME.put("freightTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "freightTon"), "freightTon", "freight ton"), Optional.empty(), Optional.of("A75"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("frenchGauge", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "frenchGauge"), "frenchGauge", "French gauge"), Optional.of("Fg"), Optional.of("H79"), Optional.of("metre"), Optional.of("0.333333333 \u00d7 10\u207b\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DIAMETER, QuantityKinds.RADIUS, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH))));
        UNITS_BY_NAME.put("furlong", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "furlong"), "furlong", "furlong"), Optional.of("fur"), Optional.of("M50"), Optional.of("metre"), Optional.of("2.01168 \u00d7 10\u00b2 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.HEIGHT, QuantityKinds.DISTANCE, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.BREADTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("gal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gal"), "gal", "gal"), Optional.of("Gal"), Optional.of("A76"), Optional.of("metrePerSecondSquared"), Optional.of("10\u207b\u00b2 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("gallonUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUk"), "gallonUk", "gallon (UK)"), Optional.of("gal (UK)"), Optional.of("GLI"), Optional.of("cubicMetre"), Optional.of("4.546092 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("gallonUkPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUkPerDay"), "gallonUkPerDay", "gallon (UK) per day"), Optional.of("gal (UK)/d"), Optional.of("K26"), Optional.of("cubicMetrePerSecond"), Optional.of("5.261678 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gallonUkPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUkPerHour"), "gallonUkPerHour", "gallon (UK) per hour"), Optional.of("gal (UK)/h"), Optional.of("K27"), Optional.of("cubicMetrePerSecond"), Optional.of("1.262803 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gallonUkPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUkPerSecond"), "gallonUkPerSecond", "gallon (UK) per second"), Optional.of("gal (UK)/s"), Optional.of("K28"), Optional.of("cubicMetrePerSecond"), Optional.of("4.54609 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gallonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUs"), "gallonUs", "gallon (US)"), Optional.of("gal (US)"), Optional.of("GLL"), Optional.of("cubicMetre"), Optional.of("3.785412 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("gallonUsLiquidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUsLiquidPerSecond"), "gallonUsLiquidPerSecond", "gallon (US liquid) per second"), Optional.of("gal (US liq.)/s"), Optional.of("K30"), Optional.of("cubicMetrePerSecond"), Optional.of("3.785412 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gallonUsPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUsPerDay"), "gallonUsPerDay", "gallon (US) per day"), Optional.of("gal (US)/d"), Optional.of("GB"), Optional.of("cubicMetrePerSecond"), Optional.of("4.381264 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gallonUsPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gallonUsPerHour"), "gallonUsPerHour", "gallon (US) per hour"), Optional.of("gal/h"), Optional.of("G50"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gamma", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gamma"), "gamma", "gamma"), Optional.of("\u03b3"), Optional.of("P12"), Optional.of("tesla"), Optional.of("10\u207b\u2079 T"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("gibibit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gibibit"), "gibibit", "gibibit"), Optional.of("Gibit"), Optional.of("B30"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gibibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gibibitPerCubicMetre"), "gibibitPerCubicMetre", "gibibit per cubic metre"), Optional.of("Gibit/m\u00b3"), Optional.of("E71"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gibibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gibibitPerMetre"), "gibibitPerMetre", "gibibit per metre"), Optional.of("Gibit/m"), Optional.of("E69"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gibibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gibibitPerSquareMetre"), "gibibitPerSquareMetre", "gibibit per square metre"), Optional.of("Gibit/m\u00b2"), Optional.of("E70"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gibibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gibibyte"), "gibibyte", "Gibibyte"), Optional.of("GiB"), Optional.of("E62"), Optional.of("byte"), Optional.of("2\u00b3\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("gigaabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigaabyte"), "gigaabyte", "Gigabyte"), Optional.of("Gbyte"), Optional.of("E34"), Optional.of("byte"), Optional.of("10\u2079 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("gigabecquerel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigabecquerel"), "gigabecquerel", "gigabecquerel"), Optional.of("GBq"), Optional.of("GBQ"), Optional.of("becquerel"), Optional.of("10\u2079 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("gigabit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigabit"), "gigabit", "gigabit"), Optional.of("Gbit"), Optional.of("B68"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gigabitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigabitPerSecond"), "gigabitPerSecond", "gigabit per second"), Optional.of("Gbit/s"), Optional.of("B80"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gigabytePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigabytePerSecond"), "gigabytePerSecond", "gigabyte per second"), Optional.of("Gbyte/s"), Optional.of("E68"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gigacoulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigacoulombPerCubicMetre"), "gigacoulombPerCubicMetre", "gigacoulomb per cubic metre"), Optional.of("GC/m\u00b3"), Optional.of("A84"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u2079 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("gigaelectronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigaelectronvolt"), "gigaelectronvolt", "gigaelectronvolt"), Optional.of("GeV"), Optional.of("A85"), Optional.of("electronvolt"), Optional.of("10\u2079 eV"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WORK, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.MAXIMUM_BETA_PARTICLE_ENERGY, QuantityKinds.FERMI_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.RESONANCE_ENERGY, QuantityKinds.BETA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("gigahertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigahertz"), "gigahertz", "gigahertz"), Optional.of("GHz"), Optional.of("A86"), Optional.of("hertz"), Optional.of("10\u2079 Hz"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("gigahertzMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigahertzMetre"), "gigahertzMetre", "gigahertz metre"), Optional.of("GHz\u00b7m"), Optional.of("M18"), Optional.of("hertzMetre"), Optional.of("10\u2079 Hz \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COEFFICIENT, QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("gigajoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigajoule"), "gigajoule", "gigajoule"), Optional.of("GJ"), Optional.of("GV"), Optional.of("joule"), Optional.of("10\u2079 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINETIC_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.WORK, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("gigaohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigaohm"), "gigaohm", "gigaohm"), Optional.of("G\u2126"), Optional.of("A87"), Optional.of("ohm"), Optional.of("10\u2079 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("gigaohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigaohmMetre"), "gigaohmMetre", "gigaohm metre"), Optional.of("G\u2126\u00b7m"), Optional.of("A88"), Optional.of("ohmMetre"), Optional.of("10\u2079 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("gigaohmPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigaohmPerMetre"), "gigaohmPerMetre", "gigaohm per metre"), Optional.of("G\u2126/m"), Optional.of("M26"), Optional.of("ohmPerMetre"), Optional.of("10\u2079 \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.RESISTANCE_LOAD_PER_UNIT_LENGTH))));
        UNITS_BY_NAME.put("gigapascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigapascal"), "gigapascal", "gigapascal"), Optional.of("GPa"), Optional.of("A89"), Optional.of("pascal"), Optional.of("10\u2079 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("gigawatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigawatt"), "gigawatt", "gigawatt"), Optional.of("GW"), Optional.of("A90"), Optional.of("watt"), Optional.of("10\u2079 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("gigawattHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gigawattHour"), "gigawattHour", "gigawatt hour"), Optional.of("GW\u00b7h"), Optional.of("GWH"), Optional.of("joule"), Optional.of("3.6 \u00d7 10\u00b9\u00b2 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY))));
        UNITS_BY_NAME.put("gilbert", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gilbert"), "gilbert", "gilbert"), Optional.of("Gi"), Optional.of("N97"), Optional.of("ampere"), Optional.of("7.957747 \u00d7 10\u207b\u00b9 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT))));
        UNITS_BY_NAME.put("gillUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUk"), "gillUk", "gill (UK)"), Optional.of("gi (UK)"), Optional.of("GII"), Optional.of("cubicMetre"), Optional.of("1.420653 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("gillUkPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUkPerDay"), "gillUkPerDay", "gill (UK) per day"), Optional.of("gi (UK)/d"), Optional.of("K32"), Optional.of("cubicMetrePerSecond"), Optional.of("1.644274 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUkPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUkPerHour"), "gillUkPerHour", "gill (UK) per hour"), Optional.of("gi (UK)/h"), Optional.of("K33"), Optional.of("cubicMetrePerSecond"), Optional.of("3.946258 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUkPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUkPerMinute"), "gillUkPerMinute", "gill (UK) per minute"), Optional.of("gi (UK)/min"), Optional.of("K34"), Optional.of("cubicMetrePerSecond"), Optional.of("0.02367755 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUkPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUkPerSecond"), "gillUkPerSecond", "gill (UK) per second"), Optional.of("gi (UK)/s"), Optional.of("K35"), Optional.of("cubicMetrePerSecond"), Optional.of("1.420653 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUs"), "gillUs", "gill (US)"), Optional.of("gi (US)"), Optional.of("GIA"), Optional.of("cubicMetre"), Optional.of("1.182941 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("gillUsPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUsPerDay"), "gillUsPerDay", "gill (US) per day"), Optional.of("gi (US)/d"), Optional.of("K36"), Optional.of("cubicMetrePerSecond"), Optional.of("1.369145 \u00d7 10\u207b\u2079 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUsPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUsPerHour"), "gillUsPerHour", "gill (US) per hour"), Optional.of("gi (US)/h"), Optional.of("K37"), Optional.of("cubicMetrePerSecond"), Optional.of("3.285947 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUsPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUsPerMinute"), "gillUsPerMinute", "gill (US) per minute"), Optional.of("gi (US)/min"), Optional.of("K38"), Optional.of("cubicMetrePerSecond"), Optional.of("1.971568 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gillUsPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gillUsPerSecond"), "gillUsPerSecond", "gill (US) per second"), Optional.of("gi (US)/s"), Optional.of("K39"), Optional.of("cubicMetrePerSecond"), Optional.of("1.182941 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("gon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gon"), "gon", "gon"), Optional.of("gon"), Optional.of("A91"), Optional.of("rad"), Optional.of("1.570796 \u00d7 10\u207b\u00b2 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE, QuantityKinds.ANGLE_PLANE))));
        UNITS_BY_NAME.put("grain", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grain"), "grain", "grain"), Optional.of("gr"), Optional.of("GRN"), Optional.of("kilogram"), Optional.of("64.79891 \u00d7 10\u207b\u2076 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("grainPerGallonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grainPerGallonUs"), "grainPerGallonUs", "grain per gallon (US)"), Optional.of("gr/gal (US)"), Optional.of("K41"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.711806 \u00d7 10\u207b\u00b2 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("gram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gram"), "gram", "gram"), Optional.of("g"), Optional.of("GRM"), Optional.of("kilogram"), Optional.of("10\u207b\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("gramCentimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramCentimetrePerSecond"), "gramCentimetrePerSecond", "gram centimetre per second"), Optional.of("g\u00b7(cm/s)"), Optional.of("M99"), Optional.of("kilogramMetrePerSecond"), Optional.of("10\u207b\u2075 kg \u00d7 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENTUM, QuantityKinds.MOMENTUM))));
        UNITS_BY_NAME.put("gramDryWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramDryWeight"), "gramDryWeight", "gram, dry weight"), Optional.empty(), Optional.of("GDW"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gramForcePerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramForcePerSquareCentimetre"), "gramForcePerSquareCentimetre", "gram-force per square centimetre"), Optional.of("gf/cm\u00b2"), Optional.of("K31"), Optional.of("pascal"), Optional.of("98.0665 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION))));
        UNITS_BY_NAME.put("gramIncludingContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramIncludingContainer"), "gramIncludingContainer", "gram, including container"), Optional.empty(), Optional.of("GIC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gramIncludingInnerPackaging", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramIncludingInnerPackaging"), "gramIncludingInnerPackaging", "gram, including inner packaging"), Optional.empty(), Optional.of("GIP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gramMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramMillimetre"), "gramMillimetre", "gram millimetre"), Optional.of("g\u00b7mm"), Optional.of("H84"), Optional.of("kilogramMetre"), Optional.of("10\u207b\u2076 kg \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("gramOfFissileIsotope", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramOfFissileIsotope"), "gramOfFissileIsotope", "gram of fissile isotope"), Optional.of("gi F/S"), Optional.of("GFI"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("gramPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerBar"), "gramPerBar", "gram per bar"), Optional.of("g/bar"), Optional.of("F74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCentimetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCentimetreSecond"), "gramPerCentimetreSecond", "gram per centimetre second"), Optional.of("g/(cm\u00b7s)"), Optional.of("N41"), Optional.of("pascalSecond"), Optional.of("0.1 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("gramPerCubicCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicCentimetre"), "gramPerCubicCentimetre", "gram per cubic centimetre"), Optional.of("g/cm\u00b3"), Optional.of("23"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicCentimetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicCentimetreBar"), "gramPerCubicCentimetreBar", "gram per cubic centimetre bar"), Optional.of("g/(cm\u00b3\u00b7bar)"), Optional.of("G11"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicCentimetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicCentimetreKelvin"), "gramPerCubicCentimetreKelvin", "gram per cubic centimetre kelvin"), Optional.of("g/(cm\u00b3\u00b7K)"), Optional.of("G33"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicDecimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicDecimetre"), "gramPerCubicDecimetre", "gram per cubic decimetre"), Optional.of("g/dm\u00b3"), Optional.of("F23"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicDecimetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicDecimetreBar"), "gramPerCubicDecimetreBar", "gram per cubic decimetre bar"), Optional.of("g/(dm\u00b3\u00b7bar)"), Optional.of("G12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicDecimetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicDecimetreKelvin"), "gramPerCubicDecimetreKelvin", "gram per cubic decimetre kelvin"), Optional.of("g/(dm\u00b3\u00b7K)"), Optional.of("G34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicMetre"), "gramPerCubicMetre", "gram per cubic metre"), Optional.of("g/m\u00b3"), Optional.of("A93"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u207b\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("gramPerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicMetreBar"), "gramPerCubicMetreBar", "gram per cubic metre bar"), Optional.of("g/(m\u00b3\u00b7bar)"), Optional.of("G14"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerCubicMetreKelvin"), "gramPerCubicMetreKelvin", "gram per cubic metre kelvin"), Optional.of("g/(m\u00b3\u00b7K)"), Optional.of("G36"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerDay"), "gramPerDay", "gram per day"), Optional.of("g/d"), Optional.of("F26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerDayBar"), "gramPerDayBar", "gram per day bar"), Optional.of("g/(d\u00b7bar)"), Optional.of("F62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerDayKelvin"), "gramPerDayKelvin", "gram per day kelvin"), Optional.of("g/(d\u00b7K)"), Optional.of("F35"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerHertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerHertz"), "gramPerHertz", "gram per hertz"), Optional.of("g/Hz"), Optional.of("F25"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerHour"), "gramPerHour", "gram per hour"), Optional.of("g/h"), Optional.of("F27"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerHourBar"), "gramPerHourBar", "gram per hour bar"), Optional.of("g/(h\u00b7bar)"), Optional.of("F63"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerHourKelvin"), "gramPerHourKelvin", "gram per hour kelvin"), Optional.of("g/(h\u00b7K)"), Optional.of("F36"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerKelvin"), "gramPerKelvin", "gram per kelvin"), Optional.of("g/K"), Optional.of("F14"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerLitre"), "gramPerLitre", "gram per litre"), Optional.of("g/l"), Optional.of("GL"), Optional.of("kilogramPerCubicMetre"), Optional.of("kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("gramPerLitreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerLitreBar"), "gramPerLitreBar", "gram per litre bar"), Optional.of("g/(l\u00b7bar)"), Optional.of("G13"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerLitreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerLitreKelvin"), "gramPerLitreKelvin", "gram per litre kelvin"), Optional.of("g/(l\u00b7K)"), Optional.of("G35"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerMetreGramPer100Centimetres", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMetreGramPer100Centimetres"), "gramPerMetreGramPer100Centimetres", "gram per metre (gram per 100 centimetres)"), Optional.of("g/m"), Optional.of("GF"), Optional.of("kilogramPerMetre"), Optional.of("10\u207b\u00b3 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS))));
        UNITS_BY_NAME.put("gramPerMillilitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMillilitre"), "gramPerMillilitre", "gram per millilitre"), Optional.of("g/ml"), Optional.of("GJ"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("gramPerMillilitreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMillilitreBar"), "gramPerMillilitreBar", "gram per millilitre bar"), Optional.of("g/(ml\u00b7bar)"), Optional.of("G15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerMillilitreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMillilitreKelvin"), "gramPerMillilitreKelvin", "gram per millilitre kelvin"), Optional.of("g/(ml\u00b7K)"), Optional.of("G37"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("gramPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMillimetre"), "gramPerMillimetre", "gram per millimetre"), Optional.of("g/mm"), Optional.of("H76"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("gramPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMinute"), "gramPerMinute", "gram per minute"), Optional.of("g/min"), Optional.of("F28"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMinuteBar"), "gramPerMinuteBar", "gram per minute bar"), Optional.of("g/(min\u00b7bar)"), Optional.of("F64"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMinuteKelvin"), "gramPerMinuteKelvin", "gram per minute kelvin"), Optional.of("g/(min\u00b7K)"), Optional.of("F37"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerMole"), "gramPerMole", "gram per mole"), Optional.of("g/mol"), Optional.of("A94"), Optional.of("kilogramPerMole"), Optional.of("10\u207b\u00b3 kg/mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_MASS, QuantityKinds.MOLAR_MASS))));
        UNITS_BY_NAME.put("gramPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSecond"), "gramPerSecond", "gram per second"), Optional.of("g/s"), Optional.of("F29"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSecondBar"), "gramPerSecondBar", "gram per second bar"), Optional.of("g/(s\u00b7bar)"), Optional.of("F65"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSecondKelvin"), "gramPerSecondKelvin", "gram per second kelvin"), Optional.of("g/(s\u00b7K)"), Optional.of("F38"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("gramPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSquareCentimetre"), "gramPerSquareCentimetre", "gram per square centimetre"), Optional.of("g/cm\u00b2"), Optional.of("25"), Optional.of("kilogramPerSquareMetre"), Optional.of("10 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("gramPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSquareMetre"), "gramPerSquareMetre", "gram per square metre"), Optional.of("g/m\u00b2"), Optional.of("GM"), Optional.of("kilogramPerSquareMetre"), Optional.of("10\u207b\u00b3 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("gramPerSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gramPerSquareMillimetre"), "gramPerSquareMillimetre", "gram per square millimetre"), Optional.of("g/mm\u00b2"), Optional.of("N24"), Optional.of("kilogramPerSquareMetre"), Optional.of("10\u00b3 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("gray", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gray"), "gray", "gray"), Optional.of("Gy"), Optional.of("A95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ENERGY_IMPARTED, QuantityKinds.MASSIC_ENERGY_IMPARTED))));
        UNITS_BY_NAME.put("grayPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grayPerHour"), "grayPerHour", "gray per hour"), Optional.of("Gy/h"), Optional.of("P61"), Optional.of("grayPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("grayPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grayPerMinute"), "grayPerMinute", "gray per minute"), Optional.of("Gy/min"), Optional.of("P57"), Optional.of("grayPerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u00b2 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("grayPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grayPerSecond"), "grayPerSecond", "gray per second"), Optional.of("Gy/s"), Optional.of("A96"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("greatGross", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "greatGross"), "greatGross", "great gross"), Optional.empty(), Optional.of("GGR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
    }

    private static void init5() {
        UNITS_BY_NAME.put("gross", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "gross"), "gross", "gross"), Optional.of("gr"), Optional.of("GRO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("grossKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "grossKilogram"), "grossKilogram", "gross kilogram"), Optional.empty(), Optional.of("E4"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("group", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "group"), "group", "group"), Optional.empty(), Optional.of("10"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("guntersChain", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "guntersChain"), "guntersChain", "Gunter's chain"), Optional.of("ch (UK)"), Optional.of("X1"), Optional.of("metre"), Optional.of("20.1168 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.RADIUS, QuantityKinds.DISTANCE, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH))));
        UNITS_BY_NAME.put("halfYear6Months", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "halfYear6Months"), "halfYear6Months", "half year (6 months)"), Optional.empty(), Optional.of("SAN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hangingContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hangingContainer"), "hangingContainer", "hanging container"), Optional.empty(), Optional.of("Z11"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hank", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hank"), "hank", "hank"), Optional.empty(), Optional.of("HA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hartley", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hartley"), "hartley", "hartley"), Optional.of("Hart"), Optional.of("Q15"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hartleyPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hartleyPerSecond"), "hartleyPerSecond", "hartley per second"), Optional.of("Hart/s"), Optional.of("Q18"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("head", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "head"), "head", "head"), Optional.empty(), Optional.of("HEA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hectobar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectobar"), "hectobar", "hectobar"), Optional.of("hbar"), Optional.of("HBA"), Optional.of("pascal"), Optional.of("10\u2077 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("hectogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectogram"), "hectogram", "hectogram"), Optional.of("hg"), Optional.of("HGM"), Optional.of("kilogram"), Optional.of("10\u207b\u00b9 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("hectolitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectolitre"), "hectolitre", "hectolitre"), Optional.of("hl"), Optional.of("HLT"), Optional.of("cubicMetre"), Optional.of("10\u207b\u00b9 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("hectolitreOfPureAlcohol", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectolitreOfPureAlcohol"), "hectolitreOfPureAlcohol", "hectolitre of pure alcohol"), Optional.empty(), Optional.of("HPA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hectometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectometre"), "hectometre", "hectometre"), Optional.of("hm"), Optional.of("HMT"), Optional.of("metre"), Optional.of("10\u00b2 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("hectopascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascal"), "hectopascal", "hectopascal"), Optional.of("hPa"), Optional.of("A97"), Optional.of("pascal"), Optional.of("10\u00b2 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("hectopascalCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascalCubicMetrePerSecond"), "hectopascalCubicMetrePerSecond", "hectopascal cubic metre per second"), Optional.of("hPa\u00b7m\u00b3/s"), Optional.of("F94"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("hectopascalLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascalLitrePerSecond"), "hectopascalLitrePerSecond", "hectopascal litre per second"), Optional.of("hPa\u00b7l/s"), Optional.of("F93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY))));
        UNITS_BY_NAME.put("hectopascalPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascalPerBar"), "hectopascalPerBar", "hectopascal per bar"), Optional.of("hPa/bar"), Optional.of("E99"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("hectopascalPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascalPerKelvin"), "hectopascalPerKelvin", "hectopascal per kelvin"), Optional.of("hPa/K"), Optional.of("F82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("hectopascalPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hectopascalPerMetre"), "hectopascalPerMetre", "hectopascal per metre"), Optional.of("hPa/m"), Optional.of("P82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("hefnerKerze", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hefnerKerze"), "hefnerKerze", "Hefner-Kerze"), Optional.of("HK"), Optional.of("P35"), Optional.of("candela"), Optional.of("0.903 cd"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_INTENSITY, QuantityKinds.LUMINOUS_INTENSITY))));
        UNITS_BY_NAME.put("henry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "henry"), "henry", "henry"), Optional.of("H"), Optional.of("81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("henryPerKiloohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "henryPerKiloohm"), "henryPerKiloohm", "henry per kiloohm"), Optional.of("H/k\u2126"), Optional.of("H03"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u00b3 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("henryPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "henryPerMetre"), "henryPerMetre", "henry per metre"), Optional.of("H/m"), Optional.of("A98"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMEABILITY_OF_VACUUM, QuantityKinds.PERMEABILITY, QuantityKinds.MAGNETIC_CONSTANT))));
        UNITS_BY_NAME.put("henryPerOhm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "henryPerOhm"), "henryPerOhm", "henry per ohm"), Optional.of("H/\u2126"), Optional.of("H04"), Optional.of("secondUnitOfTime"), Optional.of("s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE))));
        UNITS_BY_NAME.put("hertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hertz"), "hertz", "hertz"), Optional.of("Hz"), Optional.of("HTZ"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("hertzMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hertzMetre"), "hertzMetre", "hertz metre"), Optional.of("Hz\u00b7m"), Optional.of("H34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("horsepowerBoiler", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "horsepowerBoiler"), "horsepowerBoiler", "horsepower (boiler)"), Optional.of("boiler hp"), Optional.of("K42"), Optional.of("watt"), Optional.of("9.80950 \u00d7 10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("horsepowerElectric", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "horsepowerElectric"), "horsepowerElectric", "horsepower (electric)"), Optional.of("electric hp"), Optional.of("K43"), Optional.of("watt"), Optional.of("746 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("hour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hour"), "hour", "hour"), Optional.of("h"), Optional.of("HUR"), Optional.of("secondUnitOfTime"), Optional.of("3600 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("hundred", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundred"), "hundred", "hundred"), Optional.empty(), Optional.of("CEN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredBoardFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredBoardFoot"), "hundredBoardFoot", "hundred board foot"), Optional.empty(), Optional.of("BP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredBoxes", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredBoxes"), "hundredBoxes", "hundred boxes"), Optional.empty(), Optional.of("HBX"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredCount", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredCount"), "hundredCount", "hundred count"), Optional.empty(), Optional.of("HC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredCubicFoot"), "hundredCubicFoot", "hundred cubic foot"), Optional.empty(), Optional.of("HH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredCubicMetre"), "hundredCubicMetre", "hundred cubic metre"), Optional.empty(), Optional.of("FF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredInternationalUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredInternationalUnit"), "hundredInternationalUnit", "hundred international unit"), Optional.empty(), Optional.of("HIU"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredKilogramDryWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredKilogramDryWeight"), "hundredKilogramDryWeight", "hundred kilogram, dry weight"), Optional.empty(), Optional.of("HDW"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredKilogramNetMass", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredKilogramNetMass"), "hundredKilogramNetMass", "hundred kilogram, net mass"), Optional.empty(), Optional.of("HKM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredLeave", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredLeave"), "hundredLeave", "hundred leave"), Optional.empty(), Optional.of("CLF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredMetre"), "hundredMetre", "hundred metre"), Optional.empty(), Optional.of("JPS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredPack", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredPack"), "hundredPack", "hundred pack"), Optional.empty(), Optional.of("CNP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("hundredPoundCwtOrHundredWeightUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredPoundCwtOrHundredWeightUs"), "hundredPoundCwtOrHundredWeightUs", "hundred pound (cwt) / hundred weight (US)"), Optional.of("cwt (US)"), Optional.of("CWA"), Optional.of("kilogram"), Optional.of("45.3592 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("hundredWeightUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hundredWeightUk"), "hundredWeightUk", "hundred weight (UK)"), Optional.of("cwt (UK)"), Optional.of("CWI"), Optional.of("kilogram"), Optional.of("50.80235 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("hydraulicHorsePower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "hydraulicHorsePower"), "hydraulicHorsePower", "hydraulic horse power"), Optional.empty(), Optional.of("5J"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("imperialGallonPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "imperialGallonPerMinute"), "imperialGallonPerMinute", "Imperial gallon per minute"), Optional.of("gal (UK) /min"), Optional.of("G3"), Optional.of("cubicMetrePerSecond"), Optional.of("7.57682 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("inch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inch"), "inch", "inch"), Optional.of("in"), Optional.of("INH"), Optional.of("metre"), Optional.of("25.4 \u00d7 10\u207b\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.BREADTH, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE))));
        UNITS_BY_NAME.put("inchOfMercury", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfMercury"), "inchOfMercury", "inch of mercury"), Optional.of("inHg"), Optional.of("F79"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE))));
        UNITS_BY_NAME.put("inchOfMercury32Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfMercury32Degreesf"), "inchOfMercury32Degreesf", "inch of mercury (32 \u00b0F)"), Optional.of("inHG (32 \u00b0F)"), Optional.of("N16"), Optional.of("pascal"), Optional.of("3.38638 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("inchOfMercury60Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfMercury60Degreesf"), "inchOfMercury60Degreesf", "inch of mercury (60 \u00b0F)"), Optional.of("inHg (60 \u00b0F)"), Optional.of("N17"), Optional.of("pascal"), Optional.of("3.37685 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("inchOfWater", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfWater"), "inchOfWater", "inch of water"), Optional.of("inH\u2082O"), Optional.of("F78"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_MODULUS))));
        UNITS_BY_NAME.put("inchOfWater392Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfWater392Degreesf"), "inchOfWater392Degreesf", "inch of water (39.2 \u00b0F)"), Optional.of("inH\u2082O (39,2 \u00b0F)"), Optional.of("N18"), Optional.of("pascal"), Optional.of("2.49082 \u00d7 10\u00b2 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("inchOfWater60Degreesf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchOfWater60Degreesf"), "inchOfWater60Degreesf", "inch of water (60 \u00b0F)"), Optional.of("inH\u2082O (60 \u00b0F)"), Optional.of("N19"), Optional.of("pascal"), Optional.of("2.4884 \u00d7 10\u00b2 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE))));
        UNITS_BY_NAME.put("inchPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerDegreeFahrenheit"), "inchPerDegreeFahrenheit", "inch per degree Fahrenheit"), Optional.of("in/\u00b0F"), Optional.of("K45"), Optional.of("metrePerKelvin"), Optional.of("4.572 \u00d7 10\u207b\u00b2 m/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BREADTH, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.LENGTH, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT))));
        UNITS_BY_NAME.put("inchPerLinearFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerLinearFoot"), "inchPerLinearFoot", "inch per linear foot"), Optional.empty(), Optional.of("B82"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("inchPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerMinute"), "inchPerMinute", "inch per minute"), Optional.of("in/min"), Optional.of("M63"), Optional.of("metrePerSecond"), Optional.of("4.233333 \u00d7 10\u207b\u2074 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY))));
        UNITS_BY_NAME.put("inchPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerPsi"), "inchPerPsi", "inch per psi"), Optional.of("in/psi"), Optional.of("K46"), Optional.of("metrePerPascal"), Optional.of("3.683959 \u00d7 10\u207b\u2076 m/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH_OF_PATH))));
        UNITS_BY_NAME.put("inchPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerSecond"), "inchPerSecond", "inch per second"), Optional.of("in/s"), Optional.of("IU"), Optional.of("metrePerSecond"), Optional.of("0.0254 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("inchPerSecondDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerSecondDegreeFahrenheit"), "inchPerSecondDegreeFahrenheit", "inch per second degree Fahrenheit"), Optional.of("(in/s)/\u00b0F"), Optional.of("K47"), Optional.of("metrePerSecondKelvin"), Optional.of("4.572 \u00d7 10\u207b\u00b2 (m/s)/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("inchPerSecondPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerSecondPsi"), "inchPerSecondPsi", "inch per second psi"), Optional.of("(in/s)/psi"), Optional.of("K48"), Optional.of("metrePerSecondPascal"), Optional.of("3.683959 \u00d7 10\u207b\u2076 (m/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("inchPerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerSecondSquared"), "inchPerSecondSquared", "inch per second squared"), Optional.of("in/s\u00b2"), Optional.of("IV"), Optional.of("metrePerSecondSquared"), Optional.of("0.0254 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("inchPerTwoPiRadiant", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerTwoPiRadiant"), "inchPerTwoPiRadiant", "inch per two pi radiant"), Optional.of("in/revolution"), Optional.of("H57"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOLID_ANGLE))));
        UNITS_BY_NAME.put("inchPerYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPerYear"), "inchPerYear", "inch per year"), Optional.of("in/y"), Optional.of("M61"), Optional.of("metrePerSecond"), Optional.of("8.048774 \u00d7 10\u207b\u00b9\u2070 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES))));
        UNITS_BY_NAME.put("inchPoundPoundInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPoundPoundInch"), "inchPoundPoundInch", "inch pound (pound inch)"), Optional.of("in\u00b7lb"), Optional.of("IA"), Optional.of("kilogramMetre"), Optional.of("1.15212 \u00d7 10\u207b\u00b2 kg \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("inchPoundal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchPoundal"), "inchPoundal", "inch poundal"), Optional.of("in\u00b7pdl"), Optional.of("N47"), Optional.of("joule"), Optional.of("3.511677 \u00d7 10\u207b\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("inchToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "inchToTheFourthPower"), "inchToTheFourthPower", "inch to the fourth power"), Optional.of("in\u2074"), Optional.of("D69"), Optional.of("metreToTheFourthPower"), Optional.of("41.62314 \u00d7 10\u207b\u2078 m\u2074"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SECOND_POLAR_MOMENT_OF_AREA, QuantityKinds.SECOND_MOMENT_OF_AREA, QuantityKinds.SECOND_AXIAL_MOMENT_OF_AREA))));
        UNITS_BY_NAME.put("internationalCandle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "internationalCandle"), "internationalCandle", "international candle"), Optional.of("IK"), Optional.of("P36"), Optional.of("candela"), Optional.of("1.019 cd"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_INTENSITY, QuantityKinds.LUMINOUS_INTENSITY))));
        UNITS_BY_NAME.put("internationalSugarDegree", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "internationalSugarDegree"), "internationalSugarDegree", "international sugar degree"), Optional.empty(), Optional.of("ISD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("job", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "job"), "job", "job"), Optional.empty(), Optional.of("E51"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("joule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joule"), "joule", "joule"), Optional.of("J"), Optional.of("JOU"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("joulePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerCubicMetre"), "joulePerCubicMetre", "joule per cubic metre"), Optional.of("J/m\u00b3"), Optional.of("B8"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_ENERGY, QuantityKinds.VOLUMIC, QuantityKinds.VOLUMIC_ELECTROMAGNETIC_ENERGY, QuantityKinds.SOUND_ENERGY_DENSITY, QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.ELECTROMAGNETIC_ENERGY_DENSITY))));
        UNITS_BY_NAME.put("joulePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerDay"), "joulePerDay", "joule per day"), Optional.of("J/d"), Optional.of("P17"), Optional.of("watt"), Optional.of("1.15741 \u00d7 10\u207b\u2075 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("joulePerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerGram"), "joulePerGram", "joule per gram"), Optional.of("J/g"), Optional.of("D95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASSIC_THERMODYNAMIC_ENERGY))));
        UNITS_BY_NAME.put("joulePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerHour"), "joulePerHour", "joule per hour"), Optional.of("J/h"), Optional.of("P16"), Optional.of("watt"), Optional.of("2.77778 \u00d7 10\u207b\u2074 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("joulePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerKelvin"), "joulePerKelvin", "joule per kelvin"), Optional.of("J/K"), Optional.of("JE"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY))));
        UNITS_BY_NAME.put("joulePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerKilogram"), "joulePerKilogram", "joule per kilogram"), Optional.of("J/kg"), Optional.of("J2"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ENERGY, QuantityKinds.MASSIC_ENERGY))));
        UNITS_BY_NAME.put("joulePerKilogramKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerKilogramKelvin"), "joulePerKilogramKelvin", "joule per kilogram kelvin"), Optional.of("J/(kg\u00b7K)"), Optional.of("B11"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("joulePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerMetre"), "joulePerMetre", "joule per metre"), Optional.of("J/m"), Optional.of("B12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_LINEAR_STOPPING_POWER, QuantityKinds.LINEAR_ENERGY_TRANSFER))));
        UNITS_BY_NAME.put("joulePerMetreToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerMetreToTheFourthPower"), "joulePerMetreToTheFourthPower", "joule per metre to the fourth power"), Optional.of("J/m\u2074"), Optional.of("B14"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_RADIANT_ENERGY_DENSITY_IN_TERMS_OF_WAVE_LENGTH, QuantityKinds.SPECTRAL_CONCENTRATION_OF_RADIANT_ENERGY_DENSITY_IN_TERMS_OF_WAVELENGTH))));
        UNITS_BY_NAME.put("joulePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerMinute"), "joulePerMinute", "joule per minute"), Optional.of("J/min"), Optional.of("P15"), Optional.of("watt"), Optional.of("1.66667 \u00d7 10\u207b\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("joulePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerMole"), "joulePerMole", "joule per mole"), Optional.of("J/mol"), Optional.of("B15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_THERMODYNAMIC_ENERGY, QuantityKinds.CHEMICAL_POTENTIAL, QuantityKinds.AFFINITY_OF_A_CHEMICAL_REACTION))));
        UNITS_BY_NAME.put("joulePerMoleKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerMoleKelvin"), "joulePerMoleKelvin", "joule per mole kelvin"), Optional.of("J/(mol\u00b7K)"), Optional.of("B16"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_HEAT_CAPACITY, QuantityKinds.MOLAR_GAS_CONSTANT, QuantityKinds.MOLAR_ENTROPY))));
        UNITS_BY_NAME.put("joulePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerSecond"), "joulePerSecond", "joule per second"), Optional.of("J/s"), Optional.of("P14"), Optional.of("watt"), Optional.of("W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("joulePerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerSquareCentimetre"), "joulePerSquareCentimetre", "joule per square centimetre"), Optional.of("J/cm\u00b2"), Optional.of("E43"), Optional.of("joulePerSquareMetre"), Optional.of("10\u2074 J/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.RADIANT_ENERGY_FLUENCE))));
        UNITS_BY_NAME.put("joulePerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerSquareMetre"), "joulePerSquareMetre", "joule per square metre"), Optional.of("J/m\u00b2"), Optional.of("B13"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE))));
        UNITS_BY_NAME.put("joulePerTesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "joulePerTesla"), "joulePerTesla", "joule per tesla"), Optional.of("J/T"), Optional.of("Q10"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("jouleSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "jouleSecond"), "jouleSecond", "joule second"), Optional.of("J\u00b7s"), Optional.of("B18"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_CONSTANT))));
        UNITS_BY_NAME.put("jouleSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "jouleSquareMetre"), "jouleSquareMetre", "joule square metre"), Optional.of("J\u00b7m\u00b2"), Optional.of("D73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_ATOMIC_STOPPING_POWER))));
        UNITS_BY_NAME.put("jouleSquareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "jouleSquareMetrePerKilogram"), "jouleSquareMetrePerKilogram", "joule square metre per kilogram"), Optional.of("J\u00b7m\u00b2/kg"), Optional.of("B20"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TOTAL_MASS_STOPPING_POWER))));
        UNITS_BY_NAME.put("katal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "katal"), "katal", "katal"), Optional.of("kat"), Optional.of("KAT"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CATALYTIC_ACTIVITY))));
        UNITS_BY_NAME.put("kelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvin"), "kelvin", "kelvin"), Optional.of("K"), Optional.of("KEL"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NEEL_TEMPERATURE, QuantityKinds.THERMODYNAMIC, QuantityKinds.SUPER_CONDUCTOR_TRANSITION_TEMPERATURE, QuantityKinds.DEBYE_TEMPERATURE, QuantityKinds.FERMI_TEMPERATURE, QuantityKinds.CURIE_TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinMetrePerWatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinMetrePerWatt"), "kelvinMetrePerWatt", "kelvin metre per watt"), Optional.of("K\u00b7m/W"), Optional.of("H35"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE))));
        UNITS_BY_NAME.put("kelvinPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerBar"), "kelvinPerBar", "kelvin per bar"), Optional.of("K/bar"), Optional.of("F61"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerHour"), "kelvinPerHour", "kelvin per hour"), Optional.of("K/h"), Optional.of("F10"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerKelvin"), "kelvinPerKelvin", "kelvin per kelvin"), Optional.of("K/K"), Optional.of("F02"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerMinute"), "kelvinPerMinute", "kelvin per minute"), Optional.of("K/min"), Optional.of("F11"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerPascal"), "kelvinPerPascal", "kelvin per pascal"), Optional.of("K/Pa"), Optional.of("N79"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerSecond"), "kelvinPerSecond", "kelvin per second"), Optional.of("K/s"), Optional.of("F12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("kelvinPerWatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kelvinPerWatt"), "kelvinPerWatt", "kelvin per watt"), Optional.of("K/W"), Optional.of("B21"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_RESISTANCE))));
    }

    private static void init6() {
        UNITS_BY_NAME.put("kibibit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kibibit"), "kibibit", "kibibit"), Optional.of("Kibit"), Optional.of("C21"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kibibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kibibitPerCubicMetre"), "kibibitPerCubicMetre", "kibibit per cubic metre"), Optional.of("Kibit/m\u00b3"), Optional.of("E74"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kibibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kibibitPerMetre"), "kibibitPerMetre", "kibibit per metre"), Optional.of("Kibit/m"), Optional.of("E72"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kibibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kibibitPerSquareMetre"), "kibibitPerSquareMetre", "kibibit per square metre"), Optional.of("Kibit/m\u00b2"), Optional.of("E73"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kibibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kibibyte"), "kibibyte", "kibibyte"), Optional.of("Kibyte"), Optional.of("E64"), Optional.of("byte"), Optional.of("2\u00b9\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("kiloampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloampere"), "kiloampere", "kiloampere"), Optional.of("kA"), Optional.of("B22"), Optional.of("ampere"), Optional.of("10\u00b3 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE))));
        UNITS_BY_NAME.put("kiloampereHourThousandAmpereHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloampereHourThousandAmpereHour"), "kiloampereHourThousandAmpereHour", "kiloampere hour (thousand ampere hour)"), Optional.of("kA\u00b7h"), Optional.of("TAH"), Optional.of("coulomb"), Optional.of("3.6 \u00d7 10\u2076 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("kiloamperePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloamperePerMetre"), "kiloamperePerMetre", "kiloampere per metre"), Optional.of("kA/m"), Optional.of("B24"), Optional.of("amperePerMetre"), Optional.of("10\u00b3 A/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.MAGNETIZATION, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY, QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.LINEIC_ELECTRIC_CURRENT))));
        UNITS_BY_NAME.put("kiloamperePerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloamperePerSquareMetre"), "kiloamperePerSquareMetre", "kiloampere per square metre"), Optional.of("kA/m\u00b2"), Optional.of("B23"), Optional.of("amperePerSquareMetre"), Optional.of("10\u00b3 A/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY, QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("kilobar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobar"), "kilobar", "kilobar"), Optional.of("kbar"), Optional.of("KBA"), Optional.of("pascal"), Optional.of("10\u2078 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("kilobaud", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobaud"), "kilobaud", "kilobaud"), Optional.of("kBd"), Optional.of("K50"), Optional.of("baud"), Optional.of("10\u00b3 Bd"), Collections.emptySet()));
        UNITS_BY_NAME.put("kilobecquerel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobecquerel"), "kilobecquerel", "kilobecquerel"), Optional.of("kBq"), Optional.of("2Q"), Optional.of("becquerel"), Optional.of("10\u00b3 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("kilobecquerelPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobecquerelPerKilogram"), "kilobecquerelPerKilogram", "kilobecquerel per kilogram"), Optional.of("kBq/kg"), Optional.of("B25"), Optional.of("becquerelPerKilogram"), Optional.of("10\u00b3 Bq/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE, QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE))));
        UNITS_BY_NAME.put("kilobit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobit"), "kilobit", "kilobit"), Optional.of("kbit"), Optional.of("C37"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilobitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobitPerSecond"), "kilobitPerSecond", "kilobit per second"), Optional.of("kbit/s"), Optional.of("C74"), Optional.of("bitPerSecond"), Optional.of("10\u00b3 bit/s"), Collections.emptySet()));
        UNITS_BY_NAME.put("kilobyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobyte"), "kilobyte", "Kilobyte"), Optional.of("kbyte"), Optional.of("2P"), Optional.of("byte"), Optional.of("10\u00b3 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("kilobytePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilobytePerSecond"), "kilobytePerSecond", "kilobyte per second"), Optional.of("kbyte/s"), Optional.of("P94"), Optional.of("bytePerSecond"), Optional.of("10\u00b3 byte/s"), Collections.emptySet()));
        UNITS_BY_NAME.put("kilocalorieInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieInternationalTable"), "kilocalorieInternationalTable", "kilocalorie (international table)"), Optional.of("kcalIT"), Optional.of("E14"), Optional.of("joule"), Optional.of("4.1868 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HEAT, QuantityKinds.ENTHALPY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("kilocalorieInternationalTablePerGramKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieInternationalTablePerGramKelvin"), "kilocalorieInternationalTablePerGramKelvin", "kilocalorie (international table) per gram kelvin"), Optional.of("(kcalIT/K)/g"), Optional.of("N65"), Optional.of("joulePerKilogramKelvin"), Optional.of("4.1868 \u00d7 10\u2076 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("kilocalorieInternationalTablePerHourMetreDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieInternationalTablePerHourMetreDegreeCelsius"), "kilocalorieInternationalTablePerHourMetreDegreeCelsius", "kilocalorie (international table) per hour metre degree Celsius"), Optional.of("kcal/(m\u00b7h\u00b7\u00b0C)"), Optional.of("K52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("kilocalorieMean", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieMean"), "kilocalorieMean", "kilocalorie (mean)"), Optional.of("kcal"), Optional.of("K51"), Optional.of("joule"), Optional.of("4.19002 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HEAT, QuantityKinds.ENTHALPY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HELMHOLTZ_FREE_ENERGY))));
        UNITS_BY_NAME.put("kilocalorieThermochemical", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieThermochemical"), "kilocalorieThermochemical", "kilocalorie (thermochemical)"), Optional.of("kcalth"), Optional.of("K53"), Optional.of("joule"), Optional.of("4.184 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.HEAT))));
        UNITS_BY_NAME.put("kilocalorieThermochemicalPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieThermochemicalPerHour"), "kilocalorieThermochemicalPerHour", "kilocalorie (thermochemical) per hour"), Optional.of("kcalth/h"), Optional.of("E15"), Optional.of("watt"), Optional.of("1.16222 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilocalorieThermochemicalPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieThermochemicalPerMinute"), "kilocalorieThermochemicalPerMinute", "kilocalorie (thermochemical) per minute"), Optional.of("kcalth/min"), Optional.of("K54"), Optional.of("watt"), Optional.of("69.73333 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilocalorieThermochemicalPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocalorieThermochemicalPerSecond"), "kilocalorieThermochemicalPerSecond", "kilocalorie (thermochemical) per second"), Optional.of("kcalth/s"), Optional.of("K55"), Optional.of("watt"), Optional.of("4.184 \u00d7 10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilocandela", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocandela"), "kilocandela", "kilocandela"), Optional.of("kcd"), Optional.of("P33"), Optional.of("candela"), Optional.of("10\u00b3 cd"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_INTENSITY, QuantityKinds.LUMINOUS_INTENSITY))));
        UNITS_BY_NAME.put("kilocharacter", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocharacter"), "kilocharacter", "kilocharacter"), Optional.empty(), Optional.of("KB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilocoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocoulomb"), "kilocoulomb", "kilocoulomb"), Optional.of("kC"), Optional.of("B26"), Optional.of("coulomb"), Optional.of("10\u00b3 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("kilocoulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocoulombPerCubicMetre"), "kilocoulombPerCubicMetre", "kilocoulomb per cubic metre"), Optional.of("kC/m\u00b3"), Optional.of("B27"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u00b3 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("kilocoulombPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocoulombPerSquareMetre"), "kilocoulombPerSquareMetre", "kilocoulomb per square metre"), Optional.of("kC/m\u00b2"), Optional.of("B28"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u00b3 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("kilocurie", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilocurie"), "kilocurie", "kilocurie"), Optional.of("kCi"), Optional.of("2R"), Optional.of("becquerel"), Optional.of("3.7 \u00d7 10\u00b9\u00b3 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("kiloelectronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloelectronvolt"), "kiloelectronvolt", "kiloelectronvolt"), Optional.of("keV"), Optional.of("B29"), Optional.of("electronvolt"), Optional.of("10\u00b3 eV"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.MAXIMUM_BETA_PARTICLE_ENERGY, QuantityKinds.FERMI_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.RESONANCE_ENERGY, QuantityKinds.BETA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("kilofarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilofarad"), "kilofarad", "kilofarad"), Optional.of("kF"), Optional.of("N90"), Optional.of("farad"), Optional.of("10\u00b3 F"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE, QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("kilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogram"), "kilogram", "kilogram"), Optional.of("kg"), Optional.of("KGM"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("kilogramCentimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramCentimetrePerSecond"), "kilogramCentimetrePerSecond", "kilogram centimetre per second"), Optional.of("kg\u00b7(cm/s)"), Optional.of("M98"), Optional.of("kilogramMetrePerSecond"), Optional.of("10\u207b\u00b2 kg \u00d7 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENTUM, QuantityKinds.MOMENTUM))));
        UNITS_BY_NAME.put("kilogramDrainedNetWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramDrainedNetWeight"), "kilogramDrainedNetWeight", "kilogram drained net weight"), Optional.of("kg/net eda"), Optional.of("KDW"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramDryWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramDryWeight"), "kilogramDryWeight", "kilogram, dry weight"), Optional.empty(), Optional.of("MND"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramForceMetrePerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramForceMetrePerSquareCentimetre"), "kilogramForceMetrePerSquareCentimetre", "kilogram-force metre per square centimetre"), Optional.of("kgf\u00b7m/cm\u00b2"), Optional.of("E44"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramForcePerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramForcePerSquareCentimetre"), "kilogramForcePerSquareCentimetre", "kilogram-force per square centimetre"), Optional.of("kgf/cm\u00b2"), Optional.of("E42"), Optional.of("pascal"), Optional.of("9.80665 \u00d7 10\u2074 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("kilogramForcePerSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramForcePerSquareMillimetre"), "kilogramForcePerSquareMillimetre", "kilogram-force per square millimetre"), Optional.of("kgf/mm\u00b2"), Optional.of("E41"), Optional.of("pascal"), Optional.of("9.80665 \u00d7 10\u2076 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("kilogramIncludingContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramIncludingContainer"), "kilogramIncludingContainer", "kilogram, including container"), Optional.empty(), Optional.of("KIC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramIncludingInnerPackaging", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramIncludingInnerPackaging"), "kilogramIncludingInnerPackaging", "kilogram, including inner packaging"), Optional.empty(), Optional.of("KIP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramMetre"), "kilogramMetre", "kilogram metre"), Optional.of("kg\u00b7m"), Optional.of("M94"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("kilogramMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramMetrePerSecond"), "kilogramMetrePerSecond", "kilogram metre per second"), Optional.of("kg\u00b7m/s"), Optional.of("B31"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENTUM))));
        UNITS_BY_NAME.put("kilogramMetrePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramMetrePerSecondSquared"), "kilogramMetrePerSecondSquared", "kilogram metre per second squared"), Optional.of("kg\u00b7m/s\u00b2"), Optional.of("M77"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("kilogramMetreSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramMetreSquared"), "kilogramMetreSquared", "kilogram metre squared"), Optional.of("kg\u00b7m\u00b2"), Optional.of("B32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA))));
        UNITS_BY_NAME.put("kilogramMetreSquaredPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramMetreSquaredPerSecond"), "kilogramMetreSquaredPerSecond", "kilogram metre squared per second"), Optional.of("kg\u00b7m\u00b2/s"), Optional.of("B33"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_MOMENTUM, QuantityKinds.ANGULAR_MOMENTUM))));
        UNITS_BY_NAME.put("kilogramNamedSubstance", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramNamedSubstance"), "kilogramNamedSubstance", "kilogram named substance"), Optional.empty(), Optional.of("KNS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfCholineChloride", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfCholineChloride"), "kilogramOfCholineChloride", "kilogram of choline chloride"), Optional.of("kg C\u2085 H\u2081\u2084ClNO"), Optional.of("KCC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfHydrogenPeroxide", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfHydrogenPeroxide"), "kilogramOfHydrogenPeroxide", "kilogram of hydrogen peroxide"), Optional.of("kg H\u2082O\u2082"), Optional.of("KHY"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfImportedMeatLessOffal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfImportedMeatLessOffal"), "kilogramOfImportedMeatLessOffal", "kilogram of imported meat, less offal"), Optional.empty(), Optional.of("TMS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfMethylamine", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfMethylamine"), "kilogramOfMethylamine", "kilogram of methylamine"), Optional.of("kg met.am."), Optional.of("KMA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfNitrogen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfNitrogen"), "kilogramOfNitrogen", "kilogram of nitrogen"), Optional.of("kg N"), Optional.of("KNI"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfPhosphorusPentoxidePhosphoricAnhydride", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfPhosphorusPentoxidePhosphoricAnhydride"), "kilogramOfPhosphorusPentoxidePhosphoricAnhydride", "kilogram of phosphorus pentoxide (phosphoric anhydride)"), Optional.empty(), Optional.of("KPP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfPotassiumHydroxideCausticPotash", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfPotassiumHydroxideCausticPotash"), "kilogramOfPotassiumHydroxideCausticPotash", "kilogram of potassium hydroxide (caustic potash)"), Optional.of("kg KOH"), Optional.of("KPH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfPotassiumOxide", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfPotassiumOxide"), "kilogramOfPotassiumOxide", "kilogram of potassium oxide"), Optional.of("kg K\u2082O"), Optional.of("KPO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfSodiumHydroxideCausticSoda", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfSodiumHydroxideCausticSoda"), "kilogramOfSodiumHydroxideCausticSoda", "kilogram of sodium hydroxide (caustic soda)"), Optional.of("kg NaOH"), Optional.of("KSH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfSubstance90PercentDry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfSubstance90PercentDry"), "kilogramOfSubstance90PercentDry", "kilogram of substance 90 % dry"), Optional.of("kg 90 % sdt"), Optional.of("KSD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfTungstenTrioxide", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfTungstenTrioxide"), "kilogramOfTungstenTrioxide", "kilogram of tungsten trioxide"), Optional.of("kg WO\u2083"), Optional.of("KWO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramOfUranium", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramOfUranium"), "kilogramOfUranium", "kilogram of uranium"), Optional.of("kg U"), Optional.of("KUR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerBar"), "kilogramPerBar", "kilogram per bar"), Optional.of("kg/bar"), Optional.of("H53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicCentimetre"), "kilogramPerCubicCentimetre", "kilogram per cubic centimetre"), Optional.of("kg/cm\u00b3"), Optional.of("G31"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicCentimetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicCentimetreBar"), "kilogramPerCubicCentimetreBar", "kilogram per cubic centimetre bar"), Optional.of("kg/(cm\u00b3\u00b7bar)"), Optional.of("G16"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicCentimetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicCentimetreKelvin"), "kilogramPerCubicCentimetreKelvin", "kilogram per cubic centimetre kelvin"), Optional.of("kg/(cm\u00b3\u00b7K)"), Optional.of("G38"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicDecimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicDecimetre"), "kilogramPerCubicDecimetre", "kilogram per cubic decimetre"), Optional.of("kg/dm\u00b3"), Optional.of("B34"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("kilogramPerCubicDecimetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicDecimetreBar"), "kilogramPerCubicDecimetreBar", "kilogram per cubic decimetre bar"), Optional.of("(kg/dm\u00b3)/bar"), Optional.of("H55"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicDecimetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicDecimetreKelvin"), "kilogramPerCubicDecimetreKelvin", "kilogram per cubic decimetre kelvin"), Optional.of("(kg/dm\u00b3)/K"), Optional.of("H54"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicMetre"), "kilogramPerCubicMetre", "kilogram per cubic metre"), Optional.of("kg/m\u00b3"), Optional.of("KMQ"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("kilogramPerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicMetreBar"), "kilogramPerCubicMetreBar", "kilogram per cubic metre bar"), Optional.of("kg/(m\u00b3\u00b7bar)"), Optional.of("G18"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicMetreKelvin"), "kilogramPerCubicMetreKelvin", "kilogram per cubic metre kelvin"), Optional.of("kg/(m\u00b3\u00b7K)"), Optional.of("G40"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerCubicMetrePascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerCubicMetrePascal"), "kilogramPerCubicMetrePascal", "kilogram per cubic metre pascal"), Optional.of("(kg/m\u00b3)/Pa"), Optional.of("M73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerDay"), "kilogramPerDay", "kilogram per day"), Optional.of("kg/d"), Optional.of("F30"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerDayBar"), "kilogramPerDayBar", "kilogram per day bar"), Optional.of("kg/(d\u00b7bar)"), Optional.of("F66"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerDayKelvin"), "kilogramPerDayKelvin", "kilogram per day kelvin"), Optional.of("kg/(d\u00b7K)"), Optional.of("F39"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerHour"), "kilogramPerHour", "kilogram per hour"), Optional.of("kg/h"), Optional.of("E93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerHourBar"), "kilogramPerHourBar", "kilogram per hour bar"), Optional.of("kg/(h\u00b7bar)"), Optional.of("F67"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerHourKelvin"), "kilogramPerHourKelvin", "kilogram per hour kelvin"), Optional.of("kg/(h\u00b7K)"), Optional.of("F40"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerKelvin"), "kilogramPerKelvin", "kilogram per kelvin"), Optional.of("kg/K"), Optional.of("F15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerKilogram"), "kilogramPerKilogram", "kilogram per kilogram"), Optional.of("kg/kg"), Optional.of("M29"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_RATIO))));
        UNITS_BY_NAME.put("kilogramPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerKilometre"), "kilogramPerKilometre", "kilogram per kilometre"), Optional.of("kg/km"), Optional.of("M31"), Optional.of("kilogramPerMetre"), Optional.of("10\u207b\u00b3 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS))));
        UNITS_BY_NAME.put("kilogramPerKilomol", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerKilomol"), "kilogramPerKilomol", "kilogram per kilomol"), Optional.of("kg/kmol"), Optional.of("F24"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerLitre"), "kilogramPerLitre", "kilogram per litre"), Optional.of("kg/l or kg/L"), Optional.of("B35"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("kilogramPerLitreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerLitreBar"), "kilogramPerLitreBar", "kilogram per litre bar"), Optional.of("kg/(l\u00b7bar)"), Optional.of("G17"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerLitreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerLitreKelvin"), "kilogramPerLitreKelvin", "kilogram per litre kelvin"), Optional.of("kg/(l\u00b7K)"), Optional.of("G39"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMetre"), "kilogramPerMetre", "kilogram per metre"), Optional.of("kg/m"), Optional.of("KL"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("kilogramPerMetreDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMetreDay"), "kilogramPerMetreDay", "kilogram per metre day"), Optional.of("kg/(m\u00b7d)"), Optional.of("N39"), Optional.of("pascalSecond"), Optional.of("1.15741 \u00d7 10\u207b\u2075 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("kilogramPerMetreHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMetreHour"), "kilogramPerMetreHour", "kilogram per metre hour"), Optional.of("kg/(m\u00b7h)"), Optional.of("N40"), Optional.of("pascalSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("kilogramPerMetreMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMetreMinute"), "kilogramPerMetreMinute", "kilogram per metre minute"), Optional.of("kg/(m\u00b7min)"), Optional.of("N38"), Optional.of("pascalSecond"), Optional.of("1.66667 \u00d7 10\u207b\u00b2 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("kilogramPerMetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMetreSecond"), "kilogramPerMetreSecond", "kilogram per metre second"), Optional.of("kg/(m\u00b7s)"), Optional.of("N37"), Optional.of("pascalSecond"), Optional.of("Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("kilogramPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMillimetre"), "kilogramPerMillimetre", "kilogram per millimetre"), Optional.of("kg/mm"), Optional.of("KW"), Optional.of("kilogramPerMetre"), Optional.of("10\u00b3 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("kilogramPerMillimetreWidth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMillimetreWidth"), "kilogramPerMillimetreWidth", "kilogram per millimetre width"), Optional.empty(), Optional.of("KI"), Optional.of("kilogramPerMetre"), Optional.of("10\u00b3 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("kilogramPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMinute"), "kilogramPerMinute", "kilogram per minute"), Optional.of("kg/min"), Optional.of("F31"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMinuteBar"), "kilogramPerMinuteBar", "kilogram per minute bar"), Optional.of("kg/(min\u00b7bar)"), Optional.of("F68"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMinuteKelvin"), "kilogramPerMinuteKelvin", "kilogram per minute kelvin"), Optional.of("kg/(min\u00b7K)"), Optional.of("F41"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerMole"), "kilogramPerMole", "kilogram per mole"), Optional.of("kg/mol"), Optional.of("D74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_MASS))));
        UNITS_BY_NAME.put("kilogramPerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerPascal"), "kilogramPerPascal", "kilogram per pascal"), Optional.of("kg/Pa"), Optional.of("M74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSecond"), "kilogramPerSecond", "kilogram per second"), Optional.of("kg/s"), Optional.of("KGS"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSecondBar"), "kilogramPerSecondBar", "kilogram per second bar"), Optional.of("kg/(s\u00b7bar)"), Optional.of("F69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSecondKelvin"), "kilogramPerSecondKelvin", "kilogram per second kelvin"), Optional.of("kg/(s\u00b7K)"), Optional.of("F42"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramPerSecondPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSecondPascal"), "kilogramPerSecondPascal", "kilogram per second pascal"), Optional.of("(kg/s)/Pa"), Optional.of("M87"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
    }

    private static void init7() {
        UNITS_BY_NAME.put("kilogramPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSquareCentimetre"), "kilogramPerSquareCentimetre", "kilogram per square centimetre"), Optional.of("kg/cm\u00b2"), Optional.of("D5"), Optional.of("kilogramPerSquareMetre"), Optional.of("10\u2074 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("kilogramPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSquareMetre"), "kilogramPerSquareMetre", "kilogram per square metre"), Optional.of("kg/m\u00b2"), Optional.of("28"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("kilogramPerSquareMetrePascalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSquareMetrePascalSecond"), "kilogramPerSquareMetrePascalSecond", "kilogram per square metre pascal second"), Optional.of("kg/(m\u00b2\u00b7Pa\u00b7s)"), Optional.of("Q28"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilogramPerSquareMetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramPerSquareMetreSecond"), "kilogramPerSquareMetreSecond", "kilogram per square metre second"), Optional.of("kg/(m\u00b2\u00b7s)"), Optional.of("H56"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kilogramSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramSquareCentimetre"), "kilogramSquareCentimetre", "kilogram square centimetre"), Optional.of("kg\u00b7cm\u00b2"), Optional.of("F18"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilogramSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilogramSquareMillimetre"), "kilogramSquareMillimetre", "kilogram square millimetre"), Optional.of("kg\u00b7mm\u00b2"), Optional.of("F19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("kilohenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilohenry"), "kilohenry", "kilohenry"), Optional.of("kH"), Optional.of("P24"), Optional.of("henry"), Optional.of("10\u00b3 H"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("kilohertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilohertz"), "kilohertz", "kilohertz"), Optional.of("kHz"), Optional.of("KHZ"), Optional.of("hertz"), Optional.of("10\u00b3 Hz"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("kilohertzMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilohertzMetre"), "kilohertzMetre", "kilohertz metre"), Optional.of("kHz\u00b7m"), Optional.of("M17"), Optional.of("hertzMetre"), Optional.of("10\u00b3 Hz \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT, QuantityKinds.COEFFICIENT, QuantityKinds.PERFORMANCE_CHARACTERISTIC))));
        UNITS_BY_NAME.put("kilojoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoule"), "kilojoule", "kilojoule"), Optional.of("kJ"), Optional.of("KJO"), Optional.of("joule"), Optional.of("10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.WORK))));
        UNITS_BY_NAME.put("kilojoulePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerDay"), "kilojoulePerDay", "kilojoule per day"), Optional.of("kJ/d"), Optional.of("P21"), Optional.of("watt"), Optional.of("1.15741 \u00d7 10\u207b\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilojoulePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerHour"), "kilojoulePerHour", "kilojoule per hour"), Optional.of("kJ/h"), Optional.of("P20"), Optional.of("watt"), Optional.of("2.77778 \u00d7 10\u207b\u00b9 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilojoulePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerKelvin"), "kilojoulePerKelvin", "kilojoule per kelvin"), Optional.of("kJ/K"), Optional.of("B41"), Optional.of("joulePerKelvin"), Optional.of("10\u00b3 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY, QuantityKinds.HEAT_CAPACITY, QuantityKinds.ENTROPY))));
        UNITS_BY_NAME.put("kilojoulePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerKilogram"), "kilojoulePerKilogram", "kilojoule per kilogram"), Optional.of("kJ/kg"), Optional.of("B42"), Optional.of("joulePerKilogram"), Optional.of("10\u00b3 J/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ENTHALPY, QuantityKinds.MASSIC_ENTHALPY, QuantityKinds.SPECIFIC_ENERGY, QuantityKinds.MASSIC_ENERGY))));
        UNITS_BY_NAME.put("kilojoulePerKilogramKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerKilogramKelvin"), "kilojoulePerKilogramKelvin", "kilojoule per kilogram kelvin"), Optional.of("kJ/(kg\u00b7K)"), Optional.of("B43"), Optional.of("joulePerKilogramKelvin"), Optional.of("10\u00b3 J/(kg \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_SATURATION, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_VOLUME, QuantityKinds.SPECIFIC_HEAT_CAPACITY_AT_CONSTANT_PRESSURE))));
        UNITS_BY_NAME.put("kilojoulePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerMinute"), "kilojoulePerMinute", "kilojoule per minute"), Optional.of("kJ/min"), Optional.of("P19"), Optional.of("watt"), Optional.of("1.66667 \u00d7 10 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("kilojoulePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerMole"), "kilojoulePerMole", "kilojoule per mole"), Optional.of("kJ/mol"), Optional.of("B44"), Optional.of("joulePerMole"), Optional.of("10\u00b3 J/mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_THERMODYNAMIC_ENERGY, QuantityKinds.CHEMICAL_POTENTIAL, QuantityKinds.AFFINITY_OF_A_CHEMICAL_REACTION, QuantityKinds.MOLAR_THERMODYNAMIC_ENERGY))));
        UNITS_BY_NAME.put("kilojoulePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilojoulePerSecond"), "kilojoulePerSecond", "kilojoule per second"), Optional.of("kJ/s"), Optional.of("P18"), Optional.of("watt"), Optional.of("10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("kilolitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilolitre"), "kilolitre", "kilolitre"), Optional.of("kl"), Optional.of("K6"), Optional.of("cubicMetre"), Optional.of("m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("kilolitrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilolitrePerHour"), "kilolitrePerHour", "kilolitre per hour"), Optional.of("kl/h"), Optional.of("4X"), Optional.of("cubicMetrePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("kilolux", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilolux"), "kilolux", "kilolux"), Optional.of("klx"), Optional.of("KLX"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ILLUMINANCE))));
        UNITS_BY_NAME.put("kilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilometre"), "kilometre", "kilometre"), Optional.of("km"), Optional.of("KMT"), Optional.of("metre"), Optional.of("10\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.BREADTH, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("kilometrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilometrePerHour"), "kilometrePerHour", "kilometre per hour"), Optional.of("km/h"), Optional.of("KMH"), Optional.of("metrePerSecond"), Optional.of("0.277778 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("kilometrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilometrePerSecond"), "kilometrePerSecond", "kilometre per second"), Optional.of("km/s"), Optional.of("M62"), Optional.of("metrePerSecond"), Optional.of("10\u00b3 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY))));
        UNITS_BY_NAME.put("kilometrePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilometrePerSecondSquared"), "kilometrePerSecondSquared", "kilometre per second squared"), Optional.of("km/s\u00b2"), Optional.of("M38"), Optional.of("metrePerSecondSquared"), Optional.of("10\u00b3 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("kilomole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomole"), "kilomole", "kilomole"), Optional.of("kmol"), Optional.of("B45"), Optional.of("mole"), Optional.of("10\u00b3 mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("kilomolePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerCubicMetre"), "kilomolePerCubicMetre", "kilomole per cubic metre"), Optional.of("kmol/m\u00b3"), Optional.of("B46"), Optional.of("molePerCubicMetre"), Optional.of("10\u00b3 mol/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("kilomolePerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerCubicMetreBar"), "kilomolePerCubicMetreBar", "kilomole per cubic metre bar"), Optional.of("(kmol/m\u00b3)/bar"), Optional.of("K60"), Optional.of("molPerCubicMetrePascal"), Optional.of("10\u207b\u00b2 (mol/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("kilomolePerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerCubicMetreKelvin"), "kilomolePerCubicMetreKelvin", "kilomole per cubic metre kelvin"), Optional.of("(kmol/m\u00b3)/K"), Optional.of("K59"), Optional.of("molePerCubicMetreKelvin"), Optional.of("10\u00b3 (mol/m\u00b3)/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("kilomolePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerHour"), "kilomolePerHour", "kilomole per hour"), Optional.of("kmol/h"), Optional.of("K58"), Optional.of("molePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_FLUX, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("kilomolePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerKilogram"), "kilomolePerKilogram", "kilomole per kilogram"), Optional.of("kmol/kg"), Optional.of("P47"), Optional.of("molePerKilogram"), Optional.of("10\u00b3 mol/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLALITY_OF_SOLUTE_B, QuantityKinds.IONIC_STRENGTH))));
        UNITS_BY_NAME.put("kilomolePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerMinute"), "kilomolePerMinute", "kilomole per minute"), Optional.of("kmol/min"), Optional.of("K61"), Optional.of("molePerSecond"), Optional.of("16.6667 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_FLUX, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("kilomolePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilomolePerSecond"), "kilomolePerSecond", "kilomole per second"), Optional.of("kmol/s"), Optional.of("E94"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CATALYTIC_ACTIVITY))));
        UNITS_BY_NAME.put("kilonewton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilonewton"), "kilonewton", "kilonewton"), Optional.of("kN"), Optional.of("B47"), Optional.of("newton"), Optional.of("10\u00b3 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("kilonewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilonewtonMetre"), "kilonewtonMetre", "kilonewton metre"), Optional.of("kN\u00b7m"), Optional.of("B48"), Optional.of("newtonMetre"), Optional.of("10\u00b3 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("kilonewtonPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilonewtonPerMetre"), "kilonewtonPerMetre", "kilonewton per metre"), Optional.of("kN/m"), Optional.of("N31"), Optional.of("newtonPerMetre"), Optional.of("10\u00b3 N/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION, QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("kiloohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloohm"), "kiloohm", "kiloohm"), Optional.of("k\u2126"), Optional.of("B49"), Optional.of("ohm"), Optional.of("10\u00b3 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.REACTANCE, QuantityKinds.IMPEDANCE, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.MODULUS_OF_IMPEDANCE))));
        UNITS_BY_NAME.put("kiloohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloohmMetre"), "kiloohmMetre", "kiloohm metre"), Optional.of("k\u2126\u00b7m"), Optional.of("B50"), Optional.of("ohmMetre"), Optional.of("10\u00b3 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("kilopascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascal"), "kilopascal", "kilopascal"), Optional.of("kPa"), Optional.of("KPA"), Optional.of("pascal"), Optional.of("10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("kilopascalPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascalPerBar"), "kilopascalPerBar", "kilopascal per bar"), Optional.of("kPa/bar"), Optional.of("F03"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("kilopascalPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascalPerKelvin"), "kilopascalPerKelvin", "kilopascal per kelvin"), Optional.of("kPa/K"), Optional.of("F83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("kilopascalPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascalPerMetre"), "kilopascalPerMetre", "kilopascal per metre"), Optional.of("kPa/m"), Optional.of("P81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("kilopascalPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascalPerMillimetre"), "kilopascalPerMillimetre", "kilopascal per millimetre"), Optional.of("kPa/mm"), Optional.of("34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("kilopascalSquareMetrePerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopascalSquareMetrePerGram"), "kilopascalSquareMetrePerGram", "kilopascal square metre per gram"), Optional.of("kPa\u00b7m\u00b2/g"), Optional.of("33"), Optional.of("metrePerSecondSquared"), Optional.of("10\u2076 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BURST_INDEX, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("kilopoundForce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopoundForce"), "kilopoundForce", "kilopound-force"), Optional.of("kip"), Optional.of("M75"), Optional.of("newton"), Optional.of("4.448222 \u00d7 10\u00b3 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("kilopoundPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilopoundPerHour"), "kilopoundPerHour", "kilopound per hour"), Optional.of("klb/h"), Optional.of("M90"), Optional.of("kilogramPerSecond"), Optional.of("0.125997889 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("kiloroentgen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloroentgen"), "kiloroentgen", "kiloroentgen"), Optional.of("kR"), Optional.of("KR"), Optional.of("coulombPerKilogram"), Optional.of("2.58 \u00d7 10\u207b\u00b9 C/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE, QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("kilosecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilosecond"), "kilosecond", "kilosecond"), Optional.of("ks"), Optional.of("B52"), Optional.of("secondUnitOfTime"), Optional.of("10\u00b3 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("kilosegment", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilosegment"), "kilosegment", "kilosegment"), Optional.empty(), Optional.of("KJ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilosiemens", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilosiemens"), "kilosiemens", "kilosiemens"), Optional.of("kS"), Optional.of("B53"), Optional.of("siemens"), Optional.of("10\u00b3 S"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("kilosiemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilosiemensPerMetre"), "kilosiemensPerMetre", "kilosiemens per metre"), Optional.of("kS/m"), Optional.of("B54"), Optional.of("siemensPerMetre"), Optional.of("10\u00b3 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("kilotesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilotesla"), "kilotesla", "kilotesla"), Optional.of("kT"), Optional.of("P13"), Optional.of("tesla"), Optional.of("10\u00b3 T"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("kilotonne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilotonne"), "kilotonne", "kilotonne"), Optional.of("kt"), Optional.of("KTN"), Optional.of("kilogram"), Optional.of("10\u2076 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("kilovar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovar"), "kilovar", "kilovar"), Optional.of("kvar"), Optional.of("KVR"), Optional.of("voltAmpere"), Optional.of("10\u00b3 V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.APPARENT_POWER, QuantityKinds.REACTIVE_POWER))));
        UNITS_BY_NAME.put("kilovolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovolt"), "kilovolt", "kilovolt"), Optional.of("kV"), Optional.of("KVT"), Optional.of("volt"), Optional.of("10\u00b3 V"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.VOLTAGE, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.TENSION, QuantityKinds.ELECTROMOTIVE_FORCE))));
        UNITS_BY_NAME.put("kilovoltAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovoltAmpere"), "kilovoltAmpere", "kilovolt - ampere"), Optional.of("kV\u00b7A"), Optional.of("KVA"), Optional.of("voltAmpere"), Optional.of("10\u00b3 V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.APPARENT_POWER, QuantityKinds.APPARENT_POWER))));
        UNITS_BY_NAME.put("kilovoltAmpereHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovoltAmpereHour"), "kilovoltAmpereHour", "kilovolt ampere hour"), Optional.of("kVAh"), Optional.of("C79"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilovoltAmpereReactiveDemand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovoltAmpereReactiveDemand"), "kilovoltAmpereReactiveDemand", "kilovolt ampere reactive demand"), Optional.empty(), Optional.of("K2"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilovoltAmpereReactiveHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovoltAmpereReactiveHour"), "kilovoltAmpereReactiveHour", "kilovolt ampere reactive hour"), Optional.of("kvar\u00b7h"), Optional.of("K3"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilovoltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilovoltPerMetre"), "kilovoltPerMetre", "kilovolt per metre"), Optional.of("kV/m"), Optional.of("B55"), Optional.of("voltPerMetre"), Optional.of("10\u00b3 V/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("kilowatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowatt"), "kilowatt", "kilowatt"), Optional.of("kW"), Optional.of("KWT"), Optional.of("watt"), Optional.of("10\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE))));
        UNITS_BY_NAME.put("kilowattDemand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattDemand"), "kilowattDemand", "kilowatt demand"), Optional.empty(), Optional.of("K1"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilowattHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattHour"), "kilowattHour", "kilowatt hour"), Optional.of("kW\u00b7h"), Optional.of("KWH"), Optional.of("joule"), Optional.of("3.6 \u00d7 10\u2076 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("kilowattHourPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattHourPerCubicMetre"), "kilowattHourPerCubicMetre", "kilowatt hour per cubic metre"), Optional.of("kW\u00b7h/m\u00b3"), Optional.of("E46"), Optional.of("joulePerCubicMetre"), Optional.of("3.6 \u00d7 10\u2076 J/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_ENERGY, QuantityKinds.VOLUMIC, QuantityKinds.VOLUMIC_ELECTROMAGNETIC_ENERGY, QuantityKinds.SOUND_ENERGY_DENSITY, QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.ELECTROMAGNETIC_ENERGY_DENSITY))));
        UNITS_BY_NAME.put("kilowattHourPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattHourPerHour"), "kilowattHourPerHour", "kilowatt hour per hour"), Optional.of("kW\u00b7h/h"), Optional.of("D03"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("kilowattHourPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattHourPerKelvin"), "kilowattHourPerKelvin", "kilowatt hour per kelvin"), Optional.of("kW\u00b7h/K"), Optional.of("E47"), Optional.of("joulePerKelvin"), Optional.of("3.6 \u00d7 10\u2076 J/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PLANCK_FUNCTION, QuantityKinds.HEAT_CAPACITY, QuantityKinds.MASSIEU_FUNCTION, QuantityKinds.BOLTZMANN_CONSTANT, QuantityKinds.ENTROPY))));
        UNITS_BY_NAME.put("kilowattPerMetreDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattPerMetreDegreeCelsius"), "kilowattPerMetreDegreeCelsius", "kilowatt per metre degree Celsius"), Optional.of("kW/(m\u00b7\u00b0C)"), Optional.of("N82"), Optional.of("wattPerMetreKelvin"), Optional.of("10\u00b3 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("kilowattPerMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattPerMetreKelvin"), "kilowattPerMetreKelvin", "kilowatt per metre kelvin"), Optional.of("kW/(m\u00b7K)"), Optional.of("N81"), Optional.of("wattPerMetreKelvin"), Optional.of("10\u00b3 W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("kilowattPerSquareMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kilowattPerSquareMetreKelvin"), "kilowattPerSquareMetreKelvin", "kilowatt per square metre kelvin"), Optional.of("kW/(m\u00b2\u00b7K)"), Optional.of("N78"), Optional.of("wattPerSquareMetreKelvin"), Optional.of("10\u00b3 W/(m\u00b2 \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_COEFFICIENT_OF_HEAT_TRANSFER, QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("kiloweber", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloweber"), "kiloweber", "kiloweber"), Optional.of("kWb"), Optional.of("P11"), Optional.of("weber"), Optional.of("10\u00b3 Wb"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_QUANTUM, QuantityKinds.MAGNETIC_FLUX, QuantityKinds.MAGNETIC_FLUX))));
        UNITS_BY_NAME.put("kiloweberPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kiloweberPerMetre"), "kiloweberPerMetre", "kiloweber per metre"), Optional.of("kWb/m"), Optional.of("B56"), Optional.of("weberPerMetre"), Optional.of("10\u00b3 Wb/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_VECTOR_POTENTIAL, QuantityKinds.MAGNETIC_VECTOR_POTENTIAL))));
        UNITS_BY_NAME.put("kipPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kipPerSquareInch"), "kipPerSquareInch", "kip per square inch"), Optional.of("ksi"), Optional.of("N20"), Optional.of("pascal"), Optional.of("6.894757 \u00d7 10\u2076 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS))));
        UNITS_BY_NAME.put("kit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "kit"), "kit", "kit"), Optional.empty(), Optional.of("KT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("knot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "knot"), "knot", "knot"), Optional.of("kn"), Optional.of("KNT"), Optional.of("metrePerSecond"), Optional.of("0.514444 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY))));
        UNITS_BY_NAME.put("labourHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "labourHour"), "labourHour", "labour hour"), Optional.empty(), Optional.of("LH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lacticDryMaterialPercentage", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lacticDryMaterialPercentage"), "lacticDryMaterialPercentage", "lactic dry material percentage"), Optional.empty(), Optional.of("KLK"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lactoseExcessPercentage", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lactoseExcessPercentage"), "lactoseExcessPercentage", "lactose excess percentage"), Optional.empty(), Optional.of("LAC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lambert", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lambert"), "lambert", "lambert"), Optional.of("Lb"), Optional.of("P30"), Optional.of("candelaPerSquareMetre"), Optional.of("3.183099 \u00d7 10\u00b3 cd/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE, QuantityKinds.LUMINANCE))));
        UNITS_BY_NAME.put("langley", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "langley"), "langley", "langley"), Optional.of("Ly"), Optional.of("P40"), Optional.of("joulePerSquareMetre"), Optional.of("4.184 \u00d7 10\u2074 J/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANT_ENERGY_FLUENCE, QuantityKinds.RADIANCE_EXPOSURE, QuantityKinds.ENERGY_FLUENCE))));
        UNITS_BY_NAME.put("layer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "layer"), "layer", "layer"), Optional.empty(), Optional.of("LR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("leaf", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "leaf"), "leaf", "leaf"), Optional.empty(), Optional.of("LEF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lengthUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lengthUnit"), "lengthUnit", "length"), Optional.empty(), Optional.of("LN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lightYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lightYear"), "lightYear", "light year"), Optional.of("ly"), Optional.of("B57"), Optional.of("metre"), Optional.of("9.46073 \u00d7 10\u00b9\u2075 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("linearFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "linearFoot"), "linearFoot", "linear foot"), Optional.empty(), Optional.of("LF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("linearMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "linearMetre"), "linearMetre", "linear metre"), Optional.empty(), Optional.of("LM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("linearYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "linearYard"), "linearYard", "linear yard"), Optional.empty(), Optional.of("LY"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("link", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "link"), "link", "link"), Optional.empty(), Optional.of("LK"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("liquidPintUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "liquidPintUs"), "liquidPintUs", "liquid pint (US)"), Optional.of("liq pt (US)"), Optional.of("PTL"), Optional.of("cubicMetre"), Optional.of("4. 731765 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("liquidPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "liquidPound"), "liquidPound", "liquid pound"), Optional.empty(), Optional.of("LP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("liquidQuartUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "liquidQuartUs"), "liquidQuartUs", "liquid quart (US)"), Optional.of("liq qt (US)"), Optional.of("QTL"), Optional.of("cubicMetre"), Optional.of("9.463529 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("litre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litre"), "litre", "litre"), Optional.of("l"), Optional.of("LTR"), Optional.of("cubicMetre"), Optional.of("10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("litreOfPureAlcohol", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litreOfPureAlcohol"), "litreOfPureAlcohol", "litre of pure alcohol"), Optional.empty(), Optional.of("LPA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("litrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerBar"), "litrePerBar", "litre per bar"), Optional.of("l/bar"), Optional.of("G95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("litrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerDay"), "litrePerDay", "litre per day"), Optional.of("l/d"), Optional.of("LD"), Optional.of("cubicMetrePerSecond"), Optional.of("1.15741 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerDayBar"), "litrePerDayBar", "litre per day bar"), Optional.of("l/(d\u00b7bar)"), Optional.of("G82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerDayKelvin"), "litrePerDayKelvin", "litre per day kelvin"), Optional.of("l/(d\u00b7K)"), Optional.of("G65"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerHour"), "litrePerHour", "litre per hour"), Optional.of("l/h"), Optional.of("E32"), Optional.of("cubicMetrePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerHourBar"), "litrePerHourBar", "litre per hour bar"), Optional.of("l/(h\u00b7bar)"), Optional.of("G83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerHourKelvin"), "litrePerHourKelvin", "litre per hour kelvin"), Optional.of("l/(h\u00b7K)"), Optional.of("G66"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerKelvin"), "litrePerKelvin", "litre per kelvin"), Optional.of("l/K"), Optional.of("G28"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_PER_TEMPERATURE))));
    }

    private static void init8() {
        UNITS_BY_NAME.put("litrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerKilogram"), "litrePerKilogram", "litre per kilogram"), Optional.of("l/kg"), Optional.of("H83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("litrePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerLitre"), "litrePerLitre", "litre per litre"), Optional.of("l/l"), Optional.of("K62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("litrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerMinute"), "litrePerMinute", "litre per minute"), Optional.of("l/min"), Optional.of("L2"), Optional.of("cubicMetrePerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerMinuteBar"), "litrePerMinuteBar", "litre per minute bar"), Optional.of("l/(min\u00b7bar)"), Optional.of("G84"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerMinuteKelvin"), "litrePerMinuteKelvin", "litre per minute kelvin"), Optional.of("l/(min\u00b7K)"), Optional.of("G67"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerMole"), "litrePerMole", "litre per mole"), Optional.of("l/mol"), Optional.of("B58"), Optional.of("cubicMetrePerMole"), Optional.of("10\u207b\u00b3 m\u00b3/mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_VOLUME, QuantityKinds.MOLAR_VOLUME))));
        UNITS_BY_NAME.put("litrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerSecond"), "litrePerSecond", "litre per second"), Optional.of("l/s"), Optional.of("G51"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerSecondBar"), "litrePerSecondBar", "litre per second bar"), Optional.of("l/(s\u00b7bar)"), Optional.of("G85"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("litrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "litrePerSecondKelvin"), "litrePerSecondKelvin", "litre per second kelvin"), Optional.of("l/(s\u00b7K)"), Optional.of("G68"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("load", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "load"), "load", "load"), Optional.empty(), Optional.of("NL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lotUnitOfProcurement", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lotUnitOfProcurement"), "lotUnitOfProcurement", "lot  [unit of procurement]"), Optional.empty(), Optional.of("LO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lotUnitOfWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lotUnitOfWeight"), "lotUnitOfWeight", "lot  [unit of weight]"), Optional.empty(), Optional.of("D04"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lumen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumen"), "lumen", "lumen"), Optional.of("lm"), Optional.of("LUM"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_FLUX))));
        UNITS_BY_NAME.put("lumenHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumenHour"), "lumenHour", "lumen hour"), Optional.of("lm\u00b7h"), Optional.of("B59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_LIGHT))));
        UNITS_BY_NAME.put("lumenPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumenPerSquareFoot"), "lumenPerSquareFoot", "lumen per square foot"), Optional.of("lm/ft\u00b2"), Optional.of("P25"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ILLUMINANCE))));
        UNITS_BY_NAME.put("lumenPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumenPerSquareMetre"), "lumenPerSquareMetre", "lumen per square metre"), Optional.of("lm/m\u00b2"), Optional.of("B60"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_EXITANCE))));
        UNITS_BY_NAME.put("lumenPerWatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumenPerWatt"), "lumenPerWatt", "lumen per watt"), Optional.of("lm/W"), Optional.of("B61"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_LUMINOUS_EFFICACY, QuantityKinds.MAXIMUM_SPECTRAL_LUMINOUS_EFFICACY, QuantityKinds.LUMINOUS_EFFICACY_AT_A_SPECIFIED_WAVELENGTH, QuantityKinds.LUMINIOUS_EFFICACY))));
        UNITS_BY_NAME.put("lumenSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumenSecond"), "lumenSecond", "lumen second"), Optional.of("lm\u00b7s"), Optional.of("B62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_LIGHT))));
        UNITS_BY_NAME.put("lumpSum", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lumpSum"), "lumpSum", "lump sum"), Optional.empty(), Optional.of("LS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("lux", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "lux"), "lux", "lux"), Optional.of("lx"), Optional.of("LUX"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ILLUMINANCE))));
        UNITS_BY_NAME.put("luxHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "luxHour"), "luxHour", "lux hour"), Optional.of("lx\u00b7h"), Optional.of("B63"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LIGHT_EXPOSURE))));
        UNITS_BY_NAME.put("luxSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "luxSecond"), "luxSecond", "lux second"), Optional.of("lx\u00b7s"), Optional.of("B64"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LIGHT_EXPOSURE))));
        UNITS_BY_NAME.put("manmonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "manmonth"), "manmonth", "manmonth"), Optional.empty(), Optional.of("3C"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("meal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "meal"), "meal", "meal"), Optional.empty(), Optional.of("Q3"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mebibit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mebibit"), "mebibit", "mebibit"), Optional.of("Mibit"), Optional.of("D11"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mebibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mebibitPerCubicMetre"), "mebibitPerCubicMetre", "mebibit per cubic metre"), Optional.of("Mibit/m\u00b3"), Optional.of("E77"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mebibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mebibitPerMetre"), "mebibitPerMetre", "mebibit per metre"), Optional.of("Mibit/m"), Optional.of("E75"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mebibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mebibitPerSquareMetre"), "mebibitPerSquareMetre", "mebibit per square metre"), Optional.of("Mibit/m\u00b2"), Optional.of("E76"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mebibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mebibyte"), "mebibyte", "mebibyte"), Optional.of("Mibyte"), Optional.of("E63"), Optional.of("byte"), Optional.of("2\u00b2\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("megaampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaampere"), "megaampere", "megaampere"), Optional.of("MA"), Optional.of("H38"), Optional.of("ampere"), Optional.of("10\u2076 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.CURRENT_LINKAGE))));
        UNITS_BY_NAME.put("megaamperePerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaamperePerSquareMetre"), "megaamperePerSquareMetre", "megaampere per square metre"), Optional.of("MA/m\u00b2"), Optional.of("B66"), Optional.of("amperePerSquareMetre"), Optional.of("10\u2076 A/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY, QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("megabaud", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabaud"), "megabaud", "megabaud"), Optional.of("MBd"), Optional.of("J54"), Optional.of("baud"), Optional.of("10\u2076 Bd"), Collections.emptySet()));
        UNITS_BY_NAME.put("megabecquerel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabecquerel"), "megabecquerel", "megabecquerel"), Optional.of("MBq"), Optional.of("4N"), Optional.of("becquerel"), Optional.of("10\u2076 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("megabecquerelPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabecquerelPerKilogram"), "megabecquerelPerKilogram", "megabecquerel per kilogram"), Optional.of("MBq/kg"), Optional.of("B67"), Optional.of("becquerelPerKilogram"), Optional.of("10\u2076 Bq/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE, QuantityKinds.SPECIFIC_ACTIVITY_IN_A_SAMPLE))));
        UNITS_BY_NAME.put("megabit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabit"), "megabit", "megabit"), Optional.of("Mbit"), Optional.of("D36"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megabitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabitPerSecond"), "megabitPerSecond", "megabit per second"), Optional.of("Mbit/s"), Optional.of("E20"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabyte"), "megabyte", "Megabyte"), Optional.of("MB"), Optional.of("4L"), Optional.of("byte"), Optional.of("10\u2076 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("megabytePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megabytePerSecond"), "megabytePerSecond", "megabyte per second"), Optional.of("Mbyte/s"), Optional.of("P95"), Optional.of("bytePerSecond"), Optional.of("10\u2076 byte/s"), Collections.emptySet()));
        UNITS_BY_NAME.put("megacoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megacoulomb"), "megacoulomb", "megacoulomb"), Optional.of("MC"), Optional.of("D77"), Optional.of("coulomb"), Optional.of("10\u2076 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE))));
        UNITS_BY_NAME.put("megacoulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megacoulombPerCubicMetre"), "megacoulombPerCubicMetre", "megacoulomb per cubic metre"), Optional.of("MC/m\u00b3"), Optional.of("B69"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u2076 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("megacoulombPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megacoulombPerSquareMetre"), "megacoulombPerSquareMetre", "megacoulomb per square metre"), Optional.of("MC/m\u00b2"), Optional.of("B70"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u2076 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("megaelectronvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaelectronvolt"), "megaelectronvolt", "megaelectronvolt"), Optional.of("MeV"), Optional.of("B71"), Optional.of("electronvolt"), Optional.of("10\u2076 eV"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.MAXIMUM_BETA_PARTICLE_ENERGY, QuantityKinds.FERMI_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.RESONANCE_ENERGY, QuantityKinds.BETA_DISINTEGRATION_ENERGY, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("megagram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megagram"), "megagram", "megagram"), Optional.of("Mg"), Optional.of("2U"), Optional.of("kilogram"), Optional.of("10\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("megagramPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megagramPerCubicMetre"), "megagramPerCubicMetre", "megagram per cubic metre"), Optional.of("Mg/m\u00b3"), Optional.of("B72"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("megahertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megahertz"), "megahertz", "megahertz"), Optional.of("MHz"), Optional.of("MHZ"), Optional.of("hertz"), Optional.of("10\u2076 Hz"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("megahertzKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megahertzKilometre"), "megahertzKilometre", "megahertz kilometre"), Optional.of("MHz\u00b7km"), Optional.of("H39"), Optional.of("hertzMetre"), Optional.of("10\u2079 Hz \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COEFFICIENT, QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("megahertzMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megahertzMetre"), "megahertzMetre", "megahertz metre"), Optional.of("MHz\u00b7m"), Optional.of("M27"), Optional.of("hertzMetre"), Optional.of("10\u2076 Hz \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT, QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("megajoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megajoule"), "megajoule", "megajoule"), Optional.of("MJ"), Optional.of("3B"), Optional.of("joule"), Optional.of("10\u2076 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.WORK, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY))));
        UNITS_BY_NAME.put("megajoulePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megajoulePerCubicMetre"), "megajoulePerCubicMetre", "megajoule per cubic metre"), Optional.of("MJ/m\u00b3"), Optional.of("JM"), Optional.of("joulePerCubicMetre"), Optional.of("10\u2076 J/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.SOUND_ENERGY, QuantityKinds.VOLUMIC, QuantityKinds.VOLUMIC_ELECTROMAGNETIC_ENERGY, QuantityKinds.SOUND_ENERGY_DENSITY, QuantityKinds.RADIANT_ENERGY_DENSITY, QuantityKinds.ELECTROMAGNETIC_ENERGY_DENSITY))));
        UNITS_BY_NAME.put("megajoulePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megajoulePerKilogram"), "megajoulePerKilogram", "megajoule per kilogram"), Optional.of("MJ/kg"), Optional.of("JK"), Optional.of("joulePerKilogram"), Optional.of("10\u2076 J/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_THERMODYNAMIC_ENERGY, QuantityKinds.SPECIFIC_ENERGY, QuantityKinds.MASSIC_ENERGY))));
        UNITS_BY_NAME.put("megajoulePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megajoulePerSecond"), "megajoulePerSecond", "megajoule per second"), Optional.of("MJ/s"), Optional.of("D78"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megalitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megalitre"), "megalitre", "megalitre"), Optional.of("Ml"), Optional.of("MAL"), Optional.of("cubicMetre"), Optional.of("10\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("megametre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megametre"), "megametre", "megametre"), Optional.of("Mm"), Optional.of("MAM"), Optional.of("metre"), Optional.of("10\u2076 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.HEIGHT, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("meganewton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "meganewton"), "meganewton", "meganewton"), Optional.of("MN"), Optional.of("B73"), Optional.of("newton"), Optional.of("10\u2076 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.FORCE, QuantityKinds.WEIGHT))));
        UNITS_BY_NAME.put("meganewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "meganewtonMetre"), "meganewtonMetre", "meganewton metre"), Optional.of("MN\u00b7m"), Optional.of("B74"), Optional.of("newtonMetre"), Optional.of("10\u2076 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("megaohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaohm"), "megaohm", "megaohm"), Optional.of("M\u2126"), Optional.of("B75"), Optional.of("ohm"), Optional.of("10\u2076 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.REACTANCE, QuantityKinds.IMPEDANCE))));
        UNITS_BY_NAME.put("megaohmKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaohmKilometre"), "megaohmKilometre", "megaohm kilometre"), Optional.of("M\u2126\u00b7km"), Optional.of("H88"), Optional.of("ohmMetre"), Optional.of("10\u2079 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY))));
        UNITS_BY_NAME.put("megaohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaohmMetre"), "megaohmMetre", "megaohm metre"), Optional.of("M\u2126\u00b7m"), Optional.of("B76"), Optional.of("ohmMetre"), Optional.of("10\u2076 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("megaohmPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaohmPerKilometre"), "megaohmPerKilometre", "megaohm per kilometre"), Optional.of("M\u2126/km"), Optional.of("H36"), Optional.of("ohmPerMetre"), Optional.of("10\u00b3 \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("megaohmPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megaohmPerMetre"), "megaohmPerMetre", "megaohm per metre"), Optional.of("M\u2126/m"), Optional.of("H37"), Optional.of("ohmPerMetre"), Optional.of("10\u2076 \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("megapascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapascal"), "megapascal", "megapascal"), Optional.of("MPa"), Optional.of("MPA"), Optional.of("pascal"), Optional.of("10\u2076 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("megapascalCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapascalCubicMetrePerSecond"), "megapascalCubicMetrePerSecond", "megapascal cubic metre per second"), Optional.of("MPa\u00b7m\u00b3/s"), Optional.of("F98"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("megapascalLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapascalLitrePerSecond"), "megapascalLitrePerSecond", "megapascal litre per second"), Optional.of("MPa\u00b7l/s"), Optional.of("F97"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION))));
        UNITS_BY_NAME.put("megapascalPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapascalPerBar"), "megapascalPerBar", "megapascal per bar"), Optional.of("MPa/bar"), Optional.of("F05"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("megapascalPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapascalPerKelvin"), "megapascalPerKelvin", "megapascal per kelvin"), Optional.of("MPa/K"), Optional.of("F85"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("megapixel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megapixel"), "megapixel", "megapixel"), Optional.empty(), Optional.of("E38"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megasiemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megasiemensPerMetre"), "megasiemensPerMetre", "megasiemens per metre"), Optional.of("MS/m"), Optional.of("B77"), Optional.of("siemensPerMetre"), Optional.of("10\u2076 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("megavar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megavar"), "megavar", "megavar"), Optional.of("kvar"), Optional.of("MAR"), Optional.of("voltAmpere"), Optional.of("10\u00b3 V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.REACTIVE_POWER, QuantityKinds.APPARENT_POWER))));
        UNITS_BY_NAME.put("megavolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megavolt"), "megavolt", "megavolt"), Optional.of("MV"), Optional.of("B78"), Optional.of("volt"), Optional.of("10\u2076 V"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.VOLTAGE, QuantityKinds.TENSION, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.POTENTIAL_DIFFERENCE))));
        UNITS_BY_NAME.put("megavoltAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megavoltAmpere"), "megavoltAmpere", "megavolt - ampere"), Optional.of("MV\u00b7A"), Optional.of("MVA"), Optional.of("voltAmpere"), Optional.of("10\u2076 V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.APPARENT_POWER, QuantityKinds.APPARENT_POWER))));
        UNITS_BY_NAME.put("megavoltAmpereReactiveHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megavoltAmpereReactiveHour"), "megavoltAmpereReactiveHour", "megavolt ampere reactive hour"), Optional.of("Mvar\u00b7h"), Optional.of("MAH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megavoltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megavoltPerMetre"), "megavoltPerMetre", "megavolt per metre"), Optional.of("MV/m"), Optional.of("B79"), Optional.of("voltPerMetre"), Optional.of("10\u2076 V/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("megawatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megawatt"), "megawatt", "megawatt"), Optional.of("MW"), Optional.of("MAW"), Optional.of("watt"), Optional.of("10\u2076 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("megawattHour1000Kwh", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megawattHour1000Kwh"), "megawattHour1000Kwh", "megawatt hour (1000\u00a0kW.h)"), Optional.of("MW\u00b7h"), Optional.of("MWH"), Optional.of("joule"), Optional.of("3.6 \u00d7 10\u2079 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.WORK, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.POTENTIAL_ENERGY))));
        UNITS_BY_NAME.put("megawattHourPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megawattHourPerHour"), "megawattHourPerHour", "megawatt hour per hour"), Optional.of("MW\u00b7h/h"), Optional.of("E07"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("megawattPerHertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "megawattPerHertz"), "megawattPerHertz", "megawatt per hertz"), Optional.of("MW/Hz"), Optional.of("E08"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("mesh", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mesh"), "mesh", "mesh"), Optional.empty(), Optional.of("57"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("message", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "message"), "message", "message"), Optional.empty(), Optional.of("NF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("metre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metre"), "metre", "metre"), Optional.of("m"), Optional.of("MTR"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("metreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metreKelvin"), "metreKelvin", "metre kelvin"), Optional.of("m\u00b7K"), Optional.of("D18"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SECOND_RADIATION_CONSTANT))));
        UNITS_BY_NAME.put("metrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerBar"), "metrePerBar", "metre per bar"), Optional.of("m/bar"), Optional.of("G05"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE))));
        UNITS_BY_NAME.put("metrePerDegreeCelsiusMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerDegreeCelsiusMetre"), "metrePerDegreeCelsiusMetre", "metre per degree Celsius metre"), Optional.of("m/(\u00b0C\u00b7m)"), Optional.of("N83"), Optional.of("reciprocalKelvinOrKelvinToThePowerMinusOne"), Optional.of("K\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT, QuantityKinds.THERMAL_DIFFUSIVITY))));
        UNITS_BY_NAME.put("metrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerHour"), "metrePerHour", "metre per hour"), Optional.of("m/h"), Optional.of("M60"), Optional.of("metrePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY))));
        UNITS_BY_NAME.put("metrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerKelvin"), "metrePerKelvin", "metre per kelvin"), Optional.of("m/K"), Optional.of("F52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT))));
        UNITS_BY_NAME.put("metrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerMinute"), "metrePerMinute", "metre per minute"), Optional.of("m/min"), Optional.of("2X"), Optional.of("metrePerSecond"), Optional.of("0.016666 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES))));
        UNITS_BY_NAME.put("metrePerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerPascal"), "metrePerPascal", "metre per pascal"), Optional.of("m/Pa"), Optional.of("M53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS))));
        UNITS_BY_NAME.put("metrePerRadiant", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerRadiant"), "metrePerRadiant", "metre per radiant"), Optional.of("m/rad"), Optional.of("M55"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOLID_ANGLE))));
        UNITS_BY_NAME.put("metrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerSecond"), "metrePerSecond", "metre per second"), Optional.of("m/s"), Optional.of("MTS"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES))));
        UNITS_BY_NAME.put("metrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerSecondBar"), "metrePerSecondBar", "metre per second bar"), Optional.of("(m/s)/bar"), Optional.of("L13"), Optional.of("metrePerSecondPascal"), Optional.of("10\u207b\u2075 (m/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("metrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerSecondKelvin"), "metrePerSecondKelvin", "metre per second kelvin"), Optional.of("(m/s)/K"), Optional.of("L12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("metrePerSecondPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerSecondPascal"), "metrePerSecondPascal", "metre per second pascal"), Optional.of("(m/s)/Pa"), Optional.of("M59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("metrePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerSecondSquared"), "metrePerSecondSquared", "metre per second squared"), Optional.of("m/s\u00b2"), Optional.of("MSK"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("metrePerVoltSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metrePerVoltSecond"), "metrePerVoltSecond", "metre per volt second"), Optional.of("m/(V\u00b7s)"), Optional.of("H58"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOBILITY))));
        UNITS_BY_NAME.put("metreToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metreToTheFourthPower"), "metreToTheFourthPower", "metre to the fourth power"), Optional.of("m\u2074"), Optional.of("B83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SECOND_MOMENT_OF_AREA, QuantityKinds.SECOND_AXIAL_MOMENT_OF_AREA))));
        UNITS_BY_NAME.put("metricCarat", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metricCarat"), "metricCarat", "metric carat"), Optional.empty(), Optional.of("CTM"), Optional.of("milligram"), Optional.of("200 mg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("metricTonIncludingContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metricTonIncludingContainer"), "metricTonIncludingContainer", "metric ton, including container"), Optional.empty(), Optional.of("TIC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("metricTonIncludingInnerPackaging", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metricTonIncludingInnerPackaging"), "metricTonIncludingInnerPackaging", "metric ton, including inner packaging"), Optional.empty(), Optional.of("TIP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("metricTonLubricatingOil", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "metricTonLubricatingOil"), "metricTonLubricatingOil", "metric ton, lubricating oil"), Optional.empty(), Optional.of("LUB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("microInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microInch"), "microInch", "micro-inch"), Optional.of("\u00b5in"), Optional.of("M7"), Optional.of("metre"), Optional.of("25.4 \u00d7 10\u207b\u2079 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.LENGTH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.HEIGHT))));
        UNITS_BY_NAME.put("microampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microampere"), "microampere", "microampere"), Optional.of("\u00b5A"), Optional.of("B84"), Optional.of("ampere"), Optional.of("10\u207b\u2076 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETOMOTIVE_FORCE))));
    }

    private static void init9() {
        UNITS_BY_NAME.put("microbar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microbar"), "microbar", "microbar"), Optional.of("\u00b5bar"), Optional.of("B85"), Optional.of("pascal"), Optional.of("10\u207b\u00b9 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("microbecquerel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microbecquerel"), "microbecquerel", "microbecquerel"), Optional.of("\u00b5Bq"), Optional.of("H08"), Optional.of("becquerel"), Optional.of("10\u207b\u2076 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("microcoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microcoulomb"), "microcoulomb", "microcoulomb"), Optional.of("\u00b5C"), Optional.of("B86"), Optional.of("coulomb"), Optional.of("10\u207b\u2076 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("microcoulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microcoulombPerCubicMetre"), "microcoulombPerCubicMetre", "microcoulomb per cubic metre"), Optional.of("\u00b5C/m\u00b3"), Optional.of("B87"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u207b\u2076 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("microcoulombPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microcoulombPerSquareMetre"), "microcoulombPerSquareMetre", "microcoulomb per square metre"), Optional.of("\u00b5C/m\u00b2"), Optional.of("B88"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u207b\u2076 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("microcurie", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microcurie"), "microcurie", "microcurie"), Optional.of("\u00b5Ci"), Optional.of("M5"), Optional.of("becquerel"), Optional.of("3.7 \u00d7 10\u2074 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("microfarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microfarad"), "microfarad", "microfarad"), Optional.of("\u00b5F"), Optional.of("4O"), Optional.of("farad"), Optional.of("10\u207b\u2076 F"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE, QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("microfaradPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microfaradPerKilometre"), "microfaradPerKilometre", "microfarad per kilometre"), Optional.of("\u00b5F/km"), Optional.of("H28"), Optional.of("faradPerMetre"), Optional.of("10\u207b\u2079 F/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.PERMITTIVITY, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT))));
        UNITS_BY_NAME.put("microfaradPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microfaradPerMetre"), "microfaradPerMetre", "microfarad per metre"), Optional.of("\u00b5F/m"), Optional.of("B89"), Optional.of("faradPerMetre"), Optional.of("10\u207b\u2076 F/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.PERMITTIVITY, QuantityKinds.PERMITTIVITY_OF_VACUUM))));
        UNITS_BY_NAME.put("microgram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgram"), "microgram", "microgram"), Optional.of("\u00b5g"), Optional.of("MC"), Optional.of("kilogram"), Optional.of("10\u207b\u2079 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("microgramPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgramPerCubicMetre"), "microgramPerCubicMetre", "microgram per cubic metre"), Optional.of("\u00b5g/m\u00b3"), Optional.of("GQ"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u207b\u2079 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("microgramPerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgramPerCubicMetreBar"), "microgramPerCubicMetreBar", "microgram per cubic metre bar"), Optional.of("(\u00b5g/m\u00b3)/bar"), Optional.of("J35"), Optional.of("kilogramPerCubicMetrePascal"), Optional.of("10\u207b\u00b9\u2074 (kg/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("microgramPerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgramPerCubicMetreKelvin"), "microgramPerCubicMetreKelvin", "microgram per cubic metre kelvin"), Optional.of("(\u00b5g/m\u00b3)/K"), Optional.of("J34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("microgramPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgramPerKilogram"), "microgramPerKilogram", "microgram per kilogram"), Optional.of("\u00b5g/kg"), Optional.of("J33"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_RATIO))));
        UNITS_BY_NAME.put("microgramPerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microgramPerLitre"), "microgramPerLitre", "microgram per litre"), Optional.of("\u00b5g/l"), Optional.of("H29"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("micrograyPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micrograyPerHour"), "micrograyPerHour", "microgray per hour"), Optional.of("\u00b5Gy/h"), Optional.of("P63"), Optional.of("grayPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9\u2070 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("micrograyPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micrograyPerMinute"), "micrograyPerMinute", "microgray per minute"), Optional.of("\u00b5Gy/min"), Optional.of("P59"), Optional.of("grayPerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u2078 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("micrograyPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micrograyPerSecond"), "micrograyPerSecond", "microgray per second"), Optional.of("\u00b5Gy/s"), Optional.of("P55"), Optional.of("grayPerSecond"), Optional.of("10\u207b\u2076 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("microhenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microhenry"), "microhenry", "microhenry"), Optional.of("\u00b5H"), Optional.of("B90"), Optional.of("henry"), Optional.of("10\u207b\u2076 H"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("microhenryPerKiloohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microhenryPerKiloohm"), "microhenryPerKiloohm", "microhenry per kiloohm"), Optional.of("\u00b5H/k\u2126"), Optional.of("G98"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2079 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("microhenryPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microhenryPerMetre"), "microhenryPerMetre", "microhenry per metre"), Optional.of("\u00b5H/m"), Optional.of("B91"), Optional.of("henryPerMetre"), Optional.of("10\u207b\u2076 H/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_CONSTANT, QuantityKinds.PERMEABILITY_OF_VACUUM, QuantityKinds.PERMEABILITY, QuantityKinds.PERMEABILITY_OF_VACUUM, QuantityKinds.PERMEABILITY, QuantityKinds.MAGNETIC_CONSTANT))));
        UNITS_BY_NAME.put("microhenryPerOhm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microhenryPerOhm"), "microhenryPerOhm", "microhenry per ohm"), Optional.of("\u00b5H/\u2126"), Optional.of("G99"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("microlitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microlitre"), "microlitre", "microlitre"), Optional.of("\u00b5l"), Optional.of("4G"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2079 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("microlitrePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microlitrePerLitre"), "microlitrePerLitre", "microlitre per litre"), Optional.of("\u00b5l/l"), Optional.of("J36"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("micrometreMicron", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micrometreMicron"), "micrometreMicron", "micrometre (micron)"), Optional.of("\u00b5m"), Optional.of("4H"), Optional.of("metre"), Optional.of("10\u207b\u2076 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.DISTANCE, QuantityKinds.BREADTH))));
        UNITS_BY_NAME.put("micrometrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micrometrePerKelvin"), "micrometrePerKelvin", "micrometre per kelvin"), Optional.of("\u00b5m/K"), Optional.of("F50"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.RADIUS, QuantityKinds.LENGTH, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER))));
        UNITS_BY_NAME.put("micromole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micromole"), "micromole", "micromole"), Optional.of("\u00b5mol"), Optional.of("FH"), Optional.of("mole"), Optional.of("10\u207b\u2076 mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("micronewton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micronewton"), "micronewton", "micronewton"), Optional.of("\u00b5N"), Optional.of("B92"), Optional.of("newton"), Optional.of("10\u207b\u2076 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("micronewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micronewtonMetre"), "micronewtonMetre", "micronewton metre"), Optional.of("\u00b5N\u00b7m"), Optional.of("B93"), Optional.of("newtonMetre"), Optional.of("10\u207b\u2076 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("microohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microohm"), "microohm", "microohm"), Optional.of("\u00b5\u2126"), Optional.of("B94"), Optional.of("ohm"), Optional.of("10\u207b\u2076 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.IMPEDANCE, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("microohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microohmMetre"), "microohmMetre", "microohm metre"), Optional.of("\u00b5\u2126\u00b7m"), Optional.of("B95"), Optional.of("ohmMetre"), Optional.of("10\u207b\u2076 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("micropascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micropascal"), "micropascal", "micropascal"), Optional.of("\u00b5Pa"), Optional.of("B96"), Optional.of("pascal"), Optional.of("10\u207b\u2076 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.NORMAL_STRESS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("micropoise", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "micropoise"), "micropoise", "micropoise"), Optional.of("\u00b5P"), Optional.of("J32"), Optional.of("pascalSecond"), Optional.of("10\u207b\u2076 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("microradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microradian"), "microradian", "microradian"), Optional.of("\u00b5rad"), Optional.of("B97"), Optional.of("rad"), Optional.of("10\u207b\u2076 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_PLANE, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("microsecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsecond"), "microsecond", "microsecond"), Optional.of("\u00b5s"), Optional.of("B98"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("microsiemens", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsiemens"), "microsiemens", "microsiemens"), Optional.of("\u00b5S"), Optional.of("B99"), Optional.of("siemens"), Optional.of("10\u207b\u2076 S"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("microsiemensPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsiemensPerCentimetre"), "microsiemensPerCentimetre", "microsiemens per centimetre"), Optional.of("\u00b5S/cm"), Optional.of("G42"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u2074 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.MODULUS_OF_ADMITTANCE))));
        UNITS_BY_NAME.put("microsiemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsiemensPerMetre"), "microsiemensPerMetre", "microsiemens per metre"), Optional.of("\u00b5S/m"), Optional.of("G43"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u2076 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.ADMITTANCE))));
        UNITS_BY_NAME.put("microsievertPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsievertPerHour"), "microsievertPerHour", "microsievert per hour"), Optional.of("\u00b5Sv/h"), Optional.of("P72"), Optional.of("sievertPerSecond"), Optional.of("0.277777778 \u00d7 10\u207b\u00b9\u2070 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("microsievertPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsievertPerMinute"), "microsievertPerMinute", "microsievert per minute"), Optional.of("\u00b5Sv/min"), Optional.of("P76"), Optional.of("sievertPerSecond"), Optional.of("1.666666667 \u00d7 10\u207b\u2078 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("microsievertPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microsievertPerSecond"), "microsievertPerSecond", "microsievert per second"), Optional.of("\u00b5Sv/s"), Optional.of("P67"), Optional.of("sievertPerSecond"), Optional.of("10\u207b\u2076 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("microtesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microtesla"), "microtesla", "microtesla"), Optional.of("\u00b5T"), Optional.of("D81"), Optional.of("tesla"), Optional.of("10\u207b\u2076 T"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("microvolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microvolt"), "microvolt", "microvolt"), Optional.of("\u00b5V"), Optional.of("D82"), Optional.of("volt"), Optional.of("10\u207b\u2076 V"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.TENSION, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.VOLTAGE))));
        UNITS_BY_NAME.put("microvoltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microvoltPerMetre"), "microvoltPerMetre", "microvolt per metre"), Optional.of("\u00b5V/m"), Optional.of("C3"), Optional.of("voltPerMetre"), Optional.of("10\u207b\u2076 V/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("microwatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microwatt"), "microwatt", "microwatt"), Optional.of("\u00b5W"), Optional.of("D80"), Optional.of("watt"), Optional.of("10\u207b\u2076 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER, QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("microwattPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "microwattPerSquareMetre"), "microwattPerSquareMetre", "microwatt per square metre"), Optional.of("\u00b5W/m\u00b2"), Optional.of("D85"), Optional.of("wattPerSquareMetre"), Optional.of("10\u207b\u2076 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_INTENSITY, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("mil", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mil"), "mil", "mil"), Optional.of("mil"), Optional.of("M43"), Optional.of("rad"), Optional.of("9.817477 \u00d7 10\u207b\u2074 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_PLANE, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("mileBasedOnUsSurveyFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mileBasedOnUsSurveyFoot"), "mileBasedOnUsSurveyFoot", "mile (based on U.S. survey foot)"), Optional.of("mi (US survey)"), Optional.of("M52"), Optional.of("metre"), Optional.of("1.609347 \u00d7 10\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.DISTANCE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.BREADTH, QuantityKinds.THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH, QuantityKinds.DIAMETER))));
        UNITS_BY_NAME.put("milePerHourStatuteMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milePerHourStatuteMile"), "milePerHourStatuteMile", "mile per hour (statute mile)"), Optional.of("mile/h"), Optional.of("HM"), Optional.of("metrePerSecond"), Optional.of("0.44704 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("milePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milePerMinute"), "milePerMinute", "mile per minute"), Optional.of("mi/min"), Optional.of("M57"), Optional.of("metrePerSecond"), Optional.of("26.8224 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("milePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milePerSecond"), "milePerSecond", "mile per second"), Optional.of("mi/s"), Optional.of("M58"), Optional.of("metrePerSecond"), Optional.of("1.609344 \u00d7 10\u00b3 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY))));
        UNITS_BY_NAME.put("mileStatuteMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mileStatuteMile"), "mileStatuteMile", "mile (statute mile)"), Optional.of("mile"), Optional.of("SMI"), Optional.of("metre"), Optional.of("1609.344 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("mileStatuteMilePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mileStatuteMilePerSecondSquared"), "mileStatuteMilePerSecondSquared", "mile (statute mile) per second squared"), Optional.of("mi/s\u00b2"), Optional.of("M42"), Optional.of("metrePerSecondSquared"), Optional.of("1.609344 \u00d7 10\u00b3 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("mille", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mille"), "mille", "mille"), Optional.empty(), Optional.of("E12"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("milliInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliInch"), "milliInch", "milli-inch"), Optional.of("mil"), Optional.of("77"), Optional.of("metre"), Optional.of("25.4 \u00d7 10\u207b\u2076 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.LENGTH, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.RADIUS))));
        UNITS_BY_NAME.put("milliampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliampere"), "milliampere", "milliampere"), Optional.of("mA"), Optional.of("4K"), Optional.of("ampere"), Optional.of("10\u207b\u00b3 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.MAGNETOMOTIVE_FORCE))));
        UNITS_BY_NAME.put("milliampereHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliampereHour"), "milliampereHour", "milliampere hour"), Optional.of("mA\u00b7h"), Optional.of("E09"), Optional.of("coulomb"), Optional.of("3.6 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("milliamperePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliamperePerBar"), "milliamperePerBar", "milliampere per bar"), Optional.of("mA/bar"), Optional.of("F59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY))));
        UNITS_BY_NAME.put("milliamperePerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliamperePerInch"), "milliamperePerInch", "milliampere per inch"), Optional.of("mA/in"), Optional.of("F08"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY))));
        UNITS_BY_NAME.put("milliamperePerLitreMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliamperePerLitreMinute"), "milliamperePerLitreMinute", "milliampere per litre minute"), Optional.of("mA/(l\u00b7min)"), Optional.of("G59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("milliamperePerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliamperePerMillimetre"), "milliamperePerMillimetre", "milliampere per millimetre"), Optional.of("mA/mm"), Optional.of("F76"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FIELD_STRENGTH, QuantityKinds.LINEIC_ELECTRIC_CURRENT, QuantityKinds.LINEAR_ELECTRIC_CURRENT_DENSITY))));
        UNITS_BY_NAME.put("milliamperePerPoundForcePerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliamperePerPoundForcePerSquareInch"), "milliamperePerPoundForcePerSquareInch", "milliampere per pound-force per square inch"), Optional.of("mA/(lbf/in\u00b2)"), Optional.of("F57"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CURRENT_DENSITY))));
        UNITS_BY_NAME.put("milliard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliard"), "milliard", "milliard"), Optional.empty(), Optional.of("MLD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millibar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millibar"), "millibar", "millibar"), Optional.of("mbar"), Optional.of("MBR"), Optional.of("pascal"), Optional.of("10\u00b2 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS))));
        UNITS_BY_NAME.put("millibarCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millibarCubicMetrePerSecond"), "millibarCubicMetrePerSecond", "millibar cubic metre per second"), Optional.of("mbar\u00b7m\u00b3/s"), Optional.of("F96"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE))));
        UNITS_BY_NAME.put("millibarLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millibarLitrePerSecond"), "millibarLitrePerSecond", "millibar litre per second"), Optional.of("mbar\u00b7l/s"), Optional.of("F95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE))));
        UNITS_BY_NAME.put("millibarPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millibarPerBar"), "millibarPerBar", "millibar per bar"), Optional.of("mbar/bar"), Optional.of("F04"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("millibarPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millibarPerKelvin"), "millibarPerKelvin", "millibar per kelvin"), Optional.of("mbar/K"), Optional.of("F84"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS))));
        UNITS_BY_NAME.put("millicandela", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicandela"), "millicandela", "millicandela"), Optional.of("mcd"), Optional.of("P34"), Optional.of("candela"), Optional.of("10\u207b\u00b3 cd"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINOUS_INTENSITY, QuantityKinds.LUMINOUS_INTENSITY))));
        UNITS_BY_NAME.put("millicoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicoulomb"), "millicoulomb", "millicoulomb"), Optional.of("mC"), Optional.of("D86"), Optional.of("coulomb"), Optional.of("10\u207b\u00b3 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("millicoulombPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicoulombPerCubicMetre"), "millicoulombPerCubicMetre", "millicoulomb per cubic metre"), Optional.of("mC/m\u00b3"), Optional.of("D88"), Optional.of("coulombPerCubicMetre"), Optional.of("10\u207b\u00b3 C/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CHARGE_DENSITY, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.VOLUMIC_CHARGE, QuantityKinds.VOLUME_DENSITY_OF_CHARGE, QuantityKinds.CHARGE_DENSITY))));
        UNITS_BY_NAME.put("millicoulombPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicoulombPerKilogram"), "millicoulombPerKilogram", "millicoulomb per kilogram"), Optional.of("mC/kg"), Optional.of("C8"), Optional.of("coulombPerKilogram"), Optional.of("10\u207b\u00b3 C/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE, QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("millicoulombPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicoulombPerSquareMetre"), "millicoulombPerSquareMetre", "millicoulomb per square metre"), Optional.of("mC/m\u00b2"), Optional.of("D89"), Optional.of("coulombPerSquareMetre"), Optional.of("10\u207b\u00b3 C/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.SURFACE_DENSITY_OF_CHARGE, QuantityKinds.ELECTRIC_FLUX_DENSITY, QuantityKinds.DISPLACEMENT_ELECTRIC_POLARIZATION))));
        UNITS_BY_NAME.put("millicurie", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millicurie"), "millicurie", "millicurie"), Optional.of("mCi"), Optional.of("MCU"), Optional.of("becquerel"), Optional.of("3.7 \u00d7 10\u2077 Bq"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVITY, QuantityKinds.ACTIVITY))));
        UNITS_BY_NAME.put("milliequivalenceCausticPotashPerGramOfProduct", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliequivalenceCausticPotashPerGramOfProduct"), "milliequivalenceCausticPotashPerGramOfProduct", "milliequivalence caustic potash per gram of product"), Optional.empty(), Optional.of("KO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millifarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millifarad"), "millifarad", "millifarad"), Optional.of("mF"), Optional.of("C10"), Optional.of("farad"), Optional.of("10\u207b\u00b3 F"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE, QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("milligal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligal"), "milligal", "milligal"), Optional.of("mGal"), Optional.of("C11"), Optional.of("metrePerSecondSquared"), Optional.of("10\u207b\u2075 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("milligram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligram"), "milligram", "milligram"), Optional.of("mg"), Optional.of("MGM"), Optional.of("kilogram"), Optional.of("10\u207b\u2076 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("milligramPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerBar"), "milligramPerBar", "milligram per bar"), Optional.of("mg/bar"), Optional.of("F75"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("milligramPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerCubicMetre"), "milligramPerCubicMetre", "milligram per cubic metre"), Optional.of("mg/m\u00b3"), Optional.of("GP"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u207b\u2076 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("milligramPerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerCubicMetreBar"), "milligramPerCubicMetreBar", "milligram per cubic metre bar"), Optional.of("(mg/m\u00b3)/bar"), Optional.of("L18"), Optional.of("kilogramPerCubicMetrePascal"), Optional.of("10\u207b\u00b9\u00b9 (kg/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("milligramPerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerCubicMetreKelvin"), "milligramPerCubicMetreKelvin", "milligram per cubic metre kelvin"), Optional.of("(mg/m\u00b3)/K"), Optional.of("L17"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("milligramPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerDay"), "milligramPerDay", "milligram per day"), Optional.of("mg/d"), Optional.of("F32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerDayBar"), "milligramPerDayBar", "milligram per day bar"), Optional.of("mg/(d\u00b7bar)"), Optional.of("F70"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerDayKelvin"), "milligramPerDayKelvin", "milligram per day kelvin"), Optional.of("mg/(d\u00b7K)"), Optional.of("F43"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerGram"), "milligramPerGram", "milligram per gram"), Optional.of("mg/g"), Optional.of("H64"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("milligramPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerHour"), "milligramPerHour", "milligram per hour"), Optional.of("mg/h"), Optional.of("4M"), Optional.of("kilogramPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9\u2070 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerHourBar"), "milligramPerHourBar", "milligram per hour bar"), Optional.of("mg/(h\u00b7bar)"), Optional.of("F71"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerHourKelvin"), "milligramPerHourKelvin", "milligram per hour kelvin"), Optional.of("mg/(h\u00b7K)"), Optional.of("F44"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerKelvin"), "milligramPerKelvin", "milligram per kelvin"), Optional.of("mg/K"), Optional.of("F16"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("milligramPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerKilogram"), "milligramPerKilogram", "milligram per kilogram"), Optional.of("mg/kg"), Optional.of("NA"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_RATIO))));
        UNITS_BY_NAME.put("milligramPerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerLitre"), "milligramPerLitre", "milligram per litre"), Optional.of("mg/l"), Optional.of("M1"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u207b\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("milligramPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerMetre"), "milligramPerMetre", "milligram per metre"), Optional.of("mg/m"), Optional.of("C12"), Optional.of("kilogramPerMetre"), Optional.of("10\u207b\u2076 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS))));
        UNITS_BY_NAME.put("milligramPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerMinute"), "milligramPerMinute", "milligram per minute"), Optional.of("mg/min"), Optional.of("F33"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerMinuteBar"), "milligramPerMinuteBar", "milligram per minute bar"), Optional.of("mg/(min\u00b7bar)"), Optional.of("F72"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerMinuteKelvin"), "milligramPerMinuteKelvin", "milligram per minute kelvin"), Optional.of("mg/(min\u00b7K)"), Optional.of("F45"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerSecond"), "milligramPerSecond", "milligram per second"), Optional.of("mg/s"), Optional.of("F34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerSecondBar"), "milligramPerSecondBar", "milligram per second bar"), Optional.of("mg/(s\u00b7bar)"), Optional.of("F73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerSecondKelvin"), "milligramPerSecondKelvin", "milligram per second kelvin"), Optional.of("mg/(s\u00b7K)"), Optional.of("F46"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("milligramPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerSquareCentimetre"), "milligramPerSquareCentimetre", "milligram per square centimetre"), Optional.of("mg/cm\u00b2"), Optional.of("H63"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS))));
    }

    private static void init10() {
        UNITS_BY_NAME.put("milligramPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligramPerSquareMetre"), "milligramPerSquareMetre", "milligram per square metre"), Optional.of("mg/m\u00b2"), Optional.of("GO"), Optional.of("kilogramPerSquareMetre"), Optional.of("10\u207b\u2076 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("milligray", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligray"), "milligray", "milligray"), Optional.of("mGy"), Optional.of("C13"), Optional.of("gray"), Optional.of("10\u207b\u00b3 Gy"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ENERGY_IMPARTED, QuantityKinds.MASSIC_ENERGY_IMPARTED, QuantityKinds.MASSIC_ENERGY_IMPARTED, QuantityKinds.SPECIFIC_ENERGY_IMPARTED))));
        UNITS_BY_NAME.put("milligrayPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligrayPerHour"), "milligrayPerHour", "milligray per hour"), Optional.of("mGy/h"), Optional.of("P62"), Optional.of("grayPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2077 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("milligrayPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligrayPerMinute"), "milligrayPerMinute", "milligray per minute"), Optional.of("mGy/min"), Optional.of("P58"), Optional.of("grayPerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u2075 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("milligrayPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milligrayPerSecond"), "milligrayPerSecond", "milligray per second"), Optional.of("mGy/s"), Optional.of("P54"), Optional.of("grayPerSecond"), Optional.of("10\u207b\u00b3 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("millihenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millihenry"), "millihenry", "millihenry"), Optional.of("mH"), Optional.of("C14"), Optional.of("henry"), Optional.of("10\u207b\u00b3 H"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE))));
        UNITS_BY_NAME.put("millihenryPerKiloohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millihenryPerKiloohm"), "millihenryPerKiloohm", "millihenry per kiloohm"), Optional.of("mH/k\u2126"), Optional.of("H05"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE))));
        UNITS_BY_NAME.put("millihenryPerOhm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millihenryPerOhm"), "millihenryPerOhm", "millihenry per ohm"), Optional.of("mH/\u2126"), Optional.of("H06"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u00b3 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("millijoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millijoule"), "millijoule", "millijoule"), Optional.of("mJ"), Optional.of("C15"), Optional.of("joule"), Optional.of("10\u207b\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.WORK, QuantityKinds.ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.POTENTIAL_ENERGY))));
        UNITS_BY_NAME.put("millilitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitre"), "millilitre", "millilitre"), Optional.of("ml"), Optional.of("MLT"), Optional.of("cubicMetre"), Optional.of("10\u207b\u2076 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("millilitrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerBar"), "millilitrePerBar", "millilitre per bar"), Optional.of("ml/bar"), Optional.of("G97"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("millilitrePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerCubicMetre"), "millilitrePerCubicMetre", "millilitre per cubic metre"), Optional.of("ml/m\u00b3"), Optional.of("H65"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("millilitrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerDay"), "millilitrePerDay", "millilitre per day"), Optional.of("ml/d"), Optional.of("G54"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerDayBar"), "millilitrePerDayBar", "millilitre per day bar"), Optional.of("ml/(d\u00b7bar)"), Optional.of("G90"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerDayKelvin"), "millilitrePerDayKelvin", "millilitre per day kelvin"), Optional.of("ml/(d\u00b7K)"), Optional.of("G73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerHour"), "millilitrePerHour", "millilitre per hour"), Optional.of("ml/h"), Optional.of("G55"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerHourBar"), "millilitrePerHourBar", "millilitre per hour bar"), Optional.of("ml/(h\u00b7bar)"), Optional.of("G91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerHourKelvin"), "millilitrePerHourKelvin", "millilitre per hour kelvin"), Optional.of("ml/(h\u00b7K)"), Optional.of("G74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerKelvin"), "millilitrePerKelvin", "millilitre per kelvin"), Optional.of("ml/K"), Optional.of("G30"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_PER_TEMPERATURE))));
        UNITS_BY_NAME.put("millilitrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerKilogram"), "millilitrePerKilogram", "millilitre per kilogram"), Optional.of("ml/kg"), Optional.of("KX"), Optional.of("cubicMetrePerKilogram"), Optional.of("10\u207b\u2076 m\u00b3/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.MASSIC_VOLUME, QuantityKinds.SPECIFIC_VOLUME))));
        UNITS_BY_NAME.put("millilitrePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerLitre"), "millilitrePerLitre", "millilitre per litre"), Optional.of("ml/l"), Optional.of("L19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_RATIO))));
        UNITS_BY_NAME.put("millilitrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerMinute"), "millilitrePerMinute", "millilitre per minute"), Optional.of("ml/min"), Optional.of("41"), Optional.of("cubicMetrePerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerMinuteBar"), "millilitrePerMinuteBar", "millilitre per minute bar"), Optional.of("ml/(min\u00b7bar)"), Optional.of("G92"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerMinuteKelvin"), "millilitrePerMinuteKelvin", "millilitre per minute kelvin"), Optional.of("ml/(min\u00b7K)"), Optional.of("G75"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerSecond"), "millilitrePerSecond", "millilitre per second"), Optional.of("ml/s"), Optional.of("40"), Optional.of("cubicMetrePerSecond"), Optional.of("10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerSecondBar"), "millilitrePerSecondBar", "millilitre per second bar"), Optional.of("ml/(s\u00b7bar)"), Optional.of("G93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerSecondKelvin"), "millilitrePerSecondKelvin", "millilitre per second kelvin"), Optional.of("ml/(s\u00b7K)"), Optional.of("G76"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("millilitrePerSquareCentimetreMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerSquareCentimetreMinute"), "millilitrePerSquareCentimetreMinute", "millilitre per square centimetre minute"), Optional.of("(ml/min)/cm\u00b2"), Optional.of("M22"), Optional.of("cubicMetrePerSecondSquareMetre"), Optional.of("2.777778 \u00d7 10\u207b\u2076 (m\u00b3/s)/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POROSITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("millilitrePerSquareCentimetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millilitrePerSquareCentimetreSecond"), "millilitrePerSquareCentimetreSecond", "millilitre per square centimetre second"), Optional.of("ml/(cm\u00b2\u00b7s)"), Optional.of("35"), Optional.of("metrePerSecond"), Optional.of("10\u207b\u00b2 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.POROSITY))));
        UNITS_BY_NAME.put("millimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetre"), "millimetre", "millimetre"), Optional.of("mm"), Optional.of("MMT"), Optional.of("metre"), Optional.of("10\u207b\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("millimetrePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerBar"), "millimetrePerBar", "millimetre per bar"), Optional.of("mm/bar"), Optional.of("G06"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.BREADTH, QuantityKinds.THICKNESS, QuantityKinds.DISTANCE, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER))));
        UNITS_BY_NAME.put("millimetrePerDegreeCelsiusMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerDegreeCelsiusMetre"), "millimetrePerDegreeCelsiusMetre", "millimetre per degree Celsius metre"), Optional.of("mm/(\u00b0C\u00b7m)"), Optional.of("E97"), Optional.of("reciprocalKelvinOrKelvinToThePowerMinusOne"), Optional.of("10\u207b\u00b3 K\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT, QuantityKinds.THERMAL_DIFFUSIVITY))));
        UNITS_BY_NAME.put("millimetrePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerHour"), "millimetrePerHour", "millimetre per hour"), Optional.of("mm/h"), Optional.of("H67"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("millimetrePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerKelvin"), "millimetrePerKelvin", "millimetre per kelvin"), Optional.of("mm/K"), Optional.of("F53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY))));
        UNITS_BY_NAME.put("millimetrePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerMinute"), "millimetrePerMinute", "millimetre per minute"), Optional.of("mm/min"), Optional.of("H81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("millimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerSecond"), "millimetrePerSecond", "millimetre per second"), Optional.of("mm/s"), Optional.of("C16"), Optional.of("metrePerSecond"), Optional.of("10\u207b\u00b3 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("millimetrePerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerSecondSquared"), "millimetrePerSecondSquared", "millimetre per second squared"), Optional.of("mm/s\u00b2"), Optional.of("M41"), Optional.of("metrePerSecondSquared"), Optional.of("10\u207b\u00b3 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("millimetrePerYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetrePerYear"), "millimetrePerYear", "millimetre per year"), Optional.of("mm/y"), Optional.of("H66"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY))));
        UNITS_BY_NAME.put("millimetreSquaredPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetreSquaredPerSecond"), "millimetreSquaredPerSecond", "millimetre squared per second"), Optional.of("mm\u00b2/s"), Optional.of("C17"), Optional.of("squareMetrePerSecond"), Optional.of("10\u207b\u2076 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("millimetreToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimetreToTheFourthPower"), "millimetreToTheFourthPower", "millimetre to the fourth power"), Optional.of("mm\u2074"), Optional.of("G77"), Optional.of("metreToTheFourthPower"), Optional.of("10\u207b\u00b9\u00b2 m\u2074"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SECOND_MOMENT_OF_AREA, QuantityKinds.SECOND_AXIAL_MOMENT_OF_AREA, QuantityKinds.SECOND_MOMENT_OF_AREA, QuantityKinds.SECOND_AXIAL_MOMENT_OF_AREA))));
        UNITS_BY_NAME.put("millimole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimole"), "millimole", "millimole"), Optional.of("mmol"), Optional.of("C18"), Optional.of("mole"), Optional.of("10\u207b\u00b3 mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("millimolePerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimolePerGram"), "millimolePerGram", "millimole per gram"), Optional.of("mmol/g"), Optional.of("H68"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IONIC_STRENGTH))));
        UNITS_BY_NAME.put("millimolePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimolePerKilogram"), "millimolePerKilogram", "millimole per kilogram"), Optional.of("mmol/kg"), Optional.of("D87"), Optional.of("molePerKilogram"), Optional.of("10\u207b\u00b3 mol/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLALITY_OF_SOLUTE_B, QuantityKinds.IONIC_STRENGTH))));
        UNITS_BY_NAME.put("millimolePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millimolePerLitre"), "millimolePerLitre", "millimole per litre"), Optional.of("mmol/l"), Optional.of("M33"), Optional.of("molePerCubicMetre"), Optional.of("mol/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("millinewton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millinewton"), "millinewton", "millinewton"), Optional.of("mN"), Optional.of("C20"), Optional.of("newton"), Optional.of("10\u207b\u00b3 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("millinewtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millinewtonMetre"), "millinewtonMetre", "millinewton metre"), Optional.of("mN\u00b7m"), Optional.of("D83"), Optional.of("newtonMetre"), Optional.of("10\u207b\u00b3 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("millinewtonPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millinewtonPerMetre"), "millinewtonPerMetre", "millinewton per metre"), Optional.of("mN/m"), Optional.of("C22"), Optional.of("newtonPerMetre"), Optional.of("10\u207b\u00b3 N/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION, QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("milliohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliohm"), "milliohm", "milliohm"), Optional.of("m\u2126"), Optional.of("E45"), Optional.of("ohm"), Optional.of("10\u207b\u00b3 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("milliohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliohmMetre"), "milliohmMetre", "milliohm metre"), Optional.of("m\u2126\u00b7m"), Optional.of("C23"), Optional.of("ohmMetre"), Optional.of("10\u207b\u00b3 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("milliohmPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliohmPerMetre"), "milliohmPerMetre", "milliohm per metre"), Optional.of("m\u2126/m"), Optional.of("F54"), Optional.of("ohmPerMetre"), Optional.of("10\u207b\u00b3 \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("million", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "million"), "million", "million"), Optional.empty(), Optional.of("MIO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millionBtuItPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millionBtuItPerHour"), "millionBtuItPerHour", "million Btu(IT) per hour"), Optional.of("BtuIT/h"), Optional.of("E16"), Optional.of("watt"), Optional.of("293071.1 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("millionBtuPer1000CubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millionBtuPer1000CubicFoot"), "millionBtuPer1000CubicFoot", "million Btu per 1000 cubic foot"), Optional.of("MBTU/kft\u00b3"), Optional.of("M9"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millionCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millionCubicMetre"), "millionCubicMetre", "million cubic metre"), Optional.of("Mm\u00b3"), Optional.of("HMQ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millionInternationalUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millionInternationalUnit"), "millionInternationalUnit", "million international unit"), Optional.empty(), Optional.of("MIU"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("millipascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millipascal"), "millipascal", "millipascal"), Optional.of("mPa"), Optional.of("74"), Optional.of("pascal"), Optional.of("10\u207b\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("millipascalPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millipascalPerMetre"), "millipascalPerMetre", "millipascal per metre"), Optional.of("mPa/m"), Optional.of("P80"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("millipascalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millipascalSecond"), "millipascalSecond", "millipascal second"), Optional.of("mPa\u00b7s"), Optional.of("C24"), Optional.of("pascalSecond"), Optional.of("10\u207b\u00b3 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("millipascalSecondPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millipascalSecondPerBar"), "millipascalSecondPerBar", "millipascal second per bar"), Optional.of("mPa\u00b7s/bar"), Optional.of("L16"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2078 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("millipascalSecondPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millipascalSecondPerKelvin"), "millipascalSecondPerKelvin", "millipascal second per kelvin"), Optional.of("mPa\u00b7s/K"), Optional.of("L15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("milliradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliradian"), "milliradian", "milliradian"), Optional.of("mrad"), Optional.of("C25"), Optional.of("rad"), Optional.of("10\u207b\u00b3 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_PLANE, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("milliroentgen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliroentgen"), "milliroentgen", "milliroentgen"), Optional.of("mR"), Optional.of("2Y"), Optional.of("coulombPerKilogram"), Optional.of("2.58 \u00d7 10\u207b\u2077 C/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE, QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("milliroentgenAequivalentMen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliroentgenAequivalentMen"), "milliroentgenAequivalentMen", "milliroentgen aequivalent men"), Optional.of("mrem"), Optional.of("L31"), Optional.of("sievert"), Optional.of("10\u207b\u2075 Sv"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DOSE_EQUIVALENT, QuantityKinds.DOSE_EQUIVALENT))));
        UNITS_BY_NAME.put("millisecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisecond"), "millisecond", "millisecond"), Optional.of("ms"), Optional.of("C26"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u00b3 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("millisiemens", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisiemens"), "millisiemens", "millisiemens"), Optional.of("mS"), Optional.of("C27"), Optional.of("siemens"), Optional.of("10\u207b\u00b3 S"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.COMPLEX_ADMITTANCE))));
        UNITS_BY_NAME.put("millisiemensPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisiemensPerCentimetre"), "millisiemensPerCentimetre", "millisiemens per centimetre"), Optional.of("mS/cm"), Optional.of("H61"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u00b9 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("millisievert", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisievert"), "millisievert", "millisievert"), Optional.of("mSv"), Optional.of("C28"), Optional.of("sievert"), Optional.of("10\u207b\u00b3 Sv"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DOSE_EQUIVALENT, QuantityKinds.DOSE_EQUIVALENT))));
        UNITS_BY_NAME.put("millisievertPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisievertPerHour"), "millisievertPerHour", "millisievert per hour"), Optional.of("mSv/h"), Optional.of("P71"), Optional.of("sievertPerSecond"), Optional.of("0.277777778 \u00d7 10\u207b\u2077 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("millisievertPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisievertPerMinute"), "millisievertPerMinute", "millisievert per minute"), Optional.of("mSv/min"), Optional.of("P75"), Optional.of("sievertPerSecond"), Optional.of("1.666666667 \u00d7 10\u207b\u2075 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("millisievertPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millisievertPerSecond"), "millisievertPerSecond", "millisievert per second"), Optional.of("mSv/s"), Optional.of("P66"), Optional.of("sievertPerSecond"), Optional.of("10\u207b\u00b3 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("millitesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millitesla"), "millitesla", "millitesla"), Optional.of("mT"), Optional.of("C29"), Optional.of("tesla"), Optional.of("10\u207b\u00b3 T"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("millivolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millivolt"), "millivolt", "millivolt"), Optional.of("mV"), Optional.of("2Z"), Optional.of("volt"), Optional.of("10\u207b\u00b3 V"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.TENSION, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.VOLTAGE))));
        UNITS_BY_NAME.put("millivoltAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millivoltAmpere"), "millivoltAmpere", "millivolt - ampere"), Optional.of("mV\u00b7A"), Optional.of("M35"), Optional.of("voltAmpere"), Optional.of("10\u207b\u00b3 V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.APPARENT_POWER, QuantityKinds.APPARENT_POWER))));
        UNITS_BY_NAME.put("millivoltPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millivoltPerKelvin"), "millivoltPerKelvin", "millivolt per kelvin"), Optional.of("mV/K"), Optional.of("D49"), Optional.of("voltPerKelvin"), Optional.of("10\u207b\u00b3 V/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SEEBECK_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.THOMPSON_COEFFICIENT))));
        UNITS_BY_NAME.put("millivoltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millivoltPerMetre"), "millivoltPerMetre", "millivolt per metre"), Optional.of("mV/m"), Optional.of("C30"), Optional.of("voltPerMetre"), Optional.of("10\u207b\u00b3 V/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("millivoltPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "millivoltPerMinute"), "millivoltPerMinute", "millivolt per minute"), Optional.of("mV/min"), Optional.of("H62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("milliwatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliwatt"), "milliwatt", "milliwatt"), Optional.of("mW"), Optional.of("C31"), Optional.of("watt"), Optional.of("10\u207b\u00b3 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER, QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("milliwattPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliwattPerSquareMetre"), "milliwattPerSquareMetre", "milliwatt per square metre"), Optional.of("mW/m\u00b2"), Optional.of("C32"), Optional.of("wattPerSquareMetre"), Optional.of("10\u207b\u00b3 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_INTENSITY, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("milliweber", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "milliweber"), "milliweber", "milliweber"), Optional.of("mWb"), Optional.of("C33"), Optional.of("weber"), Optional.of("10\u207b\u00b3 Wb"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX, QuantityKinds.MAGNETIC_FLUX_QUANTUM, QuantityKinds.MAGNETIC_FLUX))));
        UNITS_BY_NAME.put("minuteUnitOfAngle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "minuteUnitOfAngle"), "minuteUnitOfAngle", "minute [unit of angle]"), Optional.of("'"), Optional.of("D61"), Optional.of("rad"), Optional.of("2.908882 \u00d7 10\u207b\u2074 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE, QuantityKinds.ANGLE_PLANE))));
        UNITS_BY_NAME.put("minuteUnitOfTime", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "minuteUnitOfTime"), "minuteUnitOfTime", "minute [unit of time]"), Optional.of("min"), Optional.of("MIN"), Optional.of("secondUnitOfTime"), Optional.of("60 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("mmscfPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mmscfPerDay"), "mmscfPerDay", "MMSCF/day"), Optional.empty(), Optional.of("5E"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("moduleWidth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "moduleWidth"), "moduleWidth", "module width"), Optional.of("MW"), Optional.of("H77"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("molPerCubicMetrePascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molPerCubicMetrePascal"), "molPerCubicMetrePascal", "mol per cubic metre pascal"), Optional.of("(mol/m\u00b3)/Pa"), Optional.of("P52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molPerKilogramPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molPerKilogramPascal"), "molPerKilogramPascal", "mol per kilogram pascal"), Optional.of("(mol/kg)/Pa"), Optional.of("P51"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("mole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mole"), "mole", "mole"), Optional.of("mol"), Optional.of("C34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("molePerCubicDecimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerCubicDecimetre"), "molePerCubicDecimetre", "mole per cubic decimetre"), Optional.of("mol/dm\u00b3"), Optional.of("C35"), Optional.of("molePerCubicMetre"), Optional.of("10\u00b3 mol/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerCubicMetre"), "molePerCubicMetre", "mole per cubic metre"), Optional.of("mol/m\u00b3"), Optional.of("C36"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molePerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerCubicMetreBar"), "molePerCubicMetreBar", "mole per cubic metre bar"), Optional.of("(mol/m\u00b3)/bar"), Optional.of("L29"), Optional.of("molPerCubicMetrePascal"), Optional.of("10\u207b\u2075 (mol/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("molePerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerCubicMetreKelvin"), "molePerCubicMetreKelvin", "mole per cubic metre kelvin"), Optional.of("(mol/m\u00b3)/K"), Optional.of("L28"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molePerCubicMetreToThePowerSumOfStoichiometricNumbers", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerCubicMetreToThePowerSumOfStoichiometricNumbers"), "molePerCubicMetreToThePowerSumOfStoichiometricNumbers", "mole per cubic metre to the power sum of stoichiometric numbers"), Optional.of("(mol/m\u00b3)\u2211\u03bdB"), Optional.of("P99"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("molePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerHour"), "molePerHour", "mole per hour"), Optional.of("mol/h"), Optional.of("L23"), Optional.of("molePerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_FLUX, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("molePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerKilogram"), "molePerKilogram", "mole per kilogram"), Optional.of("mol/kg"), Optional.of("C19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLALITY_OF_SOLUTE_B))));
        UNITS_BY_NAME.put("molePerKilogramBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerKilogramBar"), "molePerKilogramBar", "mole per kilogram bar"), Optional.of("(mol/kg)/bar"), Optional.of("L25"), Optional.of("molPerKilogramPascal"), Optional.of("10\u207b\u2075 (mol/kg)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("molePerKilogramKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerKilogramKelvin"), "molePerKilogramKelvin", "mole per kilogram kelvin"), Optional.of("(mol/kg)/K"), Optional.of("L24"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerLitre"), "molePerLitre", "mole per litre"), Optional.of("mol/l"), Optional.of("C38"), Optional.of("molePerCubicMetre"), Optional.of("10\u00b3 mol/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("molePerLitreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerLitreBar"), "molePerLitreBar", "mole per litre bar"), Optional.of("(mol/l)/bar"), Optional.of("L27"), Optional.of("molPerCubicMetrePascal"), Optional.of("10\u207b\u00b2 (mol/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.DENSITY, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("molePerLitreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerLitreKelvin"), "molePerLitreKelvin", "mole per litre kelvin"), Optional.of("(mol/l)/K"), Optional.of("L26"), Optional.of("molePerCubicMetreKelvin"), Optional.of("10\u00b3 (mol/m\u00b3)/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("molePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerMinute"), "molePerMinute", "mole per minute"), Optional.of("mol/min"), Optional.of("L30"), Optional.of("molePerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u00b2 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.MOLAR_FLUX))));
        UNITS_BY_NAME.put("molePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "molePerSecond"), "molePerSecond", "mole per second"), Optional.of("mol/s"), Optional.of("E95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY))));
    }

    private static void init11() {
        UNITS_BY_NAME.put("monetaryValue", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "monetaryValue"), "monetaryValue", "monetary value"), Optional.empty(), Optional.of("M4"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("month", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "month"), "month", "month"), Optional.of("mo"), Optional.of("MON"), Optional.of("secondUnitOfTime"), Optional.of("2.629800 \u00d7 10\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("mutuallyDefined", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "mutuallyDefined"), "mutuallyDefined", "mutually defined"), Optional.empty(), Optional.of("ZZ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("nanoampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanoampere"), "nanoampere", "nanoampere"), Optional.of("nA"), Optional.of("C39"), Optional.of("ampere"), Optional.of("10\u207b\u2079 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE))));
        UNITS_BY_NAME.put("nanocoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanocoulomb"), "nanocoulomb", "nanocoulomb"), Optional.of("nC"), Optional.of("C40"), Optional.of("coulomb"), Optional.of("10\u207b\u2079 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY))));
        UNITS_BY_NAME.put("nanofarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanofarad"), "nanofarad", "nanofarad"), Optional.of("nF"), Optional.of("C41"), Optional.of("farad"), Optional.of("10\u207b\u2079 F"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE, QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("nanofaradPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanofaradPerMetre"), "nanofaradPerMetre", "nanofarad per metre"), Optional.of("nF/m"), Optional.of("C42"), Optional.of("faradPerMetre"), Optional.of("10\u207b\u2079 F/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT))));
        UNITS_BY_NAME.put("nanogramPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanogramPerKilogram"), "nanogramPerKilogram", "nanogram per kilogram"), Optional.of("ng/kg"), Optional.of("L32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_RATIO))));
        UNITS_BY_NAME.put("nanograyPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanograyPerHour"), "nanograyPerHour", "nanogray per hour"), Optional.of("nGy/h"), Optional.of("P64"), Optional.of("grayPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9\u00b3 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("nanograyPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanograyPerMinute"), "nanograyPerMinute", "nanogray per minute"), Optional.of("nGy/min"), Optional.of("P60"), Optional.of("grayPerSecond"), Optional.of("1.66667 \u00d7 10\u207b\u00b9\u00b9 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("nanograyPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanograyPerSecond"), "nanograyPerSecond", "nanogray per second"), Optional.of("nGy/s"), Optional.of("P56"), Optional.of("grayPerSecond"), Optional.of("10\u207b\u2079 Gy/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ABSORBED_DOSE_RATE, QuantityKinds.ABSORBED_DOSE_RATE))));
        UNITS_BY_NAME.put("nanohenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanohenry"), "nanohenry", "nanohenry"), Optional.of("nH"), Optional.of("C43"), Optional.of("henry"), Optional.of("10\u207b\u2079 H"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SELF_INDUCTANCE, QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("nanohenryPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanohenryPerMetre"), "nanohenryPerMetre", "nanohenry per metre"), Optional.of("nH/m"), Optional.of("C44"), Optional.of("henryPerMetre"), Optional.of("10\u207b\u2079 H/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_CONSTANT, QuantityKinds.PERMEABILITY_OF_VACUUM, QuantityKinds.PERMEABILITY, QuantityKinds.PERMEABILITY_OF_VACUUM, QuantityKinds.PERMEABILITY, QuantityKinds.MAGNETIC_CONSTANT))));
        UNITS_BY_NAME.put("nanometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanometre"), "nanometre", "nanometre"), Optional.of("nm"), Optional.of("C45"), Optional.of("metre"), Optional.of("10\u207b\u2079 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.RADIUS))));
        UNITS_BY_NAME.put("nanoohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanoohm"), "nanoohm", "nanoohm"), Optional.of("n\u2126"), Optional.of("P22"), Optional.of("ohm"), Optional.of("10\u207b\u2079 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.IMPEDANCE, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE))));
        UNITS_BY_NAME.put("nanoohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanoohmMetre"), "nanoohmMetre", "nanoohm metre"), Optional.of("n\u2126\u00b7m"), Optional.of("C46"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("nanosecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosecond"), "nanosecond", "nanosecond"), Optional.of("ns"), Optional.of("C47"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2079 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("nanosiemensPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosiemensPerCentimetre"), "nanosiemensPerCentimetre", "nanosiemens per centimetre"), Optional.of("nS/cm"), Optional.of("G44"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u2077 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("nanosiemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosiemensPerMetre"), "nanosiemensPerMetre", "nanosiemens per metre"), Optional.of("nS/m"), Optional.of("G45"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u2079 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("nanosievertPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosievertPerHour"), "nanosievertPerHour", "nanosievert per hour"), Optional.of("nSv/h"), Optional.of("P73"), Optional.of("sievertPerSecond"), Optional.of("0.277777778 \u00d7 10\u207b\u00b9\u00b3 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("nanosievertPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosievertPerMinute"), "nanosievertPerMinute", "nanosievert per minute"), Optional.of("nSv/min"), Optional.of("P77"), Optional.of("sievertPerSecond"), Optional.of("1.666666667 \u00d7 10\u207b\u00b9\u00b9 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("nanosievertPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanosievertPerSecond"), "nanosievertPerSecond", "nanosievert per second"), Optional.of("nSv/s"), Optional.of("P68"), Optional.of("sievertPerSecond"), Optional.of("10\u207b\u2079 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("nanotesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanotesla"), "nanotesla", "nanotesla"), Optional.of("nT"), Optional.of("C48"), Optional.of("tesla"), Optional.of("10\u207b\u2079 T"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("nanowatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nanowatt"), "nanowatt", "nanowatt"), Optional.of("nW"), Optional.of("C49"), Optional.of("watt"), Optional.of("10\u207b\u2079 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACTIVE_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("naturalUnitOfInformation", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "naturalUnitOfInformation"), "naturalUnitOfInformation", "natural unit of information"), Optional.of("nat"), Optional.of("Q16"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("naturalUnitOfInformationPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "naturalUnitOfInformationPerSecond"), "naturalUnitOfInformationPerSecond", "natural unit of information per second"), Optional.of("nat/s"), Optional.of("Q19"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("nauticalMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nauticalMile"), "nauticalMile", "nautical mile"), Optional.of("n mile"), Optional.of("NMI"), Optional.of("metre"), Optional.of("1852 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.HEIGHT, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH_OF_PATH))));
        UNITS_BY_NAME.put("neper", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "neper"), "neper", "neper"), Optional.of("Np"), Optional.of("C50"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LOGARITHMIC_DECREMENT, QuantityKinds.LEVEL_OF_A_POWER_QUANTITY, QuantityKinds.LEVEL_OF_A_FIELD_QUANTITY))));
        UNITS_BY_NAME.put("neperPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "neperPerSecond"), "neperPerSecond", "neper per second"), Optional.of("Np/s"), Optional.of("C51"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DAMPING_COEFFICIENT))));
        UNITS_BY_NAME.put("netKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "netKilogram"), "netKilogram", "net kilogram"), Optional.empty(), Optional.of("58"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("netTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "netTon"), "netTon", "net ton"), Optional.empty(), Optional.of("NT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("newton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newton"), "newton", "newton"), Optional.of("N"), Optional.of("NEW"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("newtonCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonCentimetre"), "newtonCentimetre", "newton centimetre"), Optional.of("N\u00b7cm"), Optional.of("F88"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetre"), "newtonMetre", "newton metre"), Optional.of("N\u00b7m"), Optional.of("NU"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetrePerAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerAmpere"), "newtonMetrePerAmpere", "newton metre per ampere"), Optional.of("N\u00b7m/A"), Optional.of("F90"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetrePerDegree", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerDegree"), "newtonMetrePerDegree", "newton metre per degree"), Optional.of("Nm/\u00b0"), Optional.of("F89"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerKilogram"), "newtonMetrePerKilogram", "newton metre per kilogram"), Optional.of("N\u00b7m/kg"), Optional.of("G19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetrePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerMetre"), "newtonMetrePerMetre", "newton metre per metre"), Optional.of("N\u00b7m/m\u00b2"), Optional.of("Q27"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("newtonMetrePerRadian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerRadian"), "newtonMetrePerRadian", "newton metre per radian"), Optional.of("N\u00b7m/rad"), Optional.of("M93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonMetrePerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetrePerSquareMetre"), "newtonMetrePerSquareMetre", "newton metre per square metre"), Optional.of("N\u00b7m/m\u00b2"), Optional.of("M34"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORSIONAL_STIFFNESS, QuantityKinds.AREA_RELATED_TORSIONAL_MOMENT))));
        UNITS_BY_NAME.put("newtonMetreSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetreSecond"), "newtonMetreSecond", "newton metre second"), Optional.of("N\u00b7m\u00b7s"), Optional.of("C53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_IMPULSE))));
        UNITS_BY_NAME.put("newtonMetreSquaredPerKilogramSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetreSquaredPerKilogramSquared"), "newtonMetreSquaredPerKilogramSquared", "newton metre squared per kilogram squared"), Optional.of("N\u00b7m\u00b2/kg\u00b2"), Optional.of("C54"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GRAVITATIONAL_CONSTANT))));
        UNITS_BY_NAME.put("newtonMetreWattToThePowerMinus0point5", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonMetreWattToThePowerMinus0point5"), "newtonMetreWattToThePowerMinus0point5", "newton metre watt to the power minus 0,5"), Optional.of("N\u00b7m\u00b7W\u207b\u2070\u2027\u2075"), Optional.of("H41"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonPerAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerAmpere"), "newtonPerAmpere", "newton per ampere"), Optional.of("N/A"), Optional.of("H40"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerCentimetre"), "newtonPerCentimetre", "newton per centimetre"), Optional.of("N/cm"), Optional.of("M23"), Optional.of("newtonPerMetre"), Optional.of("10\u00b2 N/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION, QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("newtonPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerMetre"), "newtonPerMetre", "newton per metre"), Optional.of("N/m"), Optional.of("4P"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("newtonPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerMillimetre"), "newtonPerMillimetre", "newton per millimetre"), Optional.of("N/mm"), Optional.of("F47"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("newtonPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerSquareCentimetre"), "newtonPerSquareCentimetre", "newton per square centimetre"), Optional.of("N/cm\u00b2"), Optional.of("E01"), Optional.of("pascal"), Optional.of("10\u2074 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("newtonPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerSquareMetre"), "newtonPerSquareMetre", "newton per square metre"), Optional.of("N/m\u00b2"), Optional.of("C55"), Optional.of("pascal"), Optional.of("Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS))));
        UNITS_BY_NAME.put("newtonPerSquareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonPerSquareMillimetre"), "newtonPerSquareMillimetre", "newton per square millimetre"), Optional.of("N/mm\u00b2"), Optional.of("C56"), Optional.of("pascal"), Optional.of("10\u2076 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("newtonSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonSecond"), "newtonSecond", "newton second"), Optional.of("N\u00b7s"), Optional.of("C57"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPULSE))));
        UNITS_BY_NAME.put("newtonSecondPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonSecondPerMetre"), "newtonSecondPerMetre", "newton second per metre"), Optional.of("N\u00b7s/m"), Optional.of("C58"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MECHANICAL_IMPEDANCE))));
        UNITS_BY_NAME.put("newtonSecondPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonSecondPerSquareMetre"), "newtonSecondPerSquareMetre", "newton second per square metre"), Optional.of("(N/m\u00b2)\u00b7s"), Optional.of("N36"), Optional.of("pascalSecond"), Optional.of("Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("newtonSquareMetrePerAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "newtonSquareMetrePerAmpere"), "newtonSquareMetrePerAmpere", "newton square metre per ampere"), Optional.of("N\u00b7m\u00b2/A"), Optional.of("P49"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_DIPOLE_MOMENT))));
        UNITS_BY_NAME.put("nil", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "nil"), "nil", "nil"), Optional.of("()"), Optional.of("NIL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfArticles", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfArticles"), "numberOfArticles", "number of articles"), Optional.empty(), Optional.of("NAR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfCells", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfCells"), "numberOfCells", "number of cells"), Optional.empty(), Optional.of("NCL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfInternationalUnits", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfInternationalUnits"), "numberOfInternationalUnits", "number of international units"), Optional.empty(), Optional.of("NIU"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfJewels", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfJewels"), "numberOfJewels", "number of jewels"), Optional.empty(), Optional.of("JWL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfPacks", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfPacks"), "numberOfPacks", "number of packs"), Optional.empty(), Optional.of("NMP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfParts", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfParts"), "numberOfParts", "number of parts"), Optional.empty(), Optional.of("NPT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("numberOfWords", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "numberOfWords"), "numberOfWords", "number of words"), Optional.empty(), Optional.of("D68"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("octave", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "octave"), "octave", "octave"), Optional.empty(), Optional.of("C59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY_INTERVAL))));
        UNITS_BY_NAME.put("octet", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "octet"), "octet", "octet"), Optional.of("o"), Optional.of("Q12"), Optional.of("bit"), Optional.of("8 bit"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("octetPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "octetPerSecond"), "octetPerSecond", "octet per second"), Optional.of("o/s"), Optional.of("Q13"), Optional.of("bitPerSecond"), Optional.of("8 bit/s"), Collections.emptySet()));
        UNITS_BY_NAME.put("ohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohm"), "ohm", "ohm"), Optional.of("\u2126"), Optional.of("OHM"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("ohmCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmCentimetre"), "ohmCentimetre", "ohm centimetre"), Optional.of("\u2126\u00b7cm"), Optional.of("C60"), Optional.of("ohmMetre"), Optional.of("10\u207b\u00b2 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY, QuantityKinds.RESISTIVITY))));
        UNITS_BY_NAME.put("ohmCircularMilPerFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmCircularMilPerFoot"), "ohmCircularMilPerFoot", "ohm circular-mil per foot"), Optional.of("\u2126\u00b7cmil/ft"), Optional.of("P23"), Optional.of("ohmMetre"), Optional.of("1.662426 \u00d7 10\u207b\u2079 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY))));
        UNITS_BY_NAME.put("ohmKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmKilometre"), "ohmKilometre", "ohm kilometre"), Optional.of("\u2126\u00b7km"), Optional.of("M24"), Optional.of("ohmMetre"), Optional.of("10\u00b3 \u2126 \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY))));
        UNITS_BY_NAME.put("ohmMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmMetre"), "ohmMetre", "ohm metre"), Optional.of("\u2126\u00b7m"), Optional.of("C61"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RESISTIVITY, QuantityKinds.RESIDUAL_RESISTIVITY))));
        UNITS_BY_NAME.put("ohmPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmPerKilometre"), "ohmPerKilometre", "ohm per kilometre"), Optional.of("\u2126/km"), Optional.of("F56"), Optional.of("ohmPerMetre"), Optional.of("10\u207b\u00b3 \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("ohmPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmPerMetre"), "ohmPerMetre", "ohm per metre"), Optional.of("\u2126/m"), Optional.of("H26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("ohmPerMileStatuteMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ohmPerMileStatuteMile"), "ohmPerMileStatuteMile", "ohm per mile (statute mile)"), Optional.of("\u2126/mi"), Optional.of("F55"), Optional.of("ohmPerMetre"), Optional.of("6.21371 \u00d7 10\u207b\u2074  \u2126/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEIC_RESISTANCE, QuantityKinds.LINEIC_RESISTANCE))));
        UNITS_BY_NAME.put("one", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "one"), "one", "one"), Optional.of("1"), Optional.of("C62"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.STATISTICAL_WEIGHT, QuantityKinds.FOURIER_NUMBER, QuantityKinds.NEUTRON_YIELD_PER_FISSION, QuantityKinds.NUMBER_OF_PAIRS_OF_POLES, QuantityKinds.PARTITION_FUNCTION_OF_A_MOLECULE, QuantityKinds.REFRACTIVE_INDEX, QuantityKinds.RELATIVE_DENSITY, QuantityKinds.RELATIVE_MASS_DEFECT, QuantityKinds.SPECTRAL_REFLECTIONFACTOR, QuantityKinds.MICROCANONICAL_PARTITION_FUNCTION, QuantityKinds.STANDARD_ABSOLUTE_ACTIVITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.NUMBER_OF_TURNS_IN_A_WINDING, QuantityKinds.TRANSMISSION_FACTOR, QuantityKinds.MOLE_FRACTION_OF_B, QuantityKinds.MACH_NUMBER, QuantityKinds.ACTIVITY_COEFFICIENT_OF_SOLUTE_B_ESPECIALLY_IN_A_DILUTE_SOLUTION, QuantityKinds.NUCLEON_NUMBER, QuantityKinds.RELATIVE_MASS_DENSITY, QuantityKinds.SPECTRAL_ABSORPTANCE, QuantityKinds.LEWIS_NUMBER, QuantityKinds.THERMAL_UTILIZATION_FACTOR, QuantityKinds.ORDER_OF_REFLEXION, QuantityKinds.SHEAR_STRAIN, QuantityKinds.LANDAU_GINZBURG_NUMBER, QuantityKinds.NUCLEAR_SPIN_QUANTUM_NUMBER, QuantityKinds.PACKING_FRACTION, QuantityKinds.TRANSPORT_NUMBER_OF_ION_B, QuantityKinds.ISENTROPIC_EXPONENT, QuantityKinds.PECLET_NUMBER, QuantityKinds.RELATIVE_ATOMIC_MASS, QuantityKinds.GRAND_PARTITION_FUNCTION, QuantityKinds.DIRECTIONAL_SPECTRAL_EMISSIVITY, QuantityKinds.NUSSELT_NUMBER_FOR_MASS_TRANSFER, QuantityKinds.SPECTRAL_EMISSIVITY, QuantityKinds.STANDARD_ABSOLUTE_ACTIVITY_OF_B_IN_A_LIQUID_OR_A_SOLID_MIXTURE, QuantityKinds.COEFFICIENT_OF_FRICTION, QuantityKinds.ORBITAL_ANGULAR_MOMENTUM_QUANTUM_NUMBER, QuantityKinds.SPIN_ANGULAR_MOMENTUM_QUANTUM_NUMBER, QuantityKinds.ABSORBANCE, QuantityKinds.REST_MASS_OF_NEUTRON, QuantityKinds.SCHMIDT_NUMBER, QuantityKinds.STOICHIOMETRIC_NUMBER_OF_B, QuantityKinds.INFINITE_MEDIUM_MULTIPLICATION_FACTOR, QuantityKinds.LINEAR_STRAIN, QuantityKinds.MAGNETIC_REYNOLDS_NUMBER, QuantityKinds.LUMINOUS_EFFICIENCY_AT_A_SPECIFIED_WAVELENGTH, QuantityKinds.GRASHOF_NUMBER, QuantityKinds.ALFVEN_NUMBER, QuantityKinds.GRAND_CANONICAL_PARTITION_FUNCTION, QuantityKinds.SPECTRAL_ABSORPTION_FACTOR, QuantityKinds.CHARGE_NUMBER_OF_ION, QuantityKinds.LEAKAGE_COEFFICIENT, QuantityKinds.MADELUNG_CONSTANT, QuantityKinds.G_FACTOR_OF_ATOM_OR_ELECTRON, QuantityKinds.SPECTRAL_TRANSMISSION_FACTOR, QuantityKinds.STANTON_NUMBER_FOR_MASS_TRANSFER, QuantityKinds.REYNOLDS_NUMBER, QuantityKinds.MAGNETIC_QUANTUM_NUMBER, QuantityKinds.RELATIVE_ELONGATION, QuantityKinds.RELATIVE_MOLECULAR_MASS, QuantityKinds.EMISSIVITY_AT_A_SPECIFIED_WAVELENGTH, QuantityKinds.FRICTION_FACTOR, QuantityKinds.REST_MASS_OF_ELECTRON, QuantityKinds.COORDINATES_TRICHROMATIC, QuantityKinds.COUPLING_COEFFICIENT, QuantityKinds.EULER_NUMBER, QuantityKinds.MOLE_RATIO_OF_SOLUTE_B, QuantityKinds.POISSON_NUMBER, QuantityKinds.AVERAGE_LOGARITHMIC_ENERGY_DECREMENT, QuantityKinds.NUMBER_OF_PHASES, QuantityKinds.DISSIPANCE, QuantityKinds.RAYLEIGH_NUMBER, QuantityKinds.DISSIPATION_FACTOR, QuantityKinds.DEGREE_OF_DISSOCIATION, QuantityKinds.INTERNAL_CONVERSION_FACTOR, QuantityKinds.ATOMIC_NUMBER, QuantityKinds.MASS_NUMBER, QuantityKinds.VOLUME_OR_BULK_STRAIN, QuantityKinds.ACTIVITY_COEFFICIENT_OF_B_IN_A_LIQUID_AS_A_SOLID_MIXTURE, QuantityKinds.OPTICAL_DENSITY, QuantityKinds.POISSON_RATIO, QuantityKinds.EFFECTIVE_MULTIPLICATION_FACTOR, QuantityKinds.STANDARD_ABSOLUTE_ACTIVITY_OF_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION, QuantityKinds.DEBYE_WALLE_FACTOR, QuantityKinds.REFLECTANCE, QuantityKinds.FAST_FISSION_FACTOR, QuantityKinds.STANDARD_EQUILIBRIUM_CONSTANT, QuantityKinds.RELATIVE_ACTIVITY_OF_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION, QuantityKinds.LUMINOUS_EFFICIENCY, QuantityKinds.THERMAL_DIFFUSION_FACTOR, QuantityKinds.RELATIVE_PERMITTIVITY, QuantityKinds.LONG_RANGE_ORDER_PARAMETER, QuantityKinds.RATIO_OF_THE_SPECIFIC_HEAT_CAPACITIES, QuantityKinds.COWLING_NUMBER, QuantityKinds.STANDARD_ABSOLUTE_ACTIVITY_OF_SOLUTE_B_ESPECIALLY_IN_A_DILUTE_SOLUTION, QuantityKinds.FINE_STRUCTURE_CONSTANT, QuantityKinds.SHORT_RANGE_ORDER_PARAMETER, QuantityKinds.WEBER_NUMBER, QuantityKinds.GRUENEISEN_PARAMETER, QuantityKinds.CANONICAL_PARTITION_FUNCTION, QuantityKinds.STANTON_NUMBER, QuantityKinds.RESONANCE_ESCAPE_PROBABILITY, QuantityKinds.SPECTRAL_TRANSMITTANCE, QuantityKinds.NUMBER_OF_MOLECULES_OR_OTHER_ELEMENTARY_ENTITIES, QuantityKinds.REST_MASS_OF_PROTON, QuantityKinds.SPECTRAL_RADIANCE_FACTOR, QuantityKinds.NEUTRON_YIELD_PER_ABSORPTION, QuantityKinds.NEUTRON_NUMBER, QuantityKinds.G_FACTOR_OF_NUCLEUS, QuantityKinds.REFLECTION_FACTOR, QuantityKinds.CURRENT_FRACTION_OF_ION_B, QuantityKinds.MULTIPLICATION_FACTOR, QuantityKinds.ABSORPTION_FACTOR, QuantityKinds.MOBILITY_RATIO, QuantityKinds.REACTIVITY, QuantityKinds.HYPERFINE_STRUCTURE_QUANTUM_NUMBER, QuantityKinds.GRASHOF_NUMBER_FOR_MASS_TRANSFER, QuantityKinds.PROTON_NUMBER, QuantityKinds.PRINCIPLE_QUANTUM_NUMBER, QuantityKinds.ACTIVITY_OF_SOLVENT_A, QuantityKinds.BINDING_FRACTION, QuantityKinds.SPECTRAL_LUMINOUS_EFFICIENCY, QuantityKinds.NON_LEAKAGE_PROBABILITY, QuantityKinds.NUSSELT_NUMBER, QuantityKinds.PRANDTL_NUMBER, QuantityKinds.RELATIVE_MASS_EXCESS, QuantityKinds.KNUDSEN_NUMBER, QuantityKinds.THERMAL_DIFFUSION_RATIO, QuantityKinds.OSMOTIC_COEFFICIENT_OF_THE_SOLVENT_A_ESPECIALLY_IN_A_DILUTE_SOLUTION, QuantityKinds.CIE_COLORIMETRIC_FUNCTIONS, QuantityKinds.RELATIVE_PERMEABILITY, QuantityKinds.RATIO_OF_THE_MASSIC_HEAT_CAPACITY, QuantityKinds.MOLECULAR_PARTITION_FUNCTION, QuantityKinds.ELECTRIC_SUSCEPTIBILITY, QuantityKinds.FOURIER_NUMBER_FOR_MASS_TRANSFER, QuantityKinds.EMISSIVITY, QuantityKinds.LETHARGY, QuantityKinds.MAGNETIC_SUSCEPTIBILITY, QuantityKinds.PECLET_NUMBER_FOR_MASS_TRANSFER, QuantityKinds.STROUHAL_NUMBER, QuantityKinds.ABSOLUTE_ACTIVITY, QuantityKinds.TOTAL_ANGULAR_MOMENTUM_QUANTUM_NUMBER, QuantityKinds.TRANSMITTANCE, QuantityKinds.SPECTRAL_REFLECTANCE, QuantityKinds.HARTMANN_NUMBER, QuantityKinds.FROUDE_NUMBER))));
        UNITS_BY_NAME.put("onePerOne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "onePerOne"), "onePerOne", "one per one"), Optional.of("1/1"), Optional.of("Q26"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ounceAvoirdupois", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupois"), "ounceAvoirdupois", "ounce (avoirdupois)"), Optional.of("oz"), Optional.of("ONZ"), Optional.of("kilogram"), Optional.of("2.834952 \u00d7 10\u207b\u00b2 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("ounceAvoirdupoisForce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisForce"), "ounceAvoirdupoisForce", "ounce (avoirdupois)-force"), Optional.of("ozf"), Optional.of("L40"), Optional.of("newton"), Optional.of("0.2780139 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisForceInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisForceInch"), "ounceAvoirdupoisForceInch", "ounce (avoirdupois)-force inch"), Optional.of("ozf\u00b7in"), Optional.of("L41"), Optional.of("newtonMetre"), Optional.of("7.061552 \u00d7 10\u207b\u00b3 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerCubicInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerCubicInch"), "ounceAvoirdupoisPerCubicInch", "ounce (avoirdupois) per cubic inch"), Optional.of("oz/in\u00b3"), Optional.of("L39"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.729994 \u00d7 10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerCubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerCubicYard"), "ounceAvoirdupoisPerCubicYard", "ounce (avoirdupois) per cubic yard"), Optional.of("oz/yd\u00b3"), Optional.of("G32"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerDay"), "ounceAvoirdupoisPerDay", "ounce (avoirdupois) per day"), Optional.of("oz/d"), Optional.of("L33"), Optional.of("kilogramPerSecond"), Optional.of("3.281194 \u00d7 10\u207b\u2077kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerGallonUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerGallonUk"), "ounceAvoirdupoisPerGallonUk", "ounce (avoirdupois) per gallon (UK)"), Optional.of("oz/gal (UK)"), Optional.of("L37"), Optional.of("kilogramPerCubicMetre"), Optional.of("6.236023 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerGallonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerGallonUs"), "ounceAvoirdupoisPerGallonUs", "ounce (avoirdupois) per gallon (US)"), Optional.of("oz/gal (US)"), Optional.of("L38"), Optional.of("kilogramPerCubicMetre"), Optional.of("7.489152 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerHour"), "ounceAvoirdupoisPerHour", "ounce (avoirdupois) per hour"), Optional.of("oz/h"), Optional.of("L34"), Optional.of("kilogramPerSecond"), Optional.of("7.874867 \u00d7 10\u207b\u2076 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerMinute"), "ounceAvoirdupoisPerMinute", "ounce (avoirdupois) per minute"), Optional.of("oz/min"), Optional.of("L35"), Optional.of("kilogramPerSecond"), Optional.of("4.72492 \u00d7 10\u207b\u2074 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerSecond"), "ounceAvoirdupoisPerSecond", "ounce (avoirdupois) per second"), Optional.of("oz/s"), Optional.of("L36"), Optional.of("kilogramPerSecond"), Optional.of("2.834952 \u00d7 10\u207b\u00b2 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceAvoirdupoisPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceAvoirdupoisPerSquareInch"), "ounceAvoirdupoisPerSquareInch", "ounce (avoirdupois) per square inch"), Optional.of("oz/in\u00b2"), Optional.of("N22"), Optional.of("kilogramPerSquareMetre"), Optional.of("4.394185 \u00d7 10 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("ounceFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceFoot"), "ounceFoot", "ounce foot"), Optional.of("oz\u00b7ft"), Optional.of("4R"), Optional.of("kilogramMetre"), Optional.of("8.640934 \u00d7 10\u207b\u00b3 kg \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("ounceInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceInch"), "ounceInch", "ounce inch"), Optional.of("oz\u00b7in"), Optional.of("4Q"), Optional.of("kilogramMetre"), Optional.of("7.200778 \u00d7 10\u207b\u2074 kg \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("ouncePerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ouncePerSquareFoot"), "ouncePerSquareFoot", "ounce per square foot"), Optional.of("oz/ft\u00b2"), Optional.of("37"), Optional.of("kilogramPerSquareMetre"), Optional.of("0.3051517 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("ouncePerSquareFootPer0point01inch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ouncePerSquareFootPer0point01inch"), "ouncePerSquareFootPer0point01inch", "ounce per square foot per 0,01inch"), Optional.of("oz/(ft\u00b2/cin)"), Optional.of("38"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ouncePerSquareYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ouncePerSquareYard"), "ouncePerSquareYard", "ounce per square yard"), Optional.of("oz/yd\u00b2"), Optional.of("ON"), Optional.of("kilogramPerSquareMetre"), Optional.of("3.390575 \u00d7 10\u207b\u00b2 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_DENSITY, QuantityKinds.AREIC_MASS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("ounceUkFluidPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUkFluidPerDay"), "ounceUkFluidPerDay", "ounce (UK fluid) per day"), Optional.of("fl oz (UK)/d"), Optional.of("J95"), Optional.of("cubicMetrePerSecond"), Optional.of("3.288549 \u00d7 10\u207b\u00b9\u2070 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUkFluidPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUkFluidPerHour"), "ounceUkFluidPerHour", "ounce (UK fluid) per hour"), Optional.of("fl oz (UK)/h"), Optional.of("J96"), Optional.of("cubicMetrePerSecond"), Optional.of("7.892517 \u00d7 10\u207b\u2079 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUkFluidPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUkFluidPerMinute"), "ounceUkFluidPerMinute", "ounce (UK fluid) per minute"), Optional.of("fl oz (UK)/min"), Optional.of("J97"), Optional.of("cubicMetrePerSecond"), Optional.of("4.73551 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUkFluidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUkFluidPerSecond"), "ounceUkFluidPerSecond", "ounce (UK fluid) per second"), Optional.of("fl oz (UK)/s"), Optional.of("J98"), Optional.of("cubicMetrePerSecond"), Optional.of("2.841306 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUsFluidPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUsFluidPerDay"), "ounceUsFluidPerDay", "ounce (US fluid) per day"), Optional.of("fl oz (US)/d"), Optional.of("J99"), Optional.of("cubicMetrePerSecond"), Optional.of("3.422862 \u00d7 10\u207b\u00b9\u2070 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUsFluidPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUsFluidPerHour"), "ounceUsFluidPerHour", "ounce (US fluid) per hour"), Optional.of("fl oz (US)/h"), Optional.of("K10"), Optional.of("cubicMetrePerSecond"), Optional.of("8.214869 \u00d7 10\u207b\u2079 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUsFluidPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUsFluidPerMinute"), "ounceUsFluidPerMinute", "ounce (US fluid) per minute"), Optional.of("fl oz (US)/min"), Optional.of("K11"), Optional.of("cubicMetrePerSecond"), Optional.of("4.928922 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("ounceUsFluidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ounceUsFluidPerSecond"), "ounceUsFluidPerSecond", "ounce (US fluid) per second"), Optional.of("fl oz (US)/s"), Optional.of("K12"), Optional.of("cubicMetrePerSecond"), Optional.of("2.957353 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
    }

    private static void init12() {
        UNITS_BY_NAME.put("outfit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "outfit"), "outfit", "outfit"), Optional.empty(), Optional.of("11"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("overtimeHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "overtimeHour"), "overtimeHour", "overtime hour"), Optional.empty(), Optional.of("OT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ozoneDepletionEquivalent", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ozoneDepletionEquivalent"), "ozoneDepletionEquivalent", "ozone depletion equivalent"), Optional.empty(), Optional.of("ODE"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pad"), "pad", "pad"), Optional.empty(), Optional.of("PD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("page", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "page"), "page", "page"), Optional.empty(), Optional.of("ZP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pageFacsimile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pageFacsimile"), "pageFacsimile", "page - facsimile"), Optional.empty(), Optional.of("QA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pageHardcopy", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pageHardcopy"), "pageHardcopy", "page - hardcopy"), Optional.empty(), Optional.of("QB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pagePerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pagePerInch"), "pagePerInch", "page per inch"), Optional.of("ppi"), Optional.of("PQ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pair", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pair"), "pair", "pair"), Optional.empty(), Optional.of("PR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("panel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "panel"), "panel", "panel"), Optional.empty(), Optional.of("OA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("parsec", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "parsec"), "parsec", "parsec"), Optional.of("pc"), Optional.of("C63"), Optional.of("metre"), Optional.of("3.085678 \u00d7 10\u00b9\u2076 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DISTANCE, QuantityKinds.THICKNESS, QuantityKinds.BREADTH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("partPerBillionUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerBillionUs"), "partPerBillionUs", "part per billion (US)"), Optional.of("ppb"), Optional.of("61"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("partPerHundredThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerHundredThousand"), "partPerHundredThousand", "part per hundred thousand"), Optional.of("ppht"), Optional.of("E40"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("partPerMillion", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerMillion"), "partPerMillion", "part per million"), Optional.of("ppm"), Optional.of("59"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("partPerQuadrillionUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerQuadrillionUs"), "partPerQuadrillionUs", "Part per quadrillion (US)"), Optional.of("ppq"), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("partPerThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerThousand"), "partPerThousand", "part per thousand"), Optional.of("\u2030"), Optional.of("NX"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("partPerTrillionUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "partPerTrillionUs"), "partPerTrillionUs", "part per trillion (US)"), Optional.of("ppt"), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascal"), "pascal", "pascal"), Optional.of("Pa"), Optional.of("PAL"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("pascalCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalCubicMetrePerSecond"), "pascalCubicMetrePerSecond", "pascal cubic metre per second"), Optional.of("Pa\u00b7m\u00b3/s"), Optional.of("G01"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY))));
        UNITS_BY_NAME.put("pascalLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalLitrePerSecond"), "pascalLitrePerSecond", "pascal litre per second"), Optional.of("Pa\u00b7l/s"), Optional.of("F99"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS))));
        UNITS_BY_NAME.put("pascalPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalPerBar"), "pascalPerBar", "pascal per bar"), Optional.of("Pa/bar"), Optional.of("F07"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("pascalPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalPerKelvin"), "pascalPerKelvin", "pascal per kelvin"), Optional.of("Pa/K"), Optional.of("C64"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_COEFFICIENT))));
        UNITS_BY_NAME.put("pascalPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalPerMetre"), "pascalPerMetre", "pascal per metre"), Optional.of("Pa/m"), Optional.of("H42"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("pascalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecond"), "pascalSecond", "pascal second"), Optional.of("Pa\u00b7s"), Optional.of("C65"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("pascalSecondPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecondPerBar"), "pascalSecondPerBar", "pascal second per bar"), Optional.of("Pa\u00b7s/bar"), Optional.of("H07"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2075 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("pascalSecondPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecondPerCubicMetre"), "pascalSecondPerCubicMetre", "pascal second per cubic metre"), Optional.of("Pa\u00b7s/m\u00b3"), Optional.of("C66"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACOUSTIC_IMPEDANCE))));
        UNITS_BY_NAME.put("pascalSecondPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecondPerKelvin"), "pascalSecondPerKelvin", "pascal second per kelvin"), Optional.of("Pa.s/K"), Optional.of("F77"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION))));
        UNITS_BY_NAME.put("pascalSecondPerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecondPerLitre"), "pascalSecondPerLitre", "pascal second per litre"), Optional.of("Pa\u00b7s/l"), Optional.of("M32"), Optional.of("pascalSecondPerCubicMetre"), Optional.of("10\u00b3 Pa \u00d7 s/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACOUSTIC_IMPEDANCE, QuantityKinds.ACOUSTIC_IMPEDANCE))));
        UNITS_BY_NAME.put("pascalSecondPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSecondPerMetre"), "pascalSecondPerMetre", "pascal second per metre"), Optional.of("Pa\u00b7 s/m"), Optional.of("C67"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CHARACTERISTIC_IMPEDANCE_OF_A_MEDIUM))));
        UNITS_BY_NAME.put("pascalSquareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSquareMetrePerKilogram"), "pascalSquareMetrePerKilogram", "pascal square metre per kilogram"), Optional.of("Pa/(kg/m\u00b2)"), Optional.of("P79"), Optional.of("metrePerSecondSquared"), Optional.of("m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BURST_INDEX, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("pascalSquaredSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalSquaredSecond"), "pascalSquaredSecond", "pascal squared second"), Optional.of("Pa\u00b2\u00b7s"), Optional.of("P42"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_EXPOSURE))));
        UNITS_BY_NAME.put("pascalToThePowerSumOfStoichiometricNumbers", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pascalToThePowerSumOfStoichiometricNumbers"), "pascalToThePowerSumOfStoichiometricNumbers", "pascal to the power sum of stoichiometric numbers"), Optional.of("Pa\u03a3\u03bdB"), Optional.of("P98"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pebibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pebibitPerCubicMetre"), "pebibitPerCubicMetre", "pebibit per cubic metre"), Optional.of("Pibit/m\u00b3"), Optional.of("E82"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pebibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pebibitPerMetre"), "pebibitPerMetre", "pebibit per metre"), Optional.of("Pibit/m"), Optional.of("E80"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pebibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pebibitPerSquareMetre"), "pebibitPerSquareMetre", "pebibit per square metre"), Optional.of("Pibit/m\u00b2"), Optional.of("E81"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pebibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pebibyte"), "pebibyte", "pebibyte"), Optional.of("PiB"), Optional.of("E60"), Optional.of("byte"), Optional.of("2\u2075\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("peck", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peck"), "peck", "peck"), Optional.of("pk (US)"), Optional.of("G23"), Optional.of("cubicMetre"), Optional.of("8.809768 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("peckUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUk"), "peckUk", "peck (UK)"), Optional.of("pk (UK)"), Optional.of("L43"), Optional.of("cubicMetre"), Optional.of("9.092181 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("peckUkPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUkPerDay"), "peckUkPerDay", "peck (UK) per day"), Optional.of("pk (UK)/d"), Optional.of("L44"), Optional.of("cubicMetrePerSecond"), Optional.of("1.052336 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUkPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUkPerHour"), "peckUkPerHour", "peck (UK) per hour"), Optional.of("pk (UK)/h"), Optional.of("L45"), Optional.of("cubicMetrePerSecond"), Optional.of("2.525606 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUkPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUkPerMinute"), "peckUkPerMinute", "peck (UK) per minute"), Optional.of("pk (UK)/min"), Optional.of("L46"), Optional.of("cubicMetrePerSecond"), Optional.of("1.5153635 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUkPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUkPerSecond"), "peckUkPerSecond", "peck (UK) per second"), Optional.of("pk (UK)/s"), Optional.of("L47"), Optional.of("cubicMetrePerSecond"), Optional.of("9.092181 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUsDryPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUsDryPerDay"), "peckUsDryPerDay", "peck (US dry) per day"), Optional.of("pk (US dry)/d"), Optional.of("L48"), Optional.of("cubicMetrePerSecond"), Optional.of("1.019649 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUsDryPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUsDryPerHour"), "peckUsDryPerHour", "peck (US dry) per hour"), Optional.of("pk (US dry)/h"), Optional.of("L49"), Optional.of("cubicMetrePerSecond"), Optional.of("2.447158 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUsDryPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUsDryPerMinute"), "peckUsDryPerMinute", "peck (US dry) per minute"), Optional.of("pk (US dry)/min"), Optional.of("L50"), Optional.of("cubicMetrePerSecond"), Optional.of("1.468295 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("peckUsDryPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "peckUsDryPerSecond"), "peckUsDryPerSecond", "peck (US dry) per second"), Optional.of("pk (US dry)/s"), Optional.of("L51"), Optional.of("cubicMetrePerSecond"), Optional.of("8.809768 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("penCalorie", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "penCalorie"), "penCalorie", "pen calorie"), Optional.empty(), Optional.of("N1"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("penGramProtein", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "penGramProtein"), "penGramProtein", "pen gram (protein)"), Optional.empty(), Optional.of("D23"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pennyweight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pennyweight"), "pennyweight", "pennyweight"), Optional.empty(), Optional.of("DWT"), Optional.of("gram"), Optional.of("1.555174 g"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("perMillePerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "perMillePerPsi"), "perMillePerPsi", "per mille per psi"), Optional.of("\u2030/psi"), Optional.of("J12"), Optional.of("reciprocalPascalOrPascalToThePowerMinusOne"), Optional.of("1.450377 \u00d7 10\u207b\u2077 Pa\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ISOTHERMAL_COMPRESSIBILITY, QuantityKinds.COMPRESSIBILITY, QuantityKinds.BULK_COMPRESSIBILITY, QuantityKinds.ISENTROPIC_COMPRESSIBILITY))));
        UNITS_BY_NAME.put("percent", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percent"), "percent", "percent"), Optional.of("%"), Optional.of("P1"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DIMENSIONLESS))));
        UNITS_BY_NAME.put("percentPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerBar"), "percentPerBar", "percent per bar"), Optional.of("%/bar"), Optional.of("H96"), Optional.of("reciprocalPascalOrPascalToThePowerMinusOne"), Optional.of("10\u207b\u2077 Pa\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ISOTHERMAL_COMPRESSIBILITY, QuantityKinds.COMPRESSIBILITY, QuantityKinds.BULK_COMPRESSIBILITY, QuantityKinds.ISENTROPIC_COMPRESSIBILITY))));
        UNITS_BY_NAME.put("percentPerDecakelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerDecakelvin"), "percentPerDecakelvin", "percent per decakelvin"), Optional.of("%/daK"), Optional.of("H73"), Optional.of("reciprocalKelvinOrKelvinToThePowerMinusOne"), Optional.of("10\u207b\u00b3 K\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT))));
        UNITS_BY_NAME.put("percentPerDegree", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerDegree"), "percentPerDegree", "percent per degree"), Optional.of("%/\u00b0"), Optional.of("H90"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerDegreeCelsius"), "percentPerDegreeCelsius", "percent per degree Celsius"), Optional.of("%/\u00b0C"), Optional.of("M25"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerHectobar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerHectobar"), "percentPerHectobar", "percent per hectobar"), Optional.of("%/hbar"), Optional.of("H72"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerHundred", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerHundred"), "percentPerHundred", "percent per hundred"), Optional.of("%/100"), Optional.of("H93"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerInch"), "percentPerInch", "percent per inch"), Optional.of("%/in"), Optional.of("H98"), Optional.of("reciprocalMetre"), Optional.of("0.3937008 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("percentPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerKelvin"), "percentPerKelvin", "percent per kelvin"), Optional.of("%/K"), Optional.of("H25"), Optional.of("reciprocalKelvinOrKelvinToThePowerMinusOne"), Optional.of("10\u207b\u00b2 K\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT))));
        UNITS_BY_NAME.put("percentPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerMetre"), "percentPerMetre", "percent per metre"), Optional.of("%/m"), Optional.of("H99"), Optional.of("reciprocalMetre"), Optional.of("10\u207b\u00b2 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("percentPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerMillimetre"), "percentPerMillimetre", "percent per millimetre"), Optional.of("%/mm"), Optional.of("J10"), Optional.of("reciprocalMetre"), Optional.of("10 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("percentPerMonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerMonth"), "percentPerMonth", "percent per month"), Optional.of("%/mo"), Optional.of("H71"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerOhm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerOhm"), "percentPerOhm", "percent per ohm"), Optional.of("%/\u2126"), Optional.of("H89"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerOneHundredThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerOneHundredThousand"), "percentPerOneHundredThousand", "percent per one hundred thousand"), Optional.of("%/100000"), Optional.of("H92"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerTenThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerTenThousand"), "percentPerTenThousand", "percent per ten thousand"), Optional.of("%/10000"), Optional.of("H91"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerThousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerThousand"), "percentPerThousand", "percent per thousand"), Optional.of("%/1000"), Optional.of("H94"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentPerVolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentPerVolt"), "percentPerVolt", "percent per volt"), Optional.of("%/V"), Optional.of("H95"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentVolume", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentVolume"), "percentVolume", "percent volume"), Optional.empty(), Optional.of("VP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("percentWeight", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "percentWeight"), "percentWeight", "percent weight"), Optional.empty(), Optional.of("60"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("perm0Degreesc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "perm0Degreesc"), "perm0Degreesc", "perm (0 \u00b0C)"), Optional.of("perm (0 \u00b0C)"), Optional.of("P91"), Optional.of("kilogramPerSquareMetrePascalSecond"), Optional.of("5.72135 \u00d7 10\u207b\u00b9\u00b9 kg/(m\u00b2 \u00d7 Pa \u00d7 s)"), Collections.emptySet()));
        UNITS_BY_NAME.put("perm23Degreesc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "perm23Degreesc"), "perm23Degreesc", "perm (23 \u00b0C)"), Optional.of("perm (23 \u00b0C)"), Optional.of("P92"), Optional.of("kilogramPerSquareMetrePascalSecond"), Optional.of("5.74525 \u00d7 10\u207b\u00b9\u00b9 kg/(m\u00b2 \u00d7 Pa \u00d7 s)"), Collections.emptySet()));
        UNITS_BY_NAME.put("person", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "person"), "person", "person"), Optional.empty(), Optional.of("IE"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("petabit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "petabit"), "petabit", "petabit"), Optional.of("Pbit"), Optional.of("E78"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("petabitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "petabitPerSecond"), "petabitPerSecond", "petabit per second"), Optional.of("Pbit/s"), Optional.of("E79"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("petabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "petabyte"), "petabyte", "petabyte"), Optional.of("Pbyte"), Optional.of("E36"), Optional.of("byte"), Optional.of("10\u00b9\u2075 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("petajoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "petajoule"), "petajoule", "petajoule"), Optional.of("PJ"), Optional.of("C68"), Optional.of("joule"), Optional.of("10\u00b9\u2075 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.WORK, QuantityKinds.ENERGY))));
        UNITS_BY_NAME.put("pferdestaerke", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pferdestaerke"), "pferdestaerke", "Pferdestaerke"), Optional.of("PS"), Optional.of("N12"), Optional.of("watt"), Optional.of("7.354988 \u00d7 10\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER))));
        UNITS_BY_NAME.put("pfund", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pfund"), "pfund", "pfund"), Optional.of("pfd"), Optional.of("M86"), Optional.of("kilogram"), Optional.of("0.5 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("phon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "phon"), "phon", "phon"), Optional.empty(), Optional.of("C69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LOUDNESS_LEVEL))));
        UNITS_BY_NAME.put("phot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "phot"), "phot", "phot"), Optional.of("ph"), Optional.of("P26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ILLUMINANCE))));
        UNITS_BY_NAME.put("pica", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pica"), "pica", "pica"), Optional.empty(), Optional.of("R1"), Optional.of("metre"), Optional.of("4.217518 \u00d7 10\u207b\u00b3 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("picoampere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picoampere"), "picoampere", "picoampere"), Optional.of("pA"), Optional.of("C70"), Optional.of("ampere"), Optional.of("10\u207b\u00b9\u00b2 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETOMOTIVE_FORCE, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.MAGNETIC_POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_CURRENT, QuantityKinds.CURRENT_LINKAGE, QuantityKinds.MAGNETOMOTIVE_FORCE))));
        UNITS_BY_NAME.put("picocoulomb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picocoulomb"), "picocoulomb", "picocoulomb"), Optional.of("pC"), Optional.of("C71"), Optional.of("coulomb"), Optional.of("10\u207b\u00b9\u00b2 C"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELEMENTARY_CHARGE, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.ELECTRIC_CHARGE, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_FLUX_FLUX_OF_DISPLACEMENT, QuantityKinds.QUANTITY_OF_ELECTRICITY, QuantityKinds.ELECTRIC_CHARGE))));
        UNITS_BY_NAME.put("picofarad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picofarad"), "picofarad", "picofarad"), Optional.of("pF"), Optional.of("4T"), Optional.of("farad"), Optional.of("10\u207b\u00b9\u00b2 F"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CAPACITANCE, QuantityKinds.CAPACITANCE))));
        UNITS_BY_NAME.put("picofaradPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picofaradPerMetre"), "picofaradPerMetre", "picofarad per metre"), Optional.of("pF/m"), Optional.of("C72"), Optional.of("faradPerMetre"), Optional.of("10\u207b\u00b9\u00b2 F/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_CONSTANT, QuantityKinds.PERMITTIVITY, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY_OF_VACUUM, QuantityKinds.PERMITTIVITY, QuantityKinds.ELECTRIC_CONSTANT))));
        UNITS_BY_NAME.put("picohenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picohenry"), "picohenry", "picohenry"), Optional.of("pH"), Optional.of("C73"), Optional.of("henry"), Optional.of("10\u207b\u00b9\u00b2 H"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MUTUAL_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.SELF_INDUCTANCE, QuantityKinds.PERMEANCE, QuantityKinds.MUTUAL_INDUCTANCE))));
        UNITS_BY_NAME.put("picometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picometre"), "picometre", "picometre"), Optional.of("pm"), Optional.of("C52"), Optional.of("metre"), Optional.of("10\u207b\u00b9\u00b2 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.RADIUS, QuantityKinds.LENGTH, QuantityKinds.THICKNESS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("picopascalPerKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picopascalPerKilometre"), "picopascalPerKilometre", "picopascal per kilometre"), Optional.of("pPa/km"), Optional.of("H69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("picosecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picosecond"), "picosecond", "picosecond"), Optional.of("ps"), Optional.of("H70"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u00b9\u00b2 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("picosiemens", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picosiemens"), "picosiemens", "picosiemens"), Optional.of("pS"), Optional.of("N92"), Optional.of("siemens"), Optional.of("10\u207b\u00b9\u00b2 S"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE, QuantityKinds.ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.MODULUS_OF_ADMITTANCE))));
        UNITS_BY_NAME.put("picosiemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picosiemensPerMetre"), "picosiemensPerMetre", "picosiemens per metre"), Optional.of("pS/m"), Optional.of("L42"), Optional.of("siemensPerMetre"), Optional.of("10\u207b\u00b9\u00b2 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("picovolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picovolt"), "picovolt", "picovolt"), Optional.of("pV"), Optional.of("N99"), Optional.of("volt"), Optional.of("10\u207b\u00b9\u00b2 V"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL, QuantityKinds.VOLTAGE, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.TENSION, QuantityKinds.ELECTRIC_POTENTIAL))));
        UNITS_BY_NAME.put("picowatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picowatt"), "picowatt", "picowatt"), Optional.of("pW"), Optional.of("C75"), Optional.of("watt"), Optional.of("10\u207b\u00b9\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("picowattPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "picowattPerSquareMetre"), "picowattPerSquareMetre", "picowatt per square metre"), Optional.of("pW/m\u00b2"), Optional.of("C76"), Optional.of("wattPerSquareMetre"), Optional.of("10\u207b\u00b9\u00b2 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOUND_INTENSITY, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("piece", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "piece"), "piece", "piece"), Optional.empty(), Optional.of("H87"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ping", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ping"), "ping", "ping"), Optional.empty(), Optional.of("E19"), Optional.of("squareMetre"), Optional.of("3.305 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("pintUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUk"), "pintUk", "pint (UK)"), Optional.of("pt (UK)"), Optional.of("PTI"), Optional.of("cubicMetre"), Optional.of("5. 68261 \u00d7 10\u207b\u2074 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("pintUkPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUkPerDay"), "pintUkPerDay", "pint (UK) per day"), Optional.of("pt (UK)/d"), Optional.of("L53"), Optional.of("cubicMetrePerSecond"), Optional.of("6.577098 \u00d7 10\u207b\u2079 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUkPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUkPerHour"), "pintUkPerHour", "pint (UK) per hour"), Optional.of("pt (UK)/h"), Optional.of("L54"), Optional.of("cubicMetrePerSecond"), Optional.of("1.578504 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUkPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUkPerMinute"), "pintUkPerMinute", "pint (UK) per minute"), Optional.of("pt (UK)/min"), Optional.of("L55"), Optional.of("cubicMetrePerSecond"), Optional.of("9.471022 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
    }

    private static void init13() {
        UNITS_BY_NAME.put("pintUkPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUkPerSecond"), "pintUkPerSecond", "pint (UK) per second"), Optional.of("pt (UK)/s"), Optional.of("L56"), Optional.of("cubicMetrePerSecond"), Optional.of("5.682613 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUsLiquidPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUsLiquidPerDay"), "pintUsLiquidPerDay", "pint (US liquid) per day"), Optional.of("pt (US liq.)/d"), Optional.of("L57"), Optional.of("cubicMetrePerSecond"), Optional.of("5.476580 \u00d7 10\u207b\u2079 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUsLiquidPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUsLiquidPerHour"), "pintUsLiquidPerHour", "pint (US liquid) per hour"), Optional.of("pt (US liq.)/h"), Optional.of("L58"), Optional.of("cubicMetrePerSecond"), Optional.of("1.314379 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUsLiquidPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUsLiquidPerMinute"), "pintUsLiquidPerMinute", "pint (US liquid) per minute"), Optional.of("pt (US liq.)/min"), Optional.of("L59"), Optional.of("cubicMetrePerSecond"), Optional.of("7.886275 \u00d7 10\u207b\u2076 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pintUsLiquidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pintUsLiquidPerSecond"), "pintUsLiquidPerSecond", "pint (US liquid) per second"), Optional.of("pt (US liq.)/s"), Optional.of("L60"), Optional.of("cubicMetrePerSecond"), Optional.of("4.731765 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("pipelineJoint", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pipelineJoint"), "pipelineJoint", "pipeline joint"), Optional.empty(), Optional.of("JNT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pitch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pitch"), "pitch", "pitch"), Optional.empty(), Optional.of("PI"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("pixel", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pixel"), "pixel", "pixel"), Optional.empty(), Optional.of("E37"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("poise", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poise"), "poise", "poise"), Optional.of("P"), Optional.of("89"), Optional.of("pascalSecond"), Optional.of("0.1 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poisePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poisePerBar"), "poisePerBar", "poise per bar"), Optional.of("P/bar"), Optional.of("F06"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("poisePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poisePerKelvin"), "poisePerKelvin", "poise per kelvin"), Optional.of("P/K"), Optional.of("F86"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poisePerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poisePerPascal"), "poisePerPascal", "poise per pascal"), Optional.of("P/Pa"), Optional.of("N35"), Optional.of("secondUnitOfTime"), Optional.of("0.1 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("pond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pond"), "pond", "pond"), Optional.of("p"), Optional.of("M78"), Optional.of("newton"), Optional.of("9.80665 \u00d7 10\u207b\u00b3 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("pound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "pound"), "pound", "pound"), Optional.of("lb"), Optional.of("LBR"), Optional.of("kilogram"), Optional.of("0.45359237 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerCubicFootDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerCubicFootDegreeFahrenheit"), "poundAvoirdupoisPerCubicFootDegreeFahrenheit", "pound (avoirdupois) per cubic foot degree Fahrenheit"), Optional.of("(lb/ft\u00b3)/\u00b0F"), Optional.of("K69"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerCubicFootPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerCubicFootPsi"), "poundAvoirdupoisPerCubicFootPsi", "pound (avoirdupois) per cubic foot psi"), Optional.of("(lb/ft\u00b3)/psi"), Optional.of("K70"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerCubicInchDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerCubicInchDegreeFahrenheit"), "poundAvoirdupoisPerCubicInchDegreeFahrenheit", "pound (avoirdupois) per cubic inch degree Fahrenheit"), Optional.of("(lb/in\u00b3)/\u00b0F"), Optional.of("K75"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerCubicInchPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerCubicInchPsi"), "poundAvoirdupoisPerCubicInchPsi", "pound (avoirdupois) per cubic inch psi"), Optional.of("(lb/in\u00b3)/psi"), Optional.of("K76"), Optional.of("kilogramPerCubicMetrePascal"), Optional.of("4.014632 (kg/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerDay"), "poundAvoirdupoisPerDay", "pound (avoirdupois) per day"), Optional.of("lb/d"), Optional.of("K66"), Optional.of("kilogramPerSecond"), Optional.of("5.249912 \u00d7 10\u207b\u2076 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerDegreeFahrenheit"), "poundAvoirdupoisPerDegreeFahrenheit", "pound (avoirdupois) per degree Fahrenheit"), Optional.of("lb/\u00b0F"), Optional.of("K64"), Optional.of("kilogramPerKelvin"), Optional.of("0.8164663 kg/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerGallonUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerGallonUk"), "poundAvoirdupoisPerGallonUk", "pound (avoirdupois) per gallon (UK)"), Optional.of("lb/gal (UK)"), Optional.of("K71"), Optional.of("kilogramPerCubicMetre"), Optional.of("99.77637 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerHourDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerHourDegreeFahrenheit"), "poundAvoirdupoisPerHourDegreeFahrenheit", "pound (avoirdupois) per hour degree Fahrenheit"), Optional.of("(lb/h)/\u00b0F"), Optional.of("K73"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerHourPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerHourPsi"), "poundAvoirdupoisPerHourPsi", "pound (avoirdupois) per hour psi"), Optional.of("(lb/h)/psi"), Optional.of("K74"), Optional.of("kilogramPerSecondPascal"), Optional.of("1.827445 \u00d7 10\u207b\u2078 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerMinute"), "poundAvoirdupoisPerMinute", "pound (avoirdupois) per minute"), Optional.of("lb/min"), Optional.of("K78"), Optional.of("kilogramPerSecond"), Optional.of("7.559873 \u00d7 10\u207b\u00b3 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerMinuteDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerMinuteDegreeFahrenheit"), "poundAvoirdupoisPerMinuteDegreeFahrenheit", "pound (avoirdupois) per minute degree Fahrenheit"), Optional.of("lb/(min\u00b7\u00b0F)"), Optional.of("K79"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerMinutePsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerMinutePsi"), "poundAvoirdupoisPerMinutePsi", "pound (avoirdupois) per minute psi"), Optional.of("(lb/min)/psi"), Optional.of("K80"), Optional.of("kilogramPerSecondPascal"), Optional.of("1.096467 \u00d7 10\u207b\u2076 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerPsi"), "poundAvoirdupoisPerPsi", "pound (avoirdupois) per psi"), Optional.of("lb/psi"), Optional.of("K77"), Optional.of("kilogramPerPascal"), Optional.of("6.578802 \u00d7 10\u207b\u2075 kg/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerSecond"), "poundAvoirdupoisPerSecond", "pound (avoirdupois) per second"), Optional.of("lb/s"), Optional.of("K81"), Optional.of("kilogramPerSecond"), Optional.of("0.4535924 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerSecondDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerSecondDegreeFahrenheit"), "poundAvoirdupoisPerSecondDegreeFahrenheit", "pound (avoirdupois) per second degree Fahrenheit"), Optional.of("(lb/s)/\u00b0F"), Optional.of("K82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisPerSecondPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisPerSecondPsi"), "poundAvoirdupoisPerSecondPsi", "pound (avoirdupois) per second psi"), Optional.of("(lb/s)/psi"), Optional.of("K83"), Optional.of("kilogramPerSecondPascal"), Optional.of("6.578802 \u00d7 10\u207b\u2075 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundAvoirdupoisSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundAvoirdupoisSquareFoot"), "poundAvoirdupoisSquareFoot", "pound (avoirdupois) square foot"), Optional.of("lb\u00b7ft\u00b2"), Optional.of("K65"), Optional.of("kilogramMetreSquared"), Optional.of("4.214011 \u00d7 10\u207b\u00b2 kg \u00d7 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA, QuantityKinds.MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA))));
        UNITS_BY_NAME.put("poundFootPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundFootPerSecond"), "poundFootPerSecond", "pound foot per second"), Optional.of("lb\u00b7(ft/s)"), Optional.of("N10"), Optional.of("kilogramMetrePerSecond"), Optional.of("1.382550 \u00d7 10\u207b\u00b9 kg \u00d7 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENTUM, QuantityKinds.MOMENTUM))));
        UNITS_BY_NAME.put("poundForce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForce"), "poundForce", "pound-force"), Optional.of("lbf"), Optional.of("C78"), Optional.of("newton"), Optional.of("4.448222 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("poundForceFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceFoot"), "poundForceFoot", "pound-force foot"), Optional.of("lbf\u00b7ft"), Optional.of("M92"), Optional.of("newtonMetre"), Optional.of("1.355818 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("poundForceFootPerAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceFootPerAmpere"), "poundForceFootPerAmpere", "pound-force foot per ampere"), Optional.of("lbf\u00b7ft/A"), Optional.of("F22"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("poundForceFootPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceFootPerInch"), "poundForceFootPerInch", "pound-force foot per inch"), Optional.of("lbf\u00b7ft/in"), Optional.of("P89"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("poundForceFootPerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceFootPerPound"), "poundForceFootPerPound", "pound-force foot per pound"), Optional.of("lbf\u00b7ft/lb"), Optional.of("G20"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WORK_PER_UNIT_WEIGHT, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE))));
        UNITS_BY_NAME.put("poundForceInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceInch"), "poundForceInch", "pound-force inch"), Optional.of("lbf\u00b7in"), Optional.of("F21"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("poundForceInchPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceInchPerInch"), "poundForceInchPerInch", "pound-force inch per inch"), Optional.of("lbf\u00b7in/in"), Optional.of("P90"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("poundForcePerFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerFoot"), "poundForcePerFoot", "pound-force per foot"), Optional.of("lbf/ft"), Optional.of("F17"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FORCE_DIVIDED_BY_LENGTH))));
        UNITS_BY_NAME.put("poundForcePerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerInch"), "poundForcePerInch", "pound-force per inch"), Optional.of("lbf/in"), Optional.of("F48"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FORCE_DIVIDED_BY_LENGTH))));
        UNITS_BY_NAME.put("poundForcePerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerSquareFoot"), "poundForcePerSquareFoot", "pound-force per square foot"), Optional.of("lbf/ft\u00b2"), Optional.of("K85"), Optional.of("pascal"), Optional.of("47.88026 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_STRESS))));
        UNITS_BY_NAME.put("poundForcePerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerSquareInch"), "poundForcePerSquareInch", "pound-force per square inch"), Optional.of("lbf/in\u00b2"), Optional.of("PS"), Optional.of("pascal"), Optional.of("6.894757 \u00d7 10\u00b3 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.SHEAR_STRESS, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("poundForcePerSquareInchDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerSquareInchDegreeFahrenheit"), "poundForcePerSquareInchDegreeFahrenheit", "pound-force per square inch degree Fahrenheit"), Optional.of("psi/\u00b0F"), Optional.of("K86"), Optional.of("pascalPerKelvin"), Optional.of("1.241056 \u00d7 10\u2074 Pa/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_COEFFICIENT, QuantityKinds.PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_COMPRESSION))));
        UNITS_BY_NAME.put("poundForcePerYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForcePerYard"), "poundForcePerYard", "pound-force per yard"), Optional.of("lbf/yd"), Optional.of("N33"), Optional.of("newtonPerMetre"), Optional.of("4.864635 N/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION, QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("poundForceSecondPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceSecondPerSquareFoot"), "poundForceSecondPerSquareFoot", "pound-force second per square foot"), Optional.of("lbf\u00b7s/ft\u00b2"), Optional.of("K91"), Optional.of("pascalSecond"), Optional.of("47.88026 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundForceSecondPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundForceSecondPerSquareInch"), "poundForceSecondPerSquareInch", "pound-force second per square inch"), Optional.of("lbf\u00b7s/in\u00b2"), Optional.of("K92"), Optional.of("pascalSecond"), Optional.of("6.894757 \u00d7 10\u00b3 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundInchPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundInchPerSecond"), "poundInchPerSecond", "pound inch per second"), Optional.of("lb\u00b7(in/s)"), Optional.of("N11"), Optional.of("kilogramMetrePerSecond"), Optional.of("1.152125 \u00d7 10\u207b\u00b2 kg \u00d7 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENTUM, QuantityKinds.MOMENTUM))));
        UNITS_BY_NAME.put("poundInchSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundInchSquared"), "poundInchSquared", "pound inch squared"), Optional.of("lb\u00b7in\u00b2"), Optional.of("F20"), Optional.of("kilogramMetreSquared"), Optional.of("2.926397 \u00d7 10\u207b\u2074 kg \u00d7 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA, QuantityKinds.MOMENT_OF_INERTIA_DYNAMIC_MOMENT_OF_INERTIA))));
        UNITS_BY_NAME.put("poundMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundMole"), "poundMole", "pound mole"), Optional.of("lbmol"), Optional.of("P44"), Optional.of("mole"), Optional.of("453.5924 mol"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.AMOUNT_OF_SUBSTANCE))));
        UNITS_BY_NAME.put("poundMolePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundMolePerMinute"), "poundMolePerMinute", "pound mole per minute"), Optional.of("lbmol/h"), Optional.of("P46"), Optional.of("molePerSecond"), Optional.of("7.559873 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.CATALYTIC_ACTIVITY))));
        UNITS_BY_NAME.put("poundMolePerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundMolePerPound"), "poundMolePerPound", "pound mole per pound"), Optional.of("lbmol/lb"), Optional.of("P48"), Optional.of("molePerKilogram"), Optional.of("10\u00b3 mol/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLALITY_OF_SOLUTE_B, QuantityKinds.IONIC_STRENGTH))));
        UNITS_BY_NAME.put("poundMolePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundMolePerSecond"), "poundMolePerSecond", "pound mole per second"), Optional.of("lbmol/s"), Optional.of("P45"), Optional.of("molePerSecond"), Optional.of("4.535924 \u00d7 10\u00b2 mol/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.CATALYTIC_ACTIVITY))));
        UNITS_BY_NAME.put("poundPerCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerCubicFoot"), "poundPerCubicFoot", "pound per cubic foot"), Optional.of("lb/ft\u00b3"), Optional.of("87"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.601846 \u00d7 10\u00b9 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("poundPerCubicInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerCubicInch"), "poundPerCubicInch", "pound per cubic inch"), Optional.of("lb/in\u00b3"), Optional.of("LA"), Optional.of("kilogramPerCubicMetre"), Optional.of("2.767990 \u00d7 10\u2074 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("poundPerCubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerCubicYard"), "poundPerCubicYard", "pound per cubic yard"), Optional.of("lb/yd\u00b3"), Optional.of("K84"), Optional.of("kilogramPerCubicMetre"), Optional.of("0.5932764 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("poundPerFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerFoot"), "poundPerFoot", "pound per foot"), Optional.of("lb/ft"), Optional.of("P2"), Optional.of("kilogramPerMetre"), Optional.of("1.488164 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("poundPerFootDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerFootDay"), "poundPerFootDay", "pound per foot day"), Optional.of("lb/(ft\u00b7d)"), Optional.of("N44"), Optional.of("pascalSecond"), Optional.of("1.722412 \u00d7 10\u207b\u2075 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundPerFootHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerFootHour"), "poundPerFootHour", "pound per foot hour"), Optional.of("lb/(ft\u00b7h)"), Optional.of("K67"), Optional.of("pascalSecond"), Optional.of("4.133789 \u00d7 10\u207b\u2074 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundPerFootMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerFootMinute"), "poundPerFootMinute", "pound per foot minute"), Optional.of("lb/(ft\u00b7min)"), Optional.of("N43"), Optional.of("pascalSecond"), Optional.of("2.480273 \u00d7 10\u207b\u00b2 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundPerFootSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerFootSecond"), "poundPerFootSecond", "pound per foot second"), Optional.of("lb/(ft\u00b7s)"), Optional.of("K68"), Optional.of("pascalSecond"), Optional.of("1.488164 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundPerGallonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerGallonUs"), "poundPerGallonUs", "pound per gallon (US)"), Optional.of("lb/gal (US)"), Optional.of("GE"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.198264 \u00d7 10\u00b2 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("poundPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerHour"), "poundPerHour", "pound per hour"), Optional.of("lb/h"), Optional.of("4U"), Optional.of("kilogramPerSecond"), Optional.of("1.259979 \u00d7 10\u207b\u2074 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("poundPerInchOfLengthUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerInchOfLengthUnit"), "poundPerInchOfLengthUnit", "pound per inch of length"), Optional.of("lb/in"), Optional.of("PO"), Optional.of("kilogramPerMetre"), Optional.of("1.785797 \u00d7 10\u00b9 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS))));
        UNITS_BY_NAME.put("poundPerPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerPound"), "poundPerPound", "pound per pound"), Optional.of("lb/lb"), Optional.of("M91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_RATIO))));
        UNITS_BY_NAME.put("poundPerReam", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerReam"), "poundPerReam", "pound per ream"), Optional.empty(), Optional.of("RP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("poundPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerSquareFoot"), "poundPerSquareFoot", "pound per square foot"), Optional.of("lb/ft\u00b2"), Optional.of("FP"), Optional.of("kilogramPerSquareMetre"), Optional.of("4.882428 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_STRESS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("poundPerSquareInchAbsolute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerSquareInchAbsolute"), "poundPerSquareInchAbsolute", "pound per square inch absolute"), Optional.of("lb/in\u00b2"), Optional.of("80"), Optional.of("kilogramPerSquareMetre"), Optional.of("7.030696 \u00d7 10\u00b2 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("poundPerSquareYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerSquareYard"), "poundPerSquareYard", "pound per square yard"), Optional.of("lb/yd\u00b2"), Optional.of("N25"), Optional.of("kilogramPerSquareMetre"), Optional.of("5.424919 \u00d7 10\u207b\u00b9 kg/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.SURFACE_DENSITY, QuantityKinds.MEAN_MASS_RANGE, QuantityKinds.AREIC_MASS))));
        UNITS_BY_NAME.put("poundPerYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundPerYard"), "poundPerYard", "pound per yard"), Optional.of("lb/yd"), Optional.of("M84"), Optional.of("kilogramPerMetre"), Optional.of("4.960546 \u00d7 10\u207b\u00b9 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY, QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("poundal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundal"), "poundal", "poundal"), Optional.of("pdl"), Optional.of("M76"), Optional.of("newton"), Optional.of("1.382550 \u00d7 10\u207b\u00b9 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.WEIGHT, QuantityKinds.FORCE))));
        UNITS_BY_NAME.put("poundalFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalFoot"), "poundalFoot", "poundal foot"), Optional.of("pdl\u00b7ft"), Optional.of("M95"), Optional.of("newtonMetre"), Optional.of("4.214011 \u00d7 10\u207b\u00b2 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("poundalInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalInch"), "poundalInch", "poundal inch"), Optional.of("pdl\u00b7in"), Optional.of("M96"), Optional.of("newtonMetre"), Optional.of("3.51167710\u207b\u00b3 N \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE, QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("poundalPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalPerInch"), "poundalPerInch", "poundal per inch"), Optional.of("pdl/in"), Optional.of("N32"), Optional.of("newtonPerMetre"), Optional.of("5.443110 N/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SURFACE_TENSION, QuantityKinds.SURFACE_TENSION))));
        UNITS_BY_NAME.put("poundalPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalPerSquareFoot"), "poundalPerSquareFoot", "poundal per square foot"), Optional.of("pdl/ft\u00b2"), Optional.of("N21"), Optional.of("pascal"), Optional.of("1.488164 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_STRESS, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY))));
        UNITS_BY_NAME.put("poundalPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalPerSquareInch"), "poundalPerSquareInch", "poundal per square inch"), Optional.of("pdl/in\u00b2"), Optional.of("N26"), Optional.of("pascal"), Optional.of("2.142957 \u00d7 10\u00b2 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.BULK_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.SHEAR_MODULUS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS))));
        UNITS_BY_NAME.put("poundalSecondPerSquareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalSecondPerSquareFoot"), "poundalSecondPerSquareFoot", "poundal second per square foot"), Optional.of("(pdl/ft\u00b2)\u00b7s"), Optional.of("N34"), Optional.of("pascalSecond"), Optional.of("1.488164 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("poundalSecondPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "poundalSecondPerSquareInch"), "poundalSecondPerSquareInch", "poundal second per square inch"), Optional.of("(pdl/in\u00b2)\u00b7s"), Optional.of("N42"), Optional.of("pascalSecond"), Optional.of("2.142957 \u00d7 10\u00b2 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("printPoint", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "printPoint"), "printPoint", "print point"), Optional.empty(), Optional.of("N3"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("proofGallon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "proofGallon"), "proofGallon", "proof gallon"), Optional.empty(), Optional.of("PGL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("proofLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "proofLitre"), "proofLitre", "proof litre"), Optional.empty(), Optional.of("PFL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("psiCubicInchPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiCubicInchPerSecond"), "psiCubicInchPerSecond", "psi cubic inch per second"), Optional.of("psi\u00b7in\u00b3/s"), Optional.of("K87"), Optional.of("pascalCubicMetrePerSecond"), Optional.of("0.112985 Pa \u00d7 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("psiCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiCubicMetrePerSecond"), "psiCubicMetrePerSecond", "psi cubic metre per second"), Optional.of("psi\u00b7m\u00b3/s"), Optional.of("K89"), Optional.of("pascalCubicMetrePerSecond"), Optional.of("6.894757 \u00d7 10\u00b3 Pa \u00d7 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("psiCubicYardPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiCubicYardPerSecond"), "psiCubicYardPerSecond", "psi cubic yard per second"), Optional.of("psi\u00b7yd\u00b3/s"), Optional.of("K90"), Optional.of("pascalCubicMetrePerSecond"), Optional.of("5.271420 \u00d7 10\u00b3 Pa \u00d7 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("psiLitrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiLitrePerSecond"), "psiLitrePerSecond", "psi litre per second"), Optional.of("psi\u00b7l/s"), Optional.of("K88"), Optional.of("pascalCubicMetrePerSecond"), Optional.of("6.894757 Pa \u00d7 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.BULK_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.LEAKAGE_RATE_OF_GAS))));
        UNITS_BY_NAME.put("psiPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiPerInch"), "psiPerInch", "psi per inch"), Optional.of("psi/in"), Optional.of("P86"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("psiPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "psiPerPsi"), "psiPerPsi", "psi per psi"), Optional.of("psi/psi"), Optional.of("L52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PRESSURE_RATIO))));
        UNITS_BY_NAME.put("quad1015Btuit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quad1015Btuit"), "quad1015Btuit", "quad (1015 BtuIT)"), Optional.of("quad"), Optional.of("N70"), Optional.of("joule"), Optional.of("1.055056 \u00d7 10\u00b9\u2078 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.HEAT, QuantityKinds.ENTHALPY, QuantityKinds.ENERGY, QuantityKinds.QUANTITY_OF_HEAT))));
        UNITS_BY_NAME.put("quartUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUk"), "quartUk", "quart (UK)"), Optional.of("qt (UK)"), Optional.of("QTI"), Optional.of("cubicMetre"), Optional.of("1.1365225 \u00d7 10\u207b\u00b3 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("quartUkLiquidPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUkLiquidPerDay"), "quartUkLiquidPerDay", "quart (UK liquid) per day"), Optional.of("qt (UK liq.)/d"), Optional.of("K94"), Optional.of("cubicMetrePerSecond"), Optional.of("1.315420 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUkLiquidPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUkLiquidPerHour"), "quartUkLiquidPerHour", "quart (UK liquid) per hour"), Optional.of("qt (UK liq.)/h"), Optional.of("K95"), Optional.of("cubicMetrePerSecond"), Optional.of("3.157008 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUkLiquidPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUkLiquidPerMinute"), "quartUkLiquidPerMinute", "quart (UK liquid) per minute"), Optional.of("qt (UK liq.)/min"), Optional.of("K96"), Optional.of("cubicMetrePerSecond"), Optional.of("1.894205 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUkLiquidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUkLiquidPerSecond"), "quartUkLiquidPerSecond", "quart (UK liquid) per second"), Optional.of("qt (UK liq.)/s"), Optional.of("K97"), Optional.of("cubicMetrePerSecond"), Optional.of("1.136523 \u00d7 10\u207b\u00b3 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUsLiquidPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUsLiquidPerDay"), "quartUsLiquidPerDay", "quart (US liquid) per day"), Optional.of("qt (US liq.)/d"), Optional.of("K98"), Optional.of("cubicMetrePerSecond"), Optional.of("1.095316 \u00d7 10\u207b\u2078 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUsLiquidPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUsLiquidPerHour"), "quartUsLiquidPerHour", "quart (US liquid) per hour"), Optional.of("qt (US liq.)/h"), Optional.of("K99"), Optional.of("cubicMetrePerSecond"), Optional.of("2.628758 \u00d7 10\u207b\u2077 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUsLiquidPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUsLiquidPerMinute"), "quartUsLiquidPerMinute", "quart (US liquid) per minute"), Optional.of("qt (US liq.)/min"), Optional.of("L10"), Optional.of("cubicMetrePerSecond"), Optional.of("1.577255 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quartUsLiquidPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quartUsLiquidPerSecond"), "quartUsLiquidPerSecond", "quart (US liquid) per second"), Optional.of("qt (US liq.)/s"), Optional.of("L11"), Optional.of("cubicMetrePerSecond"), Optional.of("9.463529 \u00d7 10\u207b\u2074 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("quarterOfAYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quarterOfAYear"), "quarterOfAYear", "quarter (of a year)"), Optional.empty(), Optional.of("QAN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("quarterUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quarterUk"), "quarterUk", "quarter (UK)"), Optional.of("Qr (UK)"), Optional.of("QTR"), Optional.of("kilogram"), Optional.of("12.700 59 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("quire", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "quire"), "quire", "quire"), Optional.of("qr"), Optional.of("QR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
    }

    private static void init14() {
        UNITS_BY_NAME.put("rackUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rackUnit"), "rackUnit", "rack unit"), Optional.of("U or RU"), Optional.of("H80"), Optional.of("metre"), Optional.of("4.445 \u00d7 10\u207b\u00b2 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("rad", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rad"), "rad", "rad"), Optional.of("rad"), Optional.of("C80"), Optional.of("gray"), Optional.of("10\u207b\u00b2 Gy"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_ENERGY_IMPARTED, QuantityKinds.MASSIC_ENERGY_IMPARTED, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("radian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radian"), "radian", "radian"), Optional.of("rad"), Optional.of("C81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_OF_OPTICAL_ROTATION, QuantityKinds.PHASE_DIFFERENCE, QuantityKinds.BRAGG_ANGLE, QuantityKinds.LOSS_ANGLE, QuantityKinds.ANGLE_PLANE, QuantityKinds.PHASE_DISPLACEMENT))));
        UNITS_BY_NAME.put("radianPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radianPerMetre"), "radianPerMetre", "radian per metre"), Optional.of("rad/m"), Optional.of("C84"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_WAVENUMBER, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.DEBYE_ANGULAR_REPETENCY, QuantityKinds.DEBYE_ANGULAR_WAVE_NUMBER))));
        UNITS_BY_NAME.put("radianPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radianPerSecond"), "radianPerSecond", "radian per second"), Optional.of("rad/s"), Optional.of("2A"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CYCLOTRON_ANGULAR_FREQUENCY, QuantityKinds.ANGULAR_VELOCITY, QuantityKinds.PULSATANCE, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.NUCLEAR_PRECESSION))));
        UNITS_BY_NAME.put("radianPerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radianPerSecondSquared"), "radianPerSecondSquared", "radian per second squared"), Optional.of("rad/s\u00b2"), Optional.of("2B"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_ACCELERATION))));
        UNITS_BY_NAME.put("radianSquareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radianSquareMetrePerKilogram"), "radianSquareMetrePerKilogram", "radian square metre per kilogram"), Optional.of("rad\u00b7m\u00b2/kg"), Optional.of("C83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_OPTICAL_ROTATORY_POWER, QuantityKinds.ROTATORY_POWER, QuantityKinds.MASSIC_OPTICAL))));
        UNITS_BY_NAME.put("radianSquareMetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "radianSquareMetrePerMole"), "radianSquareMetrePerMole", "radian square metre per mole"), Optional.of("rad\u00b7m\u00b2/mol"), Optional.of("C82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_OPTICAL_ROTATORY_POWER))));
        UNITS_BY_NAME.put("rate", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rate"), "rate", "rate"), Optional.empty(), Optional.of("A9"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ration", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ration"), "ration", "ration"), Optional.empty(), Optional.of("13"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("ream", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "ream"), "ream", "ream"), Optional.empty(), Optional.of("RM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("reciprocalAngstrom", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalAngstrom"), "reciprocalAngstrom", "reciprocal angstrom"), Optional.of("\u00c5\u207b\u00b9"), Optional.of("C85"), Optional.of("reciprocalMetre"), Optional.of("10\u00b9\u2070 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION, QuantityKinds.FERMI_ANGULAR_REPETENCY, QuantityKinds.FERMI_ANGULAR_WAVE_NUMBER))));
        UNITS_BY_NAME.put("reciprocalBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalBar"), "reciprocalBar", "reciprocal bar"), Optional.of("1/bar"), Optional.of("F58"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COMPRESSIBILITY, QuantityKinds.BULK_COMPRESSIBILITY))));
        UNITS_BY_NAME.put("reciprocalCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCentimetre"), "reciprocalCentimetre", "reciprocal centimetre"), Optional.of("cm\u207b\u00b9"), Optional.of("E90"), Optional.of("reciprocalMetre"), Optional.of("10\u00b2 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("reciprocalCubicCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicCentimetre"), "reciprocalCubicCentimetre", "reciprocal cubic centimetre"), Optional.of("cm\u207b\u00b3"), Optional.of("H50"), Optional.of("reciprocalCubicMetre"), Optional.of("10\u2076 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicFoot"), "reciprocalCubicFoot", "reciprocal cubic foot"), Optional.of("1/ft\u00b3"), Optional.of("K20"), Optional.of("reciprocalCubicMetre"), Optional.of("35.31466 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B))));
        UNITS_BY_NAME.put("reciprocalCubicInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicInch"), "reciprocalCubicInch", "reciprocal cubic inch"), Optional.of("1/in\u00b3"), Optional.of("K49"), Optional.of("reciprocalCubicMetre"), Optional.of("6.1023759 \u00d7 10\u2074 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicMetre"), "reciprocalCubicMetre", "reciprocal cubic metre"), Optional.of("m\u207b\u00b3"), Optional.of("C86"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER))));
        UNITS_BY_NAME.put("reciprocalCubicMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicMetrePerSecond"), "reciprocalCubicMetrePerSecond", "reciprocal cubic metre per second"), Optional.of("m\u207b\u00b3/s"), Optional.of("C87"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SLOWING_DOWN_DENSITY))));
        UNITS_BY_NAME.put("reciprocalCubicMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicMillimetre"), "reciprocalCubicMillimetre", "reciprocal cubic millimetre"), Optional.of("1/mm\u00b3"), Optional.of("L20"), Optional.of("reciprocalCubicMetre"), Optional.of("10\u2079 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalCubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalCubicYard"), "reciprocalCubicYard", "reciprocal cubic yard"), Optional.of("1/yd\u00b3"), Optional.of("M10"), Optional.of("reciprocalCubicMetre"), Optional.of("1.307951 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalDay"), "reciprocalDay", "reciprocal day"), Optional.of("d\u207b\u00b9"), Optional.of("E91"), Optional.of("reciprocalSecond"), Optional.of("1.15741 \u00d7 10\u207b\u2075 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY))));
        UNITS_BY_NAME.put("reciprocalDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalDegreeFahrenheit"), "reciprocalDegreeFahrenheit", "reciprocal degree Fahrenheit"), Optional.of("1/\u00b0F"), Optional.of("J26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TEMPERATURE))));
        UNITS_BY_NAME.put("reciprocalElectronVoltPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalElectronVoltPerCubicMetre"), "reciprocalElectronVoltPerCubicMetre", "reciprocal electron volt per cubic metre"), Optional.of("eV\u207b\u00b9/m\u00b3"), Optional.of("C88"), Optional.of("reciprocalJoulePerCubicMetre"), Optional.of("6.24146 \u00d7 10\u00b9\u2078 J\u207b\u00b9/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_STATES, QuantityKinds.DENSITY_OF_STATES))));
        UNITS_BY_NAME.put("reciprocalHenry", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalHenry"), "reciprocalHenry", "reciprocal henry"), Optional.of("H\u207b\u00b9"), Optional.of("C89"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELUCTANCE))));
        UNITS_BY_NAME.put("reciprocalHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalHour"), "reciprocalHour", "reciprocal hour"), Optional.of("1/h"), Optional.of("H10"), Optional.of("reciprocalSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("reciprocalInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalInch"), "reciprocalInch", "reciprocal inch"), Optional.of("1/in"), Optional.of("Q24"), Optional.of("reciprocalMetre"), Optional.of("39.37008 m\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("reciprocalJoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalJoule"), "reciprocalJoule", "reciprocal joule"), Optional.of("1/J"), Optional.of("N91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("reciprocalJoulePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalJoulePerCubicMetre"), "reciprocalJoulePerCubicMetre", "reciprocal joule per cubic metre"), Optional.of("J\u207b\u00b9/m\u00b3"), Optional.of("C90"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_STATES))));
        UNITS_BY_NAME.put("reciprocalKelvinOrKelvinToThePowerMinusOne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalKelvinOrKelvinToThePowerMinusOne"), "reciprocalKelvinOrKelvinToThePowerMinusOne", "reciprocal kelvin or kelvin to the power minus one"), Optional.of("K\u207b\u00b9"), Optional.of("C91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT))));
        UNITS_BY_NAME.put("reciprocalKilovoltAmpereReciprocalHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalKilovoltAmpereReciprocalHour"), "reciprocalKilovoltAmpereReciprocalHour", "reciprocal kilovolt - ampere reciprocal hour"), Optional.of("1/kVAh"), Optional.of("M21"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("reciprocalLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalLitre"), "reciprocalLitre", "reciprocal litre"), Optional.of("1/l"), Optional.of("K63"), Optional.of("reciprocalCubicMetre"), Optional.of("10\u00b3 m\u207b\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ION_NUMBER_DENSITY, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES, QuantityKinds.ELECTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_ACCEPTOR_NUMBER, QuantityKinds.ION_DENSITY, QuantityKinds.VOLUMIC_ELECTRON_NUMBER, QuantityKinds.NEUTRON_NUMBER_DENSITY, QuantityKinds.VOLUMIC_INTRINSIS_NUMBER, QuantityKinds.VOLUMIC_DONOR_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.DONOR_NUMBER_DENSITY, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.HOLE_NUMBER_DENSITY, QuantityKinds.ACCEPTOR_NUMBER_DENSITY, QuantityKinds.INTRINSIC_NUMBER_DENSITY, QuantityKinds.VOLUMIC_HOLE_NUMBER, QuantityKinds.VOLUMIC_NUMBER_OF_MOLECULES_OR_PARTICLES, QuantityKinds.MOLECULAR_CONCENTRATION_OF_B, QuantityKinds.NUMBER_DENSITY_OF_MOLECULES_OR_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalMegakelvinOrMegakelvinToThePowerMinusOne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMegakelvinOrMegakelvinToThePowerMinusOne"), "reciprocalMegakelvinOrMegakelvinToThePowerMinusOne", "reciprocal megakelvin or megakelvin to the power minus one"), Optional.of("1/MK"), Optional.of("M20"), Optional.of("reciprocalKelvinOrKelvinToThePowerMinusOne"), Optional.of("10\u207b\u2076 K\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT, QuantityKinds.RELATIVE_PRESSURE_COEFFICIENT, QuantityKinds.CUBIC_EXPANSION_COEFFICIENT, QuantityKinds.LINEAR_EXPANSION_COEFFICIENT))));
        UNITS_BY_NAME.put("reciprocalMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMetre"), "reciprocalMetre", "reciprocal metre"), Optional.of("m\u207b\u00b9"), Optional.of("C92"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_ABSORPTION_COEFFICIENT, QuantityKinds.LINEAR_IONIZATION_BY_A_PARTICLE, QuantityKinds.ATTENUATION_COEFFICIENT, QuantityKinds.MACROSCOPIC_TOTAL_CROSS_SECTION, QuantityKinds.REPETENCY, QuantityKinds.ANGULAR_WAVE_NUMBER, QuantityKinds.ANGULAR_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.FUNDAMENTAL_RECIPROCAL_LATTICE_VECTOR, QuantityKinds.LINEAR_ATTENUATION_COEFFICIENT, QuantityKinds.VOLUMIC_CROSS_SECTION, QuantityKinds.PROPAGATION_COEFFICIENT, QuantityKinds.LINEAR_EXTINCTION_COEFFICIENT, QuantityKinds.VERGENCE, QuantityKinds.TOTAL_IONIZATION_BY_A_PARTICLE, QuantityKinds.ANGULAR_REPETENCY, QuantityKinds.WAVENUMBER, QuantityKinds.VOLUMIC_TOTAL_CROSS_SECTION, QuantityKinds.LENS_POWER, QuantityKinds.WAVE_NUMBER, QuantityKinds.CURVATURE, QuantityKinds.PHASE_COEFFICIENT, QuantityKinds.RYDBERG_CONSTANT, QuantityKinds.MACROSCOPIC_CROSS_SECTION))));
        UNITS_BY_NAME.put("reciprocalMetreSquaredReciprocalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMetreSquaredReciprocalSecond"), "reciprocalMetreSquaredReciprocalSecond", "reciprocal metre squared reciprocal second"), Optional.of("m\u207b\u00b2/s"), Optional.of("B81"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PARTICAL_FLUX_DENSITY, QuantityKinds.PARTICLE_FLUENCE_RATE, QuantityKinds.NEUTRON_FLUENCE_RATE, QuantityKinds.NEUTRONFLUX_DENSITY, QuantityKinds.CURRENT_DENSITY_OF_PARTICLES))));
        UNITS_BY_NAME.put("reciprocalMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMinute"), "reciprocalMinute", "reciprocal minute"), Optional.of("min\u207b\u00b9"), Optional.of("C94"), Optional.of("secondUnitOfTime"), Optional.of("1.666667 \u00d7 10\u207b\u00b2 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ROTATIONAL_FREQUENCY, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("reciprocalMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMole"), "reciprocalMole", "reciprocal mole"), Optional.of("mol\u207b\u00b9"), Optional.of("C95"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AVOGADRO_CONSTANT))));
        UNITS_BY_NAME.put("reciprocalMonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalMonth"), "reciprocalMonth", "reciprocal month"), Optional.of("1/mo"), Optional.of("H11"), Optional.of("reciprocalSecond"), Optional.of("3.80257 \u00d7 10\u207b\u2077 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("reciprocalPascalOrPascalToThePowerMinusOne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalPascalOrPascalToThePowerMinusOne"), "reciprocalPascalOrPascalToThePowerMinusOne", "reciprocal pascal or pascal to the power minus one"), Optional.of("Pa\u207b\u00b9"), Optional.of("C96"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ISOTHERMAL_COMPRESSIBILITY, QuantityKinds.COMPRESSIBILITY, QuantityKinds.BULK_COMPRESSIBILITY, QuantityKinds.ISENTROPIC_COMPRESSIBILITY))));
        UNITS_BY_NAME.put("reciprocalPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalPsi"), "reciprocalPsi", "reciprocal psi"), Optional.of("1/psi"), Optional.of("K93"), Optional.of("reciprocalPascalOrPascalToThePowerMinusOne"), Optional.of("1.450377 \u00d7 10\u207b\u2074 Pa\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.ISOTHERMAL_COMPRESSIBILITY, QuantityKinds.COMPRESSIBILITY, QuantityKinds.BULK_COMPRESSIBILITY, QuantityKinds.ISENTROPIC_COMPRESSIBILITY))));
        UNITS_BY_NAME.put("reciprocalRadian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalRadian"), "reciprocalRadian", "reciprocal radian"), Optional.of("1/rad"), Optional.of("P97"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("reciprocalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSecond"), "reciprocalSecond", "reciprocal second"), Optional.of("s\u207b\u00b9"), Optional.of("C97"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY))));
        UNITS_BY_NAME.put("reciprocalSecondPerMetreSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSecondPerMetreSquared"), "reciprocalSecondPerMetreSquared", "reciprocal second per metre squared"), Optional.of("s\u207b\u00b9/m\u00b2"), Optional.of("C99"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHOTON_EXITANCE, QuantityKinds.IRRADIANCE))));
        UNITS_BY_NAME.put("reciprocalSecondPerSteradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSecondPerSteradian"), "reciprocalSecondPerSteradian", "reciprocal second per steradian"), Optional.of("s\u207b\u00b9/sr"), Optional.of("D1"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHOTON_INTENSITY))));
        UNITS_BY_NAME.put("reciprocalSecondPerSteradianMetreSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSecondPerSteradianMetreSquared"), "reciprocalSecondPerSteradianMetreSquared", "reciprocal second per steradian metre squared"), Optional.of("s\u207b\u00b9/(sr\u00b7m\u00b2)"), Optional.of("D2"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHOTON_RADIANCE, QuantityKinds.PHOTON_LUMINANCE))));
        UNITS_BY_NAME.put("reciprocalSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSquareInch"), "reciprocalSquareInch", "reciprocal square inch"), Optional.of("1/in\u00b2"), Optional.of("P78"), Optional.of("reciprocalSquareMetre"), Optional.of("1.550003 \u00d7 10\u00b3 m\u207b\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHOTON_EXPOSURE, QuantityKinds.PARTICLE_FLUENCE, QuantityKinds.PARTICLE_FLUENCE))));
        UNITS_BY_NAME.put("reciprocalSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalSquareMetre"), "reciprocalSquareMetre", "reciprocal square metre"), Optional.of("m\u207b\u00b2"), Optional.of("C93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PHOTON_EXPOSURE, QuantityKinds.PARTICLE_FLUENCE))));
        UNITS_BY_NAME.put("reciprocalVolt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalVolt"), "reciprocalVolt", "reciprocal volt"), Optional.of("1/V"), Optional.of("P96"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("reciprocalVoltAmpereReciprocalSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalVoltAmpereReciprocalSecond"), "reciprocalVoltAmpereReciprocalSecond", "reciprocal volt - ampere reciprocal second"), Optional.of("1/(V\u00b7A\u00b7s)"), Optional.of("M30"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.PERFORMANCE_CHARACTERISTIC, QuantityKinds.COEFFICIENT))));
        UNITS_BY_NAME.put("reciprocalWeek", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalWeek"), "reciprocalWeek", "reciprocal week"), Optional.of("1/wk"), Optional.of("H85"), Optional.of("reciprocalSecond"), Optional.of("1.647989452868 \u00d7 10\u207b\u2076 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("reciprocalYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "reciprocalYear"), "reciprocalYear", "reciprocal year"), Optional.of("1/y"), Optional.of("H09"), Optional.of("reciprocalSecond"), Optional.of("3.16881 \u00d7 10\u207b\u2078 s\u207b\u00b9"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.DECAY_CONSTANT, QuantityKinds.DAMPING_COEFFICIENT, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.DISINTEGRATION_CONSTANT, QuantityKinds.PHOTON_FLUX, QuantityKinds.LARMOR_ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.PULSATANCE, QuantityKinds.ROTATIONAL_FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("rem", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rem"), "rem", "rem"), Optional.of("rem"), Optional.of("D91"), Optional.of("sievert"), Optional.of("10\u207b\u00b2 Sv"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DOSE_EQUIVALENT, QuantityKinds.DOSE_EQUIVALENT))));
        UNITS_BY_NAME.put("remPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "remPerSecond"), "remPerSecond", "rem per second"), Optional.of("rem/s"), Optional.of("P69"), Optional.of("sievertPerSecond"), Optional.of("10\u207b\u00b2 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("revenueTonMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "revenueTonMile"), "revenueTonMile", "revenue ton mile"), Optional.empty(), Optional.of("RT"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("revolution", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "revolution"), "revolution", "revolution"), Optional.of("rev"), Optional.of("M44"), Optional.of("rad"), Optional.of("6.283185 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_PLANE, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("revolutionPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "revolutionPerMinute"), "revolutionPerMinute", "revolution per minute"), Optional.of("r/min"), Optional.of("M46"), Optional.of("radianPerSecond"), Optional.of("0.1047198 rad/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_VELOCITY, QuantityKinds.CYCLOTRON_ANGULAR_FREQUENCY, QuantityKinds.ANGULAR_VELOCITY, QuantityKinds.PULSATANCE, QuantityKinds.DEBYE_ANGULAR_FREQUENCY, QuantityKinds.ANGULAR_FREQUENCY, QuantityKinds.CIRCULAR_FREQUENCY, QuantityKinds.NUCLEAR_PRECESSION))));
        UNITS_BY_NAME.put("revolutionsPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "revolutionsPerMinute"), "revolutionsPerMinute", "revolutions per minute"), Optional.of("r/min"), Optional.of("RPM"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ROTATIONAL_FREQUENCY))));
        UNITS_BY_NAME.put("revolutionsPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "revolutionsPerSecond"), "revolutionsPerSecond", "revolutions per second"), Optional.of("r/s"), Optional.of("RPS"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ROTATIONAL_FREQUENCY))));
        UNITS_BY_NAME.put("rhe", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rhe"), "rhe", "rhe"), Optional.of("rhe"), Optional.of("P88"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("rodUnitOfDistance", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "rodUnitOfDistance"), "rodUnitOfDistance", "rod [unit of distance]"), Optional.of("rd (US)"), Optional.of("F49"), Optional.of("metre"), Optional.of("5.029210 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.LENGTH))));
        UNITS_BY_NAME.put("roentgen", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "roentgen"), "roentgen", "roentgen"), Optional.of("R"), Optional.of("2C"), Optional.of("coulombPerKilogram"), Optional.of("2.58 \u00d7 10\u207b\u2074 C/kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE, QuantityKinds.EXPOSURE))));
        UNITS_BY_NAME.put("roentgenPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "roentgenPerSecond"), "roentgenPerSecond", "roentgen per second"), Optional.of("R/s"), Optional.of("D6"), Optional.of("coulombPerKilogramSecond"), Optional.of("2.58 \u00d7 10\u207b\u2074 C/(kg \u00d7 s)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EXPOSURE_RATE, QuantityKinds.EXPOSURE_RATE))));
        UNITS_BY_NAME.put("room", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "room"), "room", "room"), Optional.empty(), Optional.of("ROM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("round", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "round"), "round", "round"), Optional.empty(), Optional.of("D65"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("runFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "runFoot"), "runFoot", "run foot"), Optional.empty(), Optional.of("E52"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("runningOrOperatingHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "runningOrOperatingHour"), "runningOrOperatingHour", "running or operating hour"), Optional.empty(), Optional.of("RH"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("score", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "score"), "score", "score"), Optional.empty(), Optional.of("SCO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("scruple", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "scruple"), "scruple", "scruple"), Optional.empty(), Optional.of("SCR"), Optional.of("gram"), Optional.of("1.295982 g"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("secondPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondPerCubicMetre"), "secondPerCubicMetre", "second per cubic metre"), Optional.of("s/m\u00b3"), Optional.of("D93"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_DOSE))));
        UNITS_BY_NAME.put("secondPerCubicMetreRadian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondPerCubicMetreRadian"), "secondPerCubicMetreRadian", "second per cubic metre radian"), Optional.of("s/(rad\u00b7m\u00b3)"), Optional.of("D94"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_CONCENTRATION_OF_VIBRATIONAL_MODES_IN_TERMS_OF_ANGULAR_FREQUENCY))));
        UNITS_BY_NAME.put("secondPerKilogramm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondPerKilogramm"), "secondPerKilogramm", "second per kilogramm"), Optional.of("s/kg"), Optional.of("Q20"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("secondPerRadianCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondPerRadianCubicMetre"), "secondPerRadianCubicMetre", "second per radian cubic metre"), Optional.of("1/(Hz\u00b7rad\u00b7m\u00b3)"), Optional.of("Q22"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("secondUnitOfAngle", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondUnitOfAngle"), "secondUnitOfAngle", "second [unit of angle]"), Optional.of("\""), Optional.of("D62"), Optional.of("rad"), Optional.of("4.848137 \u00d7 10\u207b\u2076 rad"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGLE_PLANE, QuantityKinds.ABSORBED_DOSE))));
        UNITS_BY_NAME.put("secondUnitOfTime", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "secondUnitOfTime"), "secondUnitOfTime", "second [unit of time]"), Optional.of("s"), Optional.of("SEC"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("segment", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "segment"), "segment", "segment"), Optional.empty(), Optional.of("SG"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("serviceUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "serviceUnit"), "serviceUnit", "service unit"), Optional.empty(), Optional.of("E48"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("set", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "set"), "set", "set"), Optional.empty(), Optional.of("SET"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("shake", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shake"), "shake", "shake"), Optional.of("shake"), Optional.of("M56"), Optional.of("secondUnitOfTime"), Optional.of("10\u207b\u2078 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("shannon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shannon"), "shannon", "shannon"), Optional.of("Sh"), Optional.of("Q14"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("shannonPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shannonPerSecond"), "shannonPerSecond", "shannon per second"), Optional.of("Sh/s"), Optional.of("Q17"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("shares", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shares"), "shares", "shares"), Optional.empty(), Optional.of("E21"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("shipment", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shipment"), "shipment", "shipment"), Optional.empty(), Optional.of("SX"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("shot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "shot"), "shot", "shot"), Optional.empty(), Optional.of("14"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("siderealYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "siderealYear"), "siderealYear", "sidereal year"), Optional.of("y (sidereal)"), Optional.of("L96"), Optional.of("secondUnitOfTime"), Optional.of("3.155815 \u00d7 10\u2077 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("siemens", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "siemens"), "siemens", "siemens"), Optional.of("S"), Optional.of("SIE"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.CONDUCTANCE_FOR_DIRECT_CURRENT, QuantityKinds.ADMITTANCE, QuantityKinds.MODULUS_OF_ADMITTANCE, QuantityKinds.CONDUCTANCE_FOR_ALTERNATING_CURRENT, QuantityKinds.COMPLEX_ADMITTANCE))));
        UNITS_BY_NAME.put("siemensPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "siemensPerCentimetre"), "siemensPerCentimetre", "siemens per centimetre"), Optional.of("S/cm"), Optional.of("H43"), Optional.of("siemensPerMetre"), Optional.of("10\u00b2 S/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("siemensPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "siemensPerMetre"), "siemensPerMetre", "siemens per metre"), Optional.of("S/m"), Optional.of("D10"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTROLYTIC_CONDUCTIVITY, QuantityKinds.CONDUCTIVITY))));
        UNITS_BY_NAME.put("siemensSquareMetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "siemensSquareMetrePerMole"), "siemensSquareMetrePerMole", "siemens square metre per mole"), Optional.of("S\u00b7m\u00b2/mol"), Optional.of("D12"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_CONDUCTIVITY))));
        UNITS_BY_NAME.put("sievert", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sievert"), "sievert", "sievert"), Optional.of("Sv"), Optional.of("D13"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DOSE_EQUIVALENT))));
        UNITS_BY_NAME.put("sievertPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sievertPerHour"), "sievertPerHour", "sievert per hour"), Optional.of("Sv/h"), Optional.of("P70"), Optional.of("sievertPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u2074 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("sievertPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sievertPerMinute"), "sievertPerMinute", "sievert per minute"), Optional.of("Sv/min"), Optional.of("P74"), Optional.of("sievertPerSecond"), Optional.of("0.016666 Sv/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT, QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("sievertPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sievertPerSecond"), "sievertPerSecond", "sievert per second"), Optional.of("Sv/s"), Optional.of("P65"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.EQUIVALENCE_DOSE_OUTPUT))));
        UNITS_BY_NAME.put("sitas", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sitas"), "sitas", "sitas"), Optional.empty(), Optional.of("56"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("skein", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "skein"), "skein", "skein"), Optional.empty(), Optional.of("SW"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("slug", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slug"), "slug", "slug"), Optional.of("slug"), Optional.of("F13"), Optional.of("kilogram"), Optional.of("1.459390 \u00d7 10\u00b9 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("slugPerCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerCubicFoot"), "slugPerCubicFoot", "slug per cubic foot"), Optional.of("slug/ft\u00b3"), Optional.of("L65"), Optional.of("kilogramPerCubicMetre"), Optional.of("5.153788 \u00d7 10\u00b2 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("slugPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerDay"), "slugPerDay", "slug per day"), Optional.of("slug/d"), Optional.of("L63"), Optional.of("kilogramPerSecond"), Optional.of("1.689109 \u00d7 10\u207b\u2074 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("slugPerFootSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerFootSecond"), "slugPerFootSecond", "slug per foot second"), Optional.of("slug/(ft\u00b7s)"), Optional.of("L64"), Optional.of("pascalSecond"), Optional.of("47.88026 Pa \u00d7 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY, QuantityKinds.VISCOSITY_DYNAMIC_VISCOSITY))));
        UNITS_BY_NAME.put("slugPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerHour"), "slugPerHour", "slug per hour"), Optional.of("slug/h"), Optional.of("L66"), Optional.of("kilogramPerSecond"), Optional.of("4.053861 \u00d7 10\u207b\u00b3 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("slugPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerMinute"), "slugPerMinute", "slug per minute"), Optional.of("slug/min"), Optional.of("L67"), Optional.of("kilogramPerSecond"), Optional.of("0.2432317 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
    }

    private static void init15() {
        UNITS_BY_NAME.put("slugPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "slugPerSecond"), "slugPerSecond", "slug per second"), Optional.of("slug/s"), Optional.of("L68"), Optional.of("kilogramPerSecond"), Optional.of("14.59390 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("sone", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "sone"), "sone", "sone"), Optional.empty(), Optional.of("D15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LOUDNESS))));
        UNITS_BY_NAME.put("square", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "square"), "square", "square"), Optional.empty(), Optional.of("SQ"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("squareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareCentimetre"), "squareCentimetre", "square centimetre"), Optional.of("cm\u00b2"), Optional.of("CMK"), Optional.of("squareMetre"), Optional.of("10\u207b\u2074 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareCentimetrePerErg", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareCentimetrePerErg"), "squareCentimetrePerErg", "square centimetre per erg"), Optional.of("cm\u00b2/erg"), Optional.of("D16"), Optional.of("squareMetrePerJoule"), Optional.of("10\u00b3 m\u00b2/J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_CROSS_SECTION, QuantityKinds.SPECTRAL_CROSS_SECTION))));
        UNITS_BY_NAME.put("squareCentimetrePerGram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareCentimetrePerGram"), "squareCentimetrePerGram", "square centimetre per gram"), Optional.of("cm\u00b2/g"), Optional.of("H15"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECIFIC_VOLUME, QuantityKinds.MASSIC_VOLUME))));
        UNITS_BY_NAME.put("squareCentimetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareCentimetrePerSecond"), "squareCentimetrePerSecond", "square centimetre per second"), Optional.of("cm\u00b2/s"), Optional.of("M81"), Optional.of("squareMetrePerSecond"), Optional.of("10\u207b\u2074 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareCentimetrePerSteradianErg", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareCentimetrePerSteradianErg"), "squareCentimetrePerSteradianErg", "square centimetre per steradian erg"), Optional.of("cm\u00b2/(sr\u00b7erg)"), Optional.of("D17"), Optional.of("squareMetrePerSteradianJoule"), Optional.of("10\u00b3 m\u00b2/(sr \u00d7 J)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_ANGULAR_CROSS_SECTION, QuantityKinds.SPECTRAL_ANGULAR_CROSS_SECTION))));
        UNITS_BY_NAME.put("squareDecametre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareDecametre"), "squareDecametre", "square decametre"), Optional.of("dam\u00b2"), Optional.of("H16"), Optional.of("squareMetre"), Optional.of("10\u00b2 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareDecimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareDecimetre"), "squareDecimetre", "square decimetre"), Optional.of("dm\u00b2"), Optional.of("DMK"), Optional.of("squareMetre"), Optional.of("10\u207b\u00b2 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareFoot"), "squareFoot", "square foot"), Optional.of("ft\u00b2"), Optional.of("FTK"), Optional.of("squareMetre"), Optional.of("9.290304 \u00d7 10\u207b\u00b2 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareFootPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareFootPerHour"), "squareFootPerHour", "square foot per hour"), Optional.of("ft\u00b2/h"), Optional.of("M79"), Optional.of("squareMetrePerSecond"), Optional.of("2.58064 \u00d7 10\u207b\u2075 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareFootPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareFootPerSecond"), "squareFootPerSecond", "square foot per second"), Optional.of("ft\u00b2/s"), Optional.of("S3"), Optional.of("squareMetrePerSecond"), Optional.of("0.09290304 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareHectometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareHectometre"), "squareHectometre", "square hectometre"), Optional.of("hm\u00b2"), Optional.of("H18"), Optional.of("squareMetre"), Optional.of("10\u2074 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA, QuantityKinds.AREA))));
        UNITS_BY_NAME.put("squareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareInch"), "squareInch", "square inch"), Optional.of("in\u00b2"), Optional.of("INK"), Optional.of("squareMetre"), Optional.of("6.4516 \u00d7 10\u207b\u2074 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareInchPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareInchPerSecond"), "squareInchPerSecond", "square inch per second"), Optional.of("in\u00b2/s"), Optional.of("G08"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareKilometre"), "squareKilometre", "square kilometre"), Optional.of("km\u00b2"), Optional.of("KMK"), Optional.of("squareMetre"), Optional.of("10\u2076 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetre"), "squareMetre", "square metre"), Optional.of("m\u00b2"), Optional.of("MTK"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareMetreHourDegreeCelsiusPerKilocalorieInternationalTable", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetreHourDegreeCelsiusPerKilocalorieInternationalTable"), "squareMetreHourDegreeCelsiusPerKilocalorieInternationalTable", "square metre hour degree Celsius per kilocalorie (international table)"), Optional.of("m\u00b2\u00b7h\u00b7\u00b0C/kcal"), Optional.of("L14"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION))));
        UNITS_BY_NAME.put("squareMetreKelvinPerWatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetreKelvinPerWatt"), "squareMetreKelvinPerWatt", "square metre kelvin per watt"), Optional.of("m\u00b2\u00b7K/W"), Optional.of("D19"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_INSULANCE, QuantityKinds.COEFFICIENT_OF_THERMAL_INSULATION))));
        UNITS_BY_NAME.put("squareMetrePerJoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerJoule"), "squareMetrePerJoule", "square metre per joule"), Optional.of("m\u00b2/J"), Optional.of("D20"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_CROSS_SECTION))));
        UNITS_BY_NAME.put("squareMetrePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerKilogram"), "squareMetrePerKilogram", "square metre per kilogram"), Optional.of("m\u00b2/kg"), Optional.of("D21"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_ENERGY_TRANSFER_COEFFICIENT, QuantityKinds.MASS_ATTENUATION_COEFFICIENT))));
        UNITS_BY_NAME.put("squareMetrePerLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerLitre"), "squareMetrePerLitre", "square metre per litre"), Optional.of("m\u00b2/l"), Optional.of("E31"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("squareMetrePerMole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerMole"), "squareMetrePerMole", "square metre per mole"), Optional.of("m\u00b2/mol"), Optional.of("D22"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOLAR_ATTENUATION_COEFFICIENT, QuantityKinds.MOLAR_ABSORPTION_COEFFICIENT))));
        UNITS_BY_NAME.put("squareMetrePerNewton", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerNewton"), "squareMetrePerNewton", "square metre per newton"), Optional.of("m\u00b2/N"), Optional.of("H59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA))));
        UNITS_BY_NAME.put("squareMetrePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSecond"), "squareMetrePerSecond", "square metre per second"), Optional.of("m\u00b2/s"), Optional.of("S4"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareMetrePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSecondBar"), "squareMetrePerSecondBar", "square metre per second bar"), Optional.of("m\u00b2/(s\u00b7bar)"), Optional.of("G41"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareMetrePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSecondKelvin"), "squareMetrePerSecondKelvin", "square metre per second kelvin"), Optional.of("m\u00b2/(s\u00b7K)"), Optional.of("G09"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareMetrePerSecondPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSecondPascal"), "squareMetrePerSecondPascal", "square metre per second pascal"), Optional.of("(m\u00b2/s)/Pa"), Optional.of("M82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("squareMetrePerSteradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSteradian"), "squareMetrePerSteradian", "square metre per steradian"), Optional.of("m\u00b2/sr"), Optional.of("D24"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ANGULAR_CROSS_SECTION))));
        UNITS_BY_NAME.put("squareMetrePerSteradianJoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerSteradianJoule"), "squareMetrePerSteradianJoule", "square metre per steradian joule"), Optional.of("m\u00b2/(sr\u00b7J)"), Optional.of("D25"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SPECTRAL_ANGULAR_CROSS_SECTION))));
        UNITS_BY_NAME.put("squareMetrePerVoltSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMetrePerVoltSecond"), "squareMetrePerVoltSecond", "square metre per volt second"), Optional.of("m\u00b2/(V\u00b7s)"), Optional.of("D26"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MOBILITY))));
        UNITS_BY_NAME.put("squareMicrometreSquareMicron", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMicrometreSquareMicron"), "squareMicrometreSquareMicron", "square micrometre (square micron)"), Optional.of("\u00b5m\u00b2"), Optional.of("H30"), Optional.of("squareMetre"), Optional.of("10\u207b\u00b9\u00b2 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareMileBasedOnUsSurveyFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMileBasedOnUsSurveyFoot"), "squareMileBasedOnUsSurveyFoot", "square mile (based on U.S. survey foot)"), Optional.of("mi\u00b2 (US survey)"), Optional.of("M48"), Optional.of("squareMetre"), Optional.of("2.589998 \u00d7 10\u2076 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareMileStatuteMile", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMileStatuteMile"), "squareMileStatuteMile", "square mile (statute mile)"), Optional.of("mi\u00b2"), Optional.of("MIK"), Optional.of("squareKilometre"), Optional.of("2.589988 km\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA))));
        UNITS_BY_NAME.put("squareMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareMillimetre"), "squareMillimetre", "square millimetre"), Optional.of("mm\u00b2"), Optional.of("MMK"), Optional.of("squareMetre"), Optional.of("10\u207b\u2076 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("squareRoofing", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareRoofing"), "squareRoofing", "square, roofing"), Optional.empty(), Optional.of("SQR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("squareYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "squareYard"), "squareYard", "square yard"), Optional.of("yd\u00b2"), Optional.of("YDK"), Optional.of("squareMetre"), Optional.of("8.361274 \u00d7 10\u207b\u00b9 m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AREA, QuantityKinds.AREA, QuantityKinds.ATOMIC_ATTENUATION_COEFFICIENT, QuantityKinds.MIGRATION_AREA, QuantityKinds.CROSS_SECTION, QuantityKinds.EQUIVALENT_ABSORPTION_AREA_OF_A_SURFACE_OR_OBJECT, QuantityKinds.NUCLEAR_QUADRUPOLE_MOMENT, QuantityKinds.SLOWING_DOWN_AREA, QuantityKinds.DIFFUSION_AREA))));
        UNITS_BY_NAME.put("standard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standard"), "standard", "standard"), Optional.of("std"), Optional.of("WSD"), Optional.of("cubicMetre"), Optional.of("4.672 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("standardAccelerationOfFreeFall", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standardAccelerationOfFreeFall"), "standardAccelerationOfFreeFall", "standard acceleration of free fall"), Optional.of("gn"), Optional.of("K40"), Optional.of("metrePerSecondSquared"), Optional.of("9.80665 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY))));
        UNITS_BY_NAME.put("standardAtmosphere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standardAtmosphere"), "standardAtmosphere", "standard atmosphere"), Optional.of("atm"), Optional.of("ATM"), Optional.of("pascal"), Optional.of("101325 Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.SHEAR_MODULUS, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.NORMAL_STRESS, QuantityKinds.BULK_MODULUS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.PRESSURE, QuantityKinds.FUGACITY_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.PRESSURE, QuantityKinds.SHEAR_MODULUS, QuantityKinds.STATIC_PRESSURE, QuantityKinds.NORMAL_STRESS, QuantityKinds.MODULUS_OF_RIGIDITY, QuantityKinds.INSTANTANEOUS_SOUND_PRESSURE, QuantityKinds.MODULUS_OF_ELASTICITY, QuantityKinds.SHEAR_STRESS, QuantityKinds.MODULUS_OF_COMPRESSION, QuantityKinds.PARTIAL_PRESSURE_OF_B_IN_A_GASEOUS_MIXTURE, QuantityKinds.BULK_MODULUS, QuantityKinds.OSMOTIC_PRESSURE))));
        UNITS_BY_NAME.put("standardAtmospherePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standardAtmospherePerMetre"), "standardAtmospherePerMetre", "standard atmosphere per metre"), Optional.of("Atm/m"), Optional.of("P83"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("standardKilolitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standardKilolitre"), "standardKilolitre", "standard kilolitre"), Optional.empty(), Optional.of("DMO"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("standardLitre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "standardLitre"), "standardLitre", "standard litre"), Optional.empty(), Optional.of("STL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("steradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "steradian"), "steradian", "steradian"), Optional.of("sr"), Optional.of("D27"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SOLID_ANGLE))));
        UNITS_BY_NAME.put("stere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stere"), "stere", "stere"), Optional.of("st"), Optional.of("G26"), Optional.of("cubicMetre"), Optional.of("m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("stick", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stick"), "stick", "stick"), Optional.empty(), Optional.of("STC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("stickCigarette", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stickCigarette"), "stickCigarette", "stick, cigarette"), Optional.empty(), Optional.of("STK"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("stickMilitary", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stickMilitary"), "stickMilitary", "stick, military"), Optional.empty(), Optional.of("15"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("stilb", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stilb"), "stilb", "stilb"), Optional.of("sb"), Optional.of("P31"), Optional.of("candelaPerSquareMetre"), Optional.of("10\u2074 cd/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LUMINANCE, QuantityKinds.LUMINANCE))));
        UNITS_BY_NAME.put("stokes", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stokes"), "stokes", "stokes"), Optional.of("St"), Optional.of("91"), Optional.of("squareMetrePerSecond"), Optional.of("10\u207b\u2074 m\u00b2/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY, QuantityKinds.THERMAL_DIFFUSIVITY, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_NUMBER_DENSITY, QuantityKinds.THERMAL_DIFFUSION_COEFFICIENT, QuantityKinds.DIFFUSION_COEFFICIENT, QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("stokesPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stokesPerBar"), "stokesPerBar", "stokes per bar"), Optional.of("St/bar"), Optional.of("G46"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("stokesPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stokesPerKelvin"), "stokesPerKelvin", "stokes per kelvin"), Optional.of("St/K"), Optional.of("G10"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("stokesPerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stokesPerPascal"), "stokesPerPascal", "stokes per pascal"), Optional.of("St/Pa"), Optional.of("M80"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.KINEMATIC_VISCOSITY))));
        UNITS_BY_NAME.put("stoneUk", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "stoneUk"), "stoneUk", "stone (UK)"), Optional.of("st"), Optional.of("STI"), Optional.of("kilogram"), Optional.of("6.350293 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("strand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "strand"), "strand", "strand"), Optional.empty(), Optional.of("E30"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("straw", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "straw"), "straw", "straw"), Optional.empty(), Optional.of("STW"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("strip", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "strip"), "strip", "strip"), Optional.empty(), Optional.of("SR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("syringe", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "syringe"), "syringe", "syringe"), Optional.empty(), Optional.of("SYR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tablespoonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tablespoonUs"), "tablespoonUs", "tablespoon (US)"), Optional.of("tablespoon (US)"), Optional.of("G24"), Optional.of("cubicMetre"), Optional.of("1.478676 \u00d7 10\u207b\u2075 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("tablet", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tablet"), "tablet", "tablet"), Optional.empty(), Optional.of("U2"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("teaspoonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "teaspoonUs"), "teaspoonUs", "teaspoon (US)"), Optional.of("teaspoon (US)"), Optional.of("G25"), Optional.of("cubicMetre"), Optional.of("4.928922 \u00d7 10\u207b\u2076 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("tebibitPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tebibitPerCubicMetre"), "tebibitPerCubicMetre", "tebibit per cubic metre"), Optional.of("Tibit/m\u00b3"), Optional.of("E86"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tebibitPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tebibitPerMetre"), "tebibitPerMetre", "tebibit per metre"), Optional.of("Tibit/m"), Optional.of("E85"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tebibitPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tebibitPerSquareMetre"), "tebibitPerSquareMetre", "tebibit per square metre"), Optional.of("Tibit/m\u00b2"), Optional.of("E87"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tebibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tebibyte"), "tebibyte", "Tebibyte"), Optional.of("TiB"), Optional.of("E61"), Optional.of("byte"), Optional.of("2\u2074\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("technicalAtmospherePerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "technicalAtmospherePerMetre"), "technicalAtmospherePerMetre", "technical atmosphere per metre"), Optional.of("at/m"), Optional.of("P84"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("telecommunicationLineInService", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "telecommunicationLineInService"), "telecommunicationLineInService", "telecommunication line in service"), Optional.empty(), Optional.of("T0"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("telecommunicationLineInServiceAverage", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "telecommunicationLineInServiceAverage"), "telecommunicationLineInServiceAverage", "telecommunication line in service average"), Optional.empty(), Optional.of("UB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("telecommunicationPort", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "telecommunicationPort"), "telecommunicationPort", "telecommunication port"), Optional.empty(), Optional.of("UC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tenDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tenDay"), "tenDay", "ten day"), Optional.empty(), Optional.of("DAD"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tenPack", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tenPack"), "tenPack", "ten pack"), Optional.empty(), Optional.of("TP"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tenPair", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tenPair"), "tenPair", "ten pair"), Optional.empty(), Optional.of("TPR"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tenSet", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tenSet"), "tenSet", "ten set"), Optional.empty(), Optional.of("TST"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tenThousandSticks", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tenThousandSticks"), "tenThousandSticks", "ten thousand sticks"), Optional.empty(), Optional.of("TTS"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("terabit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terabit"), "terabit", "terabit"), Optional.of("Tbit"), Optional.of("E83"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("terabitPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terabitPerSecond"), "terabitPerSecond", "terabit per second"), Optional.of("Tbit/s"), Optional.of("E84"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("terabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terabyte"), "terabyte", "terabyte"), Optional.of("TB"), Optional.of("E35"), Optional.of("byte"), Optional.of("10\u00b9\u00b2 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("terahertz", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terahertz"), "terahertz", "terahertz"), Optional.of("THz"), Optional.of("D29"), Optional.of("hertz"), Optional.of("10\u00b9\u00b2 Hz"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FREQUENCY, QuantityKinds.FREQUENCY))));
        UNITS_BY_NAME.put("terajoule", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terajoule"), "terajoule", "terajoule"), Optional.of("TJ"), Optional.of("D30"), Optional.of("joule"), Optional.of("10\u00b9\u00b2 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("teraohm", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "teraohm"), "teraohm", "teraohm"), Optional.of("T\u2126"), Optional.of("H44"), Optional.of("ohm"), Optional.of("10\u00b9\u00b2 \u2126"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.IMPEDANCE, QuantityKinds.REACTANCE, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT, QuantityKinds.MODULUS_OF_IMPEDANCE, QuantityKinds.IMPEDANCE, QuantityKinds.RESISTANCE_TO_DIRECT_CURRENT, QuantityKinds.REACTANCE, QuantityKinds.COMPLEX_IMPEDANCES, QuantityKinds.RESISTANCE_TO_ALTERNATING_CURRENT))));
        UNITS_BY_NAME.put("terawatt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terawatt"), "terawatt", "terawatt"), Optional.of("TW"), Optional.of("D31"), Optional.of("watt"), Optional.of("10\u00b9\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.ACTIVE_POWER))));
        UNITS_BY_NAME.put("terawattHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "terawattHour"), "terawattHour", "terawatt hour"), Optional.of("TW\u00b7h"), Optional.of("D32"), Optional.of("joule"), Optional.of("3.6 \u00d7 10\u00b9\u2075 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.ENERGY, QuantityKinds.WORK, QuantityKinds.POTENTIAL_ENERGY))));
        UNITS_BY_NAME.put("tesla", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tesla"), "tesla", "tesla"), Optional.of("T"), Optional.of("D33"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_INDUCTION, QuantityKinds.LOWER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.UPPER_CRITICAL_MAGNETIC_FLUX_DENSITY, QuantityKinds.MAGNETIC_POLARIZATION, QuantityKinds.THERMODYNAMIC_CRITICAL_MAGNETIC_FLUX_DENSITY))));
        UNITS_BY_NAME.put("test", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "test"), "test", "test"), Optional.empty(), Optional.of("E53"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("teu", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "teu"), "teu", "TEU"), Optional.empty(), Optional.of("E22"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tex", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tex"), "tex", "tex"), Optional.of("tex (g/km)"), Optional.of("D34"), Optional.of("kilogramPerMetre"), Optional.of("10\u207b\u2076 kg/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LINEAR_MASS, QuantityKinds.LINEAR_DENSITY))));
        UNITS_BY_NAME.put("theoreticalPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "theoreticalPound"), "theoreticalPound", "theoretical pound"), Optional.empty(), Optional.of("24"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("theoreticalTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "theoreticalTon"), "theoreticalTon", "theoretical ton"), Optional.empty(), Optional.of("27"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thermEc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thermEc"), "thermEc", "therm (EC)"), Optional.of("thm (EC)"), Optional.of("N71"), Optional.of("joule"), Optional.of("1.05506 \u00d7 10\u2078 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HEAT, QuantityKinds.ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("thermUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thermUs"), "thermUs", "therm (U.S.)"), Optional.of("thm (US)"), Optional.of("N72"), Optional.of("joule"), Optional.of("1.054804 \u00d7 10\u2078 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.ENERGY, QuantityKinds.HEAT, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("thirtyDayMonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thirtyDayMonth"), "thirtyDayMonth", "30-day month"), Optional.of("mo (30 days)"), Optional.of("M36"), Optional.of("secondUnitOfTime"), Optional.of("2.592000 \u00d7 10\u2076 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("thousand", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousand"), "thousand", "thousand"), Optional.empty(), Optional.of("MIL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thousandBoardFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandBoardFoot"), "thousandBoardFoot", "thousand board foot"), Optional.empty(), Optional.of("MBF"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thousandCubicFoot", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandCubicFoot"), "thousandCubicFoot", "thousand cubic foot"), Optional.of("kft\u00b3"), Optional.of("FC"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thousandCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandCubicMetre"), "thousandCubicMetre", "thousand cubic metre"), Optional.empty(), Optional.of("R9"), Optional.of("cubicMetre"), Optional.of("10\u00b3m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("thousandCubicMetrePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandCubicMetrePerDay"), "thousandCubicMetrePerDay", "thousand cubic metre per day"), Optional.of("km\u00b3/d"), Optional.of("TQD"), Optional.of("cubicMetrePerSecond"), Optional.of("1.15741 \u00d7 10\u207b\u00b2 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("thousandPiece", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandPiece"), "thousandPiece", "thousand piece"), Optional.empty(), Optional.of("T3"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thousandSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandSquareInch"), "thousandSquareInch", "thousand square inch"), Optional.empty(), Optional.of("TI"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("thousandStandardBrickEquivalent", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "thousandStandardBrickEquivalent"), "thousandStandardBrickEquivalent", "thousand standard brick equivalent"), Optional.empty(), Optional.of("MBE"), Optional.empty(), Optional.empty(), Collections.emptySet()));
    }

    private static void init16() {
        UNITS_BY_NAME.put("tonAssay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonAssay"), "tonAssay", "ton, assay"), Optional.empty(), Optional.of("M85"), Optional.of("kilogram"), Optional.of("2.916667 \u00d7 10\u207b\u00b2 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("tonForceUsShort", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonForceUsShort"), "tonForceUsShort", "ton-force (US short)"), Optional.of("ton.sh-force"), Optional.of("L94"), Optional.of("newton"), Optional.of("8.896443 \u00d7 10\u00b3 N"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WEIGHT, QuantityKinds.FORCE, QuantityKinds.FORCE, QuantityKinds.WEIGHT))));
        UNITS_BY_NAME.put("tonLongPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonLongPerDay"), "tonLongPerDay", "ton long per day"), Optional.of("ton (UK)/d"), Optional.of("L85"), Optional.of("kilogramPerSecond"), Optional.of("1.175980 \u00d7 10\u207b\u00b2 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonRegister", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonRegister"), "tonRegister", "ton, register"), Optional.of("RT"), Optional.of("M70"), Optional.of("cubicMetre"), Optional.of("2.831685 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS))));
        UNITS_BY_NAME.put("tonShortPerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonShortPerDay"), "tonShortPerDay", "ton short per day"), Optional.of("ton (US)/d"), Optional.of("L88"), Optional.of("kilogramPerSecond"), Optional.of("1.049982 \u00d7 10\u207b\u00b2 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonShortPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonShortPerDegreeFahrenheit"), "tonShortPerDegreeFahrenheit", "ton short per degree Fahrenheit"), Optional.of("ton (US)/\u00b0F"), Optional.of("L87"), Optional.of("kilogramPerKelvin"), Optional.of("1.632932 \u00d7 10\u00b3 kg/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("tonShortPerHourDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonShortPerHourDegreeFahrenheit"), "tonShortPerHourDegreeFahrenheit", "ton short per hour degree Fahrenheit"), Optional.of("ton (US)/(h\u00b7\u00b0F)"), Optional.of("L89"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonShortPerHourPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonShortPerHourPsi"), "tonShortPerHourPsi", "ton short per hour psi"), Optional.of("(ton (US)/h)/psi"), Optional.of("L90"), Optional.of("kilogramPerSecondPascal"), Optional.of("3.654889 \u00d7 10\u207b\u2075 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonShortPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonShortPerPsi"), "tonShortPerPsi", "ton short per psi"), Optional.of("ton (US)/psi"), Optional.of("L91"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("tonUkLongPerCubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUkLongPerCubicYard"), "tonUkLongPerCubicYard", "ton (UK long) per cubic yard"), Optional.of("ton.l/yd\u00b3 (UK)"), Optional.of("L92"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.328939 \u00d7 10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("tonUkOrLongTonUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUkOrLongTonUs"), "tonUkOrLongTonUs", "ton (UK) or long ton (US)"), Optional.of("ton (UK)"), Optional.of("LTN"), Optional.of("kilogram"), Optional.of("1.016047 \u00d7 10\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("tonUkShipping", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUkShipping"), "tonUkShipping", "ton (UK shipping)"), Optional.of("British shipping ton"), Optional.of("L84"), Optional.of("cubicMetre"), Optional.of("1.1893 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("tonUsOrShortTonUkorus", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUsOrShortTonUkorus"), "tonUsOrShortTonUkorus", "ton (US) or short ton (UK/US)"), Optional.of("ton (US)"), Optional.of("STN"), Optional.of("kilogram"), Optional.of("0.9071847 \u00d7 10\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("tonUsPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUsPerHour"), "tonUsPerHour", "ton (US) per hour"), Optional.of("ton (US) /h"), Optional.of("4W"), Optional.of("kilogramPerSecond"), Optional.of("2.519958 \u00d7 10\u207b\u00b9 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonUsShipping", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUsShipping"), "tonUsShipping", "ton (US shipping)"), Optional.of("(US) shipping ton"), Optional.of("L86"), Optional.of("cubicMetre"), Optional.of("1.1326 m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME, QuantityKinds.SECTION_MODULUS, QuantityKinds.VOLUME))));
        UNITS_BY_NAME.put("tonUsShortPerCubicYard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonUsShortPerCubicYard"), "tonUsShortPerCubicYard", "ton (US short) per cubic yard"), Optional.of("ton.s/yd\u00b3 (US)"), Optional.of("L93"), Optional.of("kilogramPerCubicMetre"), Optional.of("1.186553 \u00d7 10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.DENSITY, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("tonneKilometre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonneKilometre"), "tonneKilometre", "tonne kilometre"), Optional.of("t\u00b7km"), Optional.of("TKM"), Optional.of("kilogramMetre"), Optional.of("10\u2076 kg \u00d7 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TORQUE, QuantityKinds.MOMENT_OF_FORCE, QuantityKinds.MOMENT_OF_A_COUPLE))));
        UNITS_BY_NAME.put("tonneMetricTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonneMetricTon"), "tonneMetricTon", "tonne (metric ton)"), Optional.of("t"), Optional.of("TNE"), Optional.of("kilogram"), Optional.of("10\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS, QuantityKinds.MASS))));
        UNITS_BY_NAME.put("tonnePerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerBar"), "tonnePerBar", "tonne per bar"), Optional.of("t/bar"), Optional.of("L70"), Optional.of("kilogramPerPascal"), Optional.of("10\u207b\u00b2 kg/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("tonnePerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerCubicMetre"), "tonnePerCubicMetre", "tonne per cubic metre"), Optional.of("t/m\u00b3"), Optional.of("D41"), Optional.of("kilogramPerCubicMetre"), Optional.of("10\u00b3 kg/m\u00b3"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.AMOUNT_OF_SUBSTANCE, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.CONCENTRATION_OF_B, QuantityKinds.MASS_CONCENTRATION_OF_B, QuantityKinds.VOLUMIC_MASS))));
        UNITS_BY_NAME.put("tonnePerCubicMetreBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerCubicMetreBar"), "tonnePerCubicMetreBar", "tonne per cubic metre bar"), Optional.of("(t/m\u00b3)/bar"), Optional.of("L77"), Optional.of("kilogramPerCubicMetrePascal"), Optional.of("10\u207b\u00b2 (kg/m\u00b3)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY, QuantityKinds.DENSITY, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY))));
        UNITS_BY_NAME.put("tonnePerCubicMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerCubicMetreKelvin"), "tonnePerCubicMetreKelvin", "tonne per cubic metre kelvin"), Optional.of("(t/m\u00b3)/K"), Optional.of("L76"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("tonnePerDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerDay"), "tonnePerDay", "tonne per day"), Optional.of("t/d"), Optional.of("L71"), Optional.of("kilogramPerSecond"), Optional.of("1.15741 \u00d7 10\u207b\u00b2 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerDayBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerDayBar"), "tonnePerDayBar", "tonne per day bar"), Optional.of("(t/d)/bar"), Optional.of("L73"), Optional.of("kilogramPerSecondPascal"), Optional.of("1.15741 \u00d7 10\u207b\u2077 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerDayKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerDayKelvin"), "tonnePerDayKelvin", "tonne per day kelvin"), Optional.of("(t/d)/K"), Optional.of("L72"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerHour"), "tonnePerHour", "tonne per hour"), Optional.of("t/h"), Optional.of("E18"), Optional.of("kilogramPerSecond"), Optional.of("2.77778 \u00d7 10\u207b\u00b9 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerHourBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerHourBar"), "tonnePerHourBar", "tonne per hour bar"), Optional.of("(t/h)/bar"), Optional.of("L75"), Optional.of("kilogramPerSecondPascal"), Optional.of("2.77778 \u00d7 10\u207b\u2076 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerHourKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerHourKelvin"), "tonnePerHourKelvin", "tonne per hour kelvin"), Optional.of("(t/h)/K"), Optional.of("L74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerKelvin"), "tonnePerKelvin", "tonne per kelvin"), Optional.of("t/K"), Optional.of("L69"), Optional.of("kilogramPerKelvin"), Optional.of("10\u00b3 kg/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.VOLUMIC_MASS, QuantityKinds.MASS_DENSITY, QuantityKinds.DENSITY))));
        UNITS_BY_NAME.put("tonnePerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerMinute"), "tonnePerMinute", "tonne per minute"), Optional.of("t/min"), Optional.of("L78"), Optional.of("kilogramPerSecond"), Optional.of("16.6667 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerMinuteBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerMinuteBar"), "tonnePerMinuteBar", "tonne per minute bar"), Optional.of("(t/min)/bar"), Optional.of("L80"), Optional.of("kilogramPerSecondPascal"), Optional.of("1.66667 \u00d7 10\u207b\u2074 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerMinuteKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerMinuteKelvin"), "tonnePerMinuteKelvin", "tonne per minute kelvin"), Optional.of("(t/min)/K"), Optional.of("L79"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerMonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerMonth"), "tonnePerMonth", "tonne per month"), Optional.of("t/mo"), Optional.of("M88"), Optional.of("kilogramPerSecond"), Optional.of("3.80257053768 \u00d7 10\u207b\u2074 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerSecond"), "tonnePerSecond", "tonne per second"), Optional.of("t/s"), Optional.of("L81"), Optional.of("kilogramPerSecond"), Optional.of("10\u00b3 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerSecondBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerSecondBar"), "tonnePerSecondBar", "tonne per second bar"), Optional.of("(t/s)/bar"), Optional.of("L83"), Optional.of("kilogramPerSecondPascal"), Optional.of("10\u207b\u00b2 (kg/s)/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerSecondKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerSecondKelvin"), "tonnePerSecondKelvin", "tonne per second kelvin"), Optional.of("(t/s)/K"), Optional.of("L82"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("tonnePerYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tonnePerYear"), "tonnePerYear", "tonne per year"), Optional.of("t/y"), Optional.of("M89"), Optional.of("kilogramPerSecond"), Optional.of("3.168808781 \u00d7 10\u207b\u2075 kg/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_FLOW_RATE, QuantityKinds.MASS_FLOW_RATE))));
        UNITS_BY_NAME.put("torrPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "torrPerMetre"), "torrPerMetre", "torr per metre"), Optional.of("Torr/m"), Optional.of("P85"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.HARDNESS_INDEX))));
        UNITS_BY_NAME.put("totalAcidNumber", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "totalAcidNumber"), "totalAcidNumber", "total acid number"), Optional.of("TAN"), Optional.of("TAN"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("treatment", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "treatment"), "treatment", "treatment"), Optional.empty(), Optional.of("U1"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("trillionEur", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "trillionEur"), "trillionEur", "trillion (EUR)"), Optional.empty(), Optional.of("TRL"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("trip", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "trip"), "trip", "trip"), Optional.empty(), Optional.of("E54"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tropicalYear", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tropicalYear"), "tropicalYear", "tropical year"), Optional.of("y (tropical)"), Optional.of("D42"), Optional.of("secondUnitOfTime"), Optional.of("3.155692 5 \u00d7 10\u2077 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("troyOunceOrApothecaryOunce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "troyOunceOrApothecaryOunce"), "troyOunceOrApothecaryOunce", "troy ounce or apothecary ounce"), Optional.of("tr oz"), Optional.of("APZ"), Optional.of("kilogram"), Optional.of("3.110348 \u00d7 10\u207b\u00b3 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("troyPoundUs", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "troyPoundUs"), "troyPoundUs", "troy pound (US)"), Optional.empty(), Optional.of("LBT"), Optional.of("gram"), Optional.of("373.2417 g"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS))));
        UNITS_BY_NAME.put("twentyFootContainer", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "twentyFootContainer"), "twentyFootContainer", "twenty foot container"), Optional.empty(), Optional.of("20"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("tyre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "tyre"), "tyre", "tyre"), Optional.empty(), Optional.of("E23"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("unifiedAtomicMassUnit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "unifiedAtomicMassUnit"), "unifiedAtomicMassUnit", "unified atomic mass unit"), Optional.of("u"), Optional.of("D43"), Optional.of("kilogram"), Optional.of("1.660 538 782 \u00d7 10\u207b\u00b2\u2077 kg"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MASS_DEFECT, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.UNIFIED_ATOMIC_MASS_CONSTANT, QuantityKinds.MASS_OF_ATOM_OF_A_NUCLIDE_X, QuantityKinds.MASS_OF_MOLECULE, QuantityKinds.EFFECTIVE_MASS, QuantityKinds.MASS, QuantityKinds.NUCLIDIC_MASS, QuantityKinds.MASS_EXCESS))));
        UNITS_BY_NAME.put("unitPole", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "unitPole"), "unitPole", "unit pole"), Optional.of("unit pole"), Optional.of("P53"), Optional.of("weber"), Optional.of("1.256637 \u00d7 10\u207b\u2077 Wb"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_QUANTUM, QuantityKinds.MAGNETIC_FLUX_QUANTUM, QuantityKinds.MAGNETIC_FLUX))));
        UNITS_BY_NAME.put("usGallonPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "usGallonPerMinute"), "usGallonPerMinute", "US gallon per minute"), Optional.of("gal (US) /min"), Optional.of("G2"), Optional.of("cubicMetrePerSecond"), Optional.of("6.309020 \u00d7 10\u207b\u2075 m\u00b3/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VOLUME_FLOW_RATE, QuantityKinds.RECOMBINATION_COEFFICIENT, QuantityKinds.INSTANTANEOUS_VOLUME_FLOW_RATE, QuantityKinds.VOLUME_FLOW_RATE))));
        UNITS_BY_NAME.put("use", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "use"), "use", "use"), Optional.empty(), Optional.of("E55"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("var", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "var"), "var", "var"), Optional.of("var"), Optional.of("D44"), Optional.of("voltAmpere"), Optional.of("V \u00d7 A"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.APPARENT_POWER, QuantityKinds.REACTIVE_POWER))));
        UNITS_BY_NAME.put("volt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "volt"), "volt", "volt"), Optional.of("V"), Optional.of("VLT"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TENSION, QuantityKinds.VOLTAGE, QuantityKinds.PELTIER_COEFFICIENT_FOR_SUBSTANCES_A_AND_B, QuantityKinds.ELECTROMOTIVE_FORCE, QuantityKinds.THERMOELECTROMOTIVE_FORCE_BETWEEN_SUBSTANCES_A_AND_B, QuantityKinds.POTENTIAL_DIFFERENCE, QuantityKinds.ELECTRIC_POTENTIAL))));
        UNITS_BY_NAME.put("voltAc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltAc"), "voltAc", "volt AC"), Optional.of("V"), Optional.of("2G"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("voltAmpere", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltAmpere"), "voltAmpere", "volt - ampere"), Optional.of("V\u00b7A"), Optional.of("D46"), Optional.of("watt"), Optional.of("W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT, QuantityKinds.APPARENT_POWER))));
        UNITS_BY_NAME.put("voltAmperePerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltAmperePerKilogram"), "voltAmperePerKilogram", "volt - ampere per kilogram"), Optional.of("V\u00b7A / kg"), Optional.of("VA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("voltDc", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltDc"), "voltDc", "volt DC"), Optional.of("V"), Optional.of("2H"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("voltPerBar", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerBar"), "voltPerBar", "volt per bar"), Optional.of("V/bar"), Optional.of("G60"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerCentimetre"), "voltPerCentimetre", "volt per centimetre"), Optional.of("V/cm"), Optional.of("D47"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerInch"), "voltPerInch", "volt per inch"), Optional.of("V/in"), Optional.of("H23"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerKelvin"), "voltPerKelvin", "volt per kelvin"), Optional.of("V/K"), Optional.of("D48"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.SEEBECK_COEFFICIENT_FOR_SUBSTANCES_A_AND_B))));
        UNITS_BY_NAME.put("voltPerLitreMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerLitreMinute"), "voltPerLitreMinute", "volt per litre minute"), Optional.of("V/(l\u00b7min)"), Optional.of("F87"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerMetre"), "voltPerMetre", "volt per metre"), Optional.of("V/m"), Optional.of("D50"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerMicrosecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerMicrosecond"), "voltPerMicrosecond", "volt per microsecond"), Optional.of("V/\u00b5s"), Optional.of("H24"), Optional.of("voltPerSecond"), Optional.of("10\u2076 V/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerMillimetre"), "voltPerMillimetre", "volt per millimetre"), Optional.of("V/mm"), Optional.of("D51"), Optional.of("voltPerMetre"), Optional.of("10\u00b3 V/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH, QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerPascal", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerPascal"), "voltPerPascal", "volt per pascal"), Optional.of("V/Pa"), Optional.of("N98"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltPerSecond"), "voltPerSecond", "volt per second"), Optional.of("V/s"), Optional.of("H46"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltSecondPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltSecondPerMetre"), "voltSecondPerMetre", "volt second per metre"), Optional.of("V\u00b7s/m"), Optional.of("H45"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltSquareInchPerPoundForce", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltSquareInchPerPoundForce"), "voltSquareInchPerPoundForce", "volt square inch per pound-force"), Optional.of("V/(lbf/in\u00b2)"), Optional.of("H22"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("voltSquaredPerKelvinSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "voltSquaredPerKelvinSquared"), "voltSquaredPerKelvinSquared", "volt squared per kelvin squared"), Optional.of("V\u00b2/K\u00b2"), Optional.of("D45"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ELECTRIC_FIELD_STRENGTH))));
        UNITS_BY_NAME.put("waterHorsePower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "waterHorsePower"), "waterHorsePower", "water horse power"), Optional.empty(), Optional.of("F80"), Optional.of("watt"), Optional.of("7.46043 \u00d7 10\u00b2 W"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POWER, QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("watt", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "watt"), "watt", "watt"), Optional.of("W"), Optional.of("WTT"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGYFLUX, QuantityKinds.ACTIVE_POWER, QuantityKinds.HEAT_FLOW_RATE, QuantityKinds.SOUND_POWER, QuantityKinds.POWER, QuantityKinds.RADIANT_POWER, QuantityKinds.POWER_FOR_DIRECT_CURRENT))));
        UNITS_BY_NAME.put("wattHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattHour"), "wattHour", "watt hour"), Optional.of("W\u00b7h"), Optional.of("WHR"), Optional.of("joule"), Optional.of("3.6 \u00d7 10\u00b3 J"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.WORK, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.REACTION_ENERGY, QuantityKinds.WORK_FUNCTION, QuantityKinds.ACTIVE_ENERGY, QuantityKinds.KINETIC_ENERGY, QuantityKinds.LEVEL_WIDTH, QuantityKinds.MEAN_ENERGY_IMPARTED, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.RADIANT_ENERGY, QuantityKinds.POTENTIAL_ENERGY, QuantityKinds.ENERGY, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.WORK, QuantityKinds.HEAT, QuantityKinds.HARTREE_ENERGY, QuantityKinds.ENERGY_IMPARTED, QuantityKinds.ENTHALPY, QuantityKinds.ALPHA_DISINTEGRATION_ENERGY))));
        UNITS_BY_NAME.put("wattPerCubicMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerCubicMetre"), "wattPerCubicMetre", "watt per cubic metre"), Optional.of("W/m\u00b3"), Optional.of("H47"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.RADIANT_ENERGY, QuantityKinds.RADIANT_EXITANCE, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE))));
        UNITS_BY_NAME.put("wattPerKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerKelvin"), "wattPerKelvin", "watt per kelvin"), Optional.of("W/K"), Optional.of("D52"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTANCE))));
        UNITS_BY_NAME.put("wattPerKilogram", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerKilogram"), "wattPerKilogram", "watt per kilogram"), Optional.of("W/kg"), Optional.of("WA"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("wattPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerMetre"), "wattPerMetre", "watt per metre"), Optional.of("W/m"), Optional.of("H74"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_ENERGY, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.RADIANT_EXITANCE, QuantityKinds.FIRST_RADIATION_CONSTANT))));
        UNITS_BY_NAME.put("wattPerMetreDegreeCelsius", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerMetreDegreeCelsius"), "wattPerMetreDegreeCelsius", "watt per metre degree Celsius"), Optional.of("W/(m\u00b7\u00b0C)"), Optional.of("N80"), Optional.of("wattPerMetreKelvin"), Optional.of("W/(m \u00d7 K)"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY, QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("wattPerMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerMetreKelvin"), "wattPerMetreKelvin", "watt per metre kelvin"), Optional.of("W/(m\u00b7K)"), Optional.of("D53"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THERMAL_CONDUCTIVITY))));
        UNITS_BY_NAME.put("wattPerSquareCentimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSquareCentimetre"), "wattPerSquareCentimetre", "watt per square centimetre"), Optional.of("W/cm\u00b2"), Optional.of("N48"), Optional.of("wattPerSquareMetre"), Optional.of("10\u2074 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("wattPerSquareInch", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSquareInch"), "wattPerSquareInch", "watt per square inch"), Optional.of("W/in\u00b2"), Optional.of("N49"), Optional.of("wattPerSquareMetre"), Optional.of("1.550003 \u00d7 10\u00b3 W/m\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("wattPerSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSquareMetre"), "wattPerSquareMetre", "watt per square metre"), Optional.of("W/m\u00b2"), Optional.of("D54"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.POYNTING_VECTOR, QuantityKinds.FLUENCE_RATE, QuantityKinds.IRRADIANCE, QuantityKinds.SOUND_INTENSITY, QuantityKinds.RADIANT_ENERGY, QuantityKinds.FIRST_RADIATION_CONSTANT, QuantityKinds.ENERGY_FLUENCE_RATE, QuantityKinds.ENERGY_FLUX_DENSITY, QuantityKinds.DENSITY_OF_HEAT_FLOW_RATE, QuantityKinds.RADIANT_EXITANCE))));
        UNITS_BY_NAME.put("wattPerSquareMetreKelvin", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSquareMetreKelvin"), "wattPerSquareMetreKelvin", "watt per square metre kelvin"), Optional.of("W/(m\u00b2\u00b7K)"), Optional.of("D55"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.COEFFICIENT_OF_HEAT_TRANSFER))));
        UNITS_BY_NAME.put("wattPerSquareMetreKelvinToTheFourthPower", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSquareMetreKelvinToTheFourthPower"), "wattPerSquareMetreKelvinToTheFourthPower", "watt per square metre kelvin to the fourth power"), Optional.of("W/(m\u00b2\u00b7K\u2074)"), Optional.of("D56"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.STEFAN_BOLTZMANN_CONSTANT))));
        UNITS_BY_NAME.put("wattPerSteradian", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSteradian"), "wattPerSteradian", "watt per steradian"), Optional.of("W/sr"), Optional.of("D57"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANT_INTENSITY))));
        UNITS_BY_NAME.put("wattPerSteradianSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattPerSteradianSquareMetre"), "wattPerSteradianSquareMetre", "watt per steradian square metre"), Optional.of("W/(sr\u00b7m\u00b2)"), Optional.of("D58"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.RADIANCE))));
        UNITS_BY_NAME.put("wattSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattSecond"), "wattSecond", "watt second"), Optional.of("W\u00b7s"), Optional.of("J55"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ENERGY, QuantityKinds.QUANTITY_OF_HEAT, QuantityKinds.THERMODYNAMIC_ENERGY, QuantityKinds.HELMHOLTZ_FUNCTION, QuantityKinds.HELMHOLTZ_FREE_ENERGY, QuantityKinds.ENTHALPY, QuantityKinds.HEAT))));
        UNITS_BY_NAME.put("wattSquareMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wattSquareMetre"), "wattSquareMetre", "watt square metre"), Optional.of("W\u00b7m\u00b2"), Optional.of("Q21"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("weber", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "weber"), "weber", "weber"), Optional.of("Wb"), Optional.of("WEB"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_FLUX_QUANTUM, QuantityKinds.MAGNETIC_FLUX))));
        UNITS_BY_NAME.put("weberMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "weberMetre"), "weberMetre", "weber metre"), Optional.of("Wb\u00b7m"), Optional.of("P50"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_DIPOLE_MOMENT))));
        UNITS_BY_NAME.put("weberPerMetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "weberPerMetre"), "weberPerMetre", "weber per metre"), Optional.of("Wb/m"), Optional.of("D59"), Optional.empty(), Optional.empty(), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_VECTOR_POTENTIAL))));
        UNITS_BY_NAME.put("weberPerMillimetre", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "weberPerMillimetre"), "weberPerMillimetre", "weber per millimetre"), Optional.of("Wb/mm"), Optional.of("D60"), Optional.of("weberPerMetre"), Optional.of("10\u00b3 Wb/m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.MAGNETIC_VECTOR_POTENTIAL, QuantityKinds.MAGNETIC_VECTOR_POTENTIAL))));
        UNITS_BY_NAME.put("weberToThePowerMinusOne", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "weberToThePowerMinusOne"), "weberToThePowerMinusOne", "weber to the power minus one"), Optional.of("1/Wb"), Optional.of("Q23"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("week", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "week"), "week", "week"), Optional.of("wk"), Optional.of("WEE"), Optional.of("secondUnitOfTime"), Optional.of("6.048 \u00d7 10\u2075 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME, QuantityKinds.TIME))));
        UNITS_BY_NAME.put("well", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "well"), "well", "well"), Optional.empty(), Optional.of("E56"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("wetKilo", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wetKilo"), "wetKilo", "wet kilo"), Optional.empty(), Optional.of("W2"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("wetPound", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wetPound"), "wetPound", "wet pound"), Optional.empty(), Optional.of("WB"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("wetTon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wetTon"), "wetTon", "wet ton"), Optional.empty(), Optional.of("WE"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("wineGallon", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "wineGallon"), "wineGallon", "wine gallon"), Optional.empty(), Optional.of("WG"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("workingDay", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "workingDay"), "workingDay", "working day"), Optional.empty(), Optional.of("E49"), Optional.empty(), Optional.empty(), Collections.emptySet()));
    }

    private static void init17() {
        UNITS_BY_NAME.put("workingMonth", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "workingMonth"), "workingMonth", "working month"), Optional.empty(), Optional.of("WM"), Optional.empty(), Optional.empty(), Collections.emptySet()));
        UNITS_BY_NAME.put("yard", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yard"), "yard", "yard"), Optional.of("yd"), Optional.of("YRD"), Optional.of("metre"), Optional.of("0.9144 m"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.THICKNESS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.HEIGHT, QuantityKinds.DIAMETER, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.THICKNESS, QuantityKinds.PARTICLE_POSITION_VECTOR, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.FOCAL_DISTANCE, QuantityKinds.RADIUS, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISPLACEMENT_VECTOR_OF_ION_OR_ATOM, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.COMPTON_WAVELENGTH, QuantityKinds.SLOWING_DOWN_LENGTH, QuantityKinds.MIGRATION_LENGTH, QuantityKinds.MEAN_FREE_PATH, QuantityKinds.EQUILIBRIUM_POSITION_VECTOR_OF_ION_OR_ATOM, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_DISPLACEMENT, QuantityKinds.IMAGE_DISTANCE, QuantityKinds.BREADTH, QuantityKinds.LENGTH, QuantityKinds.HALF_VALUE_THICKNESS, QuantityKinds.COHERENCE_LENGTH, QuantityKinds.LATTICE_VECTOR, QuantityKinds.LONDON_PENETRATION_DEPTH, QuantityKinds.DIFFUSION_LENGTH, QuantityKinds.MEAN_FREE_PATH_OF_PHONONS_OR_ELECTRONS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUX_DENSITY, QuantityKinds.HALF_THICKNESS, QuantityKinds.HEIGHT, QuantityKinds.ELECTRON_RADIUS, QuantityKinds.DISTANCE, QuantityKinds.OBJECT_DISTANCE, QuantityKinds.BOHR_RADIUS, QuantityKinds.DIFFUSION_COEFFICIENT_FOR_NEUTRON_FLUENCE_RATE, QuantityKinds.NUCLEAR_RADIUS, QuantityKinds.WAVELENGTH, QuantityKinds.FUNDAMENTAL_LATTICE_VECTOR, QuantityKinds.MEAN_LINEAR_RANGE))));
        UNITS_BY_NAME.put("yardPerDegreeFahrenheit", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerDegreeFahrenheit"), "yardPerDegreeFahrenheit", "yard per degree Fahrenheit"), Optional.of("yd/\u00b0F"), Optional.of("L98"), Optional.of("metrePerKelvin"), Optional.of("1.64592 m/K"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.THICKNESS, QuantityKinds.LENGTH, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DISTANCE, QuantityKinds.RADIUS, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.RADIUS, QuantityKinds.HEIGHT, QuantityKinds.THICKNESS, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.BREADTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS_OF_CURVATURE))));
        UNITS_BY_NAME.put("yardPerHour", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerHour"), "yardPerHour", "yard per hour"), Optional.of("yd/h"), Optional.of("M66"), Optional.of("metrePerSecond"), Optional.of("2.54 \u00d7 10\u207b\u2074 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES))));
        UNITS_BY_NAME.put("yardPerMinute", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerMinute"), "yardPerMinute", "yard per minute"), Optional.of("yd/min"), Optional.of("M65"), Optional.of("metrePerSecond"), Optional.of("1.524 \u00d7 10\u207b\u00b2 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY, QuantityKinds.PHASE_VELOCITY))));
        UNITS_BY_NAME.put("yardPerPsi", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerPsi"), "yardPerPsi", "yard per psi"), Optional.of("yd/psi"), Optional.of("L99"), Optional.of("metrePerPascal"), Optional.of("1.326225 \u00d7 10\u207b\u2074 m/Pa"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.DIAMETER, QuantityKinds.HEIGHT, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.DISTANCE, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.LENGTH, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.BREADTH, QuantityKinds.RADIUS, QuantityKinds.THICKNESS, QuantityKinds.CARTESIAN_COORDINATES, QuantityKinds.RADIUS, QuantityKinds.LENGTH_OF_PATH, QuantityKinds.DIAMETER, QuantityKinds.RADIUS_OF_CURVATURE, QuantityKinds.HEIGHT, QuantityKinds.LENGTH, QuantityKinds.BREADTH, QuantityKinds.DISTANCE, QuantityKinds.THICKNESS))));
        UNITS_BY_NAME.put("yardPerSecond", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerSecond"), "yardPerSecond", "yard per second"), Optional.of("yd/s"), Optional.of("M64"), Optional.of("metrePerSecond"), Optional.of("9.144 \u00d7 10\u207b\u00b9 m/s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY_OF_SOUND_PHASE_VELOCITY, QuantityKinds.PHASE_VELOCITY, QuantityKinds.NEUTRON_SPEED, QuantityKinds.PHASE_SPEED_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.VELOCITY, QuantityKinds.VELOCITY_SPEED_ON_PROPAGATION_OF_ELECTROMAGNETIC_WAVES_IN_VACUO, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_VELOCITY, QuantityKinds.PHASE_VELOCITY_OF_ELECTROMAGNETIC_WAVES, QuantityKinds.PHASE_VELOCITY, QuantityKinds.GROUP_VELOCITY, QuantityKinds.VELOCITY))));
        UNITS_BY_NAME.put("yardPerSecondSquared", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yardPerSecondSquared"), "yardPerSecondSquared", "yard per second squared"), Optional.of("yd/s\u00b2"), Optional.of("M40"), Optional.of("metrePerSecondSquared"), Optional.of("9.144 \u00d7 10\u207b\u00b9 m/s\u00b2"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.ACCELERATION, QuantityKinds.INSTANTANEOUS_SOUND_PARTICLE_ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION_DUE_TO_GRAVITY, QuantityKinds.ACCELERATION, QuantityKinds.ACCELERATION_OF_FREE_FALL))));
        UNITS_BY_NAME.put("year", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "year"), "year", "year"), Optional.of("y"), Optional.of("ANN"), Optional.of("secondUnitOfTime"), Optional.of("3.15576 \u00d7 10\u2077 s"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.TIME, QuantityKinds.TIME_CONSTANT, QuantityKinds.REACTOR_TIME_CONSTANT, QuantityKinds.HALF_LIFE, QuantityKinds.MEAN_LIFE, QuantityKinds.TIME, QuantityKinds.RELAXATION_TIME, QuantityKinds.PERIOD, QuantityKinds.CARRIER_LIFE_TIME, QuantityKinds.PERIODIC_TIME, QuantityKinds.REVERBERATION_TIME))));
        UNITS_BY_NAME.put("yobibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yobibyte"), "yobibyte", "Yobibyte"), Optional.of("YiB"), Optional.empty(), Optional.of("byte"), Optional.of("2\u2078\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("yottabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "yottabyte"), "yottabyte", "Yottabyte"), Optional.of("YB"), Optional.empty(), Optional.of("byte"), Optional.of("10\u00b2\u2074 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("zebibyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "zebibyte"), "zebibyte", "Zebibyte"), Optional.of("ZiB"), Optional.empty(), Optional.of("byte"), Optional.of("2\u2077\u2070 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("zettabyte", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "zettabyte"), "zettabyte", "Zettabyte"), Optional.of("ZB"), Optional.empty(), Optional.of("byte"), Optional.of("10\u00b2\u00b9 B"), new HashSet<QuantityKind>(Arrays.asList(QuantityKinds.INFORMATION_ENTROPY, QuantityKinds.INFORMATION_ENTROPY))));
        UNITS_BY_NAME.put("zone", version -> new DefaultUnit(MetaModelBaseAttributes.from(version, Units.urn(version, "zone"), "zone", "zone"), Optional.empty(), Optional.of("E57"), Optional.empty(), Optional.empty(), Collections.emptySet()));
    }

    public static synchronized Optional<Unit> fromName(String name, KnownVersion metaModelVersion) {
        if (UNITS_BY_NAME.isEmpty()) {
            Units.init0();
            Units.init1();
            Units.init2();
            Units.init3();
            Units.init4();
            Units.init5();
            Units.init6();
            Units.init7();
            Units.init8();
            Units.init9();
            Units.init10();
            Units.init11();
            Units.init12();
            Units.init13();
            Units.init14();
            Units.init15();
            Units.init16();
            Units.init17();
        }
        return Optional.ofNullable(UNITS_BY_NAME.get(name)).map(unitGenerator -> (Unit)unitGenerator.apply(metaModelVersion));
    }

    public static Optional<Unit> fromName(String name) {
        return Units.fromName(name, LATEST);
    }

    public static Optional<Unit> fromCode(String code, KnownVersion metaModelVersion) {
        if (UNITS_BY_NAME.isEmpty()) {
            Units.fromName("");
        }
        return UNITS_BY_NAME.values().stream().map(unitGenerator -> (Unit)unitGenerator.apply(metaModelVersion)).filter(unit -> unit.getCode().map(code2 -> code2.equals(code)).orElse(false)).findAny();
    }

    public static Optional<Unit> fromCode(String code) {
        return Units.fromCode(code, LATEST);
    }

    public static Set<Unit> fromSymbol(String symbol, KnownVersion metaModelVersion) {
        if (UNITS_BY_NAME.isEmpty()) {
            Units.fromName("");
        }
        return UNITS_BY_NAME.values().stream().map(unitGenerator -> (Unit)unitGenerator.apply(metaModelVersion)).flatMap(unit -> unit.getSymbol().filter(symbol2 -> symbol2.equals(symbol)).stream().map(symbol2 -> unit)).collect(Collectors.toSet());
    }

    public static Set<Unit> fromSymbol(String symbol) {
        return Units.fromSymbol(symbol, LATEST);
    }

    public static Set<Unit> unitsWithQuantityKind(QuantityKind quantityKind, KnownVersion metaModelVersion) {
        if (UNITS_BY_NAME.isEmpty()) {
            Units.fromName("");
        }
        return UNITS_BY_NAME.values().stream().map(unitGenerator -> (Unit)unitGenerator.apply(metaModelVersion)).filter(unit -> unit.getQuantityKinds().contains(quantityKind)).collect(Collectors.toSet());
    }

    public static Set<Unit> unitsWithQuantityKind(QuantityKind quantityKind) {
        return Units.unitsWithQuantityKind(quantityKind, LATEST);
    }
}

