/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BoundDefinition {
    OPEN{

        @Override
        public <T extends Comparable<T>> boolean isValid(T value, T limit) {
            return true;
        }

        @Override
        public <T extends Duration> boolean isValid(T value, T limit) {
            return true;
        }

        @Override
        public <T extends XMLGregorianCalendar> boolean isValid(T value, T limit) {
            return true;
        }
    }
    ,
    AT_LEAST{

        @Override
        public <T extends Comparable<T>> boolean isValid(T value, T limit) {
            return value.compareTo(limit) >= 0;
        }

        @Override
        public <T extends Duration> boolean isValid(T value, T limit) {
            return value.compare(limit) >= 0;
        }

        @Override
        public <T extends XMLGregorianCalendar> boolean isValid(T value, T limit) {
            return value.compare(limit) >= 0;
        }
    }
    ,
    GREATER_THAN{

        @Override
        public <T extends Comparable<T>> boolean isValid(T value, T limit) {
            return value.compareTo(limit) > 0;
        }

        @Override
        public <T extends Duration> boolean isValid(T value, T limit) {
            return value.compare(limit) > 0;
        }

        @Override
        public <T extends XMLGregorianCalendar> boolean isValid(T value, T limit) {
            return value.compare(limit) > 0;
        }
    }
    ,
    LESS_THAN{

        @Override
        public <T extends Comparable<T>> boolean isValid(T value, T limit) {
            return value.compareTo(limit) < 0;
        }

        @Override
        public <T extends Duration> boolean isValid(T value, T limit) {
            return value.compare(limit) < 0;
        }

        @Override
        public <T extends XMLGregorianCalendar> boolean isValid(T value, T limit) {
            return value.compare(limit) < 0;
        }
    }
    ,
    AT_MOST{

        @Override
        public <T extends Comparable<T>> boolean isValid(T value, T limit) {
            return value.compareTo(limit) <= 0;
        }

        @Override
        public <T extends Duration> boolean isValid(T value, T limit) {
            return value.compare(limit) <= 0;
        }

        @Override
        public <T extends XMLGregorianCalendar> boolean isValid(T value, T limit) {
            return value.compare(limit) <= 0;
        }
    };


    public String toString() {
        return this.name().replaceAll("_", " ").toLowerCase();
    }

    public abstract <T extends Comparable<T>> boolean isValid(T var1, T var2);

    public abstract <T extends Duration> boolean isValid(T var1, T var2);

    public abstract <T extends XMLGregorianCalendar> boolean isValid(T var1, T var2);
}

