/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.esmf.metamodel.CollectionValue;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.Value;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;
import org.eclipse.esmf.samm.KnownVersion;

public class DefaultCollectionValue
implements CollectionValue {
    private final Collection<Value> values;
    private final CollectionValue.CollectionType collectionType;
    private final Type elementType;

    public DefaultCollectionValue(Collection<Value> values, CollectionValue.CollectionType collectionType, Type elementType) {
        this.values = values;
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    @Override
    public Collection<Value> getValues() {
        return this.values;
    }

    @Override
    public Type getType() {
        return this.elementType;
    }

    @Override
    public CollectionValue.CollectionType getCollectionType() {
        return this.collectionType;
    }

    @Override
    public KnownVersion getMetaModelVersion() {
        return this.elementType.getMetaModelVersion();
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitCollectionValue(this, context);
    }

    public String toString() {
        return new StringJoiner(", ", DefaultCollectionValue.class.getSimpleName() + "[", "]").add("values=" + this.values).add("collectionType=" + this.collectionType).add("elementType=" + this.elementType).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCollectionValue that = (DefaultCollectionValue)o;
        return Objects.equals(this.values, that.values) && Objects.equals((Object)this.collectionType, (Object)that.collectionType) && Objects.equals(this.elementType, that.elementType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.values, this.collectionType, this.elementType});
    }
}

