/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import com.google.common.base.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.esmf.metamodel.QuantityKind;
import org.eclipse.esmf.metamodel.Unit;
import org.eclipse.esmf.metamodel.impl.ModelElementImpl;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;

public class DefaultUnit
extends ModelElementImpl
implements Unit {
    private final Optional<String> symbol;
    private final Optional<String> code;
    private final Optional<String> referenceUnit;
    private final Optional<String> conversionFactor;
    private final Set<QuantityKind> quantityKinds;

    public DefaultUnit(MetaModelBaseAttributes metaModelBaseAttributes, Optional<String> symbol, Optional<String> code, Optional<String> referenceUnit, Optional<String> conversionFactor, Set<QuantityKind> quantityKinds) {
        super(metaModelBaseAttributes);
        this.symbol = symbol;
        this.code = code;
        this.referenceUnit = referenceUnit;
        this.conversionFactor = conversionFactor;
        this.quantityKinds = quantityKinds;
    }

    @Override
    public Optional<String> getSymbol() {
        return this.symbol;
    }

    @Override
    public Optional<String> getCode() {
        return this.code;
    }

    @Override
    public Optional<String> getReferenceUnit() {
        return this.referenceUnit;
    }

    @Override
    public Optional<String> getConversionFactor() {
        return this.conversionFactor;
    }

    @Override
    public Set<QuantityKind> getQuantityKinds() {
        return this.quantityKinds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUnit that = (DefaultUnit)o;
        return Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal(this.code, that.code);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.code, this.referenceUnit, this.conversionFactor, this.quantityKinds});
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitUnit(this, context);
    }

    public String toString() {
        return new StringJoiner(", ", DefaultUnit.class.getSimpleName() + "[", "]").add("symbol=" + this.symbol).add("code=" + this.code).add("referenceUnit=" + this.referenceUnit).add("conversionFactor=" + this.conversionFactor).add("quantityKinds=" + this.quantityKinds).toString();
    }
}

