/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.NamedElement;
import org.eclipse.esmf.metamodel.datatypes.LangString;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.samm.KnownVersion;

public abstract class ModelElementImpl
implements ModelElement,
NamedElement,
Comparable<ModelElementImpl> {
    private final KnownVersion metaModelVersion;
    private final Optional<AspectModelUrn> urn;
    private final String name;
    private final Set<LangString> preferredNames;
    private final Set<LangString> descriptions;
    private final List<String> see;
    private final boolean hasSyntheticName;

    ModelElementImpl(MetaModelBaseAttributes metaModelBaseAttributes) {
        this.metaModelVersion = metaModelBaseAttributes.getMetaModelVersion();
        this.urn = metaModelBaseAttributes.getUrn();
        this.name = metaModelBaseAttributes.getName();
        this.preferredNames = metaModelBaseAttributes.getPreferredNames();
        this.descriptions = metaModelBaseAttributes.getDescriptions();
        this.see = metaModelBaseAttributes.getSee();
        this.hasSyntheticName = metaModelBaseAttributes.hasSyntheticName();
    }

    @Override
    public Optional<AspectModelUrn> getAspectModelUrn() {
        return this.urn;
    }

    @Override
    public KnownVersion getMetaModelVersion() {
        return this.metaModelVersion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<LangString> getPreferredNames() {
        return this.preferredNames;
    }

    @Override
    public Set<LangString> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public List<String> getSee() {
        return this.see;
    }

    @Override
    public boolean hasSyntheticName() {
        return this.hasSyntheticName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelElementImpl base = (ModelElementImpl)o;
        return Objects.equals(this.urn, base.urn) && Objects.equals(this.name, base.name);
    }

    public int hashCode() {
        return Objects.hash(this.urn, this.name);
    }

    @Override
    public int compareTo(ModelElementImpl o) {
        if (this.urn.isPresent() && o.urn.isPresent()) {
            return this.urn.get().compareTo(o.urn.get());
        }
        return Comparator.comparing(ModelElementImpl::getMetaModelVersion).thenComparing(ModelElementImpl::getName).thenComparing(ModelElementImpl::hasSyntheticName).compare(this, o);
    }
}

