/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMM;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;

public class AttributeValueRetriever {
    protected final SAMM samm;

    public AttributeValueRetriever(SAMM samm) {
        this.samm = samm;
    }

    protected Statement attributeValue(Resource modelElement, Property attribute) {
        return this.optionalAttributeValue(modelElement, attribute).orElseThrow(() -> new AspectLoadingException("Missing attribute " + attribute + " on " + modelElement));
    }

    protected Optional<Statement> optionalAttributeValue(Resource modelElement, Property attribute) {
        return ((Stream)this.attributeValues(modelElement, attribute).stream().sequential()).findFirst();
    }

    private boolean isRdfList(Resource resource) {
        return resource.isAnon() && (resource.hasProperty(RDF.rest) || resource.equals((Object)RDF.nil));
    }

    protected List<Statement> attributeValues(Resource modelElement, Property attribute) {
        ArrayList<Statement> result = new ArrayList<Statement>();
        StmtIterator iterator = modelElement.listProperties(attribute);
        while (iterator.hasNext()) {
            Statement statement = (Statement)iterator.next();
            if (statement.getObject().isResource() && this.isRdfList(statement.getObject().asResource())) {
                ((RDFList)statement.getObject().as(RDFList.class)).mapWith(listValue -> modelElement.getModel().createStatement(modelElement, attribute, listValue)).forEach(result::add);
                continue;
            }
            result.add(statement);
        }
        StmtIterator referenceIterator = modelElement.listProperties(this.samm.property());
        if (referenceIterator.hasNext()) {
            RDFNode referencedElement = ((Statement)referenceIterator.next()).getObject();
            if (!referencedElement.isResource()) {
                throw new AspectLoadingException("samm:property on " + modelElement + " must point to a Property");
            }
            result.addAll(this.attributeValues(referencedElement.asResource(), attribute));
            return result;
        }
        StmtIterator extendsIterator = modelElement.listProperties(this.samm._extends());
        if (extendsIterator.hasNext()) {
            RDFNode superElementNode = ((Statement)extendsIterator.next()).getObject();
            if (!superElementNode.isResource()) {
                throw new AspectLoadingException("samm:extends on " + modelElement + " must point to a valid model element");
            }
            result.addAll(this.attributeValues(superElementNode.asResource(), attribute));
        }
        ArrayList<Statement> filteredResult = new ArrayList<Statement>();
        HashSet<String> assertedLanguageTags = new HashSet<String>();
        for (Statement statement : result) {
            String languageTag;
            if (statement.getObject().isLiteral() && !(languageTag = statement.getObject().asLiteral().getLanguage()).isEmpty()) {
                if (assertedLanguageTags.contains(languageTag)) continue;
                assertedLanguageTags.add(languageTag);
            }
            filteredResult.add(statement);
        }
        return filteredResult;
    }
}

