/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.eclipse.esmf.aspectmodel.resolver.services.ExtendedXsdDataType;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMMC;
import org.eclipse.esmf.aspectmodel.vocabulary.UNIT;
import org.eclipse.esmf.metamodel.AbstractEntity;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.CollectionValue;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.EntityInstance;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.Value;
import org.eclipse.esmf.metamodel.datatypes.LangString;
import org.eclipse.esmf.metamodel.impl.DefaultCollectionValue;
import org.eclipse.esmf.metamodel.impl.DefaultEntityInstance;
import org.eclipse.esmf.metamodel.impl.DefaultScalar;
import org.eclipse.esmf.metamodel.impl.DefaultScalarValue;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;
import org.eclipse.esmf.metamodel.loader.AttributeValueRetriever;
import org.eclipse.esmf.metamodel.loader.CurieRdfType;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;
import org.eclipse.esmf.samm.KnownVersion;

public abstract class Instantiator<T extends ModelElement>
extends AttributeValueRetriever
implements Function<Resource, T> {
    protected final ModelElementFactory modelElementFactory;
    protected Class<T> targetClass;
    protected SAMMC sammc;
    protected UNIT unit;
    protected Model model;
    protected KnownVersion metaModelVersion;
    protected final RDFDatatype curieDataType = new CurieRdfType();

    public Instantiator(ModelElementFactory modelElementFactory, Class<T> targetClass) {
        super(modelElementFactory.getSamm());
        this.modelElementFactory = modelElementFactory;
        this.targetClass = targetClass;
        this.sammc = modelElementFactory.getSammc();
        this.unit = modelElementFactory.getUnit();
        this.model = modelElementFactory.getModel();
        this.metaModelVersion = modelElementFactory.getMetaModelVersion();
    }

    protected MetaModelBaseAttributes buildBaseAttributes(Resource resource) {
        return MetaModelBaseAttributes.fromModelElement(this.metaModelVersion, resource, this.model, this.samm);
    }

    protected Statement propertyValueFromTypeTree(Resource subject, org.apache.jena.rdf.model.Property property) {
        Optional<Statement> valueStatement = this.optionalAttributeValue(subject, property);
        if (valueStatement.isPresent()) {
            return valueStatement.get();
        }
        Optional<Statement> propertyStatement = this.optionalAttributeValue(subject, this.samm.property());
        if (propertyStatement.isPresent()) {
            return this.propertyValueFromTypeTree(propertyStatement.get().getObject().asResource(), property);
        }
        Statement extendsStatement = this.optionalAttributeValue(subject, this.samm._extends()).orElseThrow(() -> new AspectLoadingException("Property " + property + " not found on " + subject + " or its supertypes"));
        Resource superType = extendsStatement.getObject().asResource();
        return this.propertyValueFromTypeTree(superType, property);
    }

    protected List<Property> getPropertiesModels(Resource elementWithProperties, org.apache.jena.rdf.model.Property rootProperty) {
        return this.getResourcesFromList(elementWithProperties, rootProperty).map(propertyResource -> this.modelElementFactory.create(Property.class, (Resource)propertyResource)).collect(Collectors.toList());
    }

    protected Stream<RDFNode> getNodesFromList(Resource element, org.apache.jena.rdf.model.Property property) {
        return Optional.ofNullable(element.getProperty(property)).stream().flatMap(p -> ((RDFList)p.getObject().as(RDFList.class)).asJavaList().stream());
    }

    protected Stream<Resource> getResourcesFromList(Resource element, org.apache.jena.rdf.model.Property property) {
        return this.getNodesFromList(element, property).map(RDFNode::asResource);
    }

    protected Type getType(Resource characteristicResource) {
        Statement dataType = this.getDataType(characteristicResource);
        Resource dataTypeResource = dataType.getObject().asResource();
        Optional<Statement> entityStatement = this.optionalAttributeValue(dataTypeResource, RDF.type);
        if (entityStatement.isPresent() && this.samm.Entity().equals((Object)entityStatement.get().getObject().asResource())) {
            return this.modelElementFactory.create(Entity.class, entityStatement.get().getSubject());
        }
        if (entityStatement.isPresent() && this.samm.AbstractEntity().equals((Object)entityStatement.get().getObject().asResource())) {
            return this.modelElementFactory.create(AbstractEntity.class, entityStatement.get().getSubject());
        }
        return new DefaultScalar(dataTypeResource.getURI(), this.metaModelVersion);
    }

    private Statement getDataType(Resource resource) {
        return Optional.ofNullable(resource.getPropertyResourceValue(this.samm.baseCharacteristic())).map(this::getDataType).orElseGet(() -> resource.getProperty(this.samm.dataType()));
    }

    protected Optional<Characteristic> getElementCharacteristic(Resource collection) {
        return this.optionalAttributeValue(collection, this.sammc.elementCharacteristic()).map(Statement::getResource).map(elementCharacteristicResource -> this.modelElementFactory.create(Characteristic.class, (Resource)elementCharacteristicResource));
    }

    protected boolean isTypeOfOrSubtypeOf(Resource element, Resource type) {
        for (Resource typeInHierarchy = element.getPropertyResourceValue(RDF.type); typeInHierarchy != null; typeInHierarchy = typeInHierarchy.getPropertyResourceValue(RDFS.subClassOf)) {
            if (!type.equals((Object)typeInHierarchy)) continue;
            return true;
        }
        return false;
    }

    protected Value buildValue(RDFNode node, Optional<Resource> characteristicResource, Type type) {
        if (node.isLiteral()) {
            return this.buildScalarValue(node.asLiteral());
        }
        if (characteristicResource.isPresent()) {
            Resource characteristic = characteristicResource.get();
            Optional<Resource> elementCharacteristic = this.optionalAttributeValue(characteristic, this.sammc.elementCharacteristic()).map(Statement::getResource);
            CollectionValue.CollectionType collectionType = null;
            if (this.isTypeOfOrSubtypeOf(characteristic, this.sammc.Set())) {
                collectionType = CollectionValue.CollectionType.SET;
            } else if (this.isTypeOfOrSubtypeOf(characteristic, this.sammc.SortedSet())) {
                collectionType = CollectionValue.CollectionType.SORTEDSET;
            } else if (this.isTypeOfOrSubtypeOf(characteristic, this.sammc.List())) {
                collectionType = CollectionValue.CollectionType.LIST;
            } else if (this.isTypeOfOrSubtypeOf(characteristic, this.sammc.Collection())) {
                collectionType = CollectionValue.CollectionType.COLLECTION;
            }
            if (collectionType != null) {
                return this.buildCollectionValue((RDFList)node.as(RDFList.class), collectionType, elementCharacteristic, type);
            }
        }
        if (!type.is(Entity.class)) {
            throw new AspectLoadingException("Expected type of value " + node + " to be samm:Entity, but it is not");
        }
        Resource resource = node.asResource();
        return this.buildEntityInstance(resource, (Entity)type);
    }

    private ScalarValue buildScalarValue(Literal literal) {
        if (literal.getDatatypeURI().equals(RDF.langString.getURI())) {
            return this.buildLanguageString(literal);
        }
        return Stream.concat(ExtendedXsdDataType.supportedXsdTypes.stream(), Stream.of(this.curieDataType)).filter(type -> type.getURI().equals(literal.getDatatypeURI())).map(type -> type.parse(literal.getLexicalForm())).map(value -> new DefaultScalarValue(value, new DefaultScalar(literal.getDatatypeURI(), this.metaModelVersion))).findAny().orElseThrow(() -> new AspectLoadingException("Literal can not be parsed: " + literal));
    }

    protected ScalarValue buildLanguageString(Literal literal) {
        LangString langString = new LangString(literal.getString(), Locale.forLanguageTag(literal.getLanguage()));
        DefaultScalar type = new DefaultScalar(RDF.langString.getURI(), this.metaModelVersion);
        return new DefaultScalarValue(langString, type);
    }

    private CollectionValue buildCollectionValue(RDFList list, CollectionValue.CollectionType collectionType, Optional<Resource> elementCharacteristic, Type elementType) {
        Collection<Value> values = this.createEmptyCollectionForType(collectionType);
        list.asJavaList().forEach(element -> values.add(this.buildValue((RDFNode)element, elementCharacteristic, elementType)));
        return new DefaultCollectionValue(values, collectionType, elementType);
    }

    protected EntityInstance buildEntityInstance(Resource entityInstance, Entity type) {
        HashMap<Property, Value> assertions = new HashMap<Property, Value>();
        type.getAllProperties().forEach(property -> {
            AspectModelUrn propertyUrn = property.getAspectModelUrn().orElseThrow(() -> new AspectLoadingException("Invalid Property without a URN found"));
            org.apache.jena.rdf.model.Property rdfProperty = this.model.createProperty(propertyUrn.getUrn().toASCIIString());
            Statement statement = entityInstance.getProperty(rdfProperty);
            if (statement == null) {
                if (property.isOptional()) {
                    return;
                }
                throw new AspectLoadingException("Mandatory Property " + property + " not found in Entity instance " + entityInstance);
            }
            RDFNode rdfValue = entityInstance.getProperty(rdfProperty).getObject();
            Type propertyType = property.getDataType().orElseThrow(() -> new AspectLoadingException("Invalid Property without a dataType found"));
            Resource characteristic = this.attributeValue((Resource)rdfProperty, this.samm.characteristic()).getResource();
            Value value = this.buildValue(rdfValue, Optional.of(characteristic), propertyType);
            assertions.put((Property)property, value);
        });
        MetaModelBaseAttributes baseAttributes = this.buildBaseAttributes(entityInstance);
        return new DefaultEntityInstance(baseAttributes, assertions, type);
    }

    private Collection<Value> createEmptyCollectionForType(CollectionValue.CollectionType collectionType) {
        if (collectionType == CollectionValue.CollectionType.SORTEDSET) {
            return new LinkedHashSet<Value>();
        }
        if (collectionType == CollectionValue.CollectionType.SET) {
            return new HashSet<Value>();
        }
        return new ArrayList<Value>();
    }
}

