/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader.instantiator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.metamodel.AbstractEntity;
import org.eclipse.esmf.metamodel.ComplexType;
import org.eclipse.esmf.metamodel.Entity;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;

public abstract class ComplexTypeInstantiator<T extends ComplexType>
extends Instantiator<T> {
    private final Set<Resource> processedExtendingElements = new HashSet<Resource>();
    private final Map<Resource, T> creatingElements = new HashMap<Resource, T>();

    public ComplexTypeInstantiator(ModelElementFactory modelElementFactory, Class<T> targetClass) {
        super(modelElementFactory, targetClass);
    }

    @Override
    public T apply(Resource resource) {
        if (this.creatingElements.containsKey(resource)) {
            return (T)((ComplexType)this.creatingElements.get(resource));
        }
        MetaModelBaseAttributes metaModelBaseAttributes = this.buildBaseAttributes(resource);
        List<Property> properties = this.getPropertiesModels(resource, this.samm.properties());
        Optional<ComplexType> extendedEntity = this.getExtendedEntity(resource);
        ArrayList<AspectModelUrn> extending = new ArrayList<AspectModelUrn>();
        T entity = this.createDefaultEntity(metaModelBaseAttributes, properties, extendedEntity, extending);
        this.creatingElements.put(resource, entity);
        extending.addAll(this.getExtending(resource));
        return entity;
    }

    private List<AspectModelUrn> getExtending(Resource resource) {
        return this.model.listSubjectsWithProperty(this.samm._extends(), (RDFNode)resource).mapWith(extendingComplexType -> this.attributeValue((Resource)extendingComplexType, RDF.type)).mapWith(statement -> {
            if (this.processedExtendingElements.contains(statement.getSubject())) {
                return AspectModelUrn.fromUrn((String)statement.getSubject().getURI());
            }
            this.processedExtendingElements.add(statement.getSubject());
            if (this.samm.AbstractEntity().equals((Object)statement.getObject().asResource())) {
                return this.modelElementFactory.create(AbstractEntity.class, statement.getSubject()).getAspectModelUrn().get();
            }
            return this.modelElementFactory.create(Entity.class, statement.getSubject()).getAspectModelUrn().get();
        }).toList();
    }

    protected Optional<ComplexType> getExtendedEntity(Resource resource) {
        return this.optionalAttributeValue(resource, this.samm._extends()).map(Statement::getResource).map(extendedEntityResource -> this.attributeValue((Resource)extendedEntityResource, RDF.type)).map(entityStatement -> {
            if (this.samm.AbstractEntity().equals((Object)entityStatement.getObject().asResource())) {
                return this.modelElementFactory.create(AbstractEntity.class, entityStatement.getSubject());
            }
            return this.modelElementFactory.create(Entity.class, entityStatement.getSubject());
        });
    }

    protected abstract T createDefaultEntity(MetaModelBaseAttributes var1, List<Property> var2, Optional<ComplexType> var3, List<AspectModelUrn> var4);
}

