/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader.instantiator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.resolver.exceptions.InvalidModelException;
import org.eclipse.esmf.metamodel.Characteristic;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.Scalar;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.impl.DefaultCharacteristic;
import org.eclipse.esmf.metamodel.impl.DefaultProperty;
import org.eclipse.esmf.metamodel.impl.DefaultScalarValue;
import org.eclipse.esmf.metamodel.loader.DefaultPropertyWrapper;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;
import org.eclipse.esmf.samm.KnownVersion;

public class PropertyInstantiator
extends Instantiator<Property> {
    private final Characteristic fallbackCharacteristic;
    private final Map<Resource, Property> resourcePropertyMap = new HashMap<Resource, Property>();

    public PropertyInstantiator(ModelElementFactory modelElementFactory) {
        super(modelElementFactory, Property.class);
        MetaModelBaseAttributes characteristicBaseAttributes = MetaModelBaseAttributes.builderFor("UnnamedCharacteristic").withMetaModelVersion(KnownVersion.getLatest()).build();
        this.fallbackCharacteristic = new DefaultCharacteristic(characteristicBaseAttributes, Optional.empty());
    }

    @Override
    public Property apply(Resource property) {
        DefaultProperty defProperty;
        boolean isOptional = this.optionalAttributeValue(property, this.samm.optional()).map(Statement::getBoolean).orElse(false);
        boolean isNotInPayload = this.optionalAttributeValue(property, this.samm.notInPayload()).map(Statement::getBoolean).orElse(false);
        Optional<String> payloadName = this.optionalAttributeValue(property, this.samm.payloadName()).map(Statement::getString);
        Optional<Property> extends_ = this.optionalAttributeValue(property, this.samm._extends()).map(Statement::getResource).map(superElementResource -> this.modelElementFactory.create(Property.class, (Resource)superElementResource));
        boolean isAbstract = property.getModel().contains(property, RDF.type, (RDFNode)this.samm.AbstractProperty());
        MetaModelBaseAttributes metaModelBaseAttributes = this.buildBaseAttributes(property);
        DefaultPropertyWrapper defaultPropertyWrapper = new DefaultPropertyWrapper(metaModelBaseAttributes);
        if (this.resourcePropertyMap.containsKey(property)) {
            Property propertyInstance = this.resourcePropertyMap.get(property);
            return propertyInstance;
        }
        this.resourcePropertyMap.put(property, defaultPropertyWrapper);
        if (isAbstract) {
            defProperty = new DefaultProperty(metaModelBaseAttributes, Optional.of(this.fallbackCharacteristic), Optional.empty(), isOptional, isNotInPayload, payloadName, isAbstract, extends_);
        } else {
            Resource characteristicResource = this.attributeValue(property, this.samm.characteristic()).getResource();
            Characteristic characteristic = this.modelElementFactory.create(Characteristic.class, characteristicResource);
            Optional<ScalarValue> exampleValue = this.optionalAttributeValue(property, this.samm.exampleValue()).flatMap(statement -> characteristic.getDataType().map(type -> {
                if (!type.is(Scalar.class)) {
                    throw new InvalidModelException("Type of example value on Property " + property + " has incorrect type");
                }
                return type.as(Scalar.class);
            }).map(type -> this.buildScalarValue(statement.getLiteral(), (Scalar)type)));
            defProperty = new DefaultProperty(metaModelBaseAttributes, Optional.of(characteristic), exampleValue, isOptional, isNotInPayload, payloadName, isAbstract, extends_);
        }
        defaultPropertyWrapper.setProperty(defProperty);
        return defaultPropertyWrapper;
    }

    private ScalarValue buildScalarValue(Literal literal, Scalar type) {
        Object literalValue = literal.getValue();
        if (literalValue instanceof BaseDatatype.TypedValue) {
            return new DefaultScalarValue(literal.getLexicalForm(), type);
        }
        if (literal.getDatatypeURI().equals(RDF.langString.getURI())) {
            return this.buildLanguageString(literal);
        }
        return new DefaultScalarValue(literalValue, type);
    }
}

