/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader.instantiator;

import java.util.Optional;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.eclipse.esmf.constraint.RangeConstraint;
import org.eclipse.esmf.constraint.impl.DefaultRangeConstraint;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.impl.BoundDefinition;
import org.eclipse.esmf.metamodel.impl.DefaultScalar;
import org.eclipse.esmf.metamodel.impl.DefaultScalarValue;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;

public class RangeConstraintInstantiator
extends Instantiator<RangeConstraint> {
    public RangeConstraintInstantiator(ModelElementFactory modelElementFactory) {
        super(modelElementFactory, RangeConstraint.class);
    }

    @Override
    public RangeConstraint apply(Resource rangeConstraint) {
        MetaModelBaseAttributes metaModelBaseAttributes = this.buildBaseAttributes(rangeConstraint);
        Optional<ScalarValue> minValue = this.optionalAttributeValue(rangeConstraint, this.sammc.minValue()).map(Statement::getLiteral).map(literal -> new DefaultScalarValue(literal.getValue(), new DefaultScalar(literal.getDatatypeURI(), metaModelBaseAttributes.getMetaModelVersion())));
        Optional<ScalarValue> maxValue = this.optionalAttributeValue(rangeConstraint, this.sammc.maxValue()).map(Statement::getLiteral).map(literal -> new DefaultScalarValue(literal.getValue(), new DefaultScalar(literal.getDatatypeURI(), metaModelBaseAttributes.getMetaModelVersion())));
        BoundDefinition lowerBoundDefinition = this.getBoundDefinitionForRangeValue(minValue, this.sammc.lowerBoundDefinition(), rangeConstraint, BoundDefinition.AT_LEAST);
        BoundDefinition upperBoundDefinition = this.getBoundDefinitionForRangeValue(maxValue, this.sammc.upperBoundDefinition(), rangeConstraint, BoundDefinition.AT_MOST);
        return new DefaultRangeConstraint(metaModelBaseAttributes, minValue, maxValue, lowerBoundDefinition, upperBoundDefinition);
    }

    private BoundDefinition getBoundDefinitionForRangeValue(Optional<ScalarValue> rangeValue, Property boundDefinitionProperty, Resource rangeConstraint, BoundDefinition defaultBoundDefinitionValue) {
        Optional<String> valueForBoundDefinition = this.getValueForBoundDefinition(rangeConstraint, boundDefinitionProperty);
        if (rangeValue.isPresent() && valueForBoundDefinition.isPresent()) {
            return BoundDefinition.valueOf(valueForBoundDefinition.get());
        }
        if (rangeValue.isPresent()) {
            return defaultBoundDefinitionValue;
        }
        return BoundDefinition.OPEN;
    }

    private Optional<String> getValueForBoundDefinition(Resource rangeConstraint, Property boundDefinitionProperty) {
        return Optional.ofNullable(rangeConstraint.getProperty(boundDefinitionProperty)).map(Statement::getObject).map(RDFNode::toString).map(this::getBoundDefinitionValue);
    }

    private String getBoundDefinitionValue(String boundDefinitionUrn) {
        int startIndexOfBoundDefinitionValue = boundDefinitionUrn.indexOf(35) + 1;
        return boundDefinitionUrn.substring(startIndexOfBoundDefinitionValue);
    }
}

