/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader.instantiator;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.eclipse.esmf.characteristic.StructuredValue;
import org.eclipse.esmf.characteristic.impl.DefaultStructuredValue;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.Type;
import org.eclipse.esmf.metamodel.loader.Instantiator;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;

public class StructuredValueInstantiator
extends Instantiator<StructuredValue> {
    public StructuredValueInstantiator(ModelElementFactory modelElementFactory) {
        super(modelElementFactory, StructuredValue.class);
    }

    @Override
    public StructuredValue apply(Resource structuredValue) {
        MetaModelBaseAttributes metaModelBaseAttributes = this.buildBaseAttributes(structuredValue);
        String deconstructionRule = this.attributeValue(structuredValue, this.sammc.deconstructionRule()).getString();
        List<Object> elements = this.getNodesFromList(structuredValue, this.sammc.elements()).map(this::toElement).collect(Collectors.toList());
        Type type = this.getType(structuredValue);
        return new DefaultStructuredValue(metaModelBaseAttributes, type, deconstructionRule, elements);
    }

    private Object toElement(RDFNode node) {
        if (node.isLiteral()) {
            return ((Literal)node).getString();
        }
        return this.modelElementFactory.create(Property.class, node.asResource());
    }
}

