/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.eclipse.esmf.aspectmodel.urn.AspectModelUrn;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.datatypes.LangString;

public interface NamedElement
extends ModelElement {
    public Optional<AspectModelUrn> getAspectModelUrn();

    public String getName();

    default public boolean hasSyntheticName() {
        return false;
    }

    default public List<String> getSee() {
        return Collections.emptyList();
    }

    default public Set<LangString> getPreferredNames() {
        return Collections.emptySet();
    }

    default public Set<LangString> getDescriptions() {
        return Collections.emptySet();
    }

    default public String getPreferredName(Locale locale) {
        return this.getPreferredNames().stream().filter(preferredName -> preferredName.getLanguageTag().equals(locale)).map(LangString::getValue).findAny().orElse(this.getName());
    }

    default public String getDescription(Locale locale) {
        return this.getDescriptions().stream().filter(description -> description.getLanguageTag().equals(locale)).map(LangString::getValue).findAny().orElseGet(() -> {
            if (locale.equals(Locale.ENGLISH)) {
                return null;
            }
            return this.getDescription(Locale.ENGLISH);
        });
    }
}

