/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.esmf.metamodel.Aspect;
import org.eclipse.esmf.metamodel.Event;
import org.eclipse.esmf.metamodel.Operation;
import org.eclipse.esmf.metamodel.Property;
import org.eclipse.esmf.metamodel.impl.ModelElementImpl;
import org.eclipse.esmf.metamodel.loader.MetaModelBaseAttributes;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;

public class DefaultAspect
extends ModelElementImpl
implements Aspect {
    private final List<Property> properties;
    private final List<Operation> operations;
    private final List<Event> events;
    private final boolean isCollectionAspect;

    public DefaultAspect(MetaModelBaseAttributes metaModelBaseAttributes, List<Property> properties, List<Operation> operations, List<Event> events, boolean isCollectionAspect) {
        super(metaModelBaseAttributes);
        this.properties = new ArrayList<Property>(properties);
        this.operations = new ArrayList<Operation>(operations);
        this.events = new ArrayList<Event>(events);
        this.isCollectionAspect = isCollectionAspect;
    }

    @Override
    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public List<Operation> getOperations() {
        return this.operations;
    }

    @Override
    public List<Event> getEvents() {
        return this.events;
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitAspect(this, context);
    }

    @Override
    public boolean isCollectionAspect() {
        return this.isCollectionAspect;
    }

    public String toString() {
        return new StringJoiner(", ", DefaultAspect.class.getSimpleName() + "[", "]").add("properties=" + this.properties).add("operations=" + this.operations).add("events=" + this.events).add("isCollectionAspect=" + this.isCollectionAspect).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultAspect that = (DefaultAspect)o;
        return this.isCollectionAspect == that.isCollectionAspect && Objects.equals(this.properties, that.properties) && Objects.equals(this.operations, that.operations) && Objects.equals(this.events, that.events);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.properties, this.operations, this.events, this.isCollectionAspect);
    }
}

