/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.esmf.aspectmodel.VersionNumber;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.ModelNamespace;

public class DefaultModelNamespace
implements ModelNamespace {
    private final String packagePart;
    private final VersionNumber versionNumber;
    private final List<ModelElement> elements = new ArrayList<ModelElement>();

    public DefaultModelNamespace(String packagePart, VersionNumber versionNumber, List<ModelElement> elements) {
        this.packagePart = packagePart;
        this.versionNumber = versionNumber;
        this.elements.addAll(elements);
    }

    public static ModelNamespace from(String uri, List<ModelElement> elements) {
        String[] parts = uri.split(":");
        return new DefaultModelNamespace(parts[2], VersionNumber.parse((String)parts[3]), elements);
    }

    public static ModelNamespace from(String uri) {
        return DefaultModelNamespace.from(uri, List.of());
    }

    @Override
    public String packagePart() {
        return this.packagePart;
    }

    @Override
    public VersionNumber version() {
        return this.versionNumber;
    }

    @Override
    public List<ModelElement> elements() {
        return Collections.unmodifiableList(this.elements);
    }
}

