/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.impl;

import java.util.Objects;
import java.util.StringJoiner;
import org.eclipse.esmf.metamodel.Scalar;
import org.eclipse.esmf.metamodel.ScalarValue;
import org.eclipse.esmf.metamodel.visitor.AspectVisitor;
import org.eclipse.esmf.samm.KnownVersion;

public class DefaultScalarValue
implements ScalarValue {
    private final Object value;
    private final Scalar type;

    public DefaultScalarValue(Object value, Scalar type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Scalar getType() {
        return this.type;
    }

    @Override
    public KnownVersion getMetaModelVersion() {
        return this.type.getMetaModelVersion();
    }

    @Override
    public <T, C> T accept(AspectVisitor<T, C> visitor, C context) {
        return visitor.visitScalarValue(this, context);
    }

    @Override
    public int compareTo(ScalarValue other) {
        if (!this.type.equals(other.getType())) {
            throw new UnsupportedOperationException("Tried to compare values of different types");
        }
        if (this.value instanceof Comparable) {
            return this.compareTo(this.getValue(), other.getValue());
        }
        return 0;
    }

    private <T extends Comparable<T>> int compareTo(Object value1, Object value2) {
        return ((Comparable)value1).compareTo((Comparable)value2);
    }

    public String toString() {
        return new StringJoiner(", ", DefaultScalarValue.class.getSimpleName() + "[", "]").add("value=" + this.value).add("typeUri='" + this.type + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultScalarValue that = (DefaultScalarValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }
}

