/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import com.google.common.collect.ImmutableSet;
import io.vavr.control.Try;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.esmf.aspectmodel.UnsupportedVersionException;
import org.eclipse.esmf.aspectmodel.resolver.AspectModelResolver;
import org.eclipse.esmf.aspectmodel.resolver.exceptions.InvalidModelException;
import org.eclipse.esmf.aspectmodel.resolver.exceptions.InvalidNamespaceException;
import org.eclipse.esmf.aspectmodel.resolver.exceptions.InvalidRootElementCountException;
import org.eclipse.esmf.aspectmodel.resolver.services.VersionedModel;
import org.eclipse.esmf.aspectmodel.versionupdate.MigratorService;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMM;
import org.eclipse.esmf.metamodel.Aspect;
import org.eclipse.esmf.metamodel.AspectContext;
import org.eclipse.esmf.metamodel.ModelElement;
import org.eclipse.esmf.metamodel.ModelNamespace;
import org.eclipse.esmf.metamodel.NamedElement;
import org.eclipse.esmf.metamodel.impl.DefaultModelNamespace;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;
import org.eclipse.esmf.metamodel.loader.ModelElementFactory;
import org.eclipse.esmf.samm.KnownVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectModelLoader {
    private static final Logger LOG = LoggerFactory.getLogger(AspectModelLoader.class);
    private static final Set<KnownVersion> SUPPORTED_VERSIONS = ImmutableSet.of((Object)KnownVersion.SAMM_1_0_0, (Object)KnownVersion.SAMM_2_0_0, (Object)KnownVersion.SAMM_2_1_0);
    private static final MigratorService migratorService = new MigratorService();

    private AspectModelLoader() {
    }

    private static void validateNamespaceOfCustomUnits(SAMM samm, Model rawModel) {
        ArrayList customUnitsWithSammNamespace = new ArrayList();
        rawModel.listStatements(null, RDF.type, (RDFNode)samm.Unit()).mapWith(Statement::getSubject).filterKeep(subject -> subject.getNameSpace().equals(samm.getNamespace())).mapWith(Resource::getLocalName).forEach(customUnitsWithSammNamespace::add);
        if (!customUnitsWithSammNamespace.isEmpty()) {
            throw new InvalidNamespaceException(String.format("Aspect model contains unit(s) %s not specified in the unit catalog but referred with samm namespace", customUnitsWithSammNamespace));
        }
    }

    public static Try<List<ModelNamespace>> getNamespaces(VersionedModel versionedModel) {
        return AspectModelLoader.getElements(versionedModel).map(elements -> elements.stream().filter(element -> element.is(NamedElement.class) && element.as(NamedElement.class).getAspectModelUrn().isPresent()).collect(Collectors.groupingBy(namedElement -> {
            String urn = namedElement.as(NamedElement.class).getAspectModelUrn().orElseThrow().toString();
            return urn.substring(0, urn.indexOf("#"));
        })).entrySet().stream().map(entry -> DefaultModelNamespace.from((String)entry.getKey(), (List)entry.getValue())).toList());
    }

    public static Try<List<ModelElement>> getElements(VersionedModel versionedModel) {
        Try updatedModel;
        Optional metaModelVersion = KnownVersion.fromVersionString((String)versionedModel.getMetaModelVersion().toString());
        if (metaModelVersion.isEmpty() || !SUPPORTED_VERSIONS.contains(metaModelVersion.get())) {
            return Try.failure((Throwable)new UnsupportedVersionException(versionedModel.getMetaModelVersion()));
        }
        Try try_ = updatedModel = ((KnownVersion)metaModelVersion.get()).isOlderThan(KnownVersion.getLatest()) ? migratorService.updateMetaModelVersion(versionedModel) : Try.success((Object)versionedModel);
        if (updatedModel.isFailure()) {
            return Try.failure((Throwable)updatedModel.getCause());
        }
        SAMM samm = new SAMM(KnownVersion.getLatest());
        try {
            AspectModelLoader.validateNamespaceOfCustomUnits(samm, versionedModel.getRawModel());
        }
        catch (InvalidNamespaceException exception) {
            return Try.failure((Throwable)exception);
        }
        try {
            VersionedModel model = (VersionedModel)updatedModel.get();
            ModelElementFactory modelElementFactory = new ModelElementFactory(KnownVersion.getLatest(), model.getModel(), Map.of());
            return Try.success(model.getRawModel().listStatements(null, RDF.type, (RDFNode)null).toList().stream().map(Statement::getSubject).filter(RDFNode::isURIResource).map(resource -> model.getModel().createResource(resource.getURI())).map(resource -> modelElementFactory.create(ModelElement.class, (Resource)resource)).toList());
        }
        catch (RuntimeException exception) {
            return Try.failure((Throwable)new InvalidModelException("Could not load Aspect model, please make sure the model is valid", (Throwable)exception));
        }
    }

    public static List<ModelElement> getElementsUnchecked(VersionedModel versionedModel) {
        return (List)AspectModelLoader.getElements(versionedModel).getOrElseThrow(cause -> {
            LOG.error("Could not load elements", cause);
            throw new AspectLoadingException((Throwable)cause);
        });
    }

    public static Try<List<Aspect>> getAspects(VersionedModel versionedModel) {
        return AspectModelLoader.getElements(versionedModel).map(elements -> elements.stream().filter(element -> element.is(Aspect.class)).map(element -> element.as(Aspect.class)).toList());
    }

    public static List<Aspect> getAspectsUnchecked(VersionedModel versionedModel) {
        return (List)AspectModelLoader.getAspects(versionedModel).getOrElseThrow(cause -> {
            LOG.error("Could not load aspects", cause);
            throw new AspectLoadingException((Throwable)cause);
        });
    }

    public static Try<Aspect> getSingleAspect(VersionedModel versionedModel) {
        return AspectModelLoader.getSingleAspect(versionedModel, aspect -> true);
    }

    public static Aspect getSingleAspectUnchecked(VersionedModel versionedModel) {
        return (Aspect)AspectModelLoader.getSingleAspect(versionedModel).getOrElseThrow(cause -> {
            LOG.error("Could not load aspect", cause);
            throw new AspectLoadingException((Throwable)cause);
        });
    }

    public static Try<Aspect> getSingleAspect(VersionedModel versionedModel, Predicate<Aspect> selector) {
        return AspectModelLoader.getAspects(versionedModel).flatMap(allAspects -> {
            List aspects = allAspects.stream().filter(selector).toList();
            return switch (aspects.size()) {
                case 1 -> Try.success((Object)((Aspect)aspects.iterator().next()));
                case 0 -> Try.failure((Throwable)new InvalidRootElementCountException("No Aspects were found in the model"));
                default -> Try.failure((Throwable)new AspectLoadingException("Multiple Aspects were found in the resolved model"));
            };
        });
    }

    public static Try<AspectContext> getAspectContext(File input) {
        return AspectModelResolver.loadAndResolveModel((File)input).flatMap(versionedModel -> AspectModelLoader.getSingleAspect(versionedModel, aspect -> input.getName().equals(aspect.getName() + ".ttl")).map(aspect -> new AspectContext((VersionedModel)versionedModel, (Aspect)aspect)));
    }
}

