/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.esmf.metamodel.loader;

import java.util.Optional;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.impl.LiteralLabel;
import org.eclipse.esmf.aspectmodel.resolver.services.TypedRdfDatatype;
import org.eclipse.esmf.aspectmodel.vocabulary.SAMM;
import org.eclipse.esmf.metamodel.datatypes.Curie;
import org.eclipse.esmf.metamodel.loader.AspectLoadingException;
import org.eclipse.esmf.samm.KnownVersion;

public class CurieRdfType
implements TypedRdfDatatype<Curie> {
    public Optional<Curie> parseTyped(String lexicalForm) {
        if (this.isValid(lexicalForm)) {
            return Optional.of(new Curie(lexicalForm));
        }
        return Optional.empty();
    }

    public String unparseTyped(Curie value) {
        return value.getValue();
    }

    public String getURI() {
        return new SAMM(KnownVersion.getLatest()).curie().getURI();
    }

    public String unparse(Object value) {
        if (value instanceof Curie) {
            Curie curie = (Curie)value;
            return this.unparseTyped(curie);
        }
        throw new AspectLoadingException("Value is no valid curie: " + value);
    }

    public Object parse(String lexicalForm) throws DatatypeFormatException {
        return this.parseTyped(lexicalForm).orElseThrow(() -> new DatatypeFormatException());
    }

    public boolean isValid(String lexicalForm) {
        return lexicalForm.matches("[^:]*:.*");
    }

    public boolean isValidValue(Object valueForm) {
        return this.isValid(valueForm.toString());
    }

    public boolean isValidLiteral(LiteralLabel lit) {
        return this.isValid(lit.getLexicalForm());
    }

    public boolean isEqual(LiteralLabel value1, LiteralLabel value2) {
        return value1.getLexicalForm().equals(value2.getLexicalForm());
    }

    public int getHashCode(LiteralLabel lit) {
        return lit.getDefaultHashcode();
    }

    public Class<Curie> getJavaClass() {
        return Curie.class;
    }

    public Object cannonicalise(Object value) {
        return value;
    }

    public Object extendedTypeDefinition() {
        return null;
    }

    public RDFDatatype normalizeSubType(Object value, RDFDatatype datatype) {
        return datatype;
    }
}

